/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.nullaway.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.nullaway.dataflow.cfg.node.Node;
import org.checkerframework.nullaway.dataflow.cfg.node.NodeVisitor;

public class DeconstructorPatternNode
extends Node {
    private final Tree deconstructorPattern;
    private final List<Node> nestedPatterns;
    private @MonotonicNonNull List<LocalVariableNode> bindingVariables = null;

    public DeconstructorPatternNode(TypeMirror type, Tree deconstructorPattern, List<Node> nestedPatterns) {
        super(type);
        this.deconstructorPattern = deconstructorPattern;
        this.nestedPatterns = nestedPatterns;
    }

    @Override
    @Pure
    public @Nullable Tree getTree() {
        return this.deconstructorPattern;
    }

    @Pure
    public List<Node> getNestedPatterns() {
        return this.nestedPatterns;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitDeconstructorPattern(this, p);
    }

    @Override
    @Pure
    public Collection<Node> getOperands() {
        return this.nestedPatterns;
    }

    public List<LocalVariableNode> getBindingVariables() {
        if (this.bindingVariables == null) {
            if (this.nestedPatterns.isEmpty()) {
                this.bindingVariables = Collections.emptyList();
            } else {
                this.bindingVariables = new ArrayList<LocalVariableNode>(this.nestedPatterns.size());
                for (Node patternNode : this.nestedPatterns) {
                    if (patternNode instanceof LocalVariableNode) {
                        this.bindingVariables.add((LocalVariableNode)patternNode);
                        continue;
                    }
                    this.bindingVariables.addAll(((DeconstructorPatternNode)patternNode).getBindingVariables());
                }
                this.bindingVariables = Collections.unmodifiableList(this.bindingVariables);
            }
        }
        return this.bindingVariables;
    }
}

