/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.org.plumelib.util;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.nullaway.checker.formatter.qual.UnknownFormat;
import org.checkerframework.nullaway.checker.index.qual.GTENegativeOne;
import org.checkerframework.nullaway.checker.index.qual.LessThanUnknown;
import org.checkerframework.nullaway.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.nullaway.checker.index.qual.SameLenUnknown;
import org.checkerframework.nullaway.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.nullaway.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.nullaway.checker.initialization.qual.Initialized;
import org.checkerframework.nullaway.checker.interning.qual.Interned;
import org.checkerframework.nullaway.checker.interning.qual.UnknownInterned;
import org.checkerframework.nullaway.checker.lock.qual.GuardSatisfied;
import org.checkerframework.nullaway.checker.lock.qual.GuardedBy;
import org.checkerframework.nullaway.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.nullaway.checker.nullness.qual.NonNull;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.nullaway.checker.regex.qual.Regex;
import org.checkerframework.nullaway.checker.regex.qual.UnknownRegex;
import org.checkerframework.nullaway.checker.signature.qual.SignatureUnknown;
import org.checkerframework.nullaway.common.initializedfields.qual.InitializedFields;
import org.checkerframework.nullaway.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.nullaway.common.value.qual.UnknownVal;
import org.checkerframework.nullaway.framework.qual.EnsuresQualifierIf;

public final class RegexUtil {
    private RegexUtil() {
        throw new Error("do not instantiate");
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean isRegex(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s2) {
        return RegexUtil.isRegex(s2, 0);
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean isRegex(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s2, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int groups) {
        Pattern p;
        try {
            p = Pattern.compile(s2);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return RegexUtil.getGroupCount(p) >= groups;
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) boolean isRegex(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) char c) {
        return RegexUtil.isRegex(Character.toString(c));
    }

    @SideEffectFree
    public static @Regex @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @SignatureUnknown @UnknownThis @InitializedFields(value={}) String asRegex(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s2) {
        return RegexUtil.asRegex(s2, 0);
    }

    @SideEffectFree
    public static @Regex @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @SignatureUnknown @UnknownThis @InitializedFields(value={}) String asRegex(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s2, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int groups) {
        try {
            Pattern p = Pattern.compile(s2);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups) {
                throw new Error(RegexUtil.regexErrorMessage(s2, groups, actualGroups));
            }
            return s2;
        }
        catch (PatternSyntaxException e) {
            throw new Error(e);
        }
    }

    @SideEffectFree
    public static @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String regexError(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s2) {
        return RegexUtil.regexError(s2, 0);
    }

    @SideEffectFree
    public static @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String regexError(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s2, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int groups) {
        try {
            Pattern p = Pattern.compile(s2);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups) {
                return RegexUtil.regexErrorMessage(s2, groups, actualGroups);
            }
        }
        catch (PatternSyntaxException e) {
            return e.getMessage();
        }
        return null;
    }

    @SideEffectFree
    public static @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) PatternSyntaxException regexException(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s2) {
        return RegexUtil.regexException(s2, 0);
    }

    @SideEffectFree
    public static @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) PatternSyntaxException regexException(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s2, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int groups) {
        try {
            Pattern p = Pattern.compile(s2);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups) {
                return new PatternSyntaxException(RegexUtil.regexErrorMessage(s2, groups, actualGroups), s2, -1);
            }
        }
        catch (PatternSyntaxException pse) {
            return pse;
        }
        return null;
    }

    @SideEffectFree
    private static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String regexErrorMessage(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String s2, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int expectedGroups, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int actualGroups) {
        return "regex \"" + s2 + "\" has " + actualGroups + " groups, but " + expectedGroups + " groups are needed.";
    }

    @Pure
    private static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int getGroupCount(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) Pattern p) {
        return p.matcher("").groupCount();
    }

    public static class CheckedPatternSyntaxException
    extends Exception {
        private static final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) long serialVersionUID = 6266881831979001480L;
        private final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) PatternSyntaxException pse;

        public CheckedPatternSyntaxException(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) PatternSyntaxException pse) {
            this.pse = pse;
        }

        public CheckedPatternSyntaxException(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String desc, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String regex, @GTENegativeOne @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int index) {
            this(new PatternSyntaxException(desc, regex, index));
        }

        public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String getDescription() {
            return this.pse.getDescription();
        }

        public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) int getIndex() {
            return this.pse.getIndex();
        }

        @Override
        @Pure
        public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String getMessage(@GuardSatisfied CheckedPatternSyntaxException this) {
            return this.pse.getMessage();
        }

        public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @SignatureUnknown @UnknownThis @InitializedFields(value={}) String getPattern() {
            return this.pse.getPattern();
        }
    }
}

