/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.expression;

import com.sun.tools.javac.code.Symbol;
import java.util.Objects;
import javax.lang.model.element.Element;
import org.checkerframework.nullaway.checker.nullness.qual.Nullable;
import org.checkerframework.nullaway.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.nullaway.dataflow.expression.JavaExpression;
import org.checkerframework.nullaway.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.nullaway.javacutil.AnnotationProvider;
import org.checkerframework.nullaway.javacutil.ElementUtils;
import org.checkerframework.nullaway.javacutil.TypeAnnotationUtils;
import org.checkerframework.nullaway.javacutil.TypesUtils;

public class LocalVariable
extends JavaExpression {
    protected final Element element;

    public LocalVariable(LocalVariableNode localVar) {
        super(localVar.getType());
        this.element = localVar.getElement();
    }

    public LocalVariable(Element element) {
        super(ElementUtils.getType(element));
        this.element = element;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof LocalVariable)) {
            return false;
        }
        LocalVariable other = (LocalVariable)obj;
        return LocalVariable.sameElement(this.element, other.element);
    }

    protected static boolean sameElement(Element element1, Element element2) {
        Symbol.VarSymbol vs1 = (Symbol.VarSymbol)element1;
        Symbol.VarSymbol vs2 = (Symbol.VarSymbol)element2;
        return vs1.pos == vs2.pos && vs1.name.contentEquals(vs2.name) && vs1.owner.toString().equals(vs2.owner.toString());
    }

    public Element getElement() {
        return this.element;
    }

    public int hashCode() {
        Symbol.VarSymbol vs = (Symbol.VarSymbol)this.element;
        return Objects.hash(vs.name.toString(), TypeAnnotationUtils.unannotatedType(vs.type).toString(), vs.owner.toString());
    }

    public String toString() {
        return this.element.toString();
    }

    @Override
    public String toStringDebug() {
        return super.toStringDebug() + " [owner=" + ((Symbol.VarSymbol)this.element).owner + "]";
    }

    @Override
    public boolean containsOfClass(Class<? extends JavaExpression> clazz) {
        return this.getClass() == clazz;
    }

    @Override
    public boolean isDeterministic(AnnotationProvider provider) {
        return true;
    }

    @Override
    public boolean syntacticEquals(JavaExpression je) {
        if (!(je instanceof LocalVariable)) {
            return false;
        }
        LocalVariable other = (LocalVariable)je;
        return this.equals(other);
    }

    @Override
    public boolean containsSyntacticEqualJavaExpression(JavaExpression other) {
        return this.syntacticEquals(other);
    }

    @Override
    public boolean isUnassignableByOtherCode() {
        return true;
    }

    @Override
    public boolean isUnmodifiableByOtherCode() {
        return TypesUtils.isImmutableTypeInJdk(((Symbol.VarSymbol)this.element).type);
    }

    @Override
    public <R, P> R accept(JavaExpressionVisitor<R, P> visitor, P p) {
        return visitor.visitLocalVariable(this, p);
    }
}

