/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.expression;

import java.util.Objects;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.expression.JavaExpression;
import org.checkerframework.errorprone.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.errorprone.javacutil.AnnotationProvider;

public class ArrayAccess
extends JavaExpression {
    protected final JavaExpression array;
    protected final JavaExpression index;

    public ArrayAccess(TypeMirror type, JavaExpression array, JavaExpression index) {
        super(type);
        this.array = array;
        this.index = index;
    }

    @Override
    public <T extends JavaExpression> @Nullable T containedOfClass(Class<T> clazz) {
        if (this.getClass() == clazz) {
            return (T)this;
        }
        T result = this.array.containedOfClass(clazz);
        if (result != null) {
            return result;
        }
        return this.index.containedOfClass(clazz);
    }

    @Override
    public boolean isDeterministic(AnnotationProvider provider) {
        return this.array.isDeterministic(provider) && this.index.isDeterministic(provider);
    }

    public JavaExpression getArray() {
        return this.array;
    }

    public JavaExpression getIndex() {
        return this.index;
    }

    @Override
    public boolean isAssignableByOtherCode() {
        return true;
    }

    @Override
    public boolean isModifiableByOtherCode() {
        return true;
    }

    @Override
    public boolean syntacticEquals(JavaExpression je) {
        if (!(je instanceof ArrayAccess)) {
            return false;
        }
        ArrayAccess other = (ArrayAccess)je;
        return this.array.syntacticEquals(other.array) && this.index.syntacticEquals(other.index);
    }

    @Override
    public boolean containsSyntacticEqualJavaExpression(JavaExpression other) {
        return this.syntacticEquals(other) || this.array.containsSyntacticEqualJavaExpression(other) || this.index.containsSyntacticEqualJavaExpression(other);
    }

    @Override
    public boolean containsModifiableAliasOf(Store<?> store, JavaExpression other) {
        if (this.array.containsModifiableAliasOf(store, other)) {
            return true;
        }
        return this.index.containsModifiableAliasOf(store, other);
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ArrayAccess)) {
            return false;
        }
        ArrayAccess other = (ArrayAccess)obj;
        return this.array.equals(other.array) && this.index.equals(other.index);
    }

    public int hashCode() {
        return Objects.hash(this.array, this.index);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.array.toString());
        result.append("[");
        result.append(this.index.toString());
        result.append("]");
        return result.toString();
    }

    @Override
    public <R, P> R accept(JavaExpressionVisitor<R, P> visitor, P p) {
        return visitor.visitArrayAccess(this, p);
    }
}

