/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.AnnoConstruct;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;

public abstract class Type
extends AnnoConstruct
implements TypeMirror {
    public static final JCNoType noType = new JCNoType(){

        @Override
        public String toString() {
            return "none";
        }
    };
    public static final JCNoType recoveryType = new JCNoType(){

        @Override
        public String toString() {
            return "recovery";
        }
    };
    public static final JCNoType stuckType = new JCNoType(){

        @Override
        public String toString() {
            return "stuck";
        }
    };
    public static boolean moreInfo = false;
    public Symbol.TypeSymbol tsym;

    public boolean hasTag(TypeTag tag) {
        return tag == this.getTag();
    }

    public abstract TypeTag getTag();

    public boolean isNumeric() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isPrimitiveOrVoid() {
        return false;
    }

    public boolean isReference() {
        return false;
    }

    public boolean isNullOrReference() {
        return false;
    }

    public boolean isPartial() {
        return false;
    }

    public Object constValue() {
        return null;
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    public Type getModelType() {
        return this;
    }

    public static List<Type> getModelTypes(List<Type> ts) {
        ListBuffer<Type> lb = new ListBuffer<Type>();
        for (Type t : ts) {
            lb.append(t.getModelType());
        }
        return lb.toList();
    }

    public Type getOriginalType() {
        return this;
    }

    public <R, S> R accept(Visitor<R, S> v, S s) {
        return v.visitType(this, s);
    }

    public Type(Symbol.TypeSymbol tsym) {
        this.tsym = tsym;
    }

    public Type map(Mapping f) {
        return this;
    }

    public static List<Type> map(List<Type> ts, Mapping f) {
        if (ts.nonEmpty()) {
            List<Type> tail1 = Type.map(ts.tail, f);
            Type t = f.apply((Type)ts.head);
            if (tail1 != ts.tail || t != ts.head) {
                return tail1.prepend(t);
            }
        }
        return ts;
    }

    public Type constType(Object constValue) {
        throw new AssertionError();
    }

    public Type baseType() {
        return this;
    }

    public Type annotatedType(List<Attribute.TypeCompound> annos) {
        return new AnnotatedType(annos, this);
    }

    public boolean isAnnotated() {
        return false;
    }

    public Type unannotatedType() {
        return this;
    }

    @Override
    public List<Attribute.TypeCompound> getAnnotationMirrors() {
        return List.nil();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return null;
    }

    @Override
    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        Annotation[] tmp = (Annotation[])Array.newInstance(annotationType, 0);
        return tmp;
    }

    public static List<Type> baseTypes(List<Type> ts) {
        if (ts.nonEmpty()) {
            Type t = ((Type)ts.head).baseType();
            List<Type> baseTypes = Type.baseTypes(ts.tail);
            if (t != ts.head || baseTypes != ts.tail) {
                return baseTypes.prepend(t);
            }
        }
        return ts;
    }

    @Override
    public String toString() {
        String s;
        String string = s = this.tsym == null || this.tsym.name == null ? "<none>" : this.tsym.name.toString();
        if (moreInfo && this.hasTag(TypeTag.TYPEVAR)) {
            s = s + this.hashCode();
        }
        return s;
    }

    public static String toString(List<Type> ts) {
        if (ts.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(((Type)ts.head).toString());
        List l = ts.tail;
        while (l.nonEmpty()) {
            buf.append(",").append(((Type)l.head).toString());
            l = l.tail;
        }
        return buf.toString();
    }

    public String stringValue() {
        Object cv = Assert.checkNonNull(this.constValue());
        return cv.toString();
    }

    @Override
    public boolean equals(Object t) {
        return super.equals(t);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String argtypes(boolean varargs) {
        List<Type> args = this.getParameterTypes();
        if (!varargs) {
            return args.toString();
        }
        StringBuilder buf = new StringBuilder();
        while (args.tail.nonEmpty()) {
            buf.append(args.head);
            args = args.tail;
            buf.append(',');
        }
        if (((Type)args.head).unannotatedType().hasTag(TypeTag.ARRAY)) {
            buf.append(((ArrayType)((Type)args.head).unannotatedType()).elemtype);
            if (((List)((Type)args.head).getAnnotationMirrors()).nonEmpty()) {
                buf.append(((Type)args.head).getAnnotationMirrors());
            }
            buf.append("...");
        } else {
            buf.append(args.head);
        }
        return buf.toString();
    }

    public List<Type> getTypeArguments() {
        return List.nil();
    }

    public Type getEnclosingType() {
        return null;
    }

    public List<Type> getParameterTypes() {
        return List.nil();
    }

    public Type getReturnType() {
        return null;
    }

    public Type getReceiverType() {
        return null;
    }

    public List<Type> getThrownTypes() {
        return List.nil();
    }

    public Type getUpperBound() {
        return null;
    }

    public Type getLowerBound() {
        return null;
    }

    public List<Type> allparams() {
        return List.nil();
    }

    public boolean isErroneous() {
        return false;
    }

    public static boolean isErroneous(List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (((Type)l.head).isErroneous()) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    public boolean isParameterized() {
        return false;
    }

    public boolean isRaw() {
        return false;
    }

    public boolean isCompound() {
        return this.tsym.completer == null && (this.tsym.flags() & 0x1000000L) != 0L;
    }

    public boolean isIntersection() {
        return false;
    }

    public boolean isUnion() {
        return false;
    }

    public boolean isInterface() {
        return (this.tsym.flags() & 0x200L) != 0L;
    }

    public boolean isFinal() {
        return (this.tsym.flags() & 0x10L) != 0L;
    }

    public boolean contains(Type t) {
        return t == this;
    }

    public static boolean contains(List<Type> ts, Type t) {
        List<Type> l = ts;
        while (l.tail != null) {
            if (((Type)l.head).contains(t)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    public boolean containsAny(List<Type> ts) {
        for (Type t : ts) {
            if (!this.contains(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(List<Type> ts1, List<Type> ts2) {
        for (Type t : ts1) {
            if (!t.containsAny(ts2)) continue;
            return true;
        }
        return false;
    }

    public static List<Type> filter(List<Type> ts, Filter<Type> tf) {
        ListBuffer<Type> buf = new ListBuffer<Type>();
        for (Type t : ts) {
            if (!tf.accepts(t)) continue;
            buf.append(t);
        }
        return buf.toList();
    }

    public boolean isSuperBound() {
        return false;
    }

    public boolean isExtendsBound() {
        return false;
    }

    public boolean isUnbound() {
        return false;
    }

    public Type withTypeVar(Type t) {
        return this;
    }

    public MethodType asMethodType() {
        throw new AssertionError();
    }

    public void complete() {
    }

    public Symbol.TypeSymbol asElement() {
        return this.tsym;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.OTHER;
    }

    @Override
    public <R, P> R accept(TypeVisitor<R, P> v, P p) {
        throw new AssertionError();
    }

    public static interface Visitor<R, S> {
        public R visitClassType(ClassType var1, S var2);

        public R visitWildcardType(WildcardType var1, S var2);

        public R visitArrayType(ArrayType var1, S var2);

        public R visitMethodType(MethodType var1, S var2);

        public R visitPackageType(PackageType var1, S var2);

        public R visitTypeVar(TypeVar var1, S var2);

        public R visitCapturedType(CapturedType var1, S var2);

        public R visitForAll(ForAll var1, S var2);

        public R visitUndetVar(UndetVar var1, S var2);

        public R visitErrorType(ErrorType var1, S var2);

        public R visitAnnotatedType(AnnotatedType var1, S var2);

        public R visitType(Type var1, S var2);
    }

    public static class UnknownType
    extends Type {
        public UnknownType() {
            super(null);
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.UNKNOWN;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitUnknown(this, p);
        }

        @Override
        public boolean isPartial() {
            return true;
        }
    }

    public static class AnnotatedType
    extends Type
    implements javax.lang.model.type.ArrayType,
    DeclaredType,
    PrimitiveType,
    TypeVariable,
    javax.lang.model.type.WildcardType {
        private List<Attribute.TypeCompound> typeAnnotations;
        private Type underlyingType;

        protected AnnotatedType(List<Attribute.TypeCompound> typeAnnotations, Type underlyingType) {
            super(underlyingType.tsym);
            this.typeAnnotations = typeAnnotations;
            this.underlyingType = underlyingType;
            Assert.check(typeAnnotations != null && typeAnnotations.nonEmpty(), "Can't create AnnotatedType without annotations: " + underlyingType);
            Assert.check(!underlyingType.isAnnotated(), "Can't annotate already annotated type: " + underlyingType + "; adding: " + typeAnnotations);
        }

        @Override
        public TypeTag getTag() {
            return this.underlyingType.getTag();
        }

        @Override
        public boolean isAnnotated() {
            return true;
        }

        @Override
        public List<Attribute.TypeCompound> getAnnotationMirrors() {
            return this.typeAnnotations;
        }

        @Override
        public TypeKind getKind() {
            return this.underlyingType.getKind();
        }

        @Override
        public Type unannotatedType() {
            return this.underlyingType;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitAnnotatedType(this, s);
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return this.underlyingType.accept(v, p);
        }

        @Override
        public Type map(Mapping f) {
            this.underlyingType.map(f);
            return this;
        }

        @Override
        public Type constType(Object constValue) {
            return this.underlyingType.constType(constValue);
        }

        @Override
        public Type getEnclosingType() {
            return this.underlyingType.getEnclosingType();
        }

        @Override
        public Type getReturnType() {
            return this.underlyingType.getReturnType();
        }

        @Override
        public List<Type> getTypeArguments() {
            return this.underlyingType.getTypeArguments();
        }

        @Override
        public List<Type> getParameterTypes() {
            return this.underlyingType.getParameterTypes();
        }

        @Override
        public Type getReceiverType() {
            return this.underlyingType.getReceiverType();
        }

        @Override
        public List<Type> getThrownTypes() {
            return this.underlyingType.getThrownTypes();
        }

        @Override
        public Type getUpperBound() {
            return this.underlyingType.getUpperBound();
        }

        @Override
        public Type getLowerBound() {
            return this.underlyingType.getLowerBound();
        }

        @Override
        public boolean isErroneous() {
            return this.underlyingType.isErroneous();
        }

        @Override
        public boolean isCompound() {
            return this.underlyingType.isCompound();
        }

        @Override
        public boolean isInterface() {
            return this.underlyingType.isInterface();
        }

        @Override
        public List<Type> allparams() {
            return this.underlyingType.allparams();
        }

        @Override
        public boolean isPrimitive() {
            return this.underlyingType.isPrimitive();
        }

        @Override
        public boolean isPrimitiveOrVoid() {
            return this.underlyingType.isPrimitiveOrVoid();
        }

        @Override
        public boolean isNumeric() {
            return this.underlyingType.isNumeric();
        }

        @Override
        public boolean isReference() {
            return this.underlyingType.isReference();
        }

        @Override
        public boolean isNullOrReference() {
            return this.underlyingType.isNullOrReference();
        }

        @Override
        public boolean isPartial() {
            return this.underlyingType.isPartial();
        }

        @Override
        public boolean isParameterized() {
            return this.underlyingType.isParameterized();
        }

        @Override
        public boolean isRaw() {
            return this.underlyingType.isRaw();
        }

        @Override
        public boolean isFinal() {
            return this.underlyingType.isFinal();
        }

        @Override
        public boolean isSuperBound() {
            return this.underlyingType.isSuperBound();
        }

        @Override
        public boolean isExtendsBound() {
            return this.underlyingType.isExtendsBound();
        }

        @Override
        public boolean isUnbound() {
            return this.underlyingType.isUnbound();
        }

        @Override
        public String toString() {
            if (this.typeAnnotations != null && !this.typeAnnotations.isEmpty()) {
                return "(" + this.typeAnnotations.toString() + " :: " + this.underlyingType.toString() + ")";
            }
            return "({} :: " + this.underlyingType.toString() + ")";
        }

        @Override
        public boolean contains(Type t) {
            return this.underlyingType.contains(t);
        }

        @Override
        public Type withTypeVar(Type t) {
            this.underlyingType = this.underlyingType.withTypeVar(t);
            return this;
        }

        @Override
        public Symbol.TypeSymbol asElement() {
            return this.underlyingType.asElement();
        }

        @Override
        public MethodType asMethodType() {
            return this.underlyingType.asMethodType();
        }

        @Override
        public void complete() {
            this.underlyingType.complete();
        }

        @Override
        public TypeMirror getComponentType() {
            return ((ArrayType)this.underlyingType).getComponentType();
        }

        public Type makeVarargs() {
            return ((ArrayType)this.underlyingType).makeVarargs().annotatedType(this.typeAnnotations);
        }

        @Override
        public TypeMirror getExtendsBound() {
            return ((WildcardType)this.underlyingType).getExtendsBound();
        }

        @Override
        public TypeMirror getSuperBound() {
            return ((WildcardType)this.underlyingType).getSuperBound();
        }
    }

    public static class ErrorType
    extends ClassType
    implements javax.lang.model.type.ErrorType {
        private Type originalType = null;

        public ErrorType(Type originalType, Symbol.TypeSymbol tsym) {
            super(noType, List.nil(), null);
            this.tsym = tsym;
            this.originalType = originalType == null ? noType : originalType;
        }

        public ErrorType(Symbol.ClassSymbol c, Type originalType) {
            this(originalType, c);
            c.type = this;
            c.kind = 63;
            c.members_field = new Scope.ErrorScope(c);
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.ERROR;
        }

        @Override
        public boolean isPartial() {
            return true;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        public ErrorType(Name name, Symbol.TypeSymbol container, Type originalType) {
            this(new Symbol.ClassSymbol(0x40000009L, name, null, container), originalType);
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitErrorType(this, s);
        }

        @Override
        public Type constType(Object constValue) {
            return this;
        }

        @Override
        public Type getEnclosingType() {
            return this;
        }

        @Override
        public Type getReturnType() {
            return this;
        }

        public Type asSub(Symbol sym) {
            return this;
        }

        @Override
        public Type map(Mapping f) {
            return this;
        }

        public boolean isGenType(Type t) {
            return true;
        }

        @Override
        public boolean isErroneous() {
            return true;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public boolean isInterface() {
            return false;
        }

        @Override
        public List<Type> allparams() {
            return List.nil();
        }

        @Override
        public List<Type> getTypeArguments() {
            return List.nil();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.ERROR;
        }

        @Override
        public Type getOriginalType() {
            return this.originalType;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitError(this, p);
        }
    }

    static class BottomType
    extends Type
    implements NullType {
        public BottomType() {
            super(null);
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.BOT;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.NULL;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNull(this, p);
        }

        @Override
        public Type constType(Object value) {
            return this;
        }

        @Override
        public String stringValue() {
            return "null";
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }
    }

    public static class JCVoidType
    extends Type
    implements NoType {
        public JCVoidType() {
            super(null);
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.VOID;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.VOID;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }

        @Override
        public boolean isPrimitiveOrVoid() {
            return true;
        }
    }

    public static class JCNoType
    extends Type
    implements NoType {
        public JCNoType() {
            super(null);
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.NONE;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.NONE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }

        @Override
        public boolean isCompound() {
            return false;
        }
    }

    public static class CapturedUndetVar
    extends UndetVar {
        public CapturedUndetVar(CapturedType origin, Types types) {
            super(origin, types);
            if (!origin.lower.hasTag(TypeTag.BOT)) {
                this.bounds.put(UndetVar.InferenceBound.LOWER, List.of(origin.lower));
            }
        }

        @Override
        public void addBound(UndetVar.InferenceBound ib, Type bound, Types types, boolean update) {
            if (update) {
                super.addBound(ib, bound, types, update);
            }
        }

        @Override
        public boolean isCaptured() {
            return true;
        }
    }

    public static class UndetVar
    extends DelegatedType {
        protected Map<InferenceBound, List<Type>> bounds;
        public Type inst = null;
        public int declaredCount;
        public UndetVarListener listener = null;
        Mapping toTypeVarMap = new Mapping("toTypeVarMap"){

            @Override
            public Type apply(Type t) {
                if (t.hasTag(TypeTag.UNDETVAR)) {
                    UndetVar uv = (UndetVar)t;
                    return uv.inst != null ? uv.inst : uv.qtype;
                }
                return t.map(this);
            }
        };

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitUndetVar(this, s);
        }

        public UndetVar(TypeVar origin, Types types) {
            super(TypeTag.UNDETVAR, origin);
            this.bounds = new EnumMap<InferenceBound, List<Type>>(InferenceBound.class);
            List<Type> declaredBounds = types.getBounds(origin);
            this.declaredCount = declaredBounds.length();
            this.bounds.put(InferenceBound.UPPER, declaredBounds);
            this.bounds.put(InferenceBound.LOWER, List.nil());
            this.bounds.put(InferenceBound.EQ, List.nil());
        }

        @Override
        public String toString() {
            return this.inst == null ? this.qtype + "?" : this.inst.toString();
        }

        public String debugString() {
            String result = "inference var = " + this.qtype + "\n";
            if (this.inst != null) {
                result = result + "inst = " + this.inst + '\n';
            }
            for (InferenceBound bound : InferenceBound.values()) {
                List<Type> aboundList = this.bounds.get((Object)bound);
                if (aboundList.size() <= 0) continue;
                result = result + (Object)((Object)bound) + " = " + aboundList + '\n';
            }
            return result;
        }

        @Override
        public boolean isPartial() {
            return true;
        }

        @Override
        public Type baseType() {
            return this.inst == null ? this : this.inst.baseType();
        }

        public List<Type> getBounds(InferenceBound ... ibs) {
            ListBuffer<Type> buf = new ListBuffer<Type>();
            for (InferenceBound ib : ibs) {
                buf.appendList(this.bounds.get((Object)ib));
            }
            return buf.toList();
        }

        public List<Type> getDeclaredBounds() {
            ListBuffer<Type> buf = new ListBuffer<Type>();
            int count = 0;
            for (Type b : this.getBounds(InferenceBound.UPPER)) {
                if (count++ == this.declaredCount) break;
                buf.append(b);
            }
            return buf.toList();
        }

        public void setBounds(InferenceBound ib, List<Type> newBounds) {
            this.bounds.put(ib, newBounds);
        }

        public final void addBound(InferenceBound ib, Type bound, Types types) {
            this.addBound(ib, bound, types, false);
        }

        protected void addBound(InferenceBound ib, Type bound, Types types, boolean update) {
            Type bound2 = this.toTypeVarMap.apply(bound).baseType();
            List<Type> prevBounds = this.bounds.get((Object)ib);
            for (Type b : prevBounds) {
                if (!types.isSameType(b, bound2, true) && bound != this.qtype) continue;
                return;
            }
            this.bounds.put(ib, prevBounds.prepend(bound2));
            this.notifyChange(EnumSet.of(ib));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void substBounds(List<Type> from, List<Type> to, Types types) {
            List<Type> instVars = from.diff(to);
            if (instVars.isEmpty()) {
                return;
            }
            final EnumSet<InferenceBound> boundsChanged = EnumSet.noneOf(InferenceBound.class);
            UndetVarListener prevListener = this.listener;
            try {
                this.listener = new UndetVarListener(){

                    @Override
                    public void varChanged(UndetVar uv, Set<InferenceBound> ibs) {
                        boundsChanged.addAll(ibs);
                    }
                };
                for (Map.Entry<InferenceBound, List<Type>> _entry : this.bounds.entrySet()) {
                    InferenceBound ib = _entry.getKey();
                    List<Type> prevBounds = _entry.getValue();
                    ListBuffer<Type> newBounds = new ListBuffer<Type>();
                    ListBuffer<Type> deps = new ListBuffer<Type>();
                    for (Type t : prevBounds) {
                        if (!t.containsAny(instVars)) {
                            newBounds.append(t);
                            continue;
                        }
                        deps.append(t);
                    }
                    this.bounds.put(ib, newBounds.toList());
                    for (Type dep : deps) {
                        this.addBound(ib, types.subst(dep, from, to), types, true);
                    }
                }
            }
            finally {
                this.listener = prevListener;
                if (!boundsChanged.isEmpty()) {
                    this.notifyChange(boundsChanged);
                }
            }
        }

        private void notifyChange(EnumSet<InferenceBound> ibs) {
            if (this.listener != null) {
                this.listener.varChanged(this, ibs);
            }
        }

        public boolean isCaptured() {
            return false;
        }

        public static enum InferenceBound {
            UPPER{

                @Override
                public InferenceBound complement() {
                    return LOWER;
                }
            }
            ,
            LOWER{

                @Override
                public InferenceBound complement() {
                    return UPPER;
                }
            }
            ,
            EQ{

                @Override
                public InferenceBound complement() {
                    return EQ;
                }
            };


            public abstract InferenceBound complement();
        }

        public static interface UndetVarListener {
            public void varChanged(UndetVar var1, Set<InferenceBound> var2);
        }
    }

    public static class ForAll
    extends DelegatedType
    implements ExecutableType {
        public List<Type> tvars;

        public ForAll(List<Type> tvars, Type qtype) {
            super(TypeTag.FORALL, (MethodType)qtype);
            this.tvars = tvars;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitForAll(this, s);
        }

        @Override
        public String toString() {
            return "<" + this.tvars + ">" + this.qtype;
        }

        @Override
        public List<Type> getTypeArguments() {
            return this.tvars;
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }

        @Override
        public Type map(Mapping f) {
            return f.apply(this.qtype);
        }

        @Override
        public boolean contains(Type elem) {
            return this.qtype.contains(elem);
        }

        @Override
        public MethodType asMethodType() {
            return (MethodType)this.qtype;
        }

        @Override
        public void complete() {
            List<Type> l = this.tvars;
            while (l.nonEmpty()) {
                ((TypeVar)l.head).bound.complete();
                l = l.tail;
            }
            this.qtype.complete();
        }

        public List<TypeVar> getTypeVariables() {
            return List.convert(TypeVar.class, this.getTypeArguments());
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.EXECUTABLE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitExecutable(this, p);
        }
    }

    public static abstract class DelegatedType
    extends Type {
        public Type qtype;
        public TypeTag tag;

        public DelegatedType(TypeTag tag, Type qtype) {
            super(qtype.tsym);
            this.tag = tag;
            this.qtype = qtype;
        }

        @Override
        public TypeTag getTag() {
            return this.tag;
        }

        @Override
        public String toString() {
            return this.qtype.toString();
        }

        @Override
        public List<Type> getTypeArguments() {
            return this.qtype.getTypeArguments();
        }

        @Override
        public Type getEnclosingType() {
            return this.qtype.getEnclosingType();
        }

        @Override
        public List<Type> getParameterTypes() {
            return this.qtype.getParameterTypes();
        }

        @Override
        public Type getReturnType() {
            return this.qtype.getReturnType();
        }

        @Override
        public Type getReceiverType() {
            return this.qtype.getReceiverType();
        }

        @Override
        public List<Type> getThrownTypes() {
            return this.qtype.getThrownTypes();
        }

        @Override
        public List<Type> allparams() {
            return this.qtype.allparams();
        }

        @Override
        public Type getUpperBound() {
            return this.qtype.getUpperBound();
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }
    }

    public static class CapturedType
    extends TypeVar {
        public WildcardType wildcard;

        public CapturedType(Name name, Symbol owner, Type upper, Type lower, WildcardType wildcard) {
            super(name, owner, lower);
            this.lower = Assert.checkNonNull(lower);
            this.bound = upper;
            this.wildcard = wildcard;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitCapturedType(this, s);
        }

        @Override
        public boolean isCaptured() {
            return true;
        }

        @Override
        public String toString() {
            return "capture#" + ((long)this.hashCode() & 0xFFFFFFFFL) % 997L + " of " + this.wildcard;
        }
    }

    public static class TypeVar
    extends Type
    implements TypeVariable {
        public Type bound = null;
        public Type lower;
        int rank_field = -1;

        public TypeVar(Name name, Symbol owner, Type lower) {
            super(null);
            this.tsym = new Symbol.TypeVariableSymbol(0L, name, this, owner);
            this.lower = lower;
        }

        public TypeVar(Symbol.TypeSymbol tsym, Type bound, Type lower) {
            super(tsym);
            this.bound = bound;
            this.lower = lower;
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.TYPEVAR;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitTypeVar(this, s);
        }

        @Override
        public Type getUpperBound() {
            if ((this.bound == null || this.bound.hasTag(TypeTag.NONE)) && this != this.tsym.type) {
                this.bound = this.tsym.type.getUpperBound();
            }
            return this.bound;
        }

        @Override
        public Type getLowerBound() {
            return this.lower;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.TYPEVAR;
        }

        public boolean isCaptured() {
            return false;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitTypeVariable(this, p);
        }
    }

    public static class PackageType
    extends Type
    implements NoType {
        PackageType(Symbol.TypeSymbol tsym) {
            super(tsym);
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.PACKAGE;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitPackageType(this, s);
        }

        @Override
        public String toString() {
            return this.tsym.getQualifiedName().toString();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.PACKAGE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }
    }

    public static class MethodType
    extends Type
    implements ExecutableType {
        public List<Type> argtypes;
        public Type restype;
        public List<Type> thrown;
        public Type recvtype;

        public MethodType(List<Type> argtypes, Type restype, List<Type> thrown, Symbol.TypeSymbol methodClass) {
            super(methodClass);
            this.argtypes = argtypes;
            this.restype = restype;
            this.thrown = thrown;
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.METHOD;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitMethodType(this, s);
        }

        @Override
        public String toString() {
            return "(" + this.argtypes + ")" + this.restype;
        }

        @Override
        public List<Type> getParameterTypes() {
            return this.argtypes;
        }

        @Override
        public Type getReturnType() {
            return this.restype;
        }

        @Override
        public Type getReceiverType() {
            return this.recvtype;
        }

        @Override
        public List<Type> getThrownTypes() {
            return this.thrown;
        }

        @Override
        public boolean isErroneous() {
            return MethodType.isErroneous(this.argtypes) || this.restype != null && this.restype.isErroneous();
        }

        @Override
        public Type map(Mapping f) {
            List<Type> argtypes1 = MethodType.map(this.argtypes, f);
            Type restype1 = f.apply(this.restype);
            List<Type> thrown1 = MethodType.map(this.thrown, f);
            if (argtypes1 == this.argtypes && restype1 == this.restype && thrown1 == this.thrown) {
                return this;
            }
            return new MethodType(argtypes1, restype1, thrown1, this.tsym);
        }

        @Override
        public boolean contains(Type elem) {
            return elem == this || MethodType.contains(this.argtypes, elem) || this.restype.contains(elem) || MethodType.contains(this.thrown, elem);
        }

        @Override
        public MethodType asMethodType() {
            return this;
        }

        @Override
        public void complete() {
            List<Type> l = this.argtypes;
            while (l.nonEmpty()) {
                ((Type)l.head).complete();
                l = l.tail;
            }
            this.restype.complete();
            this.recvtype.complete();
            l = this.thrown;
            while (l.nonEmpty()) {
                ((Type)l.head).complete();
                l = l.tail;
            }
        }

        public List<TypeVar> getTypeVariables() {
            return List.nil();
        }

        @Override
        public Symbol.TypeSymbol asElement() {
            return null;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.EXECUTABLE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitExecutable(this, p);
        }
    }

    public static class ArrayType
    extends Type
    implements javax.lang.model.type.ArrayType {
        public Type elemtype;

        public ArrayType(Type elemtype, Symbol.TypeSymbol arrayClass) {
            super(arrayClass);
            this.elemtype = elemtype;
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.ARRAY;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitArrayType(this, s);
        }

        @Override
        public String toString() {
            return this.elemtype + "[]";
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj || obj instanceof ArrayType && this.elemtype.equals(((ArrayType)obj).elemtype);
        }

        @Override
        public int hashCode() {
            return (TypeTag.ARRAY.ordinal() << 5) + this.elemtype.hashCode();
        }

        public boolean isVarargs() {
            return false;
        }

        @Override
        public List<Type> allparams() {
            return this.elemtype.allparams();
        }

        @Override
        public boolean isErroneous() {
            return this.elemtype.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.elemtype.isParameterized();
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public boolean isRaw() {
            return this.elemtype.isRaw();
        }

        public ArrayType makeVarargs() {
            return new ArrayType(this.elemtype, this.tsym){

                @Override
                public boolean isVarargs() {
                    return true;
                }
            };
        }

        @Override
        public Type map(Mapping f) {
            Type elemtype1 = f.apply(this.elemtype);
            if (elemtype1 == this.elemtype) {
                return this;
            }
            return new ArrayType(elemtype1, this.tsym);
        }

        @Override
        public boolean contains(Type elem) {
            return elem == this || this.elemtype.contains(elem);
        }

        @Override
        public void complete() {
            this.elemtype.complete();
        }

        @Override
        public Type getComponentType() {
            return this.elemtype;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.ARRAY;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitArray(this, p);
        }
    }

    public static class IntersectionClassType
    extends ClassType
    implements IntersectionType {
        public boolean allInterfaces;

        public IntersectionClassType(List<Type> bounds, Symbol.ClassSymbol csym, boolean allInterfaces) {
            super(noType, List.nil(), csym);
            this.allInterfaces = allInterfaces;
            Assert.check((csym.flags() & 0x1000000L) != 0L);
            this.supertype_field = (Type)bounds.head;
            this.interfaces_field = bounds.tail;
            Assert.check(this.supertype_field.tsym.completer != null || !this.supertype_field.isInterface(), this.supertype_field);
        }

        @Override
        public java.util.List<? extends TypeMirror> getBounds() {
            return Collections.unmodifiableList(this.getExplicitComponents());
        }

        public List<Type> getComponents() {
            return this.interfaces_field.prepend(this.supertype_field);
        }

        @Override
        public boolean isIntersection() {
            return true;
        }

        public List<Type> getExplicitComponents() {
            return this.allInterfaces ? this.interfaces_field : this.getComponents();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.INTERSECTION;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitIntersection(this, p);
        }
    }

    public static class UnionClassType
    extends ClassType
    implements UnionType {
        final List<? extends Type> alternatives_field;

        public UnionClassType(ClassType ct, List<? extends Type> alternatives) {
            super(ct.outer_field, ct.typarams_field, ct.tsym);
            this.allparams_field = ct.allparams_field;
            this.supertype_field = ct.supertype_field;
            this.interfaces_field = ct.interfaces_field;
            this.all_interfaces_field = ct.interfaces_field;
            this.alternatives_field = alternatives;
        }

        public Type getLub() {
            return this.tsym.type;
        }

        @Override
        public java.util.List<? extends TypeMirror> getAlternatives() {
            return Collections.unmodifiableList(this.alternatives_field);
        }

        @Override
        public boolean isUnion() {
            return true;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.UNION;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitUnion(this, p);
        }
    }

    public static class ErasedClassType
    extends ClassType {
        public ErasedClassType(Type outer, Symbol.TypeSymbol tsym) {
            super(outer, List.nil(), tsym);
        }

        @Override
        public boolean hasErasedSupertypes() {
            return true;
        }
    }

    public static class ClassType
    extends Type
    implements DeclaredType {
        private Type outer_field;
        public List<Type> typarams_field;
        public List<Type> allparams_field;
        public Type supertype_field;
        public List<Type> interfaces_field;
        public List<Type> all_interfaces_field;
        int rank_field = -1;

        public ClassType(Type outer, List<Type> typarams, Symbol.TypeSymbol tsym) {
            super(tsym);
            this.outer_field = outer;
            this.typarams_field = typarams;
            this.allparams_field = null;
            this.supertype_field = null;
            this.interfaces_field = null;
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.CLASS;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitClassType(this, s);
        }

        @Override
        public Type constType(Object constValue) {
            final Object value = constValue;
            return new ClassType(this.getEnclosingType(), this.typarams_field, this.tsym){

                @Override
                public Object constValue() {
                    return value;
                }

                @Override
                public Type baseType() {
                    return this.tsym.type;
                }
            };
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.getEnclosingType().hasTag(TypeTag.CLASS) && this.tsym.owner.kind == 2) {
                buf.append(this.getEnclosingType().toString());
                buf.append(".");
                buf.append(this.className(this.tsym, false));
            } else {
                buf.append(this.className(this.tsym, true));
            }
            if (((List)this.getTypeArguments()).nonEmpty()) {
                buf.append('<');
                buf.append(((List)this.getTypeArguments()).toString());
                buf.append(">");
            }
            return buf.toString();
        }

        private String className(Symbol sym, boolean longform) {
            if (sym.name.isEmpty() && (sym.flags() & 0x1000000L) != 0L) {
                StringBuilder s = new StringBuilder(this.supertype_field.toString());
                List<Type> is = this.interfaces_field;
                while (is.nonEmpty()) {
                    s.append("&");
                    s.append(((Type)is.head).toString());
                    is = is.tail;
                }
                return s.toString();
            }
            if (sym.name.isEmpty()) {
                ClassType norm = (ClassType)this.tsym.type.unannotatedType();
                String s = norm == null ? Log.getLocalizedString("anonymous.class", new Object[]{null}) : (norm.interfaces_field != null && norm.interfaces_field.nonEmpty() ? Log.getLocalizedString("anonymous.class", norm.interfaces_field.head) : Log.getLocalizedString("anonymous.class", norm.supertype_field));
                if (moreInfo) {
                    s = s + String.valueOf(sym.hashCode());
                }
                return s;
            }
            if (longform) {
                return sym.getQualifiedName().toString();
            }
            return sym.name.toString();
        }

        @Override
        public List<Type> getTypeArguments() {
            if (this.typarams_field == null) {
                this.complete();
                if (this.typarams_field == null) {
                    this.typarams_field = List.nil();
                }
            }
            return this.typarams_field;
        }

        public boolean hasErasedSupertypes() {
            return this.isRaw();
        }

        @Override
        public Type getEnclosingType() {
            return this.outer_field;
        }

        public void setEnclosingType(Type outer) {
            this.outer_field = outer;
        }

        @Override
        public List<Type> allparams() {
            if (this.allparams_field == null) {
                this.allparams_field = ((List)this.getTypeArguments()).prependList(this.getEnclosingType().allparams());
            }
            return this.allparams_field;
        }

        @Override
        public boolean isErroneous() {
            return this.getEnclosingType().isErroneous() || ClassType.isErroneous((List<Type>)this.getTypeArguments()) || this != this.tsym.type.unannotatedType() && this.tsym.type.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.allparams().tail != null;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public boolean isRaw() {
            return this != this.tsym.type && this.tsym.type.allparams().nonEmpty() && this.allparams().isEmpty();
        }

        @Override
        public Type map(Mapping f) {
            Type outer = this.getEnclosingType();
            Type outer1 = f.apply(outer);
            java.util.List typarams = this.getTypeArguments();
            List<Type> typarams1 = ClassType.map((List<Type>)typarams, f);
            if (outer1 == outer && typarams1 == typarams) {
                return this;
            }
            return new ClassType(outer1, typarams1, this.tsym);
        }

        @Override
        public boolean contains(Type elem) {
            return elem == this || this.isParameterized() && (this.getEnclosingType().contains(elem) || ClassType.contains((List<Type>)this.getTypeArguments(), elem)) || this.isCompound() && (this.supertype_field.contains(elem) || ClassType.contains(this.interfaces_field, elem));
        }

        @Override
        public void complete() {
            if (this.tsym.completer != null) {
                this.tsym.complete();
            }
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.DECLARED;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitDeclared(this, p);
        }
    }

    public static class WildcardType
    extends Type
    implements javax.lang.model.type.WildcardType {
        public Type type;
        public BoundKind kind;
        public TypeVar bound;
        boolean isPrintingBound = false;

        @Override
        public <R, S> R accept(Visitor<R, S> v, S s) {
            return v.visitWildcardType(this, s);
        }

        public WildcardType(Type type, BoundKind kind, Symbol.TypeSymbol tsym) {
            super(tsym);
            this.type = Assert.checkNonNull(type);
            this.kind = kind;
        }

        public WildcardType(WildcardType t, TypeVar bound) {
            this(t.type, t.kind, t.tsym, bound);
        }

        public WildcardType(Type type, BoundKind kind, Symbol.TypeSymbol tsym, TypeVar bound) {
            this(type, kind, tsym);
            this.bound = bound;
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.WILDCARD;
        }

        @Override
        public boolean contains(Type t) {
            return this.kind != BoundKind.UNBOUND && this.type.contains(t);
        }

        @Override
        public boolean isSuperBound() {
            return this.kind == BoundKind.SUPER || this.kind == BoundKind.UNBOUND;
        }

        @Override
        public boolean isExtendsBound() {
            return this.kind == BoundKind.EXTENDS || this.kind == BoundKind.UNBOUND;
        }

        @Override
        public boolean isUnbound() {
            return this.kind == BoundKind.UNBOUND;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public Type withTypeVar(Type t) {
            if (this.bound == t) {
                return this;
            }
            this.bound = (TypeVar)t;
            return this;
        }

        @Override
        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append(this.kind.toString());
            if (this.kind != BoundKind.UNBOUND) {
                s.append(this.type);
            }
            if (moreInfo && this.bound != null && !this.isPrintingBound) {
                try {
                    this.isPrintingBound = true;
                    s.append("{:").append(this.bound.bound).append(":}");
                }
                finally {
                    this.isPrintingBound = false;
                }
            }
            return s.toString();
        }

        @Override
        public Type map(Mapping f) {
            Type t = this.type;
            if (t != null) {
                t = f.apply(t);
            }
            if (t == this.type) {
                return this;
            }
            return new WildcardType(t, this.kind, this.tsym, this.bound);
        }

        @Override
        public Type getExtendsBound() {
            if (this.kind == BoundKind.EXTENDS) {
                return this.type;
            }
            return null;
        }

        @Override
        public Type getSuperBound() {
            if (this.kind == BoundKind.SUPER) {
                return this.type;
            }
            return null;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.WILDCARD;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitWildcard(this, p);
        }
    }

    public static class JCPrimitiveType
    extends Type
    implements PrimitiveType {
        TypeTag tag;

        public JCPrimitiveType(TypeTag tag, Symbol.TypeSymbol tsym) {
            super(tsym);
            this.tag = tag;
            Assert.check(tag.isPrimitive);
        }

        @Override
        public boolean isNumeric() {
            return this.tag != TypeTag.BOOLEAN;
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public TypeTag getTag() {
            return this.tag;
        }

        @Override
        public boolean isPrimitiveOrVoid() {
            return true;
        }

        @Override
        public Type constType(Object constValue) {
            final Object value = constValue;
            return new JCPrimitiveType(this.tag, this.tsym){

                @Override
                public Object constValue() {
                    return value;
                }

                @Override
                public Type baseType() {
                    return this.tsym.type;
                }
            };
        }

        @Override
        public String stringValue() {
            Object cv = Assert.checkNonNull(this.constValue());
            if (this.tag == TypeTag.BOOLEAN) {
                return (Integer)cv == 0 ? "false" : "true";
            }
            if (this.tag == TypeTag.CHAR) {
                return String.valueOf((char)((Integer)cv).intValue());
            }
            return cv.toString();
        }

        @Override
        public boolean isFalse() {
            return this.tag == TypeTag.BOOLEAN && this.constValue() != null && (Integer)this.constValue() == 0;
        }

        @Override
        public boolean isTrue() {
            return this.tag == TypeTag.BOOLEAN && this.constValue() != null && (Integer)this.constValue() != 0;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> v, P p) {
            return v.visitPrimitive(this, p);
        }

        @Override
        public TypeKind getKind() {
            switch (this.tag) {
                case BYTE: {
                    return TypeKind.BYTE;
                }
                case CHAR: {
                    return TypeKind.CHAR;
                }
                case SHORT: {
                    return TypeKind.SHORT;
                }
                case INT: {
                    return TypeKind.INT;
                }
                case LONG: {
                    return TypeKind.LONG;
                }
                case FLOAT: {
                    return TypeKind.FLOAT;
                }
                case DOUBLE: {
                    return TypeKind.DOUBLE;
                }
                case BOOLEAN: {
                    return TypeKind.BOOLEAN;
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class Mapping {
        private String name;

        public Mapping(String name) {
            this.name = name;
        }

        public abstract Type apply(Type var1);

        public String toString() {
            return this.name;
        }
    }
}

