/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.tools.javac.api.Formattable;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.jvm.ClassReader;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Warner;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.ElementVisitor;

public class Resolve {
    protected static final Context.Key<Resolve> resolveKey = new Context.Key();
    Names names;
    Log log;
    Symtab syms;
    Attr attr;
    DeferredAttr deferredAttr;
    Check chk;
    Infer infer;
    ClassReader reader;
    TreeInfo treeinfo;
    Types types;
    JCDiagnostic.Factory diags;
    public final boolean boxingEnabled;
    public final boolean varargsEnabled;
    public final boolean allowMethodHandles;
    public final boolean allowFunctionalInterfaceMostSpecific;
    public final boolean checkVarargsAccessAfterResolution;
    private final boolean debugResolve;
    private final boolean compactMethodDiags;
    final EnumSet<VerboseResolutionMode> verboseResolutionMode;
    Scope polymorphicSignatureScope;
    private final SymbolNotFoundError varNotFound;
    private final SymbolNotFoundError methodNotFound;
    private final SymbolNotFoundError methodWithCorrectStaticnessNotFound;
    private final SymbolNotFoundError typeNotFound;
    Types.SimpleVisitor<Void, Env<AttrContext>> accessibilityChecker = new Types.SimpleVisitor<Void, Env<AttrContext>>(){

        void visit(List<Type> ts, Env<AttrContext> env) {
            for (Type t : ts) {
                this.visit(t, env);
            }
        }

        @Override
        public Void visitType(Type t, Env<AttrContext> env) {
            return null;
        }

        @Override
        public Void visitArrayType(Type.ArrayType t, Env<AttrContext> env) {
            this.visit(t.elemtype, env);
            return null;
        }

        @Override
        public Void visitClassType(Type.ClassType t, Env<AttrContext> env) {
            this.visit((List<Type>)t.getTypeArguments(), env);
            if (!Resolve.this.isAccessible(env, (Type)t, true)) {
                Resolve.this.accessBase(new AccessError(t.tsym), env.tree.pos(), env.enclClass.sym, t, t.tsym.name, true);
            }
            return null;
        }

        @Override
        public Void visitWildcardType(Type.WildcardType t, Env<AttrContext> env) {
            this.visit(t.type, env);
            return null;
        }

        @Override
        public Void visitMethodType(Type.MethodType t, Env<AttrContext> env) {
            this.visit((List<Type>)t.getParameterTypes(), env);
            this.visit(t.getReturnType(), env);
            this.visit((List<Type>)t.getThrownTypes(), env);
            return null;
        }
    };
    MethodCheck nilMethodCheck = new MethodCheck(){

        @Override
        public void argumentsAcceptable(Env<AttrContext> env, DeferredAttr.DeferredAttrContext deferredAttrContext, List<Type> argtypes, List<Type> formals, Warner warn) {
        }

        @Override
        public MethodCheck mostSpecificCheck(List<Type> actuals, boolean strict) {
            return this;
        }
    };
    MethodCheck arityMethodCheck = new AbstractMethodCheck(){

        @Override
        void checkArg(JCDiagnostic.DiagnosticPosition pos, boolean varargs, Type actual, Type formal, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner warn) {
        }

        public String toString() {
            return "arityMethodCheck";
        }
    };
    MethodCheck resolveMethodCheck = new AbstractMethodCheck(){

        @Override
        void checkArg(JCDiagnostic.DiagnosticPosition pos, boolean varargs, Type actual, Type formal, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner warn) {
            Attr.ResultInfo mresult = this.methodCheckResult(varargs, formal, deferredAttrContext, warn);
            mresult.check(pos, actual);
        }

        @Override
        public void argumentsAcceptable(Env<AttrContext> env, DeferredAttr.DeferredAttrContext deferredAttrContext, List<Type> argtypes, List<Type> formals, Warner warn) {
            super.argumentsAcceptable(env, deferredAttrContext, argtypes, formals, warn);
            if (deferredAttrContext.phase.isVarargsRequired() && (deferredAttrContext.mode == DeferredAttr.AttrMode.CHECK || !Resolve.this.checkVarargsAccessAfterResolution)) {
                this.varargsAccessible(env, Resolve.this.types.elemtype(formals.last()), deferredAttrContext.inferenceContext);
            }
        }

        private void varargsAccessible(final Env<AttrContext> env, final Type t, Infer.InferenceContext inferenceContext) {
            if (inferenceContext.free(t)) {
                inferenceContext.addFreeTypeListener(List.of(t), new Infer.FreeTypeListener(){

                    @Override
                    public void typesInferred(Infer.InferenceContext inferenceContext) {
                        this.varargsAccessible(env, inferenceContext.asInstType(t), inferenceContext);
                    }
                });
            } else if (!Resolve.this.isAccessible(env, Resolve.this.types.erasure(t))) {
                Symbol.ClassSymbol location = env.enclClass.sym;
                this.reportMC(env.tree, MethodCheckDiag.INACCESSIBLE_VARARGS, inferenceContext, t, Kinds.kindName(location), location);
            }
        }

        private Attr.ResultInfo methodCheckResult(final boolean varargsCheck, Type to, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner rsWarner) {
            MethodCheckContext checkContext = new MethodCheckContext(!deferredAttrContext.phase.isBoxingRequired(), deferredAttrContext, rsWarner){
                MethodCheckDiag methodDiag;
                {
                    super(strict, deferredAttrContext, rsWarner);
                    this.methodDiag = varargsCheck ? MethodCheckDiag.VARARG_MISMATCH : MethodCheckDiag.ARG_MISMATCH;
                }

                @Override
                public void report(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic details) {
                    this.reportMC(pos, this.methodDiag, this.deferredAttrContext.inferenceContext, details);
                }
            };
            return new MethodResultInfo(to, checkContext);
        }

        @Override
        public MethodCheck mostSpecificCheck(List<Type> actuals, boolean strict) {
            return new MostSpecificCheck(strict, actuals);
        }

        public String toString() {
            return "resolveMethodCheck";
        }
    };
    private final InapplicableMethodException inapplicableMethodException;
    Warner noteWarner = new Warner();
    LogResolveHelper basicLogResolveHelper = new LogResolveHelper(){

        @Override
        public boolean resolveDiagnosticNeeded(Type site, List<Type> argtypes, List<Type> typeargtypes) {
            return !site.isErroneous();
        }

        @Override
        public List<Type> getArgumentTypes(ResolveError errSym, Symbol accessedSym, Name name, List<Type> argtypes) {
            return argtypes;
        }
    };
    LogResolveHelper methodLogResolveHelper = new LogResolveHelper(){

        @Override
        public boolean resolveDiagnosticNeeded(Type site, List<Type> argtypes, List<Type> typeargtypes) {
            return !site.isErroneous() && !Type.isErroneous(argtypes) && (typeargtypes == null || !Type.isErroneous(typeargtypes));
        }

        @Override
        public List<Type> getArgumentTypes(ResolveError errSym, Symbol accessedSym, Name name, List<Type> argtypes) {
            return Resolve.this.syms.operatorNames.contains(name) ? argtypes : Type.map(argtypes, new ResolveDeferredRecoveryMap(DeferredAttr.AttrMode.SPECULATIVE, accessedSym, Resolve.this.currentResolutionContext.step));
        }
    };
    private final Formattable.LocalizedString noArgs = new Formattable.LocalizedString("compiler.misc.no.args");
    final List<MethodResolutionPhase> methodResolutionSteps = List.of(MethodResolutionPhase.BASIC, MethodResolutionPhase.BOX, MethodResolutionPhase.VARARITY);
    MethodResolutionContext currentResolutionContext = null;

    protected Resolve(Context context) {
        context.put(resolveKey, this);
        this.syms = Symtab.instance(context);
        this.varNotFound = new SymbolNotFoundError(133);
        this.methodNotFound = new SymbolNotFoundError(136);
        this.methodWithCorrectStaticnessNotFound = new SymbolNotFoundError(138, "method found has incorrect staticness");
        this.typeNotFound = new SymbolNotFoundError(137);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.attr = Attr.instance(context);
        this.deferredAttr = DeferredAttr.instance(context);
        this.chk = Check.instance(context);
        this.infer = Infer.instance(context);
        this.reader = ClassReader.instance(context);
        this.treeinfo = TreeInfo.instance(context);
        this.types = Types.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        Source source = Source.instance(context);
        this.boxingEnabled = source.allowBoxing();
        this.varargsEnabled = source.allowVarargs();
        Options options = Options.instance(context);
        this.debugResolve = options.isSet("debugresolve");
        this.compactMethodDiags = options.isSet(Option.XDIAGS, "compact") || options.isUnset(Option.XDIAGS) && options.isUnset("rawDiagnostics");
        this.verboseResolutionMode = VerboseResolutionMode.getVerboseResolutionMode(options);
        Target target = Target.instance(context);
        this.allowMethodHandles = target.hasMethodHandles();
        this.allowFunctionalInterfaceMostSpecific = source.allowFunctionalInterfaceMostSpecific();
        this.checkVarargsAccessAfterResolution = source.allowPostApplicabilityVarargsAccessCheck();
        this.polymorphicSignatureScope = new Scope(this.syms.noSymbol);
        this.inapplicableMethodException = new InapplicableMethodException(this.diags);
    }

    public static Resolve instance(Context context) {
        Resolve instance = context.get(resolveKey);
        if (instance == null) {
            instance = new Resolve(context);
        }
        return instance;
    }

    void reportVerboseResolutionDiagnostic(JCDiagnostic.DiagnosticPosition dpos, Name name, Type site, List<Type> argtypes, List<Type> typeargtypes, Symbol bestSoFar) {
        boolean success;
        boolean bl = success = bestSoFar.kind < 128;
        if (success && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.SUCCESS)) {
            return;
        }
        if (!success && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.FAILURE)) {
            return;
        }
        if (bestSoFar.name == this.names.init && bestSoFar.owner == this.syms.objectType.tsym && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.OBJECT_INIT)) {
            return;
        }
        if (site == this.syms.predefClass.type && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.PREDEF)) {
            return;
        }
        if (this.currentResolutionContext.internalResolution && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.INTERNAL)) {
            return;
        }
        int pos = 0;
        int mostSpecificPos = -1;
        ListBuffer<JCDiagnostic> subDiags = new ListBuffer<JCDiagnostic>();
        for (MethodResolutionContext.Candidate c : this.currentResolutionContext.candidates) {
            if (this.currentResolutionContext.step != c.step || c.isApplicable() && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.APPLICABLE) || !c.isApplicable() && !this.verboseResolutionMode.contains((Object)VerboseResolutionMode.INAPPLICABLE)) continue;
            subDiags.append(c.isApplicable() ? this.getVerboseApplicableCandidateDiag(pos, c.sym, c.mtype) : this.getVerboseInapplicableCandidateDiag(pos, c.sym, c.details));
            if (c.sym == bestSoFar) {
                mostSpecificPos = pos;
            }
            ++pos;
        }
        String key = success ? "verbose.resolve.multi" : "verbose.resolve.multi.1";
        DeferredAttr deferredAttr = this.deferredAttr;
        deferredAttr.getClass();
        List<Type> argtypes2 = Type.map(argtypes, deferredAttr.new DeferredAttr.RecoveryDeferredTypeMap(DeferredAttr.AttrMode.SPECULATIVE, bestSoFar, this.currentResolutionContext.step));
        JCDiagnostic main = this.diags.note(this.log.currentSource(), dpos, key, new Object[]{name, site.tsym, mostSpecificPos, this.currentResolutionContext.step, this.methodArguments(argtypes2), this.methodArguments(typeargtypes)});
        JCDiagnostic.MultilineDiagnostic d = new JCDiagnostic.MultilineDiagnostic(main, subDiags.toList());
        this.log.report(d);
    }

    JCDiagnostic getVerboseApplicableCandidateDiag(int pos, Symbol sym, Type inst) {
        JCDiagnostic subDiag = null;
        if (sym.type.hasTag(TypeTag.FORALL)) {
            subDiag = this.diags.fragment("partial.inst.sig", inst);
        }
        String key = subDiag == null ? "applicable.method.found" : "applicable.method.found.1";
        return this.diags.fragment(key, pos, sym, subDiag);
    }

    JCDiagnostic getVerboseInapplicableCandidateDiag(int pos, Symbol sym, JCDiagnostic subDiag) {
        return this.diags.fragment("not.applicable.method.found", pos, sym, subDiag);
    }

    protected static boolean isStatic(Env<AttrContext> env) {
        return ((AttrContext)env.info).staticLevel > ((AttrContext)env.outer.info).staticLevel;
    }

    static boolean isInitializer(Env<AttrContext> env) {
        Symbol owner = ((AttrContext)env.info).scope.owner;
        return owner.isConstructor() || owner.owner.kind == 2 && (owner.kind == 4 || owner.kind == 16 && (owner.flags() & 0x100000L) != 0L) && (owner.flags() & 8L) == 0L;
    }

    public boolean isAccessible(Env<AttrContext> env, Symbol.TypeSymbol c) {
        return this.isAccessible(env, c, false);
    }

    public boolean isAccessible(Env<AttrContext> env, Symbol.TypeSymbol c, boolean checkInner) {
        boolean isAccessible = false;
        switch ((short)(c.flags() & 7L)) {
            case 2: {
                isAccessible = env.enclClass.sym.outermostClass() == c.owner.outermostClass();
                break;
            }
            case 0: {
                isAccessible = env.toplevel.packge == c.owner || env.toplevel.packge == c.packge() || env.enclMethod != null && (env.enclMethod.mods.flags & 0x20000000L) != 0L;
                break;
            }
            default: {
                isAccessible = true;
                break;
            }
            case 4: {
                boolean bl = isAccessible = env.toplevel.packge == c.owner || env.toplevel.packge == c.packge() || this.isInnerSubClass(env.enclClass.sym, c.owner);
            }
        }
        return !checkInner || c.type.getEnclosingType() == Type.noType ? isAccessible : isAccessible && this.isAccessible(env, c.type.getEnclosingType(), checkInner);
    }

    private boolean isInnerSubClass(Symbol.ClassSymbol c, Symbol base) {
        while (c != null && !c.isSubClass(base, this.types)) {
            c = c.owner.enclClass();
        }
        return c != null;
    }

    boolean isAccessible(Env<AttrContext> env, Type t) {
        return this.isAccessible(env, t, false);
    }

    boolean isAccessible(Env<AttrContext> env, Type t, boolean checkInner) {
        return t.hasTag(TypeTag.ARRAY) ? this.isAccessible(env, this.types.cvarUpperBound(this.types.elemtype(t))) : this.isAccessible(env, t.tsym, checkInner);
    }

    public boolean isAccessible(Env<AttrContext> env, Type site, Symbol sym) {
        return this.isAccessible(env, site, sym, false);
    }

    public boolean isAccessible(Env<AttrContext> env, Type site, Symbol sym, boolean checkInner) {
        if (sym.name == this.names.init && sym.owner != site.tsym) {
            return false;
        }
        switch ((short)(sym.flags() & 7L)) {
            case 2: {
                return (env.enclClass.sym == sym.owner || env.enclClass.sym.outermostClass() == sym.owner.outermostClass()) && sym.isInheritedIn(site.tsym, this.types);
            }
            case 0: {
                return (env.toplevel.packge == sym.owner.owner || env.toplevel.packge == sym.packge()) && this.isAccessible(env, site, checkInner) && sym.isInheritedIn(site.tsym, this.types) && this.notOverriddenIn(site, sym);
            }
            case 4: {
                return (env.toplevel.packge == sym.owner.owner || env.toplevel.packge == sym.packge() || this.isProtectedAccessible(sym, env.enclClass.sym, site) || ((AttrContext)env.info).selectSuper && (sym.flags() & 8L) == 0L && sym.kind != 2) && this.isAccessible(env, site, checkInner) && this.notOverriddenIn(site, sym);
            }
        }
        return this.isAccessible(env, site, checkInner) && this.notOverriddenIn(site, sym);
    }

    private boolean notOverriddenIn(Type site, Symbol sym) {
        if (sym.kind != 16 || sym.isConstructor() || sym.isStatic()) {
            return true;
        }
        Symbol.MethodSymbol s2 = ((Symbol.MethodSymbol)sym).implementation(site.tsym, this.types, true);
        return s2 == null || s2 == sym || sym.owner == s2.owner || !this.types.isSubSignature(this.types.memberType(site, s2), this.types.memberType(site, sym));
    }

    private boolean isProtectedAccessible(Symbol sym, Symbol.ClassSymbol c, Type site) {
        Type newSite;
        Type type = newSite = site.hasTag(TypeTag.TYPEVAR) ? site.getUpperBound() : site;
        while (c != null && (!c.isSubClass(sym.owner, this.types) || (c.flags() & 0x200L) != 0L || (sym.flags() & 8L) == 0L && sym.kind != 2 && !newSite.tsym.isSubClass(c, this.types))) {
            c = c.owner.enclClass();
        }
        return c != null;
    }

    void checkAccessibleType(Env<AttrContext> env, Type t) {
        this.accessibilityChecker.visit(t, env);
    }

    Type rawInstantiate(Env<AttrContext> env, Type site, Symbol m, Attr.ResultInfo resultInfo, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs, Warner warn) throws Infer.InferenceException {
        Type mt = this.types.memberType(site, m);
        List<Type> tvars = List.nil();
        if (typeargtypes == null) {
            typeargtypes = List.nil();
        }
        if (mt.hasTag(TypeTag.FORALL) || !typeargtypes.nonEmpty()) {
            Type.ForAll pmt;
            if (mt.hasTag(TypeTag.FORALL) && typeargtypes.nonEmpty()) {
                pmt = (Type.ForAll)mt;
                if (typeargtypes.length() != pmt.tvars.length()) {
                    throw this.inapplicableMethodException.setMessage("arg.length.mismatch");
                }
                List<Type> formals = pmt.tvars;
                List<Type> actuals = typeargtypes;
                while (formals.nonEmpty() && actuals.nonEmpty()) {
                    List<Type> bounds = this.types.subst(this.types.getBounds((Type.TypeVar)formals.head), pmt.tvars, typeargtypes);
                    while (bounds.nonEmpty()) {
                        if (!this.types.isSubtypeUnchecked((Type)actuals.head, (Type)bounds.head, warn)) {
                            throw this.inapplicableMethodException.setMessage("explicit.param.do.not.conform.to.bounds", actuals.head, bounds);
                        }
                        bounds = bounds.tail;
                    }
                    formals = formals.tail;
                    actuals = actuals.tail;
                }
                mt = this.types.subst(pmt.qtype, pmt.tvars, typeargtypes);
            } else if (mt.hasTag(TypeTag.FORALL)) {
                pmt = (Type.ForAll)mt;
                List<Type> tvars1 = this.types.newInstances(pmt.tvars);
                tvars = tvars.appendList(tvars1);
                mt = this.types.subst(pmt.qtype, pmt.tvars, tvars1);
            }
        }
        boolean instNeeded = tvars.tail != null;
        List<Type> l = argtypes;
        while (l.tail != null && !instNeeded) {
            if (((Type)l.head).hasTag(TypeTag.FORALL)) {
                instNeeded = true;
            }
            l = l.tail;
        }
        if (instNeeded) {
            return this.infer.instantiateMethod(env, tvars, (Type.MethodType)mt, resultInfo, (Symbol.MethodSymbol)m, argtypes, allowBoxing, useVarargs, this.currentResolutionContext, warn);
        }
        DeferredAttr.DeferredAttrContext dc = this.currentResolutionContext.deferredAttrContext(m, this.infer.emptyContext, resultInfo, warn);
        this.currentResolutionContext.methodCheck.argumentsAcceptable(env, dc, argtypes, mt.getParameterTypes(), warn);
        dc.complete();
        return mt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type checkMethod(Env<AttrContext> env, Type site, Symbol m, Attr.ResultInfo resultInfo, List<Type> argtypes, List<Type> typeargtypes, Warner warn) {
        MethodResolutionContext prevContext = this.currentResolutionContext;
        try {
            this.currentResolutionContext = new MethodResolutionContext();
            this.currentResolutionContext.attrMode = DeferredAttr.AttrMode.CHECK;
            if (env.tree.hasTag(JCTree.Tag.REFERENCE)) {
                this.currentResolutionContext.methodCheck = new MethodReferenceCheck(resultInfo.checkContext.inferenceContext());
            }
            MethodResolutionPhase step = this.currentResolutionContext.step = ((AttrContext)env.info).pendingResolutionPhase;
            Type type = this.rawInstantiate(env, site, m, resultInfo, argtypes, typeargtypes, step.isBoxingRequired(), step.isVarargsRequired(), warn);
            return type;
        }
        finally {
            this.currentResolutionContext = prevContext;
        }
    }

    Type instantiate(Env<AttrContext> env, Type site, Symbol m, Attr.ResultInfo resultInfo, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs, Warner warn) {
        try {
            return this.rawInstantiate(env, site, m, resultInfo, argtypes, typeargtypes, allowBoxing, useVarargs, warn);
        }
        catch (InapplicableMethodException ex) {
            return null;
        }
    }

    List<Type> dummyArgs(int length) {
        ListBuffer<Type.JCNoType> buf = new ListBuffer<Type.JCNoType>();
        for (int i = 0; i < length; ++i) {
            buf.append(Type.noType);
        }
        return buf.toList();
    }

    Symbol findField(Env<AttrContext> env, Type site, Name name, Symbol.TypeSymbol c) {
        Symbol sym;
        while (c.type.hasTag(TypeTag.TYPEVAR)) {
            c = c.type.getUpperBound().tsym;
        }
        Symbol bestSoFar = this.varNotFound;
        Scope.Entry e = c.members().lookup(name);
        while (e.scope != null) {
            if (e.sym.kind == 4 && (e.sym.flags_field & 0x1000L) == 0L) {
                return this.isAccessible(env, site, e.sym) ? e.sym : new AccessError(env, site, e.sym);
            }
            e = e.next();
        }
        Type st = this.types.supertype(c.type);
        if (st != null && (st.hasTag(TypeTag.CLASS) || st.hasTag(TypeTag.TYPEVAR))) {
            sym = this.findField(env, site, name, st.tsym);
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        List<Type> l = this.types.interfaces(c.type);
        while (bestSoFar.kind != 129 && l.nonEmpty()) {
            sym = this.findField(env, site, name, ((Type)l.head).tsym);
            if (bestSoFar.exists() && sym.exists() && sym.owner != bestSoFar.owner) {
                bestSoFar = new AmbiguityError(bestSoFar, sym);
            } else if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            l = l.tail;
        }
        return bestSoFar;
    }

    public Symbol.VarSymbol resolveInternalField(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, Name name) {
        Symbol sym = this.findField(env, site, name, site.tsym);
        if (sym.kind == 4) {
            return (Symbol.VarSymbol)sym;
        }
        throw new FatalError(this.diags.fragment("fatal.err.cant.locate.field", name));
    }

    Symbol findVar(Env<AttrContext> env, Name name) {
        Symbol sym;
        Symbol bestSoFar = this.varNotFound;
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            Scope.Entry e = ((AttrContext)env1.info).scope.lookup(name);
            while (e.scope != null && (e.sym.kind != 4 || (e.sym.flags_field & 0x1000L) != 0L)) {
                e = e.next();
            }
            Symbol symbol = sym = e.scope != null ? e.sym : this.findField(env1, env1.enclClass.sym.type, name, env1.enclClass.sym);
            if (sym.exists()) {
                if (staticOnly && sym.kind == 4 && sym.owner.kind == 2 && (sym.flags() & 8L) == 0L) {
                    return new StaticError(sym);
                }
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        sym = this.findField(env, this.syms.predefClass.type, name, this.syms.predefClass);
        if (sym.exists()) {
            return sym;
        }
        if (bestSoFar.exists()) {
            return bestSoFar;
        }
        Symbol origin = null;
        for (Scope sc : new Scope[]{env.toplevel.namedImportScope, env.toplevel.starImportScope}) {
            Scope.Entry e = sc.lookup(name);
            while (e.scope != null) {
                sym = e.sym;
                if (sym.kind == 4) {
                    if (bestSoFar.kind < 129 && sym.owner != bestSoFar.owner) {
                        return new AmbiguityError(bestSoFar, sym);
                    }
                    if (bestSoFar.kind >= 4) {
                        origin = e.getOrigin().owner;
                        bestSoFar = this.isAccessible(env, origin.type, sym) ? sym : new AccessError(env, origin.type, sym);
                    }
                }
                e = e.next();
            }
            if (bestSoFar.exists()) break;
        }
        if (bestSoFar.kind == 4 && bestSoFar.owner.type != origin.type) {
            return bestSoFar.clone(origin);
        }
        return bestSoFar;
    }

    Symbol selectBest(Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes, Symbol sym, Symbol bestSoFar, boolean allowBoxing, boolean useVarargs, boolean operator) {
        if (sym.kind == 63 || !sym.isInheritedIn(site.tsym, this.types)) {
            return bestSoFar;
        }
        if (useVarargs && (sym.flags() & 0x400000000L) == 0L) {
            return bestSoFar.kind >= 128 ? new BadVarargsMethod((ResolveError)bestSoFar.baseSymbol()) : bestSoFar;
        }
        Assert.check(sym.kind < 129);
        try {
            Type mt = this.rawInstantiate(env, site, sym, null, argtypes, typeargtypes, allowBoxing, useVarargs, this.types.noWarnings);
            if (!operator || this.verboseResolutionMode.contains((Object)VerboseResolutionMode.PREDEF)) {
                this.currentResolutionContext.addApplicableCandidate(sym, mt);
            }
        }
        catch (InapplicableMethodException ex) {
            if (!operator) {
                this.currentResolutionContext.addInapplicableCandidate(sym, ex.getDiagnostic());
            }
            switch (bestSoFar.kind) {
                case 136: {
                    return new InapplicableSymbolError(this.currentResolutionContext);
                }
                case 135: {
                    if (operator) {
                        return bestSoFar;
                    }
                    bestSoFar = new InapplicableSymbolsError(this.currentResolutionContext);
                }
            }
            return bestSoFar;
        }
        if (!this.isAccessible(env, site, sym)) {
            return bestSoFar.kind == 136 ? new AccessError(env, site, sym) : bestSoFar;
        }
        return bestSoFar.kind > 129 ? sym : this.mostSpecific(argtypes, sym, bestSoFar, env, site, allowBoxing && operator, useVarargs);
    }

    Symbol mostSpecific(List<Type> argtypes, Symbol m1, Symbol m2, Env<AttrContext> env, Type site, boolean allowBoxing, boolean useVarargs) {
        switch (m2.kind) {
            case 16: {
                if (m1 == m2) {
                    return m1;
                }
                boolean m1SignatureMoreSpecific = this.signatureMoreSpecific(argtypes, env, site, m1, m2, allowBoxing, useVarargs);
                boolean m2SignatureMoreSpecific = this.signatureMoreSpecific(argtypes, env, site, m2, m1, allowBoxing, useVarargs);
                if (m1SignatureMoreSpecific && m2SignatureMoreSpecific) {
                    boolean m2Abstract;
                    Type mt2;
                    Type mt1 = this.types.memberType(site, m1);
                    if (!this.types.overrideEquivalent(mt1, mt2 = this.types.memberType(site, m2))) {
                        return this.ambiguityError(m1, m2);
                    }
                    if ((m1.flags() & 0x80000000L) != (m2.flags() & 0x80000000L)) {
                        return (m1.flags() & 0x80000000L) != 0L ? m2 : m1;
                    }
                    Symbol.TypeSymbol m1Owner = (Symbol.TypeSymbol)m1.owner;
                    Symbol.TypeSymbol m2Owner = (Symbol.TypeSymbol)m2.owner;
                    if (this.types.asSuper(m1Owner.type, m2Owner) != null && ((m1.owner.flags_field & 0x200L) == 0L || (m2.owner.flags_field & 0x200L) != 0L) && m1.overrides(m2, m1Owner, this.types, false)) {
                        return m1;
                    }
                    if (this.types.asSuper(m2Owner.type, m1Owner) != null && ((m2.owner.flags_field & 0x200L) == 0L || (m1.owner.flags_field & 0x200L) != 0L) && m2.overrides(m1, m2Owner, this.types, false)) {
                        return m2;
                    }
                    boolean m1Abstract = (m1.flags() & 0x400L) != 0L;
                    boolean bl = m2Abstract = (m2.flags() & 0x400L) != 0L;
                    if (m1Abstract && !m2Abstract) {
                        return m2;
                    }
                    if (m2Abstract && !m1Abstract) {
                        return m1;
                    }
                    return this.ambiguityError(m1, m2);
                }
                if (m1SignatureMoreSpecific) {
                    return m1;
                }
                if (m2SignatureMoreSpecific) {
                    return m2;
                }
                return this.ambiguityError(m1, m2);
            }
            case 129: {
                AmbiguityError e = (AmbiguityError)m2.baseSymbol();
                boolean m1MoreSpecificThanAnyAmbiguous = true;
                boolean allAmbiguousMoreSpecificThanM1 = true;
                for (Symbol s : e.ambiguousSyms) {
                    Symbol moreSpecific = this.mostSpecific(argtypes, m1, s, env, site, allowBoxing, useVarargs);
                    m1MoreSpecificThanAnyAmbiguous &= moreSpecific == m1;
                    allAmbiguousMoreSpecificThanM1 &= moreSpecific == s;
                }
                if (m1MoreSpecificThanAnyAmbiguous) {
                    return m1;
                }
                if (!allAmbiguousMoreSpecificThanM1) {
                    e.addAmbiguousSymbol(m1);
                }
                return e;
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean signatureMoreSpecific(List<Type> actuals, Env<AttrContext> env, Type site, Symbol m1, Symbol m2, boolean allowBoxing, boolean useVarargs) {
        this.noteWarner.clear();
        int maxLength = Math.max(Math.max(m1.type.getParameterTypes().length(), actuals.length()), m2.type.getParameterTypes().length());
        MethodResolutionContext prevResolutionContext = this.currentResolutionContext;
        try {
            this.currentResolutionContext = new MethodResolutionContext();
            this.currentResolutionContext.step = prevResolutionContext.step;
            this.currentResolutionContext.methodCheck = prevResolutionContext.methodCheck.mostSpecificCheck(actuals, !allowBoxing);
            Type mst = this.instantiate(env, site, m2, null, this.adjustArgs(this.types.cvarLowerBounds(this.types.memberType(site, m1).getParameterTypes()), m1, maxLength, useVarargs), null, allowBoxing, useVarargs, this.noteWarner);
            boolean bl = mst != null && !this.noteWarner.hasLint(Lint.LintCategory.UNCHECKED);
            return bl;
        }
        finally {
            this.currentResolutionContext = prevResolutionContext;
        }
    }

    List<Type> adjustArgs(List<Type> args, Symbol msym, int length, boolean allowVarargs) {
        if ((msym.flags() & 0x400000000L) != 0L && allowVarargs) {
            Type varargsElem = this.types.elemtype(args.last());
            if (varargsElem == null) {
                Assert.error("Bad varargs = " + args.last() + " " + msym);
            }
            List<Type> newArgs = args.reverse().tail.prepend(varargsElem).reverse();
            while (newArgs.length() < length) {
                newArgs = newArgs.append(newArgs.last());
            }
            return newArgs;
        }
        return args;
    }

    Type mostSpecificReturnType(Type mt1, Type mt2) {
        Type rt1 = mt1.getReturnType();
        Type rt2 = mt2.getReturnType();
        if (mt1.hasTag(TypeTag.FORALL) && mt2.hasTag(TypeTag.FORALL)) {
            rt1 = this.types.subst(rt1, mt1.getTypeArguments(), mt2.getTypeArguments());
        }
        if (this.types.isSubtype(rt1, rt2)) {
            return mt1;
        }
        if (this.types.isSubtype(rt2, rt1)) {
            return mt2;
        }
        if (this.types.returnTypeSubstitutable(mt1, mt2)) {
            return mt1;
        }
        if (this.types.returnTypeSubstitutable(mt2, mt1)) {
            return mt2;
        }
        return null;
    }

    Symbol ambiguityError(Symbol m1, Symbol m2) {
        if (((m1.flags() | m2.flags()) & 0x40000000000L) != 0L) {
            return (m1.flags() & 0x40000000000L) == 0L ? m1 : m2;
        }
        return new AmbiguityError(m1, m2);
    }

    Symbol findMethodInScope(Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes, Scope sc, Symbol bestSoFar, boolean allowBoxing, boolean useVarargs, boolean operator, boolean abstractok) {
        for (Symbol s : sc.getElementsByName(name, new LookupFilter(abstractok))) {
            bestSoFar = this.selectBest(env, site, argtypes, typeargtypes, s, bestSoFar, allowBoxing, useVarargs, operator);
        }
        return bestSoFar;
    }

    Symbol findMethod(Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs, boolean operator) {
        Symbol bestSoFar = this.methodNotFound;
        bestSoFar = this.findMethod(env, site, name, argtypes, typeargtypes, site.tsym.type, bestSoFar, allowBoxing, useVarargs, operator);
        return bestSoFar;
    }

    private Symbol findMethod(Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes, Type intype, Symbol bestSoFar, boolean allowBoxing, boolean useVarargs, boolean operator) {
        List[] itypes = new List[]{List.nil(), List.nil()};
        InterfaceLookupPhase iphase = InterfaceLookupPhase.ABSTRACT_OK;
        for (Symbol.TypeSymbol s : this.superclasses(intype)) {
            bestSoFar = this.findMethodInScope(env, site, name, argtypes, typeargtypes, s.members(), bestSoFar, allowBoxing, useVarargs, operator, true);
            if (name == this.names.init) {
                return bestSoFar;
            }
            if ((iphase = iphase == null ? null : iphase.update(s, this)) == null) continue;
            for (Type itype : this.types.interfaces(s.type)) {
                itypes[iphase.ordinal()] = this.types.union(this.types.closure(itype), itypes[iphase.ordinal()]);
            }
        }
        SymbolNotFoundError concrete = bestSoFar.kind < 63 && (bestSoFar.flags() & 0x400L) == 0L ? bestSoFar : this.methodNotFound;
        for (InterfaceLookupPhase iphase2 : InterfaceLookupPhase.values()) {
            for (Type itype : itypes[iphase2.ordinal()]) {
                if (!itype.isInterface() || iphase2 == InterfaceLookupPhase.DEFAULT_OK && (itype.tsym.flags() & 0x80000000000L) == 0L || concrete == (bestSoFar = this.findMethodInScope(env, site, name, argtypes, typeargtypes, itype.tsym.members(), bestSoFar, allowBoxing, useVarargs, operator, true)) || concrete.kind >= 63 || bestSoFar.kind >= 63 || !this.types.isSubSignature(concrete.type, bestSoFar.type)) continue;
                bestSoFar = concrete;
            }
        }
        return bestSoFar;
    }

    Iterable<Symbol.TypeSymbol> superclasses(final Type intype) {
        return new Iterable<Symbol.TypeSymbol>(){

            @Override
            public Iterator<Symbol.TypeSymbol> iterator() {
                return new Iterator<Symbol.TypeSymbol>(){
                    List<Symbol.TypeSymbol> seen = List.nil();
                    Symbol.TypeSymbol currentSym;
                    Symbol.TypeSymbol prevSym;
                    {
                        this.currentSym = this.symbolFor(intype);
                        this.prevSym = null;
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.currentSym == Resolve.this.syms.noSymbol) {
                            this.currentSym = this.symbolFor(Resolve.this.types.supertype(this.prevSym.type));
                        }
                        return this.currentSym != null;
                    }

                    @Override
                    public Symbol.TypeSymbol next() {
                        this.prevSym = this.currentSym;
                        this.currentSym = Resolve.this.syms.noSymbol;
                        Assert.check(this.prevSym != null || this.prevSym != Resolve.this.syms.noSymbol);
                        return this.prevSym;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    Symbol.TypeSymbol symbolFor(Type t) {
                        if (!t.hasTag(TypeTag.CLASS) && !t.hasTag(TypeTag.TYPEVAR)) {
                            return null;
                        }
                        while (t.hasTag(TypeTag.TYPEVAR)) {
                            t = t.getUpperBound();
                        }
                        if (this.seen.contains(t.tsym)) {
                            return null;
                        }
                        this.seen = this.seen.prepend(t.tsym);
                        return t.tsym;
                    }
                };
            }
        };
    }

    Symbol findFun(Env<AttrContext> env, Name name, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs) {
        Type origin;
        Symbol sym;
        Symbol bestSoFar = this.methodNotFound;
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            if ((sym = this.findMethod(env1, env1.enclClass.sym.type, name, argtypes, typeargtypes, allowBoxing, useVarargs, false)).exists()) {
                if (staticOnly && sym.kind == 16 && sym.owner.kind == 2 && (sym.flags() & 8L) == 0L) {
                    return new StaticError(sym);
                }
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        sym = this.findMethod(env, this.syms.predefClass.type, name, argtypes, typeargtypes, allowBoxing, useVarargs, false);
        if (sym.exists()) {
            return sym;
        }
        Scope.Entry e = env.toplevel.namedImportScope.lookup(name);
        while (e.scope != null) {
            sym = e.sym;
            origin = e.getOrigin().owner.type;
            if (sym.kind == 16) {
                if (e.sym.owner.type != origin) {
                    sym = sym.clone(e.getOrigin().owner);
                }
                if (!this.isAccessible(env, origin, sym)) {
                    sym = new AccessError(env, origin, sym);
                }
                bestSoFar = this.selectBest(env, origin, argtypes, typeargtypes, sym, bestSoFar, allowBoxing, useVarargs, false);
            }
            e = e.next();
        }
        if (bestSoFar.exists()) {
            return bestSoFar;
        }
        e = env.toplevel.starImportScope.lookup(name);
        while (e.scope != null) {
            sym = e.sym;
            origin = e.getOrigin().owner.type;
            if (sym.kind == 16) {
                if (e.sym.owner.type != origin) {
                    sym = sym.clone(e.getOrigin().owner);
                }
                if (!this.isAccessible(env, origin, sym)) {
                    sym = new AccessError(env, origin, sym);
                }
                bestSoFar = this.selectBest(env, origin, argtypes, typeargtypes, sym, bestSoFar, allowBoxing, useVarargs, false);
            }
            e = e.next();
        }
        return bestSoFar;
    }

    Symbol loadClass(Env<AttrContext> env, Name name) {
        try {
            Symbol.ClassSymbol c = this.reader.loadClass(name);
            return this.isAccessible(env, c) ? c : new AccessError(c);
        }
        catch (ClassReader.BadClassFile err) {
            throw err;
        }
        catch (Symbol.CompletionFailure ex) {
            return this.typeNotFound;
        }
    }

    Symbol findImmediateMemberType(Env<AttrContext> env, Type site, Name name, Symbol.TypeSymbol c) {
        Scope.Entry e = c.members().lookup(name);
        while (e.scope != null) {
            if (e.sym.kind == 2) {
                return this.isAccessible(env, site, e.sym) ? e.sym : new AccessError(env, site, e.sym);
            }
            e = e.next();
        }
        return this.typeNotFound;
    }

    Symbol findInheritedMemberType(Env<AttrContext> env, Type site, Name name, Symbol.TypeSymbol c) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        Type st = this.types.supertype(c.type);
        if (st != null && st.hasTag(TypeTag.CLASS)) {
            sym = this.findMemberType(env, site, name, st.tsym);
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        List<Type> l = this.types.interfaces(c.type);
        while (bestSoFar.kind != 129 && l.nonEmpty()) {
            sym = this.findMemberType(env, site, name, ((Type)l.head).tsym);
            if (bestSoFar.kind < 129 && sym.kind < 129 && sym.owner != bestSoFar.owner) {
                bestSoFar = new AmbiguityError(bestSoFar, sym);
            } else if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            l = l.tail;
        }
        return bestSoFar;
    }

    Symbol findMemberType(Env<AttrContext> env, Type site, Name name, Symbol.TypeSymbol c) {
        Symbol sym = this.findImmediateMemberType(env, site, name, c);
        if (sym != this.typeNotFound) {
            return sym;
        }
        return this.findInheritedMemberType(env, site, name, c);
    }

    Symbol findGlobalType(Env<AttrContext> env, Scope scope, Name name) {
        Symbol bestSoFar = this.typeNotFound;
        Scope.Entry e = scope.lookup(name);
        while (e.scope != null) {
            Symbol sym = this.loadClass(env, e.sym.flatName());
            if (bestSoFar.kind == 2 && sym.kind == 2 && bestSoFar != sym) {
                return new AmbiguityError(bestSoFar, sym);
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            e = e.next();
        }
        return bestSoFar;
    }

    Symbol findTypeVar(Env<AttrContext> env, Name name, boolean staticOnly) {
        Scope.Entry e = ((AttrContext)env.info).scope.lookup(name);
        while (e.scope != null) {
            if (e.sym.kind == 2) {
                if (staticOnly && e.sym.type.hasTag(TypeTag.TYPEVAR) && e.sym.owner.kind == 2) {
                    return new StaticError(e.sym);
                }
                return e.sym;
            }
            e = e.next();
        }
        return this.typeNotFound;
    }

    Symbol findType(Env<AttrContext> env, Name name) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        boolean staticOnly = false;
        Env<AttrContext> env1 = env;
        while (env1.outer != null) {
            JCTree.JCClassDecl encl;
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            Symbol tyvar = this.findTypeVar(env1, name, staticOnly);
            sym = this.findImmediateMemberType(env1, env1.enclClass.sym.type, name, env1.enclClass.sym);
            if (tyvar != this.typeNotFound && (sym == this.typeNotFound || tyvar.kind == 2 && tyvar.exists() && tyvar.owner.kind == 16)) {
                return tyvar;
            }
            if (sym == this.typeNotFound) {
                sym = this.findInheritedMemberType(env1, env1.enclClass.sym.type, name, env1.enclClass.sym);
            }
            if (staticOnly && sym.kind == 2 && sym.type.hasTag(TypeTag.CLASS) && sym.type.getEnclosingType().hasTag(TypeTag.CLASS) && env1.enclClass.sym.type.isParameterized() && sym.type.getEnclosingType().isParameterized()) {
                return new StaticError(sym);
            }
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            JCTree.JCClassDecl jCClassDecl = encl = env1.baseClause ? (JCTree.JCClassDecl)env1.tree : env1.enclClass;
            if ((encl.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        if (!env.tree.hasTag(JCTree.Tag.IMPORT)) {
            sym = this.findGlobalType(env, env.toplevel.namedImportScope, name);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            if ((sym = this.findGlobalType(env, env.toplevel.packge.members(), name)).exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
            if ((sym = this.findGlobalType(env, env.toplevel.starImportScope, name)).exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        return bestSoFar;
    }

    Symbol findIdent(Env<AttrContext> env, Name name, int kind) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        if ((kind & 4) != 0) {
            sym = this.findVar(env, name);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((kind & 2) != 0) {
            sym = this.findType(env, name);
            if (sym.kind == 2) {
                this.reportDependence(env.enclClass.sym, sym);
            }
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((kind & 1) != 0) {
            return this.reader.enterPackage(name);
        }
        return bestSoFar;
    }

    public void reportDependence(Symbol from, Symbol to) {
    }

    Symbol findIdentInPackage(Env<AttrContext> env, Symbol.TypeSymbol pck, Name name, int kind) {
        Name fullname = Symbol.TypeSymbol.formFullName(name, pck);
        Symbol bestSoFar = this.typeNotFound;
        Symbol.PackageSymbol pack = null;
        if ((kind & 1) != 0 && (pack = this.reader.enterPackage(fullname)).exists()) {
            return pack;
        }
        if ((kind & 2) != 0) {
            Symbol sym = this.loadClass(env, fullname);
            if (sym.exists()) {
                if (name == sym.name) {
                    return sym;
                }
            } else if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        return pack != null ? pack : bestSoFar;
    }

    Symbol findIdentInType(Env<AttrContext> env, Type site, Name name, int kind) {
        Symbol sym;
        Symbol bestSoFar = this.typeNotFound;
        if ((kind & 4) != 0) {
            sym = this.findField(env, site, name, site.tsym);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        if ((kind & 2) != 0) {
            sym = this.findMemberType(env, site, name, site.tsym);
            if (sym.exists()) {
                return sym;
            }
            if (sym.kind < bestSoFar.kind) {
                bestSoFar = sym;
            }
        }
        return bestSoFar;
    }

    Symbol accessInternal(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, boolean qualified, List<Type> argtypes, List<Type> typeargtypes, LogResolveHelper logResolveHelper) {
        ResolveError errSym;
        if (sym.kind >= 129 && logResolveHelper.resolveDiagnosticNeeded(site, argtypes = logResolveHelper.getArgumentTypes(errSym = (ResolveError)sym.baseSymbol(), sym = errSym.access(name, qualified ? site.tsym : this.syms.noSymbol), name, argtypes), typeargtypes)) {
            this.logResolveError(errSym, pos, location, site, name, argtypes, typeargtypes);
        }
        return sym;
    }

    Symbol accessMethod(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, boolean qualified, List<Type> argtypes, List<Type> typeargtypes) {
        return this.accessInternal(sym, pos, location, site, name, qualified, argtypes, typeargtypes, this.methodLogResolveHelper);
    }

    Symbol accessMethod(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Type site, Name name, boolean qualified, List<Type> argtypes, List<Type> typeargtypes) {
        return this.accessMethod(sym, pos, site.tsym, site, name, qualified, argtypes, typeargtypes);
    }

    Symbol accessBase(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, boolean qualified) {
        return this.accessInternal(sym, pos, location, site, name, qualified, List.nil(), null, this.basicLogResolveHelper);
    }

    Symbol accessBase(Symbol sym, JCDiagnostic.DiagnosticPosition pos, Type site, Name name, boolean qualified) {
        return this.accessBase(sym, pos, site.tsym, site, name, qualified);
    }

    void checkNonAbstract(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        if ((sym.flags() & 0x400L) != 0L && (sym.flags() & 0x80000000000L) == 0L) {
            this.log.error(pos, "abstract.cant.be.accessed.directly", Kinds.kindName(sym), sym, sym.location());
        }
    }

    public void printscopes(Scope s) {
        while (s != null) {
            if (s.owner != null) {
                System.err.print(s.owner + ": ");
            }
            Scope.Entry e = s.elems;
            while (e != null) {
                if ((e.sym.flags() & 0x400L) != 0L) {
                    System.err.print("abstract ");
                }
                System.err.print(e.sym + " ");
                e = e.sibling;
            }
            System.err.println();
            s = s.next;
        }
    }

    void printscopes(Env<AttrContext> env) {
        while (env.outer != null) {
            System.err.println("------------------------------");
            this.printscopes(((AttrContext)env.info).scope);
            env = env.outer;
        }
    }

    public void printscopes(Type t) {
        while (t.hasTag(TypeTag.CLASS)) {
            this.printscopes(t.tsym.members());
            t = this.types.supertype(t);
        }
    }

    Symbol resolveIdent(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Name name, int kind) {
        return this.accessBase(this.findIdent(env, name, kind), pos, env.enclClass.sym.type, name, false);
    }

    Symbol resolveMethod(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        return this.lookupMethod(env, pos, (Symbol)env.enclClass.sym, this.resolveMethodCheck, (LookupHelper)new BasicLookupHelper(name, env.enclClass.sym.type, (List)argtypes, (List)typeargtypes){

            @Override
            Symbol doLookup(Env<AttrContext> env, MethodResolutionPhase phase) {
                return Resolve.this.findFun(env, this.name, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired());
            }
        });
    }

    Symbol resolveQualifiedMethod(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        return this.resolveQualifiedMethod(pos, env, site.tsym, site, name, argtypes, typeargtypes);
    }

    Symbol resolveQualifiedMethod(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        return this.resolveQualifiedMethod(new MethodResolutionContext(), pos, env, location, site, name, argtypes, typeargtypes);
    }

    private Symbol resolveQualifiedMethod(MethodResolutionContext resolveContext, JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        return this.lookupMethod(env, pos, location, resolveContext, (LookupHelper)new BasicLookupHelper(name, site, (List)argtypes, (List)typeargtypes){

            @Override
            Symbol doLookup(Env<AttrContext> env, MethodResolutionPhase phase) {
                return Resolve.this.findMethod(env, this.site, this.name, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired(), false);
            }

            @Override
            Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition pos, Symbol location, Symbol sym) {
                Symbol.MethodSymbol msym;
                if (sym.kind >= 129) {
                    sym = super.access(env, pos, location, sym);
                } else if (Resolve.this.allowMethodHandles && ((msym = (Symbol.MethodSymbol)sym).flags() & 0x400000000000L) != 0L) {
                    return Resolve.this.findPolymorphicSignatureInstance(env, sym, this.argtypes);
                }
                return sym;
            }
        });
    }

    Symbol findPolymorphicSignatureInstance(Env<AttrContext> env, final Symbol spMethod, List<Type> argtypes) {
        Type mtype = this.infer.instantiatePolymorphicSignatureInstance(env, (Symbol.MethodSymbol)spMethod, this.currentResolutionContext, argtypes);
        for (Symbol sym : this.polymorphicSignatureScope.getElementsByName(spMethod.name)) {
            if (!this.types.isSameType(mtype, sym.type)) continue;
            return sym;
        }
        long flags = 0x2000000400L | spMethod.flags() & 7L;
        Symbol.MethodSymbol msym = new Symbol.MethodSymbol(flags, spMethod.name, mtype, spMethod.owner){

            @Override
            public Symbol baseSymbol() {
                return spMethod;
            }
        };
        this.polymorphicSignatureScope.enter(msym);
        return msym;
    }

    public Symbol.MethodSymbol resolveInternalMethod(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        MethodResolutionContext resolveContext = new MethodResolutionContext();
        resolveContext.internalResolution = true;
        Symbol sym = this.resolveQualifiedMethod(resolveContext, pos, env, site.tsym, site, name, argtypes, typeargtypes);
        if (sym.kind == 16) {
            return (Symbol.MethodSymbol)sym;
        }
        throw new FatalError(this.diags.fragment("fatal.err.cant.locate.meth", name));
    }

    Symbol resolveConstructor(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes) {
        return this.resolveConstructor(new MethodResolutionContext(), pos, env, site, argtypes, typeargtypes);
    }

    private Symbol resolveConstructor(MethodResolutionContext resolveContext, final JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes) {
        return this.lookupMethod(env, pos, (Symbol)site.tsym, resolveContext, (LookupHelper)new BasicLookupHelper(this.names.init, site, argtypes, typeargtypes){

            @Override
            Symbol doLookup(Env<AttrContext> env, MethodResolutionPhase phase) {
                return Resolve.this.findConstructor(pos, env, this.site, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired());
            }
        });
    }

    public Symbol.MethodSymbol resolveInternalConstructor(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes) {
        MethodResolutionContext resolveContext = new MethodResolutionContext();
        resolveContext.internalResolution = true;
        Symbol sym = this.resolveConstructor(resolveContext, pos, env, site, argtypes, typeargtypes);
        if (sym.kind == 16) {
            return (Symbol.MethodSymbol)sym;
        }
        throw new FatalError(this.diags.fragment("fatal.err.cant.locate.ctor", site));
    }

    Symbol findConstructor(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs) {
        Symbol sym = this.findMethod(env, site, this.names.init, argtypes, typeargtypes, allowBoxing, useVarargs, false);
        this.chk.checkDeprecated(pos, ((AttrContext)env.info).scope.owner, sym);
        return sym;
    }

    Symbol resolveDiamond(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes) {
        return this.lookupMethod(env, pos, (Symbol)site.tsym, this.resolveMethodCheck, (LookupHelper)new BasicLookupHelper(this.names.init, site, (List)argtypes, (List)typeargtypes){

            @Override
            Symbol doLookup(Env<AttrContext> env, MethodResolutionPhase phase) {
                return Resolve.this.findDiamond(env, this.site, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired());
            }

            @Override
            Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition pos, Symbol location, Symbol sym) {
                if (sym.kind >= 129) {
                    if (sym.kind != 135 && sym.kind != 134) {
                        sym = super.access(env, pos, location, sym);
                    } else {
                        final JCDiagnostic details = sym.kind == 135 ? (JCDiagnostic)((InapplicableSymbolError)sym.baseSymbol()).errCandidate().snd : null;
                        sym = new InapplicableSymbolError(sym.kind, "diamondError", Resolve.this.currentResolutionContext){

                            @Override
                            JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
                                String key = details == null ? "cant.apply.diamond" : "cant.apply.diamond.1";
                                return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, key, Resolve.this.diags.fragment("diamond", site.tsym), details);
                            }
                        };
                        sym = Resolve.this.accessMethod(sym, pos, this.site, Resolve.this.names.init, true, this.argtypes, this.typeargtypes);
                        ((AttrContext)env.info).pendingResolutionPhase = Resolve.this.currentResolutionContext.step;
                    }
                }
                return sym;
            }
        });
    }

    private Symbol findDiamond(Env<AttrContext> env, Type site, List<Type> argtypes, List<Type> typeargtypes, boolean allowBoxing, boolean useVarargs) {
        Symbol bestSoFar = this.methodNotFound;
        Scope.Entry e = site.tsym.members().lookup(this.names.init);
        while (e.scope != null) {
            final Symbol sym = e.sym;
            if (sym.kind == 16 && (sym.flags_field & 0x1000L) == 0L) {
                List oldParams = e.sym.type.hasTag(TypeTag.FORALL) ? ((Type.ForAll)sym.type).tvars : List.nil();
                Type.ForAll constrType = new Type.ForAll(site.tsym.type.getTypeArguments().appendList(oldParams), this.types.createMethodTypeWithReturn(sym.type.asMethodType(), site));
                Symbol.MethodSymbol newConstr = new Symbol.MethodSymbol(sym.flags(), this.names.init, constrType, site.tsym){

                    @Override
                    public Symbol baseSymbol() {
                        return sym;
                    }
                };
                bestSoFar = this.selectBest(env, site, argtypes, typeargtypes, newConstr, bestSoFar, allowBoxing, useVarargs, false);
            }
            e = e.next();
        }
        return bestSoFar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Symbol resolveOperator(JCDiagnostic.DiagnosticPosition pos, JCTree.Tag optag, Env<AttrContext> env, List<Type> argtypes) {
        MethodResolutionContext prevResolutionContext = this.currentResolutionContext;
        try {
            this.currentResolutionContext = new MethodResolutionContext();
            Name name = this.treeinfo.operatorName(optag);
            Symbol symbol = this.lookupMethod(env, pos, (Symbol)this.syms.predefClass, this.currentResolutionContext, (LookupHelper)new BasicLookupHelper(name, this.syms.predefClass.type, (List)argtypes, null, MethodResolutionPhase.BOX){

                @Override
                Symbol doLookup(Env<AttrContext> env, MethodResolutionPhase phase) {
                    return Resolve.this.findMethod(env, this.site, this.name, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired(), true);
                }

                @Override
                Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition pos, Symbol location, Symbol sym) {
                    return Resolve.this.accessMethod(sym, pos, env.enclClass.sym.type, this.name, false, this.argtypes, null);
                }
            });
            return symbol;
        }
        finally {
            this.currentResolutionContext = prevResolutionContext;
        }
    }

    Symbol resolveUnaryOperator(JCDiagnostic.DiagnosticPosition pos, JCTree.Tag optag, Env<AttrContext> env, Type arg) {
        return this.resolveOperator(pos, optag, env, List.of(arg));
    }

    Symbol resolveBinaryOperator(JCDiagnostic.DiagnosticPosition pos, JCTree.Tag optag, Env<AttrContext> env, Type left, Type right) {
        return this.resolveOperator(pos, optag, env, List.of(left, right));
    }

    Symbol getMemberReference(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, JCTree.JCMemberReference referenceTree, Type site, Name name) {
        site = this.types.capture(site);
        ReferenceLookupHelper lookupHelper = this.makeReferenceLookupHelper(referenceTree, site, name, List.nil(), null, MethodResolutionPhase.VARARITY);
        Env<AttrContext> newEnv = env.dup(env.tree, ((AttrContext)env.info).dup());
        Symbol sym = this.lookupMethod(newEnv, env.tree.pos(), (Symbol)site.tsym, this.nilMethodCheck, (LookupHelper)lookupHelper);
        ((AttrContext)env.info).pendingResolutionPhase = ((AttrContext)newEnv.info).pendingResolutionPhase;
        return sym;
    }

    ReferenceLookupHelper makeReferenceLookupHelper(JCTree.JCMemberReference referenceTree, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes, MethodResolutionPhase maxPhase) {
        ReferenceLookupHelper result = !name.equals(this.names.init) ? new MethodReferenceLookupHelper(referenceTree, name, site, argtypes, typeargtypes, maxPhase) : (site.hasTag(TypeTag.ARRAY) ? new ArrayConstructorReferenceLookupHelper(referenceTree, site, argtypes, typeargtypes, maxPhase) : new ConstructorReferenceLookupHelper(referenceTree, site, argtypes, typeargtypes, maxPhase));
        return result;
    }

    Symbol resolveMemberReferenceByArity(Env<AttrContext> env, JCTree.JCMemberReference referenceTree, Type site, Name name, List<Type> argtypes, Infer.InferenceContext inferenceContext) {
        boolean isStaticSelector = TreeInfo.isStaticSelector(referenceTree.expr, this.names);
        site = this.types.capture(site);
        ReferenceLookupHelper boundLookupHelper = this.makeReferenceLookupHelper(referenceTree, site, name, argtypes, null, MethodResolutionPhase.VARARITY);
        Env<AttrContext> boundEnv = env.dup(env.tree, ((AttrContext)env.info).dup());
        Symbol boundSym = this.lookupMethod(boundEnv, env.tree.pos(), (Symbol)site.tsym, this.arityMethodCheck, (LookupHelper)boundLookupHelper);
        if (isStaticSelector && !name.equals(this.names.init) && !boundSym.isStatic() && boundSym.kind < 128) {
            boundSym = this.methodNotFound;
        }
        Symbol unboundSym = this.methodNotFound;
        ReferenceLookupHelper unboundLookupHelper = null;
        Env<AttrContext> unboundEnv = env.dup(env.tree, ((AttrContext)env.info).dup());
        if (isStaticSelector) {
            unboundLookupHelper = boundLookupHelper.unboundLookup(inferenceContext);
            unboundSym = this.lookupMethod(unboundEnv, env.tree.pos(), (Symbol)site.tsym, this.arityMethodCheck, (LookupHelper)unboundLookupHelper);
            if (unboundSym.isStatic() && unboundSym.kind < 128) {
                unboundSym = this.methodNotFound;
            }
        }
        Symbol bestSym = this.choose(boundSym, unboundSym);
        ((AttrContext)env.info).pendingResolutionPhase = bestSym == unboundSym ? ((AttrContext)unboundEnv.info).pendingResolutionPhase : ((AttrContext)boundEnv.info).pendingResolutionPhase;
        return bestSym;
    }

    Pair<Symbol, ReferenceLookupHelper> resolveMemberReference(Env<AttrContext> env, JCTree.JCMemberReference referenceTree, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes, MethodCheck methodCheck, Infer.InferenceContext inferenceContext, DeferredAttr.AttrMode mode) {
        boolean shouldCheckForStaticness;
        Symbol origBoundSym;
        site = this.types.capture(site);
        ReferenceLookupHelper boundLookupHelper = this.makeReferenceLookupHelper(referenceTree, site, name, argtypes, typeargtypes, MethodResolutionPhase.VARARITY);
        Env<AttrContext> boundEnv = env.dup(env.tree, ((AttrContext)env.info).dup());
        boolean staticErrorForBound = false;
        MethodResolutionContext boundSearchResolveContext = new MethodResolutionContext();
        boundSearchResolveContext.methodCheck = methodCheck;
        Symbol boundSym = origBoundSym = this.lookupMethod(boundEnv, env.tree.pos(), (Symbol)site.tsym, boundSearchResolveContext, (LookupHelper)boundLookupHelper);
        SearchResultKind boundSearchResultKind = SearchResultKind.NOT_APPLICABLE_MATCH;
        boolean isStaticSelector = TreeInfo.isStaticSelector(referenceTree.expr, this.names);
        boolean bl = shouldCheckForStaticness = isStaticSelector && referenceTree.getMode() == MemberReferenceTree.ReferenceMode.INVOKE;
        if (boundSym.kind != 134 && boundSym.kind != 135 && shouldCheckForStaticness) {
            if (!boundSym.isStatic()) {
                staticErrorForBound = true;
                if (this.hasAnotherApplicableMethod(boundSearchResolveContext, boundSym, true)) {
                    boundSearchResultKind = SearchResultKind.BAD_MATCH_MORE_SPECIFIC;
                } else {
                    boundSearchResultKind = SearchResultKind.BAD_MATCH;
                    if (boundSym.kind < 128) {
                        boundSym = this.methodWithCorrectStaticnessNotFound;
                    }
                }
            } else if (boundSym.kind < 128) {
                boundSearchResultKind = SearchResultKind.GOOD_MATCH;
            }
        }
        Symbol origUnboundSym = null;
        Symbol unboundSym = this.methodNotFound;
        ReferenceLookupHelper unboundLookupHelper = null;
        Env<AttrContext> unboundEnv = env.dup(env.tree, ((AttrContext)env.info).dup());
        SearchResultKind unboundSearchResultKind = SearchResultKind.NOT_APPLICABLE_MATCH;
        boolean staticErrorForUnbound = false;
        if (isStaticSelector) {
            unboundLookupHelper = boundLookupHelper.unboundLookup(inferenceContext);
            MethodResolutionContext unboundSearchResolveContext = new MethodResolutionContext();
            unboundSearchResolveContext.methodCheck = methodCheck;
            unboundSym = origUnboundSym = this.lookupMethod(unboundEnv, env.tree.pos(), (Symbol)site.tsym, unboundSearchResolveContext, (LookupHelper)unboundLookupHelper);
            if (unboundSym.kind != 135 && unboundSym.kind != 134 && shouldCheckForStaticness) {
                if (unboundSym.isStatic()) {
                    staticErrorForUnbound = true;
                    if (this.hasAnotherApplicableMethod(unboundSearchResolveContext, unboundSym, false)) {
                        unboundSearchResultKind = SearchResultKind.BAD_MATCH_MORE_SPECIFIC;
                    } else {
                        unboundSearchResultKind = SearchResultKind.BAD_MATCH;
                        if (unboundSym.kind < 128) {
                            unboundSym = this.methodWithCorrectStaticnessNotFound;
                        }
                    }
                } else if (unboundSym.kind < 128) {
                    unboundSearchResultKind = SearchResultKind.GOOD_MATCH;
                }
            }
        }
        Symbol bestSym = this.choose(boundSym, unboundSym);
        if (bestSym.kind < 128 && (staticErrorForBound || staticErrorForUnbound)) {
            if (staticErrorForBound) {
                boundSym = this.methodWithCorrectStaticnessNotFound;
            }
            if (staticErrorForUnbound) {
                unboundSym = this.methodWithCorrectStaticnessNotFound;
            }
            bestSym = this.choose(boundSym, unboundSym);
        }
        if (bestSym == this.methodWithCorrectStaticnessNotFound && mode == DeferredAttr.AttrMode.CHECK) {
            Symbol symToPrint = origBoundSym;
            String errorFragmentToPrint = "non-static.cant.be.ref";
            if (staticErrorForBound && staticErrorForUnbound) {
                if (unboundSearchResultKind == SearchResultKind.BAD_MATCH_MORE_SPECIFIC) {
                    symToPrint = origUnboundSym;
                    errorFragmentToPrint = "static.method.in.unbound.lookup";
                }
            } else if (!staticErrorForBound) {
                symToPrint = origUnboundSym;
                errorFragmentToPrint = "static.method.in.unbound.lookup";
            }
            this.log.error(referenceTree.expr.pos(), "invalid.mref", Kinds.kindName(referenceTree.getMode()), this.diags.fragment(errorFragmentToPrint, Kinds.kindName(symToPrint), symToPrint));
        }
        Pair<Symbol, ReferenceLookupHelper> res = new Pair<Symbol, ReferenceLookupHelper>(bestSym, bestSym == unboundSym ? unboundLookupHelper : boundLookupHelper);
        ((AttrContext)env.info).pendingResolutionPhase = bestSym == unboundSym ? ((AttrContext)unboundEnv.info).pendingResolutionPhase : ((AttrContext)boundEnv.info).pendingResolutionPhase;
        return res;
    }

    boolean hasAnotherApplicableMethod(MethodResolutionContext resolutionContext, Symbol bestSoFar, boolean staticMth) {
        for (MethodResolutionContext.Candidate c : resolutionContext.candidates) {
            if (resolutionContext.step != c.step || !c.isApplicable() || c.sym == bestSoFar || c.sym.isStatic() != staticMth) continue;
            return true;
        }
        return false;
    }

    private Symbol choose(Symbol boundSym, Symbol unboundSym) {
        if (this.lookupSuccess(boundSym) && this.lookupSuccess(unboundSym)) {
            return this.ambiguityError(boundSym, unboundSym);
        }
        if (this.lookupSuccess(boundSym) || this.canIgnore(unboundSym) && !this.canIgnore(boundSym)) {
            return boundSym;
        }
        if (this.lookupSuccess(unboundSym) || this.canIgnore(boundSym) && !this.canIgnore(unboundSym)) {
            return unboundSym;
        }
        return boundSym;
    }

    private boolean lookupSuccess(Symbol s) {
        return s.kind == 16 || s.kind == 129;
    }

    private boolean canIgnore(Symbol s) {
        switch (s.kind) {
            case 136: {
                return true;
            }
            case 135: {
                InapplicableSymbolError errSym = (InapplicableSymbolError)s.baseSymbol();
                return new MethodResolutionDiagHelper.Template(MethodCheckDiag.ARITY_MISMATCH.regex(), new MethodResolutionDiagHelper.Template[0]).matches(errSym.errCandidate().snd);
            }
            case 134: {
                InapplicableSymbolsError errSyms = (InapplicableSymbolsError)s.baseSymbol();
                return errSyms.filterCandidates(errSyms.mapCandidates()).isEmpty();
            }
            case 138: {
                return false;
            }
        }
        return false;
    }

    Symbol lookupMethod(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition pos, Symbol location, MethodCheck methodCheck, LookupHelper lookupHelper) {
        MethodResolutionContext resolveContext = new MethodResolutionContext();
        resolveContext.methodCheck = methodCheck;
        return this.lookupMethod(env, pos, location, resolveContext, lookupHelper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Symbol lookupMethod(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition pos, Symbol location, MethodResolutionContext resolveContext, LookupHelper lookupHelper) {
        MethodResolutionContext prevResolutionContext = this.currentResolutionContext;
        try {
            Symbol bestSoFar = this.methodNotFound;
            this.currentResolutionContext = resolveContext;
            for (MethodResolutionPhase phase : this.methodResolutionSteps) {
                if (!phase.isApplicable(this.boxingEnabled, this.varargsEnabled) || lookupHelper.shouldStop(bestSoFar, phase)) break;
                MethodResolutionPhase prevPhase = this.currentResolutionContext.step;
                SymbolNotFoundError prevBest = bestSoFar;
                this.currentResolutionContext.step = phase;
                Symbol sym = lookupHelper.lookup(env, phase);
                lookupHelper.debug(pos, sym);
                bestSoFar = phase.mergeResults(bestSoFar, sym);
                ((AttrContext)env.info).pendingResolutionPhase = prevBest == bestSoFar ? prevPhase : phase;
            }
            Symbol symbol = lookupHelper.access(env, pos, location, bestSoFar);
            return symbol;
        }
        finally {
            this.currentResolutionContext = prevResolutionContext;
        }
    }

    Symbol resolveSelf(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Symbol.TypeSymbol c, Name name) {
        Env<AttrContext> env1 = env;
        boolean staticOnly = false;
        while (env1.outer != null) {
            Symbol sym;
            if (Resolve.isStatic(env1)) {
                staticOnly = true;
            }
            if (env1.enclClass.sym == c && (sym = ((AttrContext)env1.info).scope.lookup((Name)name).sym) != null) {
                if (staticOnly) {
                    sym = new StaticError(sym);
                }
                return this.accessBase(sym, pos, env.enclClass.sym.type, name, true);
            }
            if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                staticOnly = true;
            }
            env1 = env1.outer;
        }
        if (c.isInterface() && name == this.names._super && !Resolve.isStatic(env) && this.types.isDirectSuperInterface(c, env.enclClass.sym)) {
            for (Type t : this.pruneInterfaces(env.enclClass.type)) {
                if (t.tsym != c) continue;
                ((AttrContext)env.info).defaultSuperCallSite = t;
                return new Symbol.VarSymbol(0L, this.names._super, this.types.asSuper(env.enclClass.type, c), env.enclClass.sym);
            }
            for (Type i : this.types.interfaces(env.enclClass.type)) {
                if (!i.tsym.isSubClass(c, this.types) || i.tsym == c) continue;
                this.log.error(pos, "illegal.default.super.call", c, this.diags.fragment("redundant.supertype", c, i));
                return this.syms.errSymbol;
            }
            Assert.error();
        }
        this.log.error(pos, "not.encl.class", c);
        return this.syms.errSymbol;
    }

    private List<Type> pruneInterfaces(Type t) {
        ListBuffer<Type> result = new ListBuffer<Type>();
        for (Type t1 : this.types.interfaces(t)) {
            boolean shouldAdd = true;
            for (Type t2 : this.types.interfaces(t)) {
                if (t1 == t2 || !this.types.isSubtypeNoCapture(t2, t1)) continue;
                shouldAdd = false;
            }
            if (!shouldAdd) continue;
            result.append(t1);
        }
        return result.toList();
    }

    Symbol resolveSelfContaining(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Symbol member, boolean isSuperCall) {
        Symbol sym = this.resolveSelfContainingInternal(env, member, isSuperCall);
        if (sym == null) {
            this.log.error(pos, "encl.class.required", member);
            return this.syms.errSymbol;
        }
        return this.accessBase(sym, pos, env.enclClass.sym.type, sym.name, true);
    }

    boolean hasEnclosingInstance(Env<AttrContext> env, Type type) {
        Symbol encl = this.resolveSelfContainingInternal(env, type.tsym, false);
        return encl != null && encl.kind < 128;
    }

    private Symbol resolveSelfContainingInternal(Env<AttrContext> env, Symbol member, boolean isSuperCall) {
        Name name = this.names._this;
        Env<AttrContext> env1 = isSuperCall ? env.outer : env;
        boolean staticOnly = false;
        if (env1 != null) {
            while (env1 != null && env1.outer != null) {
                Symbol sym;
                if (Resolve.isStatic(env1)) {
                    staticOnly = true;
                }
                if (env1.enclClass.sym.isSubClass(member.owner, this.types) && (sym = ((AttrContext)env1.info).scope.lookup((Name)name).sym) != null) {
                    if (staticOnly) {
                        sym = new StaticError(sym);
                    }
                    return sym;
                }
                if ((env1.enclClass.sym.flags() & 8L) != 0L) {
                    staticOnly = true;
                }
                env1 = env1.outer;
            }
        }
        return null;
    }

    Type resolveImplicitThis(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type t) {
        return this.resolveImplicitThis(pos, env, t, false);
    }

    Type resolveImplicitThis(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Type t, boolean isSuperCall) {
        Type thisType = ((t.tsym.owner.kind & 0x14) != 0 ? this.resolveSelf((JCDiagnostic.DiagnosticPosition)pos, env, (Symbol.TypeSymbol)t.getEnclosingType().tsym, (Name)this.names._this) : this.resolveSelfContaining((JCDiagnostic.DiagnosticPosition)pos, env, (Symbol)t.tsym, (boolean)isSuperCall)).type;
        if (((AttrContext)env.info).isSelfCall && thisType.tsym == env.enclClass.sym) {
            this.log.error(pos, "cant.ref.before.ctor.called", "this");
        }
        return thisType;
    }

    public void logAccessErrorInternal(Env<AttrContext> env, JCTree tree, Type type) {
        AccessError error = new AccessError(env, env.enclClass.type, type.tsym);
        this.logResolveError(error, tree.pos(), env.enclClass.sym, env.enclClass.type, null, null, null);
    }

    private void logResolveError(ResolveError error, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
        JCDiagnostic d = error.getDiagnostic(JCDiagnostic.DiagnosticType.ERROR, pos, location, site, name, argtypes, typeargtypes);
        if (d != null) {
            d.setFlag(JCDiagnostic.DiagnosticFlag.RESOLVE_ERROR);
            this.log.report(d);
        }
    }

    public Object methodArguments(List<Type> argtypes) {
        if (argtypes == null || argtypes.isEmpty()) {
            return this.noArgs;
        }
        ListBuffer<Object> diagArgs = new ListBuffer<Object>();
        for (Type t : argtypes) {
            if (t.hasTag(TypeTag.DEFERRED)) {
                diagArgs.append(((DeferredAttr.DeferredType)t).tree);
                continue;
            }
            diagArgs.append(t);
        }
        return diagArgs;
    }

    class MethodResolutionContext {
        private List<Candidate> candidates = List.nil();
        MethodResolutionPhase step = null;
        MethodCheck methodCheck;
        private boolean internalResolution;
        private DeferredAttr.AttrMode attrMode;

        MethodResolutionContext() {
            this.methodCheck = Resolve.this.resolveMethodCheck;
            this.internalResolution = false;
            this.attrMode = DeferredAttr.AttrMode.SPECULATIVE;
        }

        void addInapplicableCandidate(Symbol sym, JCDiagnostic details) {
            Candidate c = new Candidate(Resolve.this.currentResolutionContext.step, sym, details, null);
            this.candidates = this.candidates.append(c);
        }

        void addApplicableCandidate(Symbol sym, Type mtype) {
            Candidate c = new Candidate(Resolve.this.currentResolutionContext.step, sym, null, mtype);
            this.candidates = this.candidates.append(c);
        }

        DeferredAttr.DeferredAttrContext deferredAttrContext(Symbol sym, Infer.InferenceContext inferenceContext, Attr.ResultInfo pendingResult, Warner warn) {
            DeferredAttr.DeferredAttrContext parent = pendingResult == null ? Resolve.this.deferredAttr.emptyDeferredAttrContext : pendingResult.checkContext.deferredAttrContext();
            DeferredAttr deferredAttr = Resolve.this.deferredAttr;
            deferredAttr.getClass();
            return deferredAttr.new DeferredAttr.DeferredAttrContext(this.attrMode, sym, this.step, inferenceContext, parent, warn);
        }

        DeferredAttr.AttrMode attrMode() {
            return this.attrMode;
        }

        boolean internal() {
            return this.internalResolution;
        }

        class Candidate {
            final MethodResolutionPhase step;
            final Symbol sym;
            final JCDiagnostic details;
            final Type mtype;

            private Candidate(MethodResolutionPhase step, Symbol sym, JCDiagnostic details, Type mtype) {
                this.step = step;
                this.sym = sym;
                this.details = details;
                this.mtype = mtype;
            }

            public boolean equals(Object o) {
                Symbol s2;
                Symbol s1;
                return o instanceof Candidate && ((s1 = this.sym) != (s2 = ((Candidate)o).sym) && (s1.overrides(s2, s1.owner.type.tsym, Resolve.this.types, false) || s2.overrides(s1, s2.owner.type.tsym, Resolve.this.types, false)) || (s1.isConstructor() || s2.isConstructor()) && s1.owner != s2.owner);
            }

            boolean isApplicable() {
                return this.mtype != null;
            }
        }
    }

    static enum MethodResolutionPhase {
        BASIC(false, false),
        BOX(true, false),
        VARARITY(true, true){

            @Override
            public Symbol mergeResults(Symbol bestSoFar, Symbol sym) {
                Assert.check(bestSoFar.kind >= 128 && bestSoFar.kind != 129);
                if (sym.kind < 128) {
                    return sym;
                }
                switch (bestSoFar.kind) {
                    case 134: 
                    case 135: {
                        switch (sym.kind) {
                            case 135: {
                                return bestSoFar.kind == 134 ? bestSoFar : sym;
                            }
                            case 136: {
                                return bestSoFar;
                            }
                        }
                        return sym;
                    }
                }
                return bestSoFar;
            }
        };

        final boolean isBoxingRequired;
        final boolean isVarargsRequired;

        private MethodResolutionPhase(boolean isBoxingRequired, boolean isVarargsRequired) {
            this.isBoxingRequired = isBoxingRequired;
            this.isVarargsRequired = isVarargsRequired;
        }

        public boolean isBoxingRequired() {
            return this.isBoxingRequired;
        }

        public boolean isVarargsRequired() {
            return this.isVarargsRequired;
        }

        public boolean isApplicable(boolean boxingEnabled, boolean varargsEnabled) {
            return !(!varargsEnabled && this.isVarargsRequired || !boxingEnabled && this.isBoxingRequired);
        }

        public Symbol mergeResults(Symbol prev, Symbol sym) {
            return sym;
        }
    }

    static class MethodResolutionDiagHelper {
        static final Template skip = new Template("", new Template[0]){

            @Override
            boolean matches(Object d) {
                return true;
            }
        };
        static final Map<Template, DiagnosticRewriter> rewriters = new LinkedHashMap<Template, DiagnosticRewriter>();

        MethodResolutionDiagHelper() {
        }

        static {
            String argMismatchRegex = MethodCheckDiag.ARG_MISMATCH.regex();
            rewriters.put(new Template(argMismatchRegex, skip), new DiagnosticRewriter(){

                @Override
                public JCDiagnostic rewriteDiagnostic(JCDiagnostic.Factory diags, JCDiagnostic.DiagnosticPosition preferedPos, DiagnosticSource preferredSource, JCDiagnostic.DiagnosticType preferredKind, JCDiagnostic d) {
                    JCDiagnostic cause = (JCDiagnostic)d.getArgs()[0];
                    return diags.create(preferredKind, preferredSource, d.getDiagnosticPosition(), "prob.found.req", cause);
                }
            });
        }

        static class Template {
            String regex;
            Template[] subTemplates;

            Template(String key, Template ... subTemplates) {
                this.regex = key;
                this.subTemplates = subTemplates;
            }

            boolean matches(Object o) {
                JCDiagnostic d = (JCDiagnostic)o;
                Object[] args = d.getArgs();
                if (!d.getCode().matches(this.regex) || this.subTemplates.length != d.getArgs().length) {
                    return false;
                }
                for (int i = 0; i < args.length; ++i) {
                    if (this.subTemplates[i].matches(args[i])) continue;
                    return false;
                }
                return true;
            }
        }

        static interface DiagnosticRewriter {
            public JCDiagnostic rewriteDiagnostic(JCDiagnostic.Factory var1, JCDiagnostic.DiagnosticPosition var2, DiagnosticSource var3, JCDiagnostic.DiagnosticType var4, JCDiagnostic var5);
        }
    }

    class BadVarargsMethod
    extends ResolveError {
        ResolveError delegatedError;

        BadVarargsMethod(ResolveError delegatedError) {
            super(delegatedError.kind, "badVarargs");
            this.delegatedError = delegatedError;
        }

        @Override
        public Symbol baseSymbol() {
            return this.delegatedError.baseSymbol();
        }

        @Override
        protected Symbol access(Name name, Symbol.TypeSymbol location) {
            return this.delegatedError.access(name, location);
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            return this.delegatedError.getDiagnostic(dkind, pos, location, site, name, argtypes, typeargtypes);
        }
    }

    class AmbiguityError
    extends ResolveError {
        List<Symbol> ambiguousSyms;

        @Override
        public boolean exists() {
            return true;
        }

        AmbiguityError(Symbol sym1, Symbol sym2) {
            super(129, "ambiguity error");
            this.ambiguousSyms = List.nil();
            this.ambiguousSyms = this.flatten(sym2).appendList(this.flatten(sym1));
        }

        private List<Symbol> flatten(Symbol sym) {
            if (sym.kind == 129) {
                return ((AmbiguityError)sym.baseSymbol()).ambiguousSyms;
            }
            return List.of(sym);
        }

        AmbiguityError addAmbiguousSymbol(Symbol s) {
            this.ambiguousSyms = this.ambiguousSyms.prepend(s);
            return this;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            List<Symbol> diagSyms = this.ambiguousSyms.reverse();
            Symbol s1 = (Symbol)diagSyms.head;
            Symbol s2 = (Symbol)diagSyms.tail.head;
            Name sname = s1.name;
            if (sname == Resolve.this.names.init) {
                sname = s1.owner.name;
            }
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "ref.ambiguous", sname, Kinds.kindName(s1), s1, s1.location(site, Resolve.this.types), Kinds.kindName(s2), s2, s2.location(site, Resolve.this.types));
        }

        Symbol mergeAbstracts(Type site) {
            List<Symbol> ambiguousInOrder = this.ambiguousSyms.reverse();
            for (Symbol s : ambiguousInOrder) {
                Type mt = Resolve.this.types.memberType(site, s);
                boolean found = true;
                List<Type> allThrown = mt.getThrownTypes();
                for (Symbol s2 : ambiguousInOrder) {
                    Type mt2 = Resolve.this.types.memberType(site, s2);
                    if ((s2.flags() & 0x400L) == 0L || !Resolve.this.types.overrideEquivalent(mt, mt2) || !Resolve.this.types.isSameTypes(s.erasure(Resolve.this.types).getParameterTypes(), s2.erasure(Resolve.this.types).getParameterTypes())) {
                        return this;
                    }
                    Type mst = Resolve.this.mostSpecificReturnType(mt, mt2);
                    if (mst == null || mst != mt) {
                        found = false;
                        break;
                    }
                    allThrown = Resolve.this.chk.intersect(allThrown, mt2.getThrownTypes());
                }
                if (!found) continue;
                return allThrown == mt.getThrownTypes() ? s : new Symbol.MethodSymbol(s.flags(), s.name, Resolve.this.types.createMethodTypeWithThrown(s.type, allThrown), s.owner);
            }
            return this;
        }

        @Override
        protected Symbol access(Name name, Symbol.TypeSymbol location) {
            Symbol firstAmbiguity = this.ambiguousSyms.last();
            return firstAmbiguity.kind == 2 ? Resolve.this.types.createErrorType((Name)name, (Symbol.TypeSymbol)location, (Type)firstAmbiguity.type).tsym : firstAmbiguity;
        }
    }

    class StaticError
    extends InvalidSymbolError {
        StaticError(Symbol sym) {
            super(131, sym, "static error");
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            Symbol errSym = this.sym.kind == 2 && this.sym.type.hasTag(TypeTag.CLASS) ? Resolve.this.types.erasure((Type)this.sym.type).tsym : this.sym;
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "non-static.cant.be.ref", Kinds.kindName(this.sym), errSym);
        }
    }

    class AccessError
    extends InvalidSymbolError {
        private Env<AttrContext> env;
        private Type site;

        AccessError(Symbol sym) {
            this(null, null, sym);
        }

        AccessError(Env<AttrContext> env, Type site, Symbol sym) {
            super(130, sym, "access error");
            this.env = env;
            this.site = site;
            if (Resolve.this.debugResolve) {
                Resolve.this.log.error("proc.messager", sym + " @ " + site + " is inaccessible.");
            }
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            if (this.sym.owner.type.hasTag(TypeTag.ERROR)) {
                return null;
            }
            if (this.sym.name == Resolve.this.names.init && this.sym.owner != site.tsym) {
                return new SymbolNotFoundError(136).getDiagnostic(dkind, pos, location, site, name, argtypes, typeargtypes);
            }
            if ((this.sym.flags() & 1L) != 0L || this.env != null && this.site != null && !Resolve.this.isAccessible(this.env, this.site)) {
                return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "not.def.access.class.intf.cant.access", this.sym, this.sym.location());
            }
            if ((this.sym.flags() & 6L) != 0L) {
                return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "report.access", this.sym, Flags.asFlagSet(this.sym.flags() & 6L), this.sym.location());
            }
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "not.def.public.cant.access", this.sym, this.sym.location());
        }
    }

    class InapplicableSymbolsError
    extends InapplicableSymbolError {
        InapplicableSymbolsError(MethodResolutionContext context) {
            super(134, "inapplicable symbols", context);
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            boolean truncatedDiag;
            Map<Symbol, JCDiagnostic> filteredCandidates;
            Map<Symbol, JCDiagnostic> candidatesMap = this.mapCandidates();
            Map<Symbol, JCDiagnostic> map = filteredCandidates = Resolve.this.compactMethodDiags ? this.filterCandidates(candidatesMap) : this.mapCandidates();
            if (filteredCandidates.isEmpty()) {
                filteredCandidates = candidatesMap;
            }
            boolean bl = truncatedDiag = candidatesMap.size() != filteredCandidates.size();
            if (filteredCandidates.size() > 1) {
                JCDiagnostic err = Resolve.this.diags.create(dkind, null, truncatedDiag ? EnumSet.of(JCDiagnostic.DiagnosticFlag.COMPRESSED) : EnumSet.noneOf(JCDiagnostic.DiagnosticFlag.class), Resolve.this.log.currentSource(), pos, "cant.apply.symbols", name == Resolve.this.names.init ? Kinds.KindName.CONSTRUCTOR : Kinds.absentKind(this.kind), name == Resolve.this.names.init ? site.tsym.name : name, Resolve.this.methodArguments(argtypes));
                return new JCDiagnostic.MultilineDiagnostic(err, this.candidateDetails(filteredCandidates, site));
            }
            if (filteredCandidates.size() == 1) {
                Map.Entry<Symbol, JCDiagnostic> _e = filteredCandidates.entrySet().iterator().next();
                final Pair<Symbol, JCDiagnostic> p = new Pair<Symbol, JCDiagnostic>(_e.getKey(), _e.getValue());
                JCDiagnostic d = new InapplicableSymbolError(this.resolveContext){

                    @Override
                    protected Pair<Symbol, JCDiagnostic> errCandidate() {
                        return p;
                    }
                }.getDiagnostic(dkind, pos, location, site, name, argtypes, typeargtypes);
                if (truncatedDiag) {
                    d.setFlag(JCDiagnostic.DiagnosticFlag.COMPRESSED);
                }
                return d;
            }
            return new SymbolNotFoundError(136).getDiagnostic(dkind, pos, location, site, name, argtypes, typeargtypes);
        }

        private Map<Symbol, JCDiagnostic> mapCandidates() {
            LinkedHashMap<Symbol, JCDiagnostic> candidates = new LinkedHashMap<Symbol, JCDiagnostic>();
            for (MethodResolutionContext.Candidate c : this.resolveContext.candidates) {
                if (c.isApplicable()) continue;
                candidates.put(c.sym, c.details);
            }
            return candidates;
        }

        Map<Symbol, JCDiagnostic> filterCandidates(Map<Symbol, JCDiagnostic> candidatesMap) {
            LinkedHashMap<Symbol, JCDiagnostic> candidates = new LinkedHashMap<Symbol, JCDiagnostic>();
            for (Map.Entry<Symbol, JCDiagnostic> _entry : candidatesMap.entrySet()) {
                JCDiagnostic d = _entry.getValue();
                if (new MethodResolutionDiagHelper.Template(MethodCheckDiag.ARITY_MISMATCH.regex(), new MethodResolutionDiagHelper.Template[0]).matches(d)) continue;
                candidates.put(_entry.getKey(), d);
            }
            return candidates;
        }

        private List<JCDiagnostic> candidateDetails(Map<Symbol, JCDiagnostic> candidatesMap, Type site) {
            List<JCDiagnostic> details = List.nil();
            for (Map.Entry<Symbol, JCDiagnostic> _entry : candidatesMap.entrySet()) {
                Symbol sym = _entry.getKey();
                JCDiagnostic detailDiag = Resolve.this.diags.fragment("inapplicable.method", Kinds.kindName(sym), sym.location(site, Resolve.this.types), sym.asMemberOf(site, Resolve.this.types), _entry.getValue());
                details = details.prepend(detailDiag);
            }
            return details;
        }
    }

    class InapplicableSymbolError
    extends ResolveError {
        protected MethodResolutionContext resolveContext;

        InapplicableSymbolError(MethodResolutionContext context) {
            this(135, "inapplicable symbol error", context);
        }

        protected InapplicableSymbolError(int kind, String debugName, MethodResolutionContext context) {
            super(kind, debugName);
            this.resolveContext = context;
        }

        @Override
        public String toString() {
            return super.toString();
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            if (name == Resolve.this.names.error) {
                return null;
            }
            if (Resolve.this.syms.operatorNames.contains(name)) {
                boolean isUnaryOp = argtypes.size() == 1;
                String key = argtypes.size() == 1 ? "operator.cant.be.applied" : "operator.cant.be.applied.1";
                Type first = (Type)argtypes.head;
                Type second = !isUnaryOp ? (Type)argtypes.tail.head : null;
                return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, key, name, first, second);
            }
            Pair<Symbol, JCDiagnostic> c = this.errCandidate();
            if (Resolve.this.compactMethodDiags) {
                for (Map.Entry<MethodResolutionDiagHelper.Template, MethodResolutionDiagHelper.DiagnosticRewriter> _entry : MethodResolutionDiagHelper.rewriters.entrySet()) {
                    if (!_entry.getKey().matches(c.snd)) continue;
                    JCDiagnostic simpleDiag = _entry.getValue().rewriteDiagnostic(Resolve.this.diags, pos, Resolve.this.log.currentSource(), dkind, (JCDiagnostic)c.snd);
                    simpleDiag.setFlag(JCDiagnostic.DiagnosticFlag.COMPRESSED);
                    return simpleDiag;
                }
            }
            Symbol ws = ((Symbol)c.fst).asMemberOf(site, Resolve.this.types);
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "cant.apply.symbol", Kinds.kindName(ws), ws.name == Resolve.this.names.init ? ws.owner.name : ws.name, Resolve.this.methodArguments(ws.type.getParameterTypes()), Resolve.this.methodArguments(argtypes), Kinds.kindName(ws.owner), ws.owner.type, c.snd);
        }

        @Override
        public Symbol access(Name name, Symbol.TypeSymbol location) {
            return Resolve.this.types.createErrorType((Name)name, (Symbol.TypeSymbol)location, (Type)Resolve.this.syms.errSymbol.type).tsym;
        }

        protected Pair<Symbol, JCDiagnostic> errCandidate() {
            MethodResolutionContext.Candidate bestSoFar = null;
            for (MethodResolutionContext.Candidate c : this.resolveContext.candidates) {
                if (c.isApplicable()) continue;
                bestSoFar = c;
            }
            Assert.checkNonNull(bestSoFar);
            return new Pair<Symbol, JCDiagnostic>(bestSoFar.sym, bestSoFar.details);
        }
    }

    class SymbolNotFoundError
    extends ResolveError {
        SymbolNotFoundError(int kind) {
            this(kind, "symbol not found error");
        }

        SymbolNotFoundError(int kind, String debugName) {
            super(kind, debugName);
        }

        @Override
        JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
            argtypes = argtypes == null ? List.nil() : argtypes;
            List<Object> list = typeargtypes = typeargtypes == null ? List.nil() : typeargtypes;
            if (name == Resolve.this.names.error) {
                return null;
            }
            if (Resolve.this.syms.operatorNames.contains(name)) {
                boolean isUnaryOp = argtypes.size() == 1;
                String key = argtypes.size() == 1 ? "operator.cant.be.applied" : "operator.cant.be.applied.1";
                Type first = (Type)argtypes.head;
                Type second = !isUnaryOp ? (Type)argtypes.tail.head : null;
                return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, key, name, first, second);
            }
            boolean hasLocation = false;
            if (location == null) {
                location = site.tsym;
            }
            if (!location.name.isEmpty()) {
                if (location.kind == 1 && !site.tsym.exists()) {
                    return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "doesnt.exist", location);
                }
                hasLocation = !location.name.equals(Resolve.this.names._this) && !location.name.equals(Resolve.this.names._super);
            }
            boolean isConstructor = (this.kind == 136 || this.kind == 138) && name == Resolve.this.names.init;
            Kinds.KindName kindname = isConstructor ? Kinds.KindName.CONSTRUCTOR : Kinds.absentKind(this.kind);
            Name idname = isConstructor ? site.tsym.name : name;
            String errKey = this.getErrorKey(kindname, typeargtypes.nonEmpty(), hasLocation);
            if (hasLocation) {
                return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, errKey, kindname, idname, typeargtypes, this.args(argtypes), this.getLocationDiag(location, site));
            }
            return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, errKey, kindname, idname, typeargtypes, this.args(argtypes));
        }

        private Object args(List<Type> args) {
            return args.isEmpty() ? args : Resolve.this.methodArguments(args);
        }

        private String getErrorKey(Kinds.KindName kindname, boolean hasTypeArgs, boolean hasLocation) {
            String key = "cant.resolve";
            String suffix = hasLocation ? ".location" : "";
            switch (kindname) {
                case METHOD: 
                case CONSTRUCTOR: {
                    suffix = suffix + ".args";
                    suffix = suffix + (hasTypeArgs ? ".params" : "");
                }
            }
            return key + suffix;
        }

        private JCDiagnostic getLocationDiag(Symbol location, Type site) {
            if (location.kind == 4) {
                return Resolve.this.diags.fragment("location.1", Kinds.kindName(location), location, location.type);
            }
            return Resolve.this.diags.fragment("location", Kinds.typeKindName(site), site, null);
        }
    }

    abstract class InvalidSymbolError
    extends ResolveError {
        Symbol sym;

        InvalidSymbolError(int kind, Symbol sym, String debugName) {
            super(kind, debugName);
            this.sym = sym;
        }

        @Override
        public boolean exists() {
            return true;
        }

        @Override
        public String toString() {
            return super.toString() + " wrongSym=" + this.sym;
        }

        @Override
        public Symbol access(Name name, Symbol.TypeSymbol location) {
            if ((this.sym.kind & 0x80) == 0 && (this.sym.kind & 2) != 0) {
                return Resolve.this.types.createErrorType((Name)name, (Symbol.TypeSymbol)location, (Type)this.sym.type).tsym;
            }
            return this.sym;
        }
    }

    abstract class ResolveError
    extends Symbol {
        final String debugName;

        ResolveError(int kind, String debugName) {
            super(kind, 0L, null, null, null);
            this.debugName = debugName;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            throw new AssertionError();
        }

        @Override
        public String toString() {
            return this.debugName;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        protected Symbol access(Name name, Symbol.TypeSymbol location) {
            return Resolve.this.types.createErrorType((Name)name, (Symbol.TypeSymbol)location, (Type)Resolve.this.syms.errSymbol.type).tsym;
        }

        abstract JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType var1, JCDiagnostic.DiagnosticPosition var2, Symbol var3, Type var4, Name var5, List<Type> var6, List<Type> var7);
    }

    class ConstructorReferenceLookupHelper
    extends ReferenceLookupHelper {
        boolean needsInference;

        ConstructorReferenceLookupHelper(JCTree.JCMemberReference referenceTree, Type site, List<Type> argtypes, List<Type> typeargtypes, MethodResolutionPhase maxPhase) {
            super(referenceTree, Resolve.this.names.init, site, argtypes, typeargtypes, maxPhase);
            if (site.isRaw()) {
                this.site = new Type.ClassType(site.getEnclosingType(), site.tsym.type.getTypeArguments(), site.tsym);
                this.needsInference = true;
            }
        }

        @Override
        protected Symbol lookup(Env<AttrContext> env, MethodResolutionPhase phase) {
            Symbol sym = this.needsInference ? Resolve.this.findDiamond(env, this.site, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired()) : Resolve.this.findMethod(env, this.site, this.name, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired(), Resolve.this.syms.operatorNames.contains(this.name));
            return sym.kind != 16 || this.site.getEnclosingType().hasTag(TypeTag.NONE) || Resolve.this.hasEnclosingInstance(env, this.site) ? sym : new InvalidSymbolError(132, sym, null){

                @Override
                JCDiagnostic getDiagnostic(JCDiagnostic.DiagnosticType dkind, JCDiagnostic.DiagnosticPosition pos, Symbol location, Type site, Name name, List<Type> argtypes, List<Type> typeargtypes) {
                    return Resolve.this.diags.create(dkind, Resolve.this.log.currentSource(), pos, "cant.access.inner.cls.constr", site.tsym.name, argtypes, site.getEnclosingType());
                }
            };
        }

        @Override
        JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol sym) {
            return this.site.getEnclosingType().hasTag(TypeTag.NONE) ? JCTree.JCMemberReference.ReferenceKind.TOPLEVEL : JCTree.JCMemberReference.ReferenceKind.IMPLICIT_INNER;
        }
    }

    class ArrayConstructorReferenceLookupHelper
    extends ReferenceLookupHelper {
        ArrayConstructorReferenceLookupHelper(JCTree.JCMemberReference referenceTree, Type site, List<Type> argtypes, List<Type> typeargtypes, MethodResolutionPhase maxPhase) {
            super(referenceTree, Resolve.this.names.init, site, argtypes, typeargtypes, maxPhase);
        }

        @Override
        protected Symbol lookup(Env<AttrContext> env, MethodResolutionPhase phase) {
            Scope sc = new Scope(Resolve.this.syms.arrayClass);
            Symbol.MethodSymbol arrayConstr = new Symbol.MethodSymbol(1L, this.name, null, this.site.tsym);
            arrayConstr.type = new Type.MethodType(List.of(Resolve.this.syms.intType), this.site, List.nil(), Resolve.this.syms.methodClass);
            sc.enter(arrayConstr);
            return Resolve.this.findMethodInScope(env, this.site, this.name, this.argtypes, this.typeargtypes, sc, Resolve.this.methodNotFound, phase.isBoxingRequired(), phase.isVarargsRequired(), false, false);
        }

        @Override
        JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol sym) {
            return JCTree.JCMemberReference.ReferenceKind.ARRAY_CTOR;
        }
    }

    class UnboundMethodReferenceLookupHelper
    extends MethodReferenceLookupHelper {
        UnboundMethodReferenceLookupHelper(JCTree.JCMemberReference referenceTree, Name name, Type site, List<Type> argtypes, List<Type> typeargtypes, MethodResolutionPhase maxPhase) {
            super(referenceTree, name, site, argtypes.tail, typeargtypes, maxPhase);
            if (site.isRaw() && !((Type)argtypes.head).hasTag(TypeTag.NONE)) {
                Type asSuperSite = Resolve.this.types.asSuper((Type)argtypes.head, site.tsym);
                this.site = Resolve.this.types.capture(asSuperSite);
            }
        }

        @Override
        ReferenceLookupHelper unboundLookup(Infer.InferenceContext inferenceContext) {
            return this;
        }

        @Override
        JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol sym) {
            return JCTree.JCMemberReference.ReferenceKind.UNBOUND;
        }
    }

    class MethodReferenceLookupHelper
    extends ReferenceLookupHelper {
        MethodReferenceLookupHelper(JCTree.JCMemberReference referenceTree, Name name, Type site, List<Type> argtypes, List<Type> typeargtypes, MethodResolutionPhase maxPhase) {
            super(referenceTree, name, site, argtypes, typeargtypes, maxPhase);
        }

        @Override
        final Symbol lookup(Env<AttrContext> env, MethodResolutionPhase phase) {
            return Resolve.this.findMethod(env, this.site, this.name, this.argtypes, this.typeargtypes, phase.isBoxingRequired(), phase.isVarargsRequired(), Resolve.this.syms.operatorNames.contains(this.name));
        }

        @Override
        ReferenceLookupHelper unboundLookup(Infer.InferenceContext inferenceContext) {
            if (TreeInfo.isStaticSelector(this.referenceTree.expr, Resolve.this.names) && this.argtypes.nonEmpty() && (((Type)this.argtypes.head).hasTag(TypeTag.NONE) || Resolve.this.types.isSubtypeUnchecked(inferenceContext.asUndetVar((Type)this.argtypes.head), this.site))) {
                return new UnboundMethodReferenceLookupHelper(this.referenceTree, this.name, this.site, this.argtypes, this.typeargtypes, this.maxPhase);
            }
            return super.unboundLookup(inferenceContext);
        }

        @Override
        JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol sym) {
            if (sym.isStatic()) {
                return JCTree.JCMemberReference.ReferenceKind.STATIC;
            }
            Name selName = TreeInfo.name(this.referenceTree.getQualifierExpression());
            return selName != null && selName == Resolve.this.names._super ? JCTree.JCMemberReference.ReferenceKind.SUPER : JCTree.JCMemberReference.ReferenceKind.BOUND;
        }
    }

    abstract class ReferenceLookupHelper
    extends LookupHelper {
        JCTree.JCMemberReference referenceTree;

        ReferenceLookupHelper(JCTree.JCMemberReference referenceTree, Name name, Type site, List<Type> argtypes, List<Type> typeargtypes, MethodResolutionPhase maxPhase) {
            super(name, site, argtypes, typeargtypes, maxPhase);
            this.referenceTree = referenceTree;
        }

        ReferenceLookupHelper unboundLookup(Infer.InferenceContext inferenceContext) {
            return new ReferenceLookupHelper(this.referenceTree, this.name, this.site, this.argtypes, this.typeargtypes, this.maxPhase){

                @Override
                ReferenceLookupHelper unboundLookup(Infer.InferenceContext inferenceContext) {
                    return this;
                }

                @Override
                Symbol lookup(Env<AttrContext> env, MethodResolutionPhase phase) {
                    return Resolve.this.methodNotFound;
                }

                @Override
                JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol sym) {
                    Assert.error();
                    return null;
                }
            };
        }

        abstract JCTree.JCMemberReference.ReferenceKind referenceKind(Symbol var1);

        @Override
        Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition pos, Symbol location, Symbol sym) {
            if (sym.kind == 129) {
                AmbiguityError a_err = (AmbiguityError)sym.baseSymbol();
                sym = a_err.mergeAbstracts(this.site);
            }
            return sym;
        }
    }

    abstract class BasicLookupHelper
    extends LookupHelper {
        BasicLookupHelper(Name name, Type site, List<Type> argtypes, List<Type> typeargtypes) {
            this(name, site, argtypes, typeargtypes, MethodResolutionPhase.VARARITY);
        }

        BasicLookupHelper(Name name, Type site, List<Type> argtypes, List<Type> typeargtypes, MethodResolutionPhase maxPhase) {
            super(name, site, argtypes, typeargtypes, maxPhase);
        }

        @Override
        final Symbol lookup(Env<AttrContext> env, MethodResolutionPhase phase) {
            Symbol sym = this.doLookup(env, phase);
            if (sym.kind == 129) {
                AmbiguityError a_err = (AmbiguityError)sym.baseSymbol();
                sym = a_err.mergeAbstracts(this.site);
            }
            return sym;
        }

        abstract Symbol doLookup(Env<AttrContext> var1, MethodResolutionPhase var2);

        @Override
        Symbol access(Env<AttrContext> env, JCDiagnostic.DiagnosticPosition pos, Symbol location, Symbol sym) {
            if (sym.kind >= 129) {
                sym = Resolve.this.accessMethod(sym, pos, location, this.site, this.name, true, this.argtypes, this.typeargtypes);
            }
            return sym;
        }

        @Override
        void debug(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
            Resolve.this.reportVerboseResolutionDiagnostic(pos, this.name, this.site, this.argtypes, this.typeargtypes, sym);
        }
    }

    abstract class LookupHelper {
        Name name;
        Type site;
        List<Type> argtypes;
        List<Type> typeargtypes;
        MethodResolutionPhase maxPhase;

        LookupHelper(Name name, Type site, List<Type> argtypes, List<Type> typeargtypes, MethodResolutionPhase maxPhase) {
            this.name = name;
            this.site = site;
            this.argtypes = argtypes;
            this.typeargtypes = typeargtypes;
            this.maxPhase = maxPhase;
        }

        final boolean shouldStop(Symbol sym, MethodResolutionPhase phase) {
            return phase.ordinal() > this.maxPhase.ordinal() || sym.kind < 128 || sym.kind == 129;
        }

        abstract Symbol lookup(Env<AttrContext> var1, MethodResolutionPhase var2);

        void debug(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        }

        abstract Symbol access(Env<AttrContext> var1, JCDiagnostic.DiagnosticPosition var2, Symbol var3, Symbol var4);
    }

    static enum SearchResultKind {
        GOOD_MATCH,
        BAD_MATCH_MORE_SPECIFIC,
        BAD_MATCH,
        NOT_APPLICABLE_MATCH;

    }

    class ResolveDeferredRecoveryMap
    extends DeferredAttr.RecoveryDeferredTypeMap {
        public ResolveDeferredRecoveryMap(DeferredAttr.AttrMode mode, Symbol msym, MethodResolutionPhase step) {
            DeferredAttr deferredAttr = Resolve.this.deferredAttr;
            deferredAttr.getClass();
            super(mode, msym, step);
        }

        @Override
        protected Type typeOf(DeferredAttr.DeferredType dt) {
            Type res = super.typeOf(dt);
            if (!res.isErroneous()) {
                switch (TreeInfo.skipParens(dt.tree).getTag()) {
                    case LAMBDA: 
                    case REFERENCE: {
                        return dt;
                    }
                    case CONDEXPR: {
                        return res == Type.recoveryType ? dt : res;
                    }
                }
            }
            return res;
        }
    }

    static interface LogResolveHelper {
        public boolean resolveDiagnosticNeeded(Type var1, List<Type> var2, List<Type> var3);

        public List<Type> getArgumentTypes(ResolveError var1, Symbol var2, Name var3, List<Type> var4);
    }

    static enum InterfaceLookupPhase {
        ABSTRACT_OK{

            @Override
            InterfaceLookupPhase update(Symbol s, Resolve rs) {
                if ((s.flags() & 0x4600L) != 0L) {
                    return this;
                }
                return DEFAULT_OK;
            }
        }
        ,
        DEFAULT_OK{

            @Override
            InterfaceLookupPhase update(Symbol s, Resolve rs) {
                return this;
            }
        };


        abstract InterfaceLookupPhase update(Symbol var1, Resolve var2);
    }

    class LookupFilter
    implements Filter<Symbol> {
        boolean abstractOk;

        LookupFilter(boolean abstractOk) {
            this.abstractOk = abstractOk;
        }

        @Override
        public boolean accepts(Symbol s) {
            long flags = s.flags();
            return s.kind == 16 && (flags & 0x1000L) == 0L && (this.abstractOk || (flags & 0x80000000000L) != 0L || (flags & 0x400L) == 0L);
        }
    }

    public static class InapplicableMethodException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;
        JCDiagnostic diagnostic = null;
        JCDiagnostic.Factory diags;

        InapplicableMethodException(JCDiagnostic.Factory diags) {
            this.diags = diags;
        }

        InapplicableMethodException setMessage() {
            return this.setMessage((JCDiagnostic)null);
        }

        InapplicableMethodException setMessage(String key) {
            return this.setMessage(key != null ? this.diags.fragment(key, new Object[0]) : null);
        }

        InapplicableMethodException setMessage(String key, Object ... args) {
            return this.setMessage(key != null ? this.diags.fragment(key, args) : null);
        }

        InapplicableMethodException setMessage(JCDiagnostic diag) {
            this.diagnostic = diag;
            return this;
        }

        public JCDiagnostic getDiagnostic() {
            return this.diagnostic;
        }
    }

    class MostSpecificCheck
    implements MethodCheck {
        boolean strict;
        List<Type> actuals;

        MostSpecificCheck(boolean strict, List<Type> actuals) {
            this.strict = strict;
            this.actuals = actuals;
        }

        @Override
        public void argumentsAcceptable(Env<AttrContext> env, DeferredAttr.DeferredAttrContext deferredAttrContext, List<Type> formals1, List<Type> formals2, Warner warn) {
            formals2 = Resolve.this.adjustArgs(formals2, deferredAttrContext.msym, formals1.length(), deferredAttrContext.phase.isVarargsRequired());
            while (formals2.nonEmpty()) {
                Attr.ResultInfo mresult = this.methodCheckResult((Type)formals2.head, deferredAttrContext, warn, (Type)this.actuals.head);
                mresult.check(null, (Type)formals1.head);
                formals1 = formals1.tail;
                formals2 = formals2.tail;
                this.actuals = this.actuals.isEmpty() ? this.actuals : this.actuals.tail;
            }
        }

        Attr.ResultInfo methodCheckResult(Type to, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner rsWarner, Type actual) {
            Attr attr = Resolve.this.attr;
            attr.getClass();
            return attr.new Attr.ResultInfo(12, to, new MostSpecificCheckContext(this.strict, deferredAttrContext, rsWarner, actual));
        }

        @Override
        public MethodCheck mostSpecificCheck(List<Type> actuals, boolean strict) {
            Assert.error("Cannot get here!");
            return null;
        }

        class MostSpecificCheckContext
        extends MethodCheckContext {
            Type actual;

            public MostSpecificCheckContext(boolean strict, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner rsWarner, Type actual) {
                super(strict, deferredAttrContext, rsWarner);
                this.actual = actual;
            }

            @Override
            public boolean compatible(Type found, Type req, Warner warn) {
                if (Resolve.this.allowFunctionalInterfaceMostSpecific && this.unrelatedFunctionalInterfaces(found, req) && this.actual != null && this.actual.getTag() == TypeTag.DEFERRED) {
                    DeferredAttr.DeferredType dt = (DeferredAttr.DeferredType)this.actual;
                    DeferredAttr.DeferredType.SpeculativeCache.Entry e = dt.speculativeCache.get(this.deferredAttrContext.msym, this.deferredAttrContext.phase);
                    if (e != null && e.speculativeTree != Resolve.this.deferredAttr.stuckTree) {
                        return this.functionalInterfaceMostSpecific(found, req, e.speculativeTree, warn);
                    }
                }
                return super.compatible(found, req, warn);
            }

            private boolean unrelatedFunctionalInterfaces(Type t, Type s) {
                return Resolve.this.types.isFunctionalInterface(t.tsym) && Resolve.this.types.isFunctionalInterface(s.tsym) && Resolve.this.types.asSuper(t, s.tsym) == null && Resolve.this.types.asSuper(s, t.tsym) == null;
            }

            private boolean functionalInterfaceMostSpecific(Type t, Type s, JCTree tree, Warner warn) {
                FunctionalInterfaceMostSpecificChecker msc = new FunctionalInterfaceMostSpecificChecker(t, s, warn);
                msc.scan(tree);
                return msc.result;
            }

            class FunctionalInterfaceMostSpecificChecker
            extends DeferredAttr.PolyScanner {
                final Type t;
                final Type s;
                final Warner warn;
                boolean result;

                FunctionalInterfaceMostSpecificChecker(Type t, Type s, Warner warn) {
                    this.t = t;
                    this.s = s;
                    this.warn = warn;
                    this.result = true;
                }

                @Override
                void skip(JCTree tree) {
                    this.result &= false;
                }

                @Override
                public void visitConditional(JCTree.JCConditional tree) {
                    this.scan(tree.truepart);
                    this.scan(tree.falsepart);
                }

                @Override
                public void visitReference(JCTree.JCMemberReference tree) {
                    Type desc_t = Resolve.this.types.findDescriptorType(this.t);
                    Type desc_s = Resolve.this.types.findDescriptorType(this.s);
                    if (!Resolve.this.types.isSameTypes(desc_t.getParameterTypes(), MostSpecificCheckContext.this.inferenceContext().asUndetVars(desc_s.getParameterTypes()))) {
                        this.result &= false;
                    } else {
                        Type ret_t = desc_t.getReturnType();
                        Type ret_s = desc_s.getReturnType();
                        if (ret_s.hasTag(TypeTag.VOID)) {
                            this.result &= true;
                        } else if (ret_t.hasTag(TypeTag.VOID)) {
                            this.result &= false;
                        } else if (ret_t.isPrimitive() != ret_s.isPrimitive()) {
                            boolean retValIsPrimitive = tree.refPolyKind == JCTree.JCPolyExpression.PolyKind.STANDALONE && tree.sym.type.getReturnType().isPrimitive();
                            this.result &= retValIsPrimitive == ret_t.isPrimitive() && retValIsPrimitive != ret_s.isPrimitive();
                        } else {
                            this.result &= MostSpecificCheckContext.super.compatible(ret_t, ret_s, this.warn);
                        }
                    }
                }

                @Override
                public void visitLambda(JCTree.JCLambda tree) {
                    Type desc_t = Resolve.this.types.findDescriptorType(this.t);
                    Type desc_s = Resolve.this.types.findDescriptorType(this.s);
                    if (!Resolve.this.types.isSameTypes(desc_t.getParameterTypes(), MostSpecificCheckContext.this.inferenceContext().asUndetVars(desc_s.getParameterTypes()))) {
                        this.result &= false;
                    } else {
                        Type ret_t = desc_t.getReturnType();
                        Type ret_s = desc_s.getReturnType();
                        if (ret_s.hasTag(TypeTag.VOID)) {
                            this.result &= true;
                        } else if (ret_t.hasTag(TypeTag.VOID)) {
                            this.result &= false;
                        } else if (MostSpecificCheckContext.this.unrelatedFunctionalInterfaces(ret_t, ret_s)) {
                            for (JCTree.JCExpression expr : this.lambdaResults(tree)) {
                                this.result &= MostSpecificCheckContext.this.functionalInterfaceMostSpecific(ret_t, ret_s, expr, this.warn);
                            }
                        } else if (ret_t.isPrimitive() != ret_s.isPrimitive()) {
                            for (JCTree.JCExpression expr : this.lambdaResults(tree)) {
                                boolean retValIsPrimitive = expr.isStandalone() && expr.type.isPrimitive();
                                this.result &= retValIsPrimitive == ret_t.isPrimitive() && retValIsPrimitive != ret_s.isPrimitive();
                            }
                        } else {
                            this.result &= MostSpecificCheckContext.super.compatible(ret_t, ret_s, this.warn);
                        }
                    }
                }

                private List<JCTree.JCExpression> lambdaResults(JCTree.JCLambda lambda) {
                    if (lambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                        return List.of((JCTree.JCExpression)lambda.body);
                    }
                    final ListBuffer buffer = new ListBuffer();
                    DeferredAttr.LambdaReturnScanner lambdaScanner = new DeferredAttr.LambdaReturnScanner(){

                        @Override
                        public void visitReturn(JCTree.JCReturn tree) {
                            if (tree.expr != null) {
                                buffer.append(tree.expr);
                            }
                        }
                    };
                    lambdaScanner.scan(lambda.body);
                    return buffer.toList();
                }
            }
        }
    }

    class MethodResultInfo
    extends Attr.ResultInfo {
        public MethodResultInfo(Type pt, Check.CheckContext checkContext) {
            Attr attr = Resolve.this.attr;
            attr.getClass();
            super(12, pt, checkContext);
        }

        @Override
        protected Type check(JCDiagnostic.DiagnosticPosition pos, Type found) {
            if (found.hasTag(TypeTag.DEFERRED)) {
                DeferredAttr.DeferredType dt = (DeferredAttr.DeferredType)found;
                return dt.check(this);
            }
            Type uResult = this.U(found.baseType());
            Type capturedType = pos == null || pos.getTree() == null ? Resolve.this.types.capture(uResult) : this.checkContext.inferenceContext().cachedCapture(pos.getTree(), uResult, true);
            return super.check(pos, Resolve.this.chk.checkNonVoid(pos, capturedType));
        }

        private Type U(Type found) {
            return found == this.pt ? found : Resolve.this.types.cvarUpperBound(found);
        }

        @Override
        protected MethodResultInfo dup(Type newPt) {
            return new MethodResultInfo(newPt, this.checkContext);
        }

        @Override
        protected Attr.ResultInfo dup(Check.CheckContext newContext) {
            return new MethodResultInfo(this.pt, newContext);
        }
    }

    abstract class MethodCheckContext
    implements Check.CheckContext {
        boolean strict;
        DeferredAttr.DeferredAttrContext deferredAttrContext;
        Warner rsWarner;

        public MethodCheckContext(boolean strict, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner rsWarner) {
            this.strict = strict;
            this.deferredAttrContext = deferredAttrContext;
            this.rsWarner = rsWarner;
        }

        @Override
        public boolean compatible(Type found, Type req, Warner warn) {
            Infer.InferenceContext inferenceContext = this.deferredAttrContext.inferenceContext;
            return this.strict ? Resolve.this.types.isSubtypeUnchecked(inferenceContext.asUndetVar(found), inferenceContext.asUndetVar(req), warn) : Resolve.this.types.isConvertible(inferenceContext.asUndetVar(found), inferenceContext.asUndetVar(req), warn);
        }

        @Override
        public void report(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic details) {
            throw Resolve.this.inapplicableMethodException.setMessage(details);
        }

        @Override
        public Warner checkWarner(JCDiagnostic.DiagnosticPosition pos, Type found, Type req) {
            return this.rsWarner;
        }

        @Override
        public Infer.InferenceContext inferenceContext() {
            return this.deferredAttrContext.inferenceContext;
        }

        @Override
        public DeferredAttr.DeferredAttrContext deferredAttrContext() {
            return this.deferredAttrContext;
        }

        public String toString() {
            return "MethodReferenceCheck";
        }
    }

    class MethodReferenceCheck
    extends AbstractMethodCheck {
        Infer.InferenceContext pendingInferenceContext;

        MethodReferenceCheck(Infer.InferenceContext pendingInferenceContext) {
            this.pendingInferenceContext = pendingInferenceContext;
        }

        @Override
        void checkArg(JCDiagnostic.DiagnosticPosition pos, boolean varargs, Type actual, Type formal, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner warn) {
            Attr.ResultInfo mresult = this.methodCheckResult(varargs, formal, deferredAttrContext, warn);
            mresult.check(pos, actual);
        }

        private Attr.ResultInfo methodCheckResult(final boolean varargsCheck, Type to, DeferredAttr.DeferredAttrContext deferredAttrContext, Warner rsWarner) {
            MethodCheckContext checkContext = new MethodCheckContext(!deferredAttrContext.phase.isBoxingRequired(), deferredAttrContext, rsWarner){
                MethodCheckDiag methodDiag;
                {
                    super(strict, deferredAttrContext, rsWarner);
                    this.methodDiag = varargsCheck ? MethodCheckDiag.VARARG_MISMATCH : MethodCheckDiag.ARG_MISMATCH;
                }

                @Override
                public boolean compatible(Type found, Type req, Warner warn) {
                    if ((found = MethodReferenceCheck.this.pendingInferenceContext.asUndetVar(found)).hasTag(TypeTag.UNDETVAR) && req.isPrimitive()) {
                        req = Resolve.this.types.boxedClass((Type)req).type;
                    }
                    return super.compatible(found, req, warn);
                }

                @Override
                public void report(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic details) {
                    MethodReferenceCheck.this.reportMC(pos, this.methodDiag, this.deferredAttrContext.inferenceContext, details);
                }
            };
            return new MethodResultInfo(to, checkContext);
        }

        @Override
        public MethodCheck mostSpecificCheck(List<Type> actuals, boolean strict) {
            return new MostSpecificCheck(strict, actuals);
        }
    }

    abstract class AbstractMethodCheck
    implements MethodCheck {
        AbstractMethodCheck() {
        }

        @Override
        public void argumentsAcceptable(Env<AttrContext> env, DeferredAttr.DeferredAttrContext deferredAttrContext, List<Type> argtypes, List<Type> formals, Warner warn) {
            Type varargsFormal;
            boolean useVarargs = deferredAttrContext.phase.isVarargsRequired();
            List<JCTree.JCExpression> trees = TreeInfo.args(env.tree);
            Infer.InferenceContext inferenceContext = deferredAttrContext.inferenceContext;
            Type type = varargsFormal = useVarargs ? formals.last() : null;
            if (varargsFormal == null && argtypes.size() != formals.size()) {
                this.reportMC(env.tree, MethodCheckDiag.ARITY_MISMATCH, inferenceContext, new Object[0]);
            }
            while (argtypes.nonEmpty() && formals.head != varargsFormal) {
                JCTree.JCExpression pos = trees != null ? (JCTree.JCExpression)trees.head : null;
                this.checkArg(pos, false, (Type)argtypes.head, (Type)formals.head, deferredAttrContext, warn);
                argtypes = argtypes.tail;
                formals = formals.tail;
                trees = trees != null ? trees.tail : trees;
            }
            if (formals.head != varargsFormal) {
                this.reportMC(env.tree, MethodCheckDiag.ARITY_MISMATCH, inferenceContext, new Object[0]);
            }
            if (useVarargs) {
                Type elt = Resolve.this.types.elemtype(varargsFormal);
                while (argtypes.nonEmpty()) {
                    JCTree.JCExpression pos = trees != null ? (JCTree.JCExpression)trees.head : null;
                    this.checkArg(pos, true, (Type)argtypes.head, elt, deferredAttrContext, warn);
                    argtypes = argtypes.tail;
                    trees = trees != null ? trees.tail : trees;
                }
            }
        }

        abstract void checkArg(JCDiagnostic.DiagnosticPosition var1, boolean var2, Type var3, Type var4, DeferredAttr.DeferredAttrContext var5, Warner var6);

        protected void reportMC(JCDiagnostic.DiagnosticPosition pos, MethodCheckDiag diag, Infer.InferenceContext inferenceContext, Object ... args) {
            InapplicableMethodException ex;
            boolean inferDiag = inferenceContext != Resolve.this.infer.emptyContext;
            InapplicableMethodException inapplicableMethodException = ex = inferDiag ? Resolve.this.infer.inferenceException : Resolve.this.inapplicableMethodException;
            if (inferDiag && !diag.inferKey.equals(diag.basicKey)) {
                Object[] args2 = new Object[args.length + 1];
                System.arraycopy(args, 0, args2, 1, args.length);
                args2[0] = inferenceContext.inferenceVars();
                args = args2;
            }
            String key = inferDiag ? diag.inferKey : diag.basicKey;
            throw ex.setMessage(Resolve.this.diags.create(JCDiagnostic.DiagnosticType.FRAGMENT, Resolve.this.log.currentSource(), pos, key, args));
        }

        @Override
        public MethodCheck mostSpecificCheck(List<Type> actuals, boolean strict) {
            return Resolve.this.nilMethodCheck;
        }
    }

    static enum MethodCheckDiag {
        ARITY_MISMATCH("arg.length.mismatch", "infer.arg.length.mismatch"),
        ARG_MISMATCH("no.conforming.assignment.exists", "infer.no.conforming.assignment.exists"),
        VARARG_MISMATCH("varargs.argument.mismatch", "infer.varargs.argument.mismatch"),
        INACCESSIBLE_VARARGS("inaccessible.varargs.type", "inaccessible.varargs.type");

        final String basicKey;
        final String inferKey;

        private MethodCheckDiag(String basicKey, String inferKey) {
            this.basicKey = basicKey;
            this.inferKey = inferKey;
        }

        String regex() {
            return String.format("([a-z]*\\.)*(%s|%s)", this.basicKey, this.inferKey);
        }
    }

    static interface MethodCheck {
        public void argumentsAcceptable(Env<AttrContext> var1, DeferredAttr.DeferredAttrContext var2, List<Type> var3, List<Type> var4, Warner var5);

        public MethodCheck mostSpecificCheck(List<Type> var1, boolean var2);
    }

    static enum VerboseResolutionMode {
        SUCCESS("success"),
        FAILURE("failure"),
        APPLICABLE("applicable"),
        INAPPLICABLE("inapplicable"),
        DEFERRED_INST("deferred-inference"),
        PREDEF("predef"),
        OBJECT_INIT("object-init"),
        INTERNAL("internal");

        final String opt;

        private VerboseResolutionMode(String opt) {
            this.opt = opt;
        }

        static EnumSet<VerboseResolutionMode> getVerboseResolutionMode(Options opts) {
            String s = opts.get("verboseResolution");
            EnumSet<VerboseResolutionMode> res = EnumSet.noneOf(VerboseResolutionMode.class);
            if (s == null) {
                return res;
            }
            if (s.contains("all")) {
                res = EnumSet.allOf(VerboseResolutionMode.class);
            }
            java.util.List<String> args = Arrays.asList(s.split(","));
            for (VerboseResolutionMode mode : VerboseResolutionMode.values()) {
                if (args.contains(mode.opt)) {
                    res.add(mode);
                    continue;
                }
                if (!args.contains("-" + mode.opt)) continue;
                res.remove((Object)mode);
            }
            return res;
        }
    }
}

