/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MandatoryWarningHandler;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Warner;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileManager;

public class Check {
    protected static final Context.Key<Check> checkKey = new Context.Key();
    private final Names names;
    private final Log log;
    private final Resolve rs;
    private final Symtab syms;
    private final Enter enter;
    private final DeferredAttr deferredAttr;
    private final Infer infer;
    private final Types types;
    private final JCDiagnostic.Factory diags;
    private boolean warnOnSyntheticConflicts;
    private boolean suppressAbortOnBadClassFile;
    private boolean enableSunApiLintControl;
    private final TreeInfo treeinfo;
    private final JavaFileManager fileManager;
    private final Profile profile;
    private final boolean warnOnAccessToSensitiveMembers;
    private Lint lint;
    private Symbol.MethodSymbol method;
    boolean allowGenerics;
    boolean allowVarargs;
    boolean allowAnnotations;
    boolean allowCovariantReturns;
    boolean allowSimplifiedVarargs;
    boolean allowDefaultMethods;
    boolean allowStrictMethodClashCheck;
    boolean complexInference;
    char syntheticNameChar;
    public Map<Name, Symbol.ClassSymbol> compiled = new HashMap<Name, Symbol.ClassSymbol>();
    private MandatoryWarningHandler deprecationHandler;
    private MandatoryWarningHandler uncheckedHandler;
    private MandatoryWarningHandler sunApiHandler;
    private DeferredLintHandler deferredLintHandler;
    CheckContext basicHandler = new CheckContext(){

        @Override
        public void report(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic details) {
            Check.this.log.error(pos, "prob.found.req", details);
        }

        @Override
        public boolean compatible(Type found, Type req, Warner warn) {
            return Check.this.types.isAssignable(found, req, warn);
        }

        @Override
        public Warner checkWarner(JCDiagnostic.DiagnosticPosition pos, Type found, Type req) {
            return Check.this.convertWarner(pos, found, req);
        }

        @Override
        public Infer.InferenceContext inferenceContext() {
            return ((Check)Check.this).infer.emptyContext;
        }

        @Override
        public DeferredAttr.DeferredAttrContext deferredAttrContext() {
            return ((Check)Check.this).deferredAttr.emptyDeferredAttrContext;
        }

        public String toString() {
            return "CheckContext: basicHandler";
        }
    };
    private static final boolean ignoreAnnotatedCasts = true;
    Types.UnaryVisitor<Boolean> isTypeArgErroneous = new Types.UnaryVisitor<Boolean>(){

        @Override
        public Boolean visitType(Type t, Void s) {
            return t.isErroneous();
        }

        @Override
        public Boolean visitTypeVar(Type.TypeVar t, Void s) {
            return (Boolean)this.visit(t.getUpperBound());
        }

        @Override
        public Boolean visitCapturedType(Type.CapturedType t, Void s) {
            return (Boolean)this.visit(t.getUpperBound()) != false || (Boolean)this.visit(t.getLowerBound()) != false;
        }

        @Override
        public Boolean visitWildcardType(Type.WildcardType t, Void s) {
            return (Boolean)this.visit(t.type);
        }
    };
    Warner overrideWarner = new Warner();
    private Filter<Symbol> equalsHasCodeFilter = new Filter<Symbol>(){

        @Override
        public boolean accepts(Symbol s) {
            return Symbol.MethodSymbol.implementation_filter.accepts(s) && (s.flags() & 0x200000000000L) == 0L;
        }
    };
    private Set<Name> defaultTargets;
    private final Name[] dfltTargetMeta;

    public static Check instance(Context context) {
        Check instance = context.get(checkKey);
        if (instance == null) {
            instance = new Check(context);
        }
        return instance;
    }

    protected Check(Context context) {
        context.put(checkKey, this);
        this.names = Names.instance(context);
        this.dfltTargetMeta = new Name[]{this.names.PACKAGE, this.names.TYPE, this.names.FIELD, this.names.METHOD, this.names.CONSTRUCTOR, this.names.ANNOTATION_TYPE, this.names.LOCAL_VARIABLE, this.names.PARAMETER};
        this.log = Log.instance(context);
        this.rs = Resolve.instance(context);
        this.syms = Symtab.instance(context);
        this.enter = Enter.instance(context);
        this.deferredAttr = DeferredAttr.instance(context);
        this.infer = Infer.instance(context);
        this.types = Types.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        Options options = Options.instance(context);
        this.lint = Lint.instance(context);
        this.treeinfo = TreeInfo.instance(context);
        this.fileManager = context.get(JavaFileManager.class);
        Source source = Source.instance(context);
        this.allowGenerics = source.allowGenerics();
        this.allowVarargs = source.allowVarargs();
        this.allowAnnotations = source.allowAnnotations();
        this.allowCovariantReturns = source.allowCovariantReturns();
        this.allowSimplifiedVarargs = source.allowSimplifiedVarargs();
        this.allowDefaultMethods = source.allowDefaultMethods();
        this.allowStrictMethodClashCheck = source.allowStrictMethodClashCheck();
        this.complexInference = options.isSet("complexinference");
        this.warnOnSyntheticConflicts = options.isSet("warnOnSyntheticConflicts");
        this.suppressAbortOnBadClassFile = options.isSet("suppressAbortOnBadClassFile");
        this.enableSunApiLintControl = options.isSet("enableSunApiLintControl");
        this.warnOnAccessToSensitiveMembers = options.isSet("warnOnAccessToSensitiveMembers");
        Target target = Target.instance(context);
        this.syntheticNameChar = target.syntheticNameChar();
        this.profile = Profile.instance(context);
        boolean verboseDeprecated = this.lint.isEnabled(Lint.LintCategory.DEPRECATION);
        boolean verboseUnchecked = this.lint.isEnabled(Lint.LintCategory.UNCHECKED);
        boolean verboseSunApi = this.lint.isEnabled(Lint.LintCategory.SUNAPI);
        boolean enforceMandatoryWarnings = source.enforceMandatoryWarnings();
        this.deprecationHandler = new MandatoryWarningHandler(this.log, verboseDeprecated, enforceMandatoryWarnings, "deprecated", Lint.LintCategory.DEPRECATION);
        this.uncheckedHandler = new MandatoryWarningHandler(this.log, verboseUnchecked, enforceMandatoryWarnings, "unchecked", Lint.LintCategory.UNCHECKED);
        this.sunApiHandler = new MandatoryWarningHandler(this.log, verboseSunApi, enforceMandatoryWarnings, "sunapi", null);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
    }

    Lint setLint(Lint newLint) {
        Lint prev = this.lint;
        this.lint = newLint;
        return prev;
    }

    Symbol.MethodSymbol setMethod(Symbol.MethodSymbol newMethod) {
        Symbol.MethodSymbol prev = this.method;
        this.method = newMethod;
        return prev;
    }

    void warnDeprecated(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        if (!this.lint.isSuppressed(Lint.LintCategory.DEPRECATION)) {
            this.deprecationHandler.report(pos, "has.been.deprecated", sym, sym.location());
        }
    }

    public void warnUnchecked(JCDiagnostic.DiagnosticPosition pos, String msg, Object ... args) {
        if (!this.lint.isSuppressed(Lint.LintCategory.UNCHECKED)) {
            this.uncheckedHandler.report(pos, msg, args);
        }
    }

    void warnUnsafeVararg(JCDiagnostic.DiagnosticPosition pos, String key, Object ... args) {
        if (this.lint.isEnabled(Lint.LintCategory.VARARGS) && this.allowSimplifiedVarargs) {
            this.log.warning(Lint.LintCategory.VARARGS, pos, key, args);
        }
    }

    public void warnSunApi(JCDiagnostic.DiagnosticPosition pos, String msg, Object ... args) {
        if (!this.lint.isSuppressed(Lint.LintCategory.SUNAPI)) {
            this.sunApiHandler.report(pos, msg, args);
        }
    }

    public void warnStatic(JCDiagnostic.DiagnosticPosition pos, String msg, Object ... args) {
        if (this.lint.isEnabled(Lint.LintCategory.STATIC)) {
            this.log.warning(Lint.LintCategory.STATIC, pos, msg, args);
        }
    }

    public void reportDeferredDiagnostics() {
        this.deprecationHandler.reportDeferredDiagnostic();
        this.uncheckedHandler.reportDeferredDiagnostic();
        this.sunApiHandler.reportDeferredDiagnostic();
    }

    public Type completionError(JCDiagnostic.DiagnosticPosition pos, Symbol.CompletionFailure ex) {
        this.log.error(JCDiagnostic.DiagnosticFlag.NON_DEFERRABLE, pos, "cant.access", ex.sym, ex.getDetailValue());
        if (ex instanceof ClassFinder.BadClassFile && !this.suppressAbortOnBadClassFile) {
            throw new Abort();
        }
        return this.syms.errType;
    }

    Type typeTagError(JCDiagnostic.DiagnosticPosition pos, Object required, Object found) {
        if (found instanceof Type && ((Type)found).hasTag(TypeTag.VOID)) {
            this.log.error(pos, "illegal.start.of.type", new Object[0]);
            return this.syms.errType;
        }
        this.log.error(pos, "type.found.req", found, required);
        return this.types.createErrorType(found instanceof Type ? (Type)found : this.syms.errType);
    }

    void earlyRefError(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        this.log.error(pos, "cant.ref.before.ctor.called", sym);
    }

    void duplicateError(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        if (!sym.type.isErroneous()) {
            Symbol location = sym.location();
            if (location.kind == 16 && ((Symbol.MethodSymbol)location).isStaticOrInstanceInit()) {
                this.log.error(pos, "already.defined.in.clinit", Kinds.kindName(sym), sym, Kinds.kindName(sym.location()), Kinds.kindName(sym.location().enclClass()), sym.location().enclClass());
            } else {
                this.log.error(pos, "already.defined", Kinds.kindName(sym), sym, Kinds.kindName(sym.location()), sym.location());
            }
        }
    }

    void varargsDuplicateError(JCDiagnostic.DiagnosticPosition pos, Symbol sym1, Symbol sym2) {
        if (!sym1.type.isErroneous() && !sym2.type.isErroneous()) {
            this.log.error(pos, "array.and.varargs", sym1, sym2, sym2.location());
        }
    }

    void checkTransparentVar(JCDiagnostic.DiagnosticPosition pos, Symbol.VarSymbol v, Scope s) {
        if (s.next != null) {
            Scope.Entry e = s.next.lookup(v.name);
            while (e.scope != null && e.sym.owner == v.owner) {
                if (e.sym.kind == 4 && (e.sym.owner.kind & 0x14) != 0 && v.name != this.names.error) {
                    this.duplicateError(pos, e.sym);
                    return;
                }
                e = e.next();
            }
        }
    }

    void checkTransparentClass(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c, Scope s) {
        if (s.next != null) {
            Scope.Entry e = s.next.lookup(c.name);
            while (e.scope != null && e.sym.owner == c.owner) {
                if (e.sym.kind == 2 && !e.sym.type.hasTag(TypeTag.TYPEVAR) && (e.sym.owner.kind & 0x14) != 0 && c.name != this.names.error) {
                    this.duplicateError(pos, e.sym);
                    return;
                }
                e = e.next();
            }
        }
    }

    boolean checkUniqueClassName(JCDiagnostic.DiagnosticPosition pos, Name name, Scope s) {
        Scope.Entry e = s.lookup(name);
        while (e.scope == s) {
            if (e.sym.kind == 2 && e.sym.name != this.names.error) {
                this.duplicateError(pos, e.sym);
                return false;
            }
            e = e.next();
        }
        Symbol sym = s.owner;
        while (sym != null) {
            if (sym.kind == 2 && sym.name == name && sym.name != this.names.error) {
                this.duplicateError(pos, sym);
                return true;
            }
            sym = sym.owner;
        }
        return true;
    }

    Name localClassName(Symbol.ClassSymbol c) {
        int i = 1;
        Name flatname;
        while (this.compiled.get(flatname = this.names.fromString("" + c.owner.enclClass().flatname + this.syntheticNameChar + i + c.name)) != null) {
            ++i;
        }
        return flatname;
    }

    public void newRound() {
        this.compiled.clear();
    }

    Type checkType(JCDiagnostic.DiagnosticPosition pos, Type found, Type req) {
        return this.checkType(pos, found, req, this.basicHandler);
    }

    Type checkType(final JCDiagnostic.DiagnosticPosition pos, final Type found, final Type req, final CheckContext checkContext) {
        Infer.InferenceContext inferenceContext = checkContext.inferenceContext();
        if (inferenceContext.free(req)) {
            inferenceContext.addFreeTypeListener(List.of(req), new Infer.FreeTypeListener(){

                @Override
                public void typesInferred(Infer.InferenceContext inferenceContext) {
                    Check.this.checkType(pos, inferenceContext.asInstType(found), inferenceContext.asInstType(req), checkContext);
                }
            });
        }
        if (req.hasTag(TypeTag.ERROR)) {
            return req;
        }
        if (req.hasTag(TypeTag.NONE)) {
            return found;
        }
        if (checkContext.compatible(found, req, checkContext.checkWarner(pos, found, req))) {
            return found;
        }
        if (found.isNumeric() && req.isNumeric()) {
            checkContext.report(pos, this.diags.fragment("possible.loss.of.precision", found, req));
            return this.types.createErrorType(found);
        }
        checkContext.report(pos, this.diags.fragment("inconvertible.types", found, req));
        return this.types.createErrorType(found);
    }

    Type checkCastable(JCDiagnostic.DiagnosticPosition pos, Type found, Type req) {
        return this.checkCastable(pos, found, req, this.basicHandler);
    }

    Type checkCastable(JCDiagnostic.DiagnosticPosition pos, Type found, Type req, CheckContext checkContext) {
        if (this.types.isCastable(found, req, this.castWarner(pos, found, req))) {
            return req;
        }
        checkContext.report(pos, this.diags.fragment("inconvertible.types", found, req));
        return this.types.createErrorType(found);
    }

    public void checkRedundantCast(Env<AttrContext> env, final JCTree.JCTypeCast tree) {
        if (!tree.type.isErroneous() && this.types.isSameType(tree.expr.type, tree.clazz.type) && !TreeInfo.containsTypeAnnotation(tree.clazz) && !this.is292targetTypeCast(tree)) {
            this.deferredLintHandler.report(new DeferredLintHandler.LintLogger(){

                @Override
                public void report() {
                    if (Check.this.lint.isEnabled(Lint.LintCategory.CAST)) {
                        Check.this.log.warning(Lint.LintCategory.CAST, tree.pos(), "redundant.cast", tree.expr.type);
                    }
                }
            });
        }
    }

    private boolean is292targetTypeCast(JCTree.JCTypeCast tree) {
        boolean is292targetTypeCast = false;
        JCTree.JCExpression expr = TreeInfo.skipParens(tree.expr);
        if (expr.hasTag(JCTree.Tag.APPLY)) {
            JCTree.JCMethodInvocation apply = (JCTree.JCMethodInvocation)expr;
            Symbol sym = TreeInfo.symbol(apply.meth);
            is292targetTypeCast = sym != null && sym.kind == 16 && (sym.flags() & 0x2000000000L) != 0L;
        }
        return is292targetTypeCast;
    }

    private boolean checkExtends(Type a, Type bound) {
        if (a.isUnbound()) {
            return true;
        }
        if (!a.hasTag(TypeTag.WILDCARD)) {
            a = this.types.upperBound(a);
            return this.types.isSubtype(a, bound);
        }
        if (a.isExtendsBound()) {
            return this.types.isCastable(bound, this.types.upperBound(a), this.types.noWarnings);
        }
        if (a.isSuperBound()) {
            return !this.types.notSoftSubtype(this.types.wildLowerBound(a), bound);
        }
        return true;
    }

    Type checkNonVoid(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (t.hasTag(TypeTag.VOID)) {
            this.log.error(pos, "void.not.allowed.here", new Object[0]);
            return this.types.createErrorType(t);
        }
        return t;
    }

    Type checkClassOrArrayType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (!(t.hasTag(TypeTag.CLASS) || t.hasTag(TypeTag.ARRAY) || t.hasTag(TypeTag.ERROR))) {
            return this.typeTagError(pos, this.diags.fragment("type.req.class.array", new Object[0]), this.asTypeParam(t));
        }
        return t;
    }

    Type checkClassType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (!t.hasTag(TypeTag.CLASS) && !t.hasTag(TypeTag.ERROR)) {
            return this.typeTagError(pos, this.diags.fragment("type.req.class", new Object[0]), this.asTypeParam(t));
        }
        return t;
    }

    private Object asTypeParam(Type t) {
        return t.hasTag(TypeTag.TYPEVAR) ? this.diags.fragment("type.parameter", t) : t;
    }

    Type checkConstructorRefType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if ((t = this.checkClassOrArrayType(pos, t)).hasTag(TypeTag.CLASS)) {
            if ((t.tsym.flags() & 0x600L) != 0L) {
                this.log.error(pos, "abstract.cant.be.instantiated", t.tsym);
                t = this.types.createErrorType(t);
            } else if ((t.tsym.flags() & 0x4000L) != 0L) {
                this.log.error(pos, "enum.cant.be.instantiated", new Object[0]);
                t = this.types.createErrorType(t);
            } else {
                t = this.checkClassType(pos, t, true);
            }
        } else if (t.hasTag(TypeTag.ARRAY) && !this.types.isReifiable(((Type.ArrayType)t).elemtype)) {
            this.log.error(pos, "generic.array.creation", new Object[0]);
            t = this.types.createErrorType(t);
        }
        return t;
    }

    Type checkClassType(JCDiagnostic.DiagnosticPosition pos, Type t, boolean noBounds) {
        t = this.checkClassType(pos, t);
        if (noBounds && t.isParameterized()) {
            List<Type> args = t.getTypeArguments();
            while (args.nonEmpty()) {
                if (((Type)args.head).hasTag(TypeTag.WILDCARD)) {
                    return this.typeTagError(pos, this.diags.fragment("type.req.exact", new Object[0]), args.head);
                }
                args = args.tail;
            }
        }
        return t;
    }

    Type checkRefType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (t.isReference()) {
            return t;
        }
        return this.typeTagError(pos, this.diags.fragment("type.req.ref", new Object[0]), t);
    }

    List<Type> checkRefTypes(List<JCTree.JCExpression> trees, List<Type> types) {
        List<JCTree.JCExpression> tl = trees;
        List<Type> l = types;
        while (l.nonEmpty()) {
            l.head = this.checkRefType(((JCTree.JCExpression)tl.head).pos(), (Type)l.head);
            tl = tl.tail;
            l = l.tail;
        }
        return types;
    }

    Type checkNullOrRefType(JCDiagnostic.DiagnosticPosition pos, Type t) {
        if (t.isReference() || t.hasTag(TypeTag.BOT)) {
            return t;
        }
        return this.typeTagError(pos, this.diags.fragment("type.req.ref", new Object[0]), t);
    }

    boolean checkDisjoint(JCDiagnostic.DiagnosticPosition pos, long flags, long set1, long set2) {
        if ((flags & set1) != 0L && (flags & set2) != 0L) {
            this.log.error(pos, "illegal.combination.of.modifiers", Flags.asFlagSet(TreeInfo.firstFlag(flags & set1)), Flags.asFlagSet(TreeInfo.firstFlag(flags & set2)));
            return false;
        }
        return true;
    }

    Type checkDiamond(JCTree.JCNewClass tree, Type t) {
        if (!TreeInfo.isDiamond(tree) || t.isErroneous()) {
            return this.checkClassType(tree.clazz.pos(), t, true);
        }
        if (tree.def != null) {
            this.log.error(tree.clazz.pos(), "cant.apply.diamond.1", t, this.diags.fragment("diamond.and.anon.class", t));
            return this.types.createErrorType(t);
        }
        if (t.tsym.type.getTypeArguments().isEmpty()) {
            this.log.error(tree.clazz.pos(), "cant.apply.diamond.1", t, this.diags.fragment("diamond.non.generic", t));
            return this.types.createErrorType(t);
        }
        if (tree.typeargs != null && tree.typeargs.nonEmpty()) {
            this.log.error(tree.clazz.pos(), "cant.apply.diamond.1", t, this.diags.fragment("diamond.and.explicit.params", t));
            return this.types.createErrorType(t);
        }
        return t;
    }

    void checkVarargsMethodDecl(Env<AttrContext> env, JCTree.JCMethodDecl tree) {
        Symbol.MethodSymbol m = tree.sym;
        if (!this.allowSimplifiedVarargs) {
            return;
        }
        boolean hasTrustMeAnno = m.attribute(this.syms.trustMeType.tsym) != null;
        Type varargElemType = null;
        if (m.isVarArgs()) {
            varargElemType = this.types.elemtype(tree.params.last().type);
        }
        if (hasTrustMeAnno && !this.isTrustMeAllowedOnMethod(m)) {
            if (varargElemType != null) {
                this.log.error(tree, "varargs.invalid.trustme.anno", this.syms.trustMeType.tsym, this.diags.fragment("varargs.trustme.on.virtual.varargs", m));
            } else {
                this.log.error(tree, "varargs.invalid.trustme.anno", this.syms.trustMeType.tsym, this.diags.fragment("varargs.trustme.on.non.varargs.meth", m));
            }
        } else if (hasTrustMeAnno && varargElemType != null && this.types.isReifiable(varargElemType)) {
            this.warnUnsafeVararg(tree, "varargs.redundant.trustme.anno", this.syms.trustMeType.tsym, this.diags.fragment("varargs.trustme.on.reifiable.varargs", varargElemType));
        } else if (!hasTrustMeAnno && varargElemType != null && !this.types.isReifiable(varargElemType)) {
            this.warnUnchecked(((JCTree.JCVariableDecl)tree.params.head).pos(), "unchecked.varargs.non.reifiable.type", varargElemType);
        }
    }

    private boolean isTrustMeAllowedOnMethod(Symbol s) {
        return (s.flags() & 0x400000000L) != 0L && (s.isConstructor() || (s.flags() & 0x18L) != 0L);
    }

    Type checkMethod(final Type mtype, final Symbol sym, final Env<AttrContext> env, final List<JCTree.JCExpression> argtrees, final List<Type> argtypes, final boolean useVarargs, Infer.InferenceContext inferenceContext) {
        List<JCTree.JCExpression> args;
        Type last;
        if (inferenceContext.free(mtype)) {
            inferenceContext.addFreeTypeListener(List.of(mtype), new Infer.FreeTypeListener(){

                @Override
                public void typesInferred(Infer.InferenceContext inferenceContext) {
                    Check.this.checkMethod(inferenceContext.asInstType(mtype), sym, env, argtrees, argtypes, useVarargs, inferenceContext);
                }
            });
            return mtype;
        }
        Type owntype = mtype;
        List<Type> formals = owntype.getParameterTypes();
        List<Type> nonInferred = sym.type.getParameterTypes();
        if (nonInferred.length() != formals.length()) {
            nonInferred = formals;
        }
        Type type = last = useVarargs ? formals.last() : null;
        if (sym.name == this.names.init && sym.owner == this.syms.enumSym) {
            formals = formals.tail.tail;
            nonInferred = nonInferred.tail.tail;
        }
        if ((args = argtrees) != null) {
            while (formals.head != last) {
                JCTree arg = (JCTree)args.head;
                Warner warn = this.convertWarner(arg.pos(), arg.type, (Type)nonInferred.head);
                this.assertConvertible(arg, arg.type, (Type)formals.head, warn);
                args = args.tail;
                formals = formals.tail;
                nonInferred = nonInferred.tail;
            }
            if (useVarargs) {
                Type varArg = this.types.elemtype(last);
                while (args.tail != null) {
                    JCTree arg = (JCTree)args.head;
                    Warner warn = this.convertWarner(arg.pos(), arg.type, varArg);
                    this.assertConvertible(arg, arg.type, varArg, warn);
                    args = args.tail;
                }
            } else if ((sym.flags() & 0x400400000000L) == 0x400000000L && this.allowVarargs) {
                Type varParam = owntype.getParameterTypes().last();
                Type lastArg = argtypes.last();
                if (this.types.isSubtypeUnchecked(lastArg, this.types.elemtype(varParam)) && !this.types.isSameType(this.types.erasure(varParam), this.types.erasure(lastArg))) {
                    this.log.warning(argtrees.last().pos(), "inexact.non-varargs.call", this.types.elemtype(varParam), varParam);
                }
            }
        }
        if (useVarargs) {
            Type argtype = owntype.getParameterTypes().last();
            if (!(this.types.isReifiable(argtype) || this.allowSimplifiedVarargs && sym.attribute(this.syms.trustMeType.tsym) != null && this.isTrustMeAllowedOnMethod(sym))) {
                this.warnUnchecked(env.tree.pos(), "unchecked.generic.array.creation", argtype);
            }
            if ((sym.baseSymbol().flags() & 0x400000000000L) == 0L) {
                TreeInfo.setVarargsElement(env.tree, this.types.elemtype(argtype));
            }
        }
        JCTree.JCPolyExpression.PolyKind pkind = sym.type.hasTag(TypeTag.FORALL) && sym.type.getReturnType().containsAny(((Type.ForAll)sym.type).tvars) ? JCTree.JCPolyExpression.PolyKind.POLY : JCTree.JCPolyExpression.PolyKind.STANDALONE;
        TreeInfo.setPolyKind(env.tree, pkind);
        return owntype;
    }

    private void assertConvertible(JCTree tree, Type actual, Type formal, Warner warn) {
        if (this.types.isConvertible(actual, formal, warn)) {
            return;
        }
        if (formal.isCompound() && this.types.isSubtype(actual, this.types.supertype(formal)) && this.types.isSubtypeUnchecked(actual, this.types.interfaces(formal), warn)) {
            return;
        }
    }

    public boolean checkValidGenericType(Type t) {
        return this.firstIncompatibleTypeArg(t) == null;
    }

    private Type firstIncompatibleTypeArg(Type type) {
        List<Type> formals = type.tsym.type.allparams();
        List<Type> actuals = type.allparams();
        List<Type> args = type.getTypeArguments();
        List<Type> forms = type.tsym.type.getTypeArguments();
        ListBuffer<Type> bounds_buf = new ListBuffer<Type>();
        while (args.nonEmpty() && forms.nonEmpty()) {
            bounds_buf.append(this.types.subst(((Type)forms.head).getUpperBound(), formals, actuals));
            args = args.tail;
            forms = forms.tail;
        }
        args = type.getTypeArguments();
        List<Type> tvars_cap = this.types.substBounds(formals, formals, this.types.capture(type).allparams());
        while (args.nonEmpty() && tvars_cap.nonEmpty()) {
            ((Type)args.head).withTypeVar((Type.TypeVar)((Type)tvars_cap.head));
            args = args.tail;
            tvars_cap = tvars_cap.tail;
        }
        args = type.getTypeArguments();
        List bounds = bounds_buf.toList();
        while (args.nonEmpty() && bounds.nonEmpty()) {
            Type actual = (Type)args.head;
            if (!(this.isTypeArgErroneous(actual) || ((Type)bounds.head).isErroneous() || this.checkExtends(actual, (Type)bounds.head))) {
                return (Type)args.head;
            }
            args = args.tail;
            bounds = bounds.tail;
        }
        args = type.getTypeArguments();
        bounds = bounds_buf.toList();
        for (Type arg : this.types.capture(type).getTypeArguments()) {
            if (arg.hasTag(TypeTag.TYPEVAR) && arg.getUpperBound().isErroneous() && !((Type)bounds.head).isErroneous() && !this.isTypeArgErroneous((Type)args.head)) {
                return (Type)args.head;
            }
            bounds = bounds.tail;
            args = args.tail;
        }
        return null;
    }

    boolean isTypeArgErroneous(Type t) {
        return this.isTypeArgErroneous.visit(t);
    }

    long checkFlags(JCDiagnostic.DiagnosticPosition pos, long flags, Symbol sym, JCTree tree) {
        long mask;
        long implicit = 0L;
        switch (sym.kind) {
            case 4: {
                if (sym.owner.kind != 2) {
                    mask = 0x200000010L;
                    break;
                }
                if ((sym.owner.flags_field & 0x200L) != 0L) {
                    implicit = 25L;
                    mask = 25L;
                    break;
                }
                mask = 16607L;
                break;
            }
            case 16: {
                if (sym.name == this.names.init) {
                    if ((sym.owner.flags_field & 0x4000L) != 0L) {
                        implicit = 2L;
                        mask = 2L;
                    } else {
                        mask = 7L;
                    }
                } else if ((sym.owner.flags_field & 0x200L) != 0L) {
                    if ((sym.owner.flags_field & 0x2000L) != 0L) {
                        mask = 1025L;
                        implicit = 1025L;
                    } else if ((flags & 0x80000000008L) != 0L) {
                        mask = 8796093025289L;
                        implicit = 1L;
                        if ((flags & 0x80000000000L) != 0L) {
                            implicit |= 0x400L;
                        }
                    } else {
                        implicit = 1025L;
                        mask = 1025L;
                    }
                } else {
                    mask = 3391L;
                }
                if (((flags | implicit) & 0x400L) != 0L && (flags & 0x80000000000L) == 0L) break;
                implicit |= sym.owner.flags_field & 0x800L;
                break;
            }
            case 2: {
                if (sym.isLocal()) {
                    mask = 23568L;
                    if (sym.name.isEmpty()) {
                        implicit |= 0x10L;
                    }
                    if ((sym.owner.flags_field & 8L) == 0L && (flags & 0x4000L) != 0L) {
                        this.log.error(pos, "enums.must.be.static", new Object[0]);
                    }
                } else if (sym.owner.kind == 2) {
                    mask = 24087L;
                    if (sym.owner.owner.kind == 1 || (sym.owner.flags_field & 8L) != 0L) {
                        mask |= 8L;
                    } else if ((flags & 0x4000L) != 0L) {
                        this.log.error(pos, "enums.must.be.static", new Object[0]);
                    }
                    if ((flags & 0x4200L) != 0L) {
                        implicit = 8L;
                    }
                } else {
                    mask = 32273L;
                }
                if ((flags & 0x200L) != 0L) {
                    implicit |= 0x400L;
                }
                if ((flags & 0x4000L) != 0L) {
                    mask &= 0xFFFFFFFFFFFFFBEFL;
                    implicit |= this.implicitEnumFinalFlag(tree);
                }
                implicit |= sym.owner.flags_field & 0x800L;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        long illegal = flags & 0x80000000FFFL & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        if (illegal != 0L) {
            if ((illegal & 0x200L) != 0L) {
                this.log.error(pos, "intf.not.allowed.here", new Object[0]);
                mask |= 0x200L;
            } else {
                this.log.error(pos, "mod.not.allowed.here", Flags.asFlagSet(illegal));
            }
        } else if (!((sym.kind == 2 || this.checkDisjoint(pos, flags, 1024L, 0x8000000000AL)) && this.checkDisjoint(pos, flags, 8L, 0x80000000000L) && this.checkDisjoint(pos, flags, 1536L, 304L) && this.checkDisjoint(pos, flags, 1L, 6L) && this.checkDisjoint(pos, flags, 2L, 5L) && this.checkDisjoint(pos, flags, 16L, 64L) && sym.kind != 2 && !this.checkDisjoint(pos, flags, 1280L, 2048L))) {
            // empty if block
        }
        return flags & (mask | 0xFFFFF7FFFFFFF000L) | implicit;
    }

    private long implicitEnumFinalFlag(JCTree tree) {
        if (!tree.hasTag(JCTree.Tag.CLASSDEF)) {
            return 0L;
        }
        class SpecialTreeVisitor
        extends JCTree.Visitor {
            boolean specialized = false;

            SpecialTreeVisitor() {
            }

            @Override
            public void visitTree(JCTree tree) {
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl tree) {
                if ((tree.mods.flags & 0x4000L) != 0L && tree.init instanceof JCTree.JCNewClass && ((JCTree.JCNewClass)tree.init).def != null) {
                    this.specialized = true;
                }
            }
        }
        SpecialTreeVisitor sts = new SpecialTreeVisitor();
        JCTree.JCClassDecl cdef = (JCTree.JCClassDecl)tree;
        for (JCTree defs : cdef.defs) {
            defs.accept(sts);
            if (!sts.specialized) continue;
            return 0L;
        }
        return 16L;
    }

    void validate(JCTree tree, Env<AttrContext> env) {
        this.validate(tree, env, true);
    }

    void validate(JCTree tree, Env<AttrContext> env, boolean checkRaw) {
        new Validator(env).validateTree(tree, checkRaw, true);
    }

    void validate(List<? extends JCTree> trees, Env<AttrContext> env) {
        List<JCTree> l = trees;
        while (l.nonEmpty()) {
            this.validate((JCTree)l.head, env);
            l = l.tail;
        }
    }

    void checkRaw(JCTree tree, Env<AttrContext> env) {
        if (this.lint.isEnabled(Lint.LintCategory.RAW) && tree.type.hasTag(TypeTag.CLASS) && !TreeInfo.isDiamond(tree) && !this.withinAnonConstr(env) && tree.type.isRaw()) {
            this.log.warning(Lint.LintCategory.RAW, tree.pos(), "raw.class.use", tree.type, tree.type.tsym.type);
        }
    }

    private boolean withinAnonConstr(Env<AttrContext> env) {
        return env.enclClass.name.isEmpty() && env.enclMethod != null && env.enclMethod.name == this.names.init;
    }

    boolean subset(Type t, List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (this.types.isSubtype(t, (Type)l.head)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    boolean intersects(Type t, List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (this.types.isSubtype(t, (Type)l.head) || this.types.isSubtype((Type)l.head, t)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    List<Type> incl(Type t, List<Type> ts) {
        return this.subset(t, ts) ? ts : this.excl(t, ts).prepend(t);
    }

    List<Type> excl(Type t, List<Type> ts) {
        if (ts.isEmpty()) {
            return ts;
        }
        List<Type> ts1 = this.excl(t, ts.tail);
        if (this.types.isSubtype((Type)ts.head, t)) {
            return ts1;
        }
        if (ts1 == ts.tail) {
            return ts;
        }
        return ts1.prepend((Type)ts.head);
    }

    List<Type> union(List<Type> ts1, List<Type> ts2) {
        List<Type> ts = ts1;
        List<Type> l = ts2;
        while (l.nonEmpty()) {
            ts = this.incl((Type)l.head, ts);
            l = l.tail;
        }
        return ts;
    }

    List<Type> diff(List<Type> ts1, List<Type> ts2) {
        List<Type> ts = ts1;
        List<Type> l = ts2;
        while (l.nonEmpty()) {
            ts = this.excl((Type)l.head, ts);
            l = l.tail;
        }
        return ts;
    }

    public List<Type> intersect(List<Type> ts1, List<Type> ts2) {
        List<Type> ts = List.nil();
        List<Type> l = ts1;
        while (l.nonEmpty()) {
            if (this.subset((Type)l.head, ts2)) {
                ts = this.incl((Type)l.head, ts);
            }
            l = l.tail;
        }
        l = ts2;
        while (l.nonEmpty()) {
            if (this.subset((Type)l.head, ts1)) {
                ts = this.incl((Type)l.head, ts);
            }
            l = l.tail;
        }
        return ts;
    }

    boolean isUnchecked(Symbol.ClassSymbol exc) {
        return exc.kind == 63 || exc.isSubClass(this.syms.errorType.tsym, this.types) || exc.isSubClass(this.syms.runtimeExceptionType.tsym, this.types);
    }

    boolean isUnchecked(Type exc) {
        return exc.hasTag(TypeTag.TYPEVAR) ? this.isUnchecked(this.types.supertype(exc)) : (exc.hasTag(TypeTag.CLASS) ? this.isUnchecked((Symbol.ClassSymbol)exc.tsym) : exc.hasTag(TypeTag.BOT));
    }

    boolean isUnchecked(JCDiagnostic.DiagnosticPosition pos, Type exc) {
        try {
            return this.isUnchecked(exc);
        }
        catch (Symbol.CompletionFailure ex) {
            this.completionError(pos, ex);
            return true;
        }
    }

    boolean isHandled(Type exc, List<Type> handled) {
        return this.isUnchecked(exc) || this.subset(exc, handled);
    }

    List<Type> unhandled(List<Type> thrown, List<Type> handled) {
        List<Type> unhandled = List.nil();
        List<Type> l = thrown;
        while (l.nonEmpty()) {
            if (!this.isHandled((Type)l.head, handled)) {
                unhandled = unhandled.prepend((Type)l.head);
            }
            l = l.tail;
        }
        return unhandled;
    }

    static int protection(long flags) {
        switch ((short)(flags & 7L)) {
            case 2: {
                return 3;
            }
            case 4: {
                return 1;
            }
            default: {
                return 0;
            }
            case 0: 
        }
        return 2;
    }

    Object cannotOverride(Symbol.MethodSymbol m, Symbol.MethodSymbol other) {
        String key = (other.owner.flags() & 0x200L) == 0L ? "cant.override" : ((m.owner.flags() & 0x200L) == 0L ? "cant.implement" : "clashes.with");
        return this.diags.fragment(key, m, m.location(), other, other.location());
    }

    Object uncheckedOverrides(Symbol.MethodSymbol m, Symbol.MethodSymbol other) {
        String key = (other.owner.flags() & 0x200L) == 0L ? "unchecked.override" : ((m.owner.flags() & 0x200L) == 0L ? "unchecked.implement" : "unchecked.clash.with");
        return this.diags.fragment(key, m, m.location(), other, other.location());
    }

    Object varargsOverrides(Symbol.MethodSymbol m, Symbol.MethodSymbol other) {
        String key = (other.owner.flags() & 0x200L) == 0L ? "varargs.override" : ((m.owner.flags() & 0x200L) == 0L ? "varargs.implement" : "varargs.clash.with");
        return this.diags.fragment(key, m, m.location(), other, other.location());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkOverride(JCTree tree, Symbol.MethodSymbol m, Symbol.MethodSymbol other, Symbol.ClassSymbol origin) {
        if ((m.flags() & 0x80001000L) != 0L || (other.flags() & 0x1000L) != 0L) {
            return;
        }
        if ((m.flags() & 8L) != 0L && (other.flags() & 8L) == 0L) {
            this.log.error(TreeInfo.diagnosticPositionFor(m, tree), "override.static", this.cannotOverride(m, other));
            m.flags_field |= 0x200000000000L;
            return;
        }
        if ((other.flags() & 0x10L) != 0L || (m.flags() & 8L) == 0L && (other.flags() & 8L) != 0L) {
            this.log.error(TreeInfo.diagnosticPositionFor(m, tree), "override.meth", this.cannotOverride(m, other), Flags.asFlagSet(other.flags() & 0x18L));
            m.flags_field |= 0x200000000000L;
            return;
        }
        if ((m.owner.flags() & 0x2000L) != 0L) {
            return;
        }
        if ((origin.flags() & 0x200L) == 0L && Check.protection(m.flags()) > Check.protection(other.flags())) {
            this.log.error(TreeInfo.diagnosticPositionFor(m, tree), "override.weaker.access", this.cannotOverride(m, other), (other.flags() & 7L) == 0L ? "package" : Flags.asFlagSet(other.flags() & 7L));
            m.flags_field |= 0x200000000000L;
            return;
        }
        Type mt = this.types.memberType(origin.type, m);
        Type ot = this.types.memberType(origin.type, other);
        List<Type> mtvars = mt.getTypeArguments();
        List<Type> otvars = ot.getTypeArguments();
        Type mtres = mt.getReturnType();
        Type otres = this.types.subst(ot.getReturnType(), otvars, mtvars);
        this.overrideWarner.clear();
        boolean resultTypesOK = this.types.returnTypeSubstitutable(mt, ot, otres, this.overrideWarner);
        if (!resultTypesOK) {
            if (this.allowCovariantReturns || m.owner == origin || !m.owner.isSubClass(other.owner, this.types)) {
                this.log.error(TreeInfo.diagnosticPositionFor(m, tree), "override.incompatible.ret", this.cannotOverride(m, other), mtres, otres);
                m.flags_field |= 0x200000000000L;
                return;
            }
        } else if (this.overrideWarner.hasNonSilentLint(Lint.LintCategory.UNCHECKED)) {
            this.warnUnchecked(TreeInfo.diagnosticPositionFor(m, tree), "override.unchecked.ret", this.uncheckedOverrides(m, other), mtres, otres);
        }
        List<Type> otthrown = this.types.subst(ot.getThrownTypes(), otvars, mtvars);
        List<Type> unhandledErased = this.unhandled(mt.getThrownTypes(), this.types.erasure(otthrown));
        List<Type> unhandledUnerased = this.unhandled(mt.getThrownTypes(), otthrown);
        if (unhandledErased.nonEmpty()) {
            this.log.error(TreeInfo.diagnosticPositionFor(m, tree), "override.meth.doesnt.throw", this.cannotOverride(m, other), unhandledUnerased.head);
            m.flags_field |= 0x200000000000L;
            return;
        }
        if (unhandledUnerased.nonEmpty()) {
            this.warnUnchecked(TreeInfo.diagnosticPositionFor(m, tree), "override.unchecked.thrown", this.cannotOverride(m, other), unhandledUnerased.head);
            return;
        }
        if (((m.flags() ^ other.flags()) & 0x400000000L) != 0L && this.lint.isEnabled(Lint.LintCategory.OVERRIDES)) {
            this.log.warning(TreeInfo.diagnosticPositionFor(m, tree), (m.flags() & 0x400000000L) != 0L ? "override.varargs.missing" : "override.varargs.extra", this.varargsOverrides(m, other));
        }
        if ((other.flags() & 0x80000000L) != 0L) {
            this.log.warning(TreeInfo.diagnosticPositionFor(m, tree), "override.bridge", this.uncheckedOverrides(m, other));
        }
        if (!this.isDeprecatedOverrideIgnorable(other, origin)) {
            Lint prevLint = this.setLint(this.lint.augment(m));
            try {
                this.checkDeprecated(TreeInfo.diagnosticPositionFor(m, tree), m, other);
            }
            finally {
                this.setLint(prevLint);
            }
        }
    }

    private boolean isDeprecatedOverrideIgnorable(Symbol.MethodSymbol m, Symbol.ClassSymbol origin) {
        Symbol.ClassSymbol mc = m.enclClass();
        Type st = this.types.supertype(origin.type);
        if (!st.hasTag(TypeTag.CLASS)) {
            return true;
        }
        Symbol.MethodSymbol stimpl = m.implementation((Symbol.ClassSymbol)st.tsym, this.types, false);
        if (mc != null && (mc.flags() & 0x200L) != 0L) {
            List<Type> intfs = this.types.interfaces(origin.type);
            return intfs.contains(mc.type) ? false : stimpl != null;
        }
        return stimpl != m;
    }

    public void checkCompatibleConcretes(JCDiagnostic.DiagnosticPosition pos, Type site) {
        Type sup = this.types.supertype(site);
        if (!sup.hasTag(TypeTag.CLASS)) {
            return;
        }
        Type t1 = sup;
        while (t1.hasTag(TypeTag.CLASS) && t1.tsym.type.isParameterized()) {
            Scope.Entry e1 = t1.tsym.members().elems;
            while (e1 != null) {
                Symbol s1 = e1.sym;
                if (s1.kind == 16 && (s1.flags() & 0x80001008L) == 0L && s1.isInheritedIn(site.tsym, this.types) && ((Symbol.MethodSymbol)s1).implementation(site.tsym, this.types, true) == s1) {
                    Type st1 = this.types.memberType(t1, s1);
                    int s1ArgsLength = st1.getParameterTypes().length();
                    if (st1 != s1.type) {
                        Type t2 = sup;
                        while (t2.hasTag(TypeTag.CLASS)) {
                            Scope.Entry e2 = t2.tsym.members().lookup(s1.name);
                            while (e2.scope != null) {
                                Type st2;
                                Symbol s2 = e2.sym;
                                if (s2 != s1 && s2.kind == 16 && (s2.flags() & 0x80001008L) == 0L && s2.type.getParameterTypes().length() == s1ArgsLength && s2.isInheritedIn(site.tsym, this.types) && ((Symbol.MethodSymbol)s2).implementation(site.tsym, this.types, true) == s2 && this.types.overrideEquivalent(st1, st2 = this.types.memberType(t2, s2))) {
                                    this.log.error(pos, "concrete.inheritance.conflict", s1, t1, s2, t2, sup);
                                }
                                e2 = e2.next();
                            }
                            t2 = this.types.supertype(t2);
                        }
                    }
                }
                e1 = e1.sibling;
            }
            t1 = this.types.supertype(t1);
        }
    }

    public boolean checkCompatibleAbstracts(JCDiagnostic.DiagnosticPosition pos, Type t1, Type t2) {
        return this.checkCompatibleAbstracts(pos, t1, t2, this.types.makeCompoundType(t1, t2));
    }

    public boolean checkCompatibleAbstracts(JCDiagnostic.DiagnosticPosition pos, Type t1, Type t2, Type site) {
        return this.firstIncompatibility(pos, t1, t2, site) == null;
    }

    private Symbol firstIncompatibility(JCDiagnostic.DiagnosticPosition pos, Type t1, Type t2, Type site) {
        HashMap<Symbol.TypeSymbol, Type> interfaces2;
        HashMap<Symbol.TypeSymbol, Type> interfaces1 = new HashMap<Symbol.TypeSymbol, Type>();
        this.closure(t1, interfaces1);
        if (t1 == t2) {
            interfaces2 = interfaces1;
        } else {
            interfaces2 = new HashMap<Symbol.TypeSymbol, Type>();
            this.closure(t2, interfaces1, interfaces2);
        }
        for (Type t3 : interfaces1.values()) {
            for (Type t4 : interfaces2.values()) {
                Symbol s = this.firstDirectIncompatibility(pos, t3, t4, site);
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    private void closure(Type t, Map<Symbol.TypeSymbol, Type> typeMap) {
        if (!t.hasTag(TypeTag.CLASS)) {
            return;
        }
        if (typeMap.put(t.tsym, t) == null) {
            this.closure(this.types.supertype(t), typeMap);
            for (Type i : this.types.interfaces(t)) {
                this.closure(i, typeMap);
            }
        }
    }

    private void closure(Type t, Map<Symbol.TypeSymbol, Type> typesSkip, Map<Symbol.TypeSymbol, Type> typeMap) {
        if (!t.hasTag(TypeTag.CLASS)) {
            return;
        }
        if (typesSkip.get(t.tsym) != null) {
            return;
        }
        if (typeMap.put(t.tsym, t) == null) {
            this.closure(this.types.supertype(t), typesSkip, typeMap);
            for (Type i : this.types.interfaces(t)) {
                this.closure(i, typesSkip, typeMap);
            }
        }
    }

    private Symbol firstDirectIncompatibility(JCDiagnostic.DiagnosticPosition pos, Type t1, Type t2, Type site) {
        Scope.Entry e1 = t1.tsym.members().elems;
        while (e1 != null) {
            Symbol.MethodSymbol impl;
            Symbol s1 = e1.sym;
            Type st1 = null;
            if (s1.kind == 16 && s1.isInheritedIn(site.tsym, this.types) && (s1.flags() & 0x1000L) == 0L && ((impl = ((Symbol.MethodSymbol)s1).implementation(site.tsym, this.types, false)) == null || (impl.flags() & 0x400L) != 0L)) {
                Scope.Entry e2 = t2.tsym.members().lookup(s1.name);
                while (e2.scope != null) {
                    Symbol s2 = e2.sym;
                    if (s1 != s2 && s2.kind == 16 && s2.isInheritedIn(site.tsym, this.types) && (s2.flags() & 0x1000L) == 0L) {
                        Type st2;
                        if (st1 == null) {
                            st1 = this.types.memberType(t1, s1);
                        }
                        if (this.types.overrideEquivalent(st1, st2 = this.types.memberType(t2, s2))) {
                            Type rt2;
                            boolean compat;
                            List<Type> tvars1 = st1.getTypeArguments();
                            List<Type> tvars2 = st2.getTypeArguments();
                            Type rt1 = st1.getReturnType();
                            boolean bl = compat = this.types.isSameType(rt1, rt2 = this.types.subst(st2.getReturnType(), tvars2, tvars1)) || !rt1.isPrimitiveOrVoid() && !rt2.isPrimitiveOrVoid() && (this.types.covariantReturnType(rt1, rt2, this.types.noWarnings) || this.types.covariantReturnType(rt2, rt1, this.types.noWarnings)) || this.checkCommonOverriderIn(s1, s2, site);
                            if (!compat) {
                                this.log.error(pos, "types.incompatible.diff.ret", t1, t2, s2.name + "(" + this.types.memberType(t2, s2).getParameterTypes() + ")");
                                return s2;
                            }
                        } else if (this.checkNameClash((Symbol.ClassSymbol)site.tsym, s1, s2) && !this.checkCommonOverriderIn(s1, s2, site)) {
                            this.log.error(pos, "name.clash.same.erasure.no.override", s1, s1.location(), s2, s2.location());
                            return s2;
                        }
                    }
                    e2 = e2.next();
                }
            }
            e1 = e1.sibling;
        }
        return null;
    }

    boolean checkCommonOverriderIn(Symbol s1, Symbol s2, Type site) {
        HashMap<Symbol.TypeSymbol, Type> supertypes = new HashMap<Symbol.TypeSymbol, Type>();
        Type st1 = this.types.memberType(site, s1);
        Type st2 = this.types.memberType(site, s2);
        this.closure(site, supertypes);
        for (Type t : supertypes.values()) {
            Scope.Entry e = t.tsym.members().lookup(s1.name);
            while (e.scope != null) {
                Type st3;
                Symbol s3 = e.sym;
                if (s3 != s1 && s3 != s2 && s3.kind == 16 && (s3.flags() & 0x80001000L) == 0L && this.types.overrideEquivalent(st3 = this.types.memberType(site, s3), st1) && this.types.overrideEquivalent(st3, st2) && this.types.returnTypeSubstitutable(st3, st1) && this.types.returnTypeSubstitutable(st3, st2)) {
                    return true;
                }
                e = e.next();
            }
        }
        return false;
    }

    void checkOverride(JCTree.JCMethodDecl tree, Symbol.MethodSymbol m) {
        Symbol.ClassSymbol origin = (Symbol.ClassSymbol)m.owner;
        if ((origin.flags() & 0x4000L) != 0L && this.names.finalize.equals(m.name) && m.overrides(this.syms.enumFinalFinalize, origin, this.types, false)) {
            this.log.error(tree.pos(), "enum.no.finalize", new Object[0]);
            return;
        }
        Type t = origin.type;
        while (t.hasTag(TypeTag.CLASS)) {
            if (t != origin.type) {
                this.checkOverride((JCTree)tree, t, origin, m);
            }
            for (Type t2 : this.types.interfaces(t)) {
                this.checkOverride((JCTree)tree, t2, origin, m);
            }
            t = this.types.supertype(t);
        }
        if (m.attribute(this.syms.overrideType.tsym) != null && !this.isOverrider(m)) {
            JCDiagnostic.DiagnosticPosition pos = tree.pos();
            for (JCTree.JCAnnotation a : tree.getModifiers().annotations) {
                if (a.annotationType.type.tsym != this.syms.overrideType.tsym) continue;
                pos = a.pos();
                break;
            }
            this.log.error(pos, "method.does.not.override.superclass", new Object[0]);
        }
    }

    void checkOverride(JCTree tree, Type site, Symbol.ClassSymbol origin, Symbol.MethodSymbol m) {
        Symbol.TypeSymbol c = site.tsym;
        Scope.Entry e = c.members().lookup(m.name);
        while (e.scope != null) {
            if (m.overrides(e.sym, origin, this.types, false) && (e.sym.flags() & 0x400L) == 0L) {
                this.checkOverride(tree, m, (Symbol.MethodSymbol)e.sym, origin);
            }
            e = e.next();
        }
    }

    public void checkClassOverrideEqualsAndHashIfNeeded(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol someClass) {
        List<Type> interfaces;
        if (someClass == (Symbol.ClassSymbol)this.syms.objectType.tsym || someClass.isInterface() || someClass.isEnum() || (someClass.flags() & 0x2000L) != 0L || (someClass.flags() & 0x400L) != 0L) {
            return;
        }
        if (someClass.isAnonymous() && (interfaces = this.types.interfaces(someClass.type)) != null && !interfaces.isEmpty() && ((Type)interfaces.head).tsym == this.syms.comparatorType.tsym) {
            return;
        }
        this.checkClassOverrideEqualsAndHash(pos, someClass);
    }

    private void checkClassOverrideEqualsAndHash(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol someClass) {
        if (this.lint.isEnabled(Lint.LintCategory.OVERRIDES)) {
            boolean overridesHashCode;
            Symbol.MethodSymbol equalsAtObject = (Symbol.MethodSymbol)this.syms.objectType.tsym.members().lookup((Name)this.names.equals).sym;
            Symbol.MethodSymbol hashCodeAtObject = (Symbol.MethodSymbol)this.syms.objectType.tsym.members().lookup((Name)this.names.hashCode).sym;
            boolean overridesEquals = this.types.implementation((Symbol.MethodSymbol)equalsAtObject, (Symbol.TypeSymbol)someClass, (boolean)false, this.equalsHasCodeFilter).owner == someClass;
            boolean bl = overridesHashCode = this.types.implementation(hashCodeAtObject, someClass, false, this.equalsHasCodeFilter) != hashCodeAtObject;
            if (overridesEquals && !overridesHashCode) {
                this.log.warning(Lint.LintCategory.OVERRIDES, pos, "override.equals.but.not.hashcode", someClass);
            }
        }
    }

    private boolean checkNameClash(Symbol.ClassSymbol origin, Symbol s1, Symbol s2) {
        ClashFilter cf = new ClashFilter(origin.type);
        return cf.accepts(s1) && cf.accepts(s2) && this.types.hasSameArgs(s1.erasure(this.types), s2.erasure(this.types));
    }

    void checkAllDefined(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c) {
        try {
            Symbol.MethodSymbol undef = this.firstUndef(c, c);
            if (undef != null) {
                if ((c.flags() & 0x4000L) != 0L && this.types.supertype((Type)c.type).tsym == this.syms.enumSym && (c.flags() & 0x10L) == 0L) {
                    c.flags_field |= 0x400L;
                } else {
                    Symbol.MethodSymbol undef1 = new Symbol.MethodSymbol(undef.flags(), undef.name, this.types.memberType(c.type, undef), undef.owner);
                    this.log.error(pos, "does.not.override.abstract", c, undef1, undef1.location());
                }
            }
        }
        catch (Symbol.CompletionFailure ex) {
            this.completionError(pos, ex);
        }
    }

    private Symbol.MethodSymbol firstUndef(Symbol.ClassSymbol impl, Symbol.ClassSymbol c) {
        Symbol.MethodSymbol undef = null;
        if (c == impl || (c.flags() & 0x600L) != 0L) {
            Type st;
            Scope s = c.members();
            Scope.Entry e = s.elems;
            while (undef == null && e != null) {
                if (e.sym.kind == 16 && (e.sym.flags() & 0x80000200400L) == 1024L) {
                    Symbol.MethodSymbol prov;
                    Symbol.MethodSymbol absmeth = (Symbol.MethodSymbol)e.sym;
                    Symbol.MethodSymbol implmeth = absmeth.implementation(impl, this.types, true);
                    if ((implmeth == null || implmeth == absmeth) && this.allowDefaultMethods && (prov = (Symbol.MethodSymbol)this.types.interfaceCandidates((Type)impl.type, (Symbol.MethodSymbol)absmeth).head) != null && prov.overrides(absmeth, impl, this.types, true)) {
                        implmeth = prov;
                    }
                    if (implmeth == null || implmeth == absmeth) {
                        undef = absmeth;
                    }
                }
                e = e.sibling;
            }
            if (undef == null && (st = this.types.supertype(c.type)).hasTag(TypeTag.CLASS)) {
                undef = this.firstUndef(impl, (Symbol.ClassSymbol)st.tsym);
            }
            List<Type> l = this.types.interfaces(c.type);
            while (undef == null && l.nonEmpty()) {
                undef = this.firstUndef(impl, (Symbol.ClassSymbol)((Type)l.head).tsym);
                l = l.tail;
            }
        }
        return undef;
    }

    void checkNonCyclicDecl(JCTree.JCClassDecl tree) {
        CycleChecker cc = new CycleChecker();
        cc.scan(tree);
        if (!cc.errorFound && !cc.partialCheck) {
            tree.sym.flags_field |= 0x40000000L;
        }
    }

    void checkNonCyclic(JCDiagnostic.DiagnosticPosition pos, Type t) {
        this.checkNonCyclicInternal(pos, t);
    }

    void checkNonCyclic(JCDiagnostic.DiagnosticPosition pos, Type.TypeVar t) {
        this.checkNonCyclic1(pos, t, List.nil());
    }

    private void checkNonCyclic1(JCDiagnostic.DiagnosticPosition pos, Type t, List<Type.TypeVar> seen) {
        if (t.hasTag(TypeTag.TYPEVAR) && (t.tsym.flags() & 0x10000000L) != 0L) {
            return;
        }
        if (seen.contains(t)) {
            Type.TypeVar tv = (Type.TypeVar)t;
            tv.bound = this.types.createErrorType(t);
            this.log.error(pos, "cyclic.inheritance", t);
        } else if (t.hasTag(TypeTag.TYPEVAR)) {
            Type.TypeVar tv = (Type.TypeVar)t;
            seen = seen.prepend(tv);
            for (Type b : this.types.getBounds(tv)) {
                this.checkNonCyclic1(pos, b, seen);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkNonCyclicInternal(JCDiagnostic.DiagnosticPosition pos, Type t) {
        boolean complete = true;
        Symbol.TypeSymbol c = t.tsym;
        if ((c.flags_field & 0x40000000L) != 0L) {
            return true;
        }
        if ((c.flags_field & 0x8000000L) != 0L) {
            this.noteCyclic(pos, (Symbol.ClassSymbol)c);
        } else if (!c.type.isErroneous()) {
            try {
                c.flags_field |= 0x8000000L;
                if (c.type.hasTag(TypeTag.CLASS)) {
                    Type st;
                    Type.ClassType clazz = (Type.ClassType)c.type;
                    if (clazz.interfaces_field != null) {
                        List<Type> l = clazz.interfaces_field;
                        while (l.nonEmpty()) {
                            complete &= this.checkNonCyclicInternal(pos, (Type)l.head);
                            l = l.tail;
                        }
                    }
                    if (clazz.supertype_field != null && (st = clazz.supertype_field) != null && st.hasTag(TypeTag.CLASS)) {
                        complete &= this.checkNonCyclicInternal(pos, st);
                    }
                    if (c.owner.kind == 2) {
                        complete &= this.checkNonCyclicInternal(pos, c.owner.type);
                    }
                }
            }
            finally {
                c.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
        }
        if (complete) {
            boolean bl = complete = (c.flags_field & 0x10000000L) == 0L && c.completer == null;
        }
        if (complete) {
            c.flags_field |= 0x40000000L;
        }
        return complete;
    }

    private void noteCyclic(JCDiagnostic.DiagnosticPosition pos, Symbol.ClassSymbol c) {
        this.log.error(pos, "cyclic.inheritance", c);
        List<Type> l = this.types.interfaces(c.type);
        while (l.nonEmpty()) {
            l.head = this.types.createErrorType((Symbol.ClassSymbol)((Type)l.head).tsym, Type.noType);
            l = l.tail;
        }
        Type st = this.types.supertype(c.type);
        if (st.hasTag(TypeTag.CLASS)) {
            ((Type.ClassType)c.type).supertype_field = this.types.createErrorType((Symbol.ClassSymbol)st.tsym, Type.noType);
        }
        c.type = this.types.createErrorType(c, c.type);
        c.flags_field |= 0x40000000L;
    }

    void checkImplementations(JCTree.JCClassDecl tree) {
        this.checkImplementations(tree, tree.sym, tree.sym);
    }

    void checkImplementations(JCTree tree, Symbol.ClassSymbol origin, Symbol.ClassSymbol ic) {
        List<Type> l = this.types.closure(ic.type);
        while (l.nonEmpty()) {
            Symbol.ClassSymbol lc = (Symbol.ClassSymbol)((Type)l.head).tsym;
            if ((this.allowGenerics || origin != lc) && (lc.flags() & 0x400L) != 0L) {
                Scope.Entry e = lc.members().elems;
                while (e != null) {
                    Symbol.MethodSymbol absmeth;
                    Symbol.MethodSymbol implmeth;
                    if (e.sym.kind == 16 && (e.sym.flags() & 0x408L) == 1024L && (implmeth = (absmeth = (Symbol.MethodSymbol)e.sym).implementation(origin, this.types, false)) != null && implmeth != absmeth && (implmeth.owner.flags() & 0x200L) == (origin.flags() & 0x200L)) {
                        this.checkOverride(tree, implmeth, absmeth, origin);
                    }
                    e = e.sibling;
                }
            }
            l = l.tail;
        }
    }

    void checkCompatibleSupertypes(JCDiagnostic.DiagnosticPosition pos, Type c) {
        List<Type> supertypes = this.types.interfaces(c);
        Type supertype = this.types.supertype(c);
        if (supertype.hasTag(TypeTag.CLASS) && (supertype.tsym.flags() & 0x400L) != 0L) {
            supertypes = supertypes.prepend(supertype);
        }
        List<Type> l = supertypes;
        while (l.nonEmpty()) {
            if (this.allowGenerics && !((Type)l.head).getTypeArguments().isEmpty() && !this.checkCompatibleAbstracts(pos, (Type)l.head, (Type)l.head, c)) {
                return;
            }
            List<Type> m = supertypes;
            while (m != l) {
                if (!this.checkCompatibleAbstracts(pos, (Type)l.head, (Type)m.head, c)) {
                    return;
                }
                m = m.tail;
            }
            l = l.tail;
        }
        this.checkCompatibleConcretes(pos, c);
    }

    void checkConflicts(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Symbol.TypeSymbol c) {
        Type ct = c.type;
        while (ct != Type.noType) {
            Scope.Entry e = ct.tsym.members().lookup(sym.name);
            while (e.scope == ct.tsym.members()) {
                if (sym.kind == e.sym.kind && this.types.isSameType(this.types.erasure(sym.type), this.types.erasure(e.sym.type)) && sym != e.sym && (sym.flags() & 0x1000L) != (e.sym.flags() & 0x1000L) && (sym.flags() & 0x200000L) == 0L && (e.sym.flags() & 0x200000L) == 0L && (sym.flags() & 0x80000000L) == 0L && (e.sym.flags() & 0x80000000L) == 0L) {
                    this.syntheticError(pos, (e.sym.flags() & 0x1000L) == 0L ? e.sym : sym);
                    return;
                }
                e = e.next();
            }
            ct = this.types.supertype(ct);
        }
    }

    void checkOverrideClashes(JCDiagnostic.DiagnosticPosition pos, Type site, Symbol.MethodSymbol sym) {
        ClashFilter cf = new ClashFilter(site);
        List<Symbol.MethodSymbol> potentiallyAmbiguousList = List.nil();
        boolean overridesAny = false;
        for (Symbol m1 : this.types.membersClosure(site, false).getElementsByName(sym.name, cf)) {
            if (!sym.overrides(m1, site.tsym, this.types, false)) {
                if (m1 == sym || overridesAny) continue;
                potentiallyAmbiguousList = potentiallyAmbiguousList.prepend((Symbol.MethodSymbol)m1);
                continue;
            }
            if (m1 != sym) {
                overridesAny = true;
                potentiallyAmbiguousList = List.nil();
            }
            for (Symbol m2 : this.types.membersClosure(site, false).getElementsByName(sym.name, cf)) {
                if (m2 == m1 || this.types.isSubSignature(sym.type, this.types.memberType(site, m2), this.allowStrictMethodClashCheck) || !this.types.hasSameArgs(m2.erasure(this.types), m1.erasure(this.types))) continue;
                sym.flags_field |= 0x40000000000L;
                String key = m1 == sym ? "name.clash.same.erasure.no.override" : "name.clash.same.erasure.no.override.1";
                this.log.error(pos, key, sym, sym.location(), m2, m2.location(), m1, m1.location());
                return;
            }
        }
        if (!overridesAny) {
            for (Symbol.MethodSymbol m : potentiallyAmbiguousList) {
                this.checkPotentiallyAmbiguousOverloads(pos, site, sym, m);
            }
        }
    }

    void checkHideClashes(JCDiagnostic.DiagnosticPosition pos, Type site, Symbol.MethodSymbol sym) {
        ClashFilter cf = new ClashFilter(site);
        for (Symbol s : this.types.membersClosure(site, true).getElementsByName(sym.name, cf)) {
            if (this.types.isSubSignature(sym.type, this.types.memberType(site, s), this.allowStrictMethodClashCheck)) continue;
            if (this.types.hasSameArgs(s.erasure(this.types), sym.erasure(this.types))) {
                this.log.error(pos, "name.clash.same.erasure.no.hide", sym, sym.location(), s, s.location());
                return;
            }
            this.checkPotentiallyAmbiguousOverloads(pos, site, sym, (Symbol.MethodSymbol)s);
        }
    }

    void checkDefaultMethodClashes(JCDiagnostic.DiagnosticPosition pos, Type site) {
        DefaultMethodClashFilter dcf = new DefaultMethodClashFilter(site);
        block0: for (Symbol m : this.types.membersClosure(site, false).getElements(dcf)) {
            Assert.check(m.kind == 16);
            List<Symbol.MethodSymbol> prov = this.types.interfaceCandidates(site, (Symbol.MethodSymbol)m);
            if (prov.size() <= 1) continue;
            ListBuffer<Object> abstracts = new ListBuffer<Symbol.MethodSymbol>();
            ListBuffer<Object> defaults = new ListBuffer<Symbol.MethodSymbol>();
            for (Symbol.MethodSymbol provSym : prov) {
                Symbol s2;
                String errKey;
                if ((provSym.flags() & 0x80000000000L) != 0L) {
                    defaults = defaults.append(provSym);
                } else if ((provSym.flags() & 0x400L) != 0L) {
                    abstracts = abstracts.append(provSym);
                }
                if (!defaults.nonEmpty() || defaults.size() + abstracts.size() < 2) continue;
                Symbol s1 = (Symbol)defaults.first();
                if (defaults.size() > 1) {
                    errKey = "types.incompatible.unrelated.defaults";
                    s2 = (Symbol)defaults.toList().tail.head;
                } else {
                    errKey = "types.incompatible.abstract.default";
                    s2 = (Symbol)abstracts.first();
                }
                this.log.error(pos, errKey, Kinds.kindName(site.tsym), site, m.name, this.types.memberType(site, m).getParameterTypes(), s1.location(), s2.location());
                continue block0;
            }
        }
    }

    void checkPotentiallyAmbiguousOverloads(JCDiagnostic.DiagnosticPosition pos, Type site, Symbol.MethodSymbol msym1, Symbol.MethodSymbol msym2) {
        if (msym1 != msym2 && this.allowDefaultMethods && this.lint.isEnabled(Lint.LintCategory.OVERLOADS) && (msym1.flags() & 0x1000000000000L) == 0L && (msym2.flags() & 0x1000000000000L) == 0L) {
            Type mt1 = this.types.memberType(site, msym1);
            Type mt2 = this.types.memberType(site, msym2);
            if (mt1.hasTag(TypeTag.FORALL) && mt2.hasTag(TypeTag.FORALL) && this.types.hasSameBounds((Type.ForAll)mt1, (Type.ForAll)mt2)) {
                mt2 = this.types.subst(mt2, ((Type.ForAll)mt2).tvars, ((Type.ForAll)mt1).tvars);
            }
            int maxLength = Math.max(mt1.getParameterTypes().length(), mt2.getParameterTypes().length());
            List<Type> args1 = this.rs.adjustArgs(mt1.getParameterTypes(), msym1, maxLength, true);
            List<Type> args2 = this.rs.adjustArgs(mt2.getParameterTypes(), msym2, maxLength, true);
            if (args1.length() != args2.length()) {
                return;
            }
            boolean potentiallyAmbiguous = false;
            while (args1.nonEmpty() && args2.nonEmpty()) {
                Type t = (Type)args2.head;
                Type s = (Type)args1.head;
                if (!this.types.isSubtype(t, s) && !this.types.isSubtype(s, t)) {
                    if (!this.types.isFunctionalInterface(s) || !this.types.isFunctionalInterface(t) || this.types.findDescriptorType(s).getParameterTypes().length() <= 0 || this.types.findDescriptorType(s).getParameterTypes().length() != this.types.findDescriptorType(t).getParameterTypes().length()) break;
                    potentiallyAmbiguous = true;
                }
                args1 = args1.tail;
                args2 = args2.tail;
            }
            if (potentiallyAmbiguous) {
                msym1.flags_field |= 0x1000000000000L;
                msym2.flags_field |= 0x1000000000000L;
                this.log.warning(Lint.LintCategory.OVERLOADS, pos, "potentially.ambiguous.overload", msym1, msym1.location(), msym2, msym2.location());
                return;
            }
        }
    }

    void checkElemAccessFromSerializableLambda(JCTree tree) {
        if (this.warnOnAccessToSensitiveMembers) {
            Symbol sym = TreeInfo.symbol(tree);
            if ((sym.kind & 0x14) == 0) {
                return;
            }
            if (sym.kind == 4 && ((sym.flags() & 0x200000000L) != 0L || sym.isLocal() || sym.name == this.names._this || sym.name == this.names._super)) {
                return;
            }
            if (!this.types.isSubtype(sym.owner.type, this.syms.serializableType) && this.isEffectivelyNonPublic(sym)) {
                this.log.warning(tree.pos(), "access.to.sensitive.member.from.serializable.element", sym);
            }
        }
    }

    private boolean isEffectivelyNonPublic(Symbol sym) {
        if (sym.packge() == this.syms.rootPackage) {
            return false;
        }
        while (sym.kind != 1) {
            if ((sym.flags() & 1L) == 0L) {
                return true;
            }
            sym = sym.owner;
        }
        return false;
    }

    private void syntheticError(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
        if (!sym.type.isErroneous()) {
            if (this.warnOnSyntheticConflicts) {
                this.log.warning(pos, "synthetic.name.conflict", sym, sym.location());
            } else {
                this.log.error(pos, "synthetic.name.conflict", sym, sym.location());
            }
        }
    }

    void checkClassBounds(JCDiagnostic.DiagnosticPosition pos, Type type) {
        this.checkClassBounds(pos, new HashMap<Symbol.TypeSymbol, Type>(), type);
    }

    void checkClassBounds(JCDiagnostic.DiagnosticPosition pos, Map<Symbol.TypeSymbol, Type> seensofar, Type type) {
        if (type.isErroneous()) {
            return;
        }
        List<Type> l = this.types.interfaces(type);
        while (l.nonEmpty()) {
            List<Type> newparams;
            List<Type> oldparams;
            Type it = (Type)l.head;
            Type oldit = seensofar.put(it.tsym, it);
            if (oldit != null && !this.types.containsTypeEquivalent(oldparams = oldit.allparams(), newparams = it.allparams())) {
                this.log.error(pos, "cant.inherit.diff.arg", it.tsym, Type.toString(oldparams), Type.toString(newparams));
            }
            this.checkClassBounds(pos, seensofar, it);
            l = l.tail;
        }
        Type st = this.types.supertype(type);
        if (st != null) {
            this.checkClassBounds(pos, seensofar, st);
        }
    }

    void checkNotRepeated(JCDiagnostic.DiagnosticPosition pos, Type it, Set<Type> its) {
        if (its.contains(it)) {
            this.log.error(pos, "repeated.interface", new Object[0]);
        } else {
            its.add(it);
        }
    }

    void validateAnnotationTree(JCTree tree) {
        class AnnotationValidator
        extends TreeScanner {
            AnnotationValidator() {
            }

            @Override
            public void visitAnnotation(JCTree.JCAnnotation tree) {
                if (!tree.type.isErroneous()) {
                    super.visitAnnotation(tree);
                    Check.this.validateAnnotation(tree);
                }
            }
        }
        tree.accept(new AnnotationValidator());
    }

    void validateAnnotationType(JCTree restype) {
        if (restype != null) {
            this.validateAnnotationType(restype.pos(), restype.type);
        }
    }

    void validateAnnotationType(JCDiagnostic.DiagnosticPosition pos, Type type) {
        if (type.isPrimitive()) {
            return;
        }
        if (this.types.isSameType(type, this.syms.stringType)) {
            return;
        }
        if ((type.tsym.flags() & 0x4000L) != 0L) {
            return;
        }
        if ((type.tsym.flags() & 0x2000L) != 0L) {
            return;
        }
        if (this.types.cvarLowerBound((Type)type).tsym == this.syms.classType.tsym) {
            return;
        }
        if (this.types.isArray(type) && !this.types.isArray(this.types.elemtype(type))) {
            this.validateAnnotationType(pos, this.types.elemtype(type));
            return;
        }
        this.log.error(pos, "invalid.annotation.member.type", new Object[0]);
    }

    void validateAnnotationMethod(JCDiagnostic.DiagnosticPosition pos, Symbol.MethodSymbol m) {
        Type sup = this.syms.annotationType;
        while (sup.hasTag(TypeTag.CLASS)) {
            Scope s = sup.tsym.members();
            Scope.Entry e = s.lookup(m.name);
            while (e.scope != null) {
                if (e.sym.kind == 16 && (e.sym.flags() & 5L) != 0L && this.types.overrideEquivalent(m.type, e.sym.type)) {
                    this.log.error(pos, "intf.annotation.member.clash", e.sym, sup);
                }
                e = e.next();
            }
            sup = this.types.supertype(sup);
        }
    }

    public void validateAnnotations(List<JCTree.JCAnnotation> annotations, Symbol s) {
        for (JCTree.JCAnnotation a : annotations) {
            this.validateAnnotation(a, s);
        }
    }

    public void validateTypeAnnotations(List<JCTree.JCAnnotation> annotations, boolean isTypeParameter) {
        for (JCTree.JCAnnotation a : annotations) {
            this.validateTypeAnnotation(a, isTypeParameter);
        }
    }

    private void validateAnnotation(JCTree.JCAnnotation a, Symbol s) {
        this.validateAnnotationTree(a);
        if (!this.annotationApplicable(a, s)) {
            this.log.error(a.pos(), "annotation.type.not.applicable", new Object[0]);
        }
        if (a.annotationType.type.tsym == this.syms.functionalInterfaceType.tsym) {
            if (s.kind != 2) {
                this.log.error(a.pos(), "bad.functional.intf.anno", new Object[0]);
            } else if (!s.isInterface() || (s.flags() & 0x2000L) != 0L) {
                this.log.error(a.pos(), "bad.functional.intf.anno.1", this.diags.fragment("not.a.functional.intf", s));
            }
        }
    }

    public void validateTypeAnnotation(JCTree.JCAnnotation a, boolean isTypeParameter) {
        Assert.checkNonNull(a.type);
        this.validateAnnotationTree(a);
        if (a.hasTag(JCTree.Tag.TYPE_ANNOTATION) && !a.annotationType.type.isErroneous() && !this.isTypeAnnotation(a, isTypeParameter)) {
            this.log.error(a.pos(), "annotation.type.not.applicable", new Object[0]);
        }
    }

    public void validateRepeatable(Symbol.TypeSymbol s, Attribute.Compound repeatable, JCDiagnostic.DiagnosticPosition pos) {
        Assert.check(this.types.isSameType(repeatable.type, this.syms.repeatableType));
        Type t = null;
        List<Pair<Symbol.MethodSymbol, Attribute>> l = repeatable.values;
        if (!l.isEmpty()) {
            Assert.check(((Symbol.MethodSymbol)((Pair)l.head).fst).name == this.names.value);
            t = ((Attribute.Class)((Attribute)((Pair)l.head).snd)).getValue();
        }
        if (t == null) {
            return;
        }
        this.validateValue(t.tsym, s, pos);
        this.validateRetention(t.tsym, s, pos);
        this.validateDocumented(t.tsym, s, pos);
        this.validateInherited(t.tsym, s, pos);
        this.validateTarget(t.tsym, s, pos);
        this.validateDefault(t.tsym, pos);
    }

    private void validateValue(Symbol.TypeSymbol container, Symbol.TypeSymbol contained, JCDiagnostic.DiagnosticPosition pos) {
        Scope.Entry e = container.members().lookup(this.names.value);
        if (e.scope != null && e.sym.kind == 16) {
            Symbol.MethodSymbol m = (Symbol.MethodSymbol)e.sym;
            Type ret = m.getReturnType();
            if (!ret.hasTag(TypeTag.ARRAY) || !this.types.isSameType(((Type.ArrayType)ret).elemtype, contained.type)) {
                this.log.error(pos, "invalid.repeatable.annotation.value.return", container, ret, this.types.makeArrayType(contained.type));
            }
        } else {
            this.log.error(pos, "invalid.repeatable.annotation.no.value", container);
        }
    }

    private void validateRetention(Symbol container, Symbol contained, JCDiagnostic.DiagnosticPosition pos) {
        Attribute.RetentionPolicy containerRetention = this.types.getRetention(container);
        Attribute.RetentionPolicy containedRetention = this.types.getRetention(contained);
        boolean error = false;
        switch (containedRetention) {
            case RUNTIME: {
                if (containerRetention == Attribute.RetentionPolicy.RUNTIME) break;
                error = true;
                break;
            }
            case CLASS: {
                if (containerRetention != Attribute.RetentionPolicy.SOURCE) break;
                error = true;
            }
        }
        if (error) {
            this.log.error(pos, "invalid.repeatable.annotation.retention", new Object[]{container, containerRetention, contained, containedRetention});
        }
    }

    private void validateDocumented(Symbol container, Symbol contained, JCDiagnostic.DiagnosticPosition pos) {
        if (contained.attribute(this.syms.documentedType.tsym) != null && container.attribute(this.syms.documentedType.tsym) == null) {
            this.log.error(pos, "invalid.repeatable.annotation.not.documented", container, contained);
        }
    }

    private void validateInherited(Symbol container, Symbol contained, JCDiagnostic.DiagnosticPosition pos) {
        if (contained.attribute(this.syms.inheritedType.tsym) != null && container.attribute(this.syms.inheritedType.tsym) == null) {
            this.log.error(pos, "invalid.repeatable.annotation.not.inherited", container, contained);
        }
    }

    private void validateTarget(Symbol container, Symbol contained, JCDiagnostic.DiagnosticPosition pos) {
        Set<Name> containedTargets;
        Set<Name> containerTargets;
        Attribute.Array containerTarget = this.getAttributeTargetAttribute(container);
        if (containerTarget == null) {
            containerTargets = this.getDefaultTargetSet();
        } else {
            containerTargets = new HashSet<Name>();
            for (Attribute app : containerTarget.values) {
                if (!(app instanceof Attribute.Enum)) continue;
                Attribute.Enum e = (Attribute.Enum)app;
                containerTargets.add(e.value.name);
            }
        }
        Attribute.Array containedTarget = this.getAttributeTargetAttribute(contained);
        if (containedTarget == null) {
            containedTargets = this.getDefaultTargetSet();
        } else {
            containedTargets = new HashSet<Name>();
            for (Attribute app : containedTarget.values) {
                if (!(app instanceof Attribute.Enum)) continue;
                Attribute.Enum e = (Attribute.Enum)app;
                containedTargets.add(e.value.name);
            }
        }
        if (!this.isTargetSubsetOf(containerTargets, containedTargets)) {
            this.log.error(pos, "invalid.repeatable.annotation.incompatible.target", container, contained);
        }
    }

    private Set<Name> getDefaultTargetSet() {
        if (this.defaultTargets == null) {
            HashSet<Name> targets = new HashSet<Name>();
            targets.add(this.names.ANNOTATION_TYPE);
            targets.add(this.names.CONSTRUCTOR);
            targets.add(this.names.FIELD);
            targets.add(this.names.LOCAL_VARIABLE);
            targets.add(this.names.METHOD);
            targets.add(this.names.PACKAGE);
            targets.add(this.names.PARAMETER);
            targets.add(this.names.TYPE);
            this.defaultTargets = Collections.unmodifiableSet(targets);
        }
        return this.defaultTargets;
    }

    private boolean isTargetSubsetOf(Set<Name> s, Set<Name> t) {
        for (Name n2 : s) {
            boolean currentElementOk = false;
            for (Name n1 : t) {
                if (n1 == n2) {
                    currentElementOk = true;
                    break;
                }
                if (n1 == this.names.TYPE && n2 == this.names.ANNOTATION_TYPE) {
                    currentElementOk = true;
                    break;
                }
                if (n1 != this.names.TYPE_USE || n2 != this.names.TYPE && n2 != this.names.ANNOTATION_TYPE && n2 != this.names.TYPE_PARAMETER) continue;
                currentElementOk = true;
                break;
            }
            if (currentElementOk) continue;
            return false;
        }
        return true;
    }

    private void validateDefault(Symbol container, JCDiagnostic.DiagnosticPosition pos) {
        Scope scope = container.members();
        for (Symbol elm : scope.getElements()) {
            if (elm.name == this.names.value || elm.kind != 16 || ((Symbol.MethodSymbol)elm).defaultValue != null) continue;
            this.log.error(pos, "invalid.repeatable.annotation.elem.nondefault", container, elm);
        }
    }

    boolean isOverrider(Symbol s) {
        if (s.kind != 16 || s.isStatic()) {
            return false;
        }
        Symbol.MethodSymbol m = (Symbol.MethodSymbol)s;
        Symbol.TypeSymbol owner = (Symbol.TypeSymbol)m.owner;
        for (Type sup : this.types.closure(owner.type)) {
            if (sup == owner.type) continue;
            Scope scope = sup.tsym.members();
            Scope.Entry e = scope.lookup(m.name);
            while (e.scope != null) {
                if (!e.sym.isStatic() && m.overrides(e.sym, owner, this.types, true)) {
                    return true;
                }
                e = e.next();
            }
        }
        return false;
    }

    protected boolean isTypeAnnotation(JCTree.JCAnnotation a, boolean isTypeParameter) {
        Attribute.Compound atTarget = a.annotationType.type.tsym.attribute(this.syms.annotationTargetType.tsym);
        if (atTarget == null) {
            return false;
        }
        Attribute atValue = atTarget.member(this.names.value);
        if (!(atValue instanceof Attribute.Array)) {
            return false;
        }
        Attribute.Array arr = (Attribute.Array)atValue;
        for (Attribute app : arr.values) {
            if (!(app instanceof Attribute.Enum)) {
                return false;
            }
            Attribute.Enum e = (Attribute.Enum)app;
            if (e.value.name == this.names.TYPE_USE) {
                return true;
            }
            if (!isTypeParameter || e.value.name != this.names.TYPE_PARAMETER) continue;
            return true;
        }
        return false;
    }

    boolean annotationApplicable(JCTree.JCAnnotation a, Symbol s) {
        Name[] targets;
        Attribute.Array arr = this.getAttributeTargetAttribute(a.annotationType.type.tsym);
        if (arr == null) {
            targets = this.defaultTargetMetaInfo(a, s);
        } else {
            targets = new Name[arr.values.length];
            for (int i = 0; i < arr.values.length; ++i) {
                Attribute app = arr.values[i];
                if (!(app instanceof Attribute.Enum)) {
                    return true;
                }
                Attribute.Enum e = (Attribute.Enum)app;
                targets[i] = e.value.name;
            }
        }
        for (Name target : targets) {
            if (target == this.names.TYPE) {
                if (s.kind != 2) continue;
                return true;
            }
            if (target == this.names.FIELD) {
                if (s.kind != 4 || s.owner.kind == 16) continue;
                return true;
            }
            if (target == this.names.METHOD) {
                if (s.kind != 16 || s.isConstructor()) continue;
                return true;
            }
            if (target == this.names.PARAMETER) {
                if (s.kind != 4 || s.owner.kind != 16 || (s.flags() & 0x200000000L) == 0L) continue;
                return true;
            }
            if (target == this.names.CONSTRUCTOR) {
                if (s.kind != 16 || !s.isConstructor()) continue;
                return true;
            }
            if (target == this.names.LOCAL_VARIABLE) {
                if (s.kind != 4 || s.owner.kind != 16 || (s.flags() & 0x200000000L) != 0L) continue;
                return true;
            }
            if (target == this.names.ANNOTATION_TYPE) {
                if (s.kind != 2 || (s.flags() & 0x2000L) == 0L) continue;
                return true;
            }
            if (target == this.names.PACKAGE) {
                if (s.kind != 1) continue;
                return true;
            }
            if (target == this.names.TYPE_USE) {
                if (s.kind != 2 && s.kind != 4 && (s.kind != 16 || s.isConstructor() || s.type.getReturnType().hasTag(TypeTag.VOID)) && (s.kind != 16 || !s.isConstructor())) continue;
                return true;
            }
            if (target == this.names.TYPE_PARAMETER) {
                if (s.kind != 2 || !s.type.hasTag(TypeTag.TYPEVAR)) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    Attribute.Array getAttributeTargetAttribute(Symbol s) {
        Attribute.Compound atTarget = s.attribute(this.syms.annotationTargetType.tsym);
        if (atTarget == null) {
            return null;
        }
        Attribute atValue = atTarget.member(this.names.value);
        if (!(atValue instanceof Attribute.Array)) {
            return null;
        }
        return (Attribute.Array)atValue;
    }

    private Name[] defaultTargetMetaInfo(JCTree.JCAnnotation a, Symbol s) {
        return this.dfltTargetMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateAnnotationDeferErrors(JCTree.JCAnnotation a) {
        boolean res = false;
        Log.DiscardDiagnosticHandler diagHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            res = this.validateAnnotation(a);
        }
        finally {
            this.log.popDiagnosticHandler(diagHandler);
        }
        return res;
    }

    private boolean validateAnnotation(JCTree.JCAnnotation a) {
        boolean isValid = true;
        LinkedHashSet<Symbol.MethodSymbol> members = new LinkedHashSet<Symbol.MethodSymbol>();
        Object e = a.annotationType.type.tsym.members().elems;
        while (e != null) {
            if (((Scope.Entry)e).sym.kind == 16 && ((Scope.Entry)e).sym.name != this.names.clinit && (((Scope.Entry)e).sym.flags() & 0x1000L) == 0L) {
                members.add((Symbol.MethodSymbol)((Scope.Entry)e).sym);
            }
            e = ((Scope.Entry)e).sibling;
        }
        for (JCTree jCTree : a.args) {
            if (!jCTree.hasTag(JCTree.Tag.ASSIGN)) continue;
            JCTree.JCAssign assign = (JCTree.JCAssign)jCTree;
            Symbol m2 = TreeInfo.symbol(assign.lhs);
            if (m2 == null || m2.type.isErroneous() || members.remove(m2)) continue;
            isValid = false;
            this.log.error(assign.lhs.pos(), "duplicate.annotation.member.value", m2.name, a.type);
        }
        List<Name> missingDefaults = List.nil();
        for (Symbol.MethodSymbol m3 : members) {
            if (m3.defaultValue != null || m3.type.isErroneous()) continue;
            missingDefaults = missingDefaults.append(m3.name);
        }
        if ((missingDefaults = missingDefaults.reverse()).nonEmpty()) {
            isValid = false;
            String string = missingDefaults.size() > 1 ? "annotation.missing.default.value.1" : "annotation.missing.default.value";
            this.log.error(a.pos(), string, a.type, missingDefaults);
        }
        if (a.annotationType.type.tsym != this.syms.annotationTargetType.tsym || a.args.tail == null) {
            return isValid;
        }
        if (!((JCTree.JCExpression)a.args.head).hasTag(JCTree.Tag.ASSIGN)) {
            return false;
        }
        JCTree.JCAssign jCAssign = (JCTree.JCAssign)((JCTree.JCExpression)a.args.head);
        Symbol m = TreeInfo.symbol(jCAssign.lhs);
        if (m.name != this.names.value) {
            return false;
        }
        JCTree.JCExpression rhs = jCAssign.rhs;
        if (!rhs.hasTag(JCTree.Tag.NEWARRAY)) {
            return false;
        }
        JCTree.JCNewArray na = (JCTree.JCNewArray)rhs;
        HashSet<Symbol> targets = new HashSet<Symbol>();
        for (JCTree jCTree : na.elems) {
            if (targets.add(TreeInfo.symbol(jCTree))) continue;
            isValid = false;
            this.log.error(jCTree.pos(), "repeated.annotation.target", new Object[0]);
        }
        return isValid;
    }

    void checkDeprecatedAnnotation(JCDiagnostic.DiagnosticPosition pos, Symbol s) {
        if (this.allowAnnotations && this.lint.isEnabled(Lint.LintCategory.DEP_ANN) && (s.flags() & 0x20000L) != 0L && !this.syms.deprecatedType.isErroneous() && s.attribute(this.syms.deprecatedType.tsym) == null) {
            this.log.warning(Lint.LintCategory.DEP_ANN, pos, "missing.deprecated.annotation", new Object[0]);
        }
    }

    void checkDeprecated(final JCDiagnostic.DiagnosticPosition pos, Symbol other, final Symbol s) {
        if ((s.flags() & 0x20000L) != 0L && (other.flags() & 0x20000L) == 0L && s.outermostClass() != other.outermostClass()) {
            this.deferredLintHandler.report(new DeferredLintHandler.LintLogger(){

                @Override
                public void report() {
                    Check.this.warnDeprecated(pos, s);
                }
            });
        }
    }

    void checkSunAPI(final JCDiagnostic.DiagnosticPosition pos, final Symbol s) {
        if ((s.flags() & 0x4000000000L) != 0L) {
            this.deferredLintHandler.report(new DeferredLintHandler.LintLogger(){

                @Override
                public void report() {
                    if (Check.this.enableSunApiLintControl) {
                        Check.this.warnSunApi(pos, "sun.proprietary", s);
                    } else {
                        Check.this.log.mandatoryWarning(pos, "sun.proprietary", s);
                    }
                }
            });
        }
    }

    void checkProfile(JCDiagnostic.DiagnosticPosition pos, Symbol s) {
        if (this.profile != Profile.DEFAULT && (s.flags() & 0x200000000000L) != 0L) {
            this.log.error(pos, "not.in.profile", new Object[]{s, this.profile});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNonCyclicElements(JCTree.JCClassDecl tree) {
        if ((tree.sym.flags_field & 0x2000L) == 0L) {
            return;
        }
        Assert.check((tree.sym.flags_field & 0x8000000L) == 0L);
        try {
            tree.sym.flags_field |= 0x8000000L;
            for (JCTree def : tree.defs) {
                if (!def.hasTag(JCTree.Tag.METHODDEF)) continue;
                JCTree.JCMethodDecl meth = (JCTree.JCMethodDecl)def;
                this.checkAnnotationResType(meth.pos(), meth.restype.type);
            }
        }
        finally {
            tree.sym.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            tree.sym.flags_field |= 0x800000000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkNonCyclicElementsInternal(JCDiagnostic.DiagnosticPosition pos, Symbol.TypeSymbol tsym) {
        if ((tsym.flags_field & 0x800000000L) != 0L) {
            return;
        }
        if ((tsym.flags_field & 0x8000000L) != 0L) {
            this.log.error(pos, "cyclic.annotation.element", new Object[0]);
            return;
        }
        try {
            tsym.flags_field |= 0x8000000L;
            Scope.Entry e = tsym.members().elems;
            while (e != null) {
                Symbol s = e.sym;
                if (s.kind == 16) {
                    this.checkAnnotationResType(pos, ((Symbol.MethodSymbol)s).type.getReturnType());
                }
                e = e.sibling;
            }
        }
        finally {
            tsym.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            tsym.flags_field |= 0x800000000L;
        }
    }

    void checkAnnotationResType(JCDiagnostic.DiagnosticPosition pos, Type type) {
        switch (type.getTag()) {
            case CLASS: {
                if ((type.tsym.flags() & 0x2000L) == 0L) break;
                this.checkNonCyclicElementsInternal(pos, type.tsym);
                break;
            }
            case ARRAY: {
                this.checkAnnotationResType(pos, this.types.elemtype(type));
                break;
            }
        }
    }

    void checkCyclicConstructors(JCTree.JCClassDecl tree) {
        HashMap<Symbol, Symbol> callMap = new HashMap<Symbol, Symbol>();
        List<JCTree> l = tree.defs;
        while (l.nonEmpty()) {
            JCTree.JCMethodInvocation app = TreeInfo.firstConstructorCall((JCTree)l.head);
            if (app != null) {
                JCTree.JCMethodDecl meth = (JCTree.JCMethodDecl)((JCTree)l.head);
                if (TreeInfo.name(app.meth) == this.names._this) {
                    callMap.put(meth.sym, TreeInfo.symbol(app.meth));
                } else {
                    meth.sym.flags_field |= 0x40000000L;
                }
            }
            l = l.tail;
        }
        Symbol[] ctors = new Symbol[]{};
        for (Symbol caller : ctors = callMap.keySet().toArray(ctors)) {
            this.checkCyclicConstructor(tree, caller, callMap);
        }
    }

    private void checkCyclicConstructor(JCTree.JCClassDecl tree, Symbol ctor, Map<Symbol, Symbol> callMap) {
        if (ctor != null && (ctor.flags_field & 0x40000000L) == 0L) {
            if ((ctor.flags_field & 0x8000000L) != 0L) {
                this.log.error(TreeInfo.diagnosticPositionFor(ctor, tree), "recursive.ctor.invocation", new Object[0]);
            } else {
                ctor.flags_field |= 0x8000000L;
                this.checkCyclicConstructor(tree, callMap.remove(ctor), callMap);
                ctor.flags_field &= 0xFFFFFFFFF7FFFFFFL;
            }
            ctor.flags_field |= 0x40000000L;
        }
    }

    int checkOperator(JCDiagnostic.DiagnosticPosition pos, Symbol.OperatorSymbol operator, JCTree.Tag tag, Type left, Type right) {
        if (operator.opcode == 277) {
            this.log.error(pos, "operator.cant.be.applied.1", this.treeinfo.operatorName(tag), left, right);
        }
        return operator.opcode;
    }

    void checkDivZero(JCDiagnostic.DiagnosticPosition pos, Symbol operator, Type operand) {
        int opc;
        if (operand.constValue() != null && this.lint.isEnabled(Lint.LintCategory.DIVZERO) && operand.getTag().isSubRangeOf(TypeTag.LONG) && ((Number)operand.constValue()).longValue() == 0L && ((opc = ((Symbol.OperatorSymbol)operator).opcode) == 108 || opc == 112 || opc == 109 || opc == 113)) {
            this.log.warning(Lint.LintCategory.DIVZERO, pos, "div.zero", new Object[0]);
        }
    }

    void checkEmptyIf(JCTree.JCIf tree) {
        if (tree.thenpart.hasTag(JCTree.Tag.SKIP) && tree.elsepart == null && this.lint.isEnabled(Lint.LintCategory.EMPTY)) {
            this.log.warning(Lint.LintCategory.EMPTY, tree.thenpart.pos(), "empty.if", new Object[0]);
        }
    }

    boolean checkUnique(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Scope s) {
        if (sym.type.isErroneous()) {
            return true;
        }
        if (sym.owner.name == this.names.any) {
            return false;
        }
        Scope.Entry e = s.lookup(sym.name);
        while (e.scope == s) {
            if (sym != e.sym && (e.sym.flags() & 0x40000000000L) == 0L && sym.kind == e.sym.kind && sym.name != this.names.error && (sym.kind != 16 || this.types.hasSameArgs(sym.type, e.sym.type) || this.types.hasSameArgs(this.types.erasure(sym.type), this.types.erasure(e.sym.type)))) {
                if ((sym.flags() & 0x400000000L) != (e.sym.flags() & 0x400000000L)) {
                    this.varargsDuplicateError(pos, sym, e.sym);
                    return true;
                }
                if (sym.kind == 16 && !this.types.hasSameArgs(sym.type, e.sym.type, false)) {
                    this.duplicateErasureError(pos, sym, e.sym);
                    sym.flags_field |= 0x40000000000L;
                    return true;
                }
                this.duplicateError(pos, e.sym);
                return false;
            }
            e = e.next();
        }
        return true;
    }

    void duplicateErasureError(JCDiagnostic.DiagnosticPosition pos, Symbol sym1, Symbol sym2) {
        if (!sym1.type.isErroneous() && !sym2.type.isErroneous()) {
            this.log.error(pos, "name.clash.same.erasure", sym1, sym2);
        }
    }

    boolean checkUniqueImport(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Scope s) {
        return this.checkUniqueImport(pos, sym, s, false);
    }

    boolean checkUniqueStaticImport(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Scope s) {
        return this.checkUniqueImport(pos, sym, s, true);
    }

    private boolean checkUniqueImport(JCDiagnostic.DiagnosticPosition pos, Symbol sym, Scope s, boolean staticImport) {
        Scope.Entry e = s.lookup(sym.name);
        while (e.scope != null) {
            boolean isClassDecl;
            boolean bl = isClassDecl = e.scope == s;
            if (!(!isClassDecl && sym == e.sym || sym.kind != e.sym.kind || sym.name == this.names.error || staticImport && e.isStaticallyImported())) {
                if (!e.sym.type.isErroneous()) {
                    if (!isClassDecl) {
                        if (staticImport) {
                            this.log.error(pos, "already.defined.static.single.import", e.sym);
                        } else {
                            this.log.error(pos, "already.defined.single.import", e.sym);
                        }
                    } else if (sym != e.sym) {
                        this.log.error(pos, "already.defined.this.unit", e.sym);
                    }
                }
                return false;
            }
            e = e.next();
        }
        return true;
    }

    public void checkCanonical(JCTree tree) {
        if (!this.isCanonical(tree)) {
            this.log.error(tree.pos(), "import.requires.canonical", TreeInfo.symbol(tree));
        }
    }

    private boolean isCanonical(JCTree tree) {
        while (tree.hasTag(JCTree.Tag.SELECT)) {
            JCTree.JCFieldAccess s = (JCTree.JCFieldAccess)tree;
            if (s.sym.owner != TreeInfo.symbol(s.selected)) {
                return false;
            }
            tree = s.selected;
        }
        return true;
    }

    void checkForBadAuxiliaryClassAccess(JCDiagnostic.DiagnosticPosition pos, Env<AttrContext> env, Symbol.ClassSymbol c) {
        if (this.lint.isEnabled(Lint.LintCategory.AUXILIARYCLASS) && (c.flags() & 0x100000000000L) != 0L && this.rs.isAccessible(env, c) && !this.fileManager.isSameFile(c.sourcefile, env.toplevel.sourcefile)) {
            this.log.warning(pos, "auxiliary.class.accessed.from.outside.of.its.source.file", c, c.sourcefile);
        }
    }

    public Warner castWarner(JCDiagnostic.DiagnosticPosition pos, Type found, Type expected) {
        return new ConversionWarner(pos, "unchecked.cast.to.type", found, expected);
    }

    public Warner convertWarner(JCDiagnostic.DiagnosticPosition pos, Type found, Type expected) {
        return new ConversionWarner(pos, "unchecked.assign", found, expected);
    }

    public void checkFunctionalInterface(JCTree.JCClassDecl tree, Symbol.ClassSymbol cs) {
        Attribute.Compound functionalType = cs.attribute(this.syms.functionalInterfaceType.tsym);
        if (functionalType != null) {
            try {
                this.types.findDescriptorSymbol(cs);
            }
            catch (Types.FunctionDescriptorLookupError ex) {
                JCDiagnostic.DiagnosticPosition pos = tree.pos();
                for (JCTree.JCAnnotation a : tree.getModifiers().annotations) {
                    if (a.annotationType.type.tsym != this.syms.functionalInterfaceType.tsym) continue;
                    pos = a.pos();
                    break;
                }
                this.log.error(pos, "bad.functional.intf.anno.1", ex.getDiagnostic());
            }
        }
    }

    private class ConversionWarner
    extends Warner {
        final String uncheckedKey;
        final Type found;
        final Type expected;

        public ConversionWarner(JCDiagnostic.DiagnosticPosition pos, String uncheckedKey, Type found, Type expected) {
            super(pos);
            this.uncheckedKey = uncheckedKey;
            this.found = found;
            this.expected = expected;
        }

        @Override
        public void warn(Lint.LintCategory lint) {
            boolean warned = this.warned;
            super.warn(lint);
            if (warned) {
                return;
            }
            switch (lint) {
                case UNCHECKED: {
                    Check.this.warnUnchecked(this.pos(), "prob.found.req", Check.this.diags.fragment(this.uncheckedKey, new Object[0]), this.found, this.expected);
                    break;
                }
                case VARARGS: {
                    if (Check.this.method == null || Check.this.method.attribute(((Check)Check.this).syms.trustMeType.tsym) == null || !Check.this.isTrustMeAllowedOnMethod(Check.this.method) || Check.this.types.isReifiable(((Check)Check.this).method.type.getParameterTypes().last())) break;
                    Check.this.warnUnsafeVararg(this.pos(), "varargs.unsafe.use.varargs.param", ((Check)Check.this).method.params.last());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected lint: " + (Object)((Object)lint)));
                }
            }
        }
    }

    private class DefaultMethodClashFilter
    implements Filter<Symbol> {
        Type site;

        DefaultMethodClashFilter(Type site) {
            this.site = site;
        }

        @Override
        public boolean accepts(Symbol s) {
            return s.kind == 16 && (s.flags() & 0x80000000000L) != 0L && s.isInheritedIn(this.site.tsym, Check.this.types) && !s.isConstructor();
        }
    }

    private class ClashFilter
    implements Filter<Symbol> {
        Type site;

        ClashFilter(Type site) {
            this.site = site;
        }

        boolean shouldSkip(Symbol s) {
            return (s.flags() & 0x40000000000L) != 0L && s.owner == this.site.tsym;
        }

        @Override
        public boolean accepts(Symbol s) {
            return s.kind == 16 && (s.flags() & 0x1000L) == 0L && !this.shouldSkip(s) && s.isInheritedIn(this.site.tsym, Check.this.types) && !s.isConstructor();
        }
    }

    class CycleChecker
    extends TreeScanner {
        List<Symbol> seenClasses = List.nil();
        boolean errorFound = false;
        boolean partialCheck = false;

        CycleChecker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkSymbol(JCDiagnostic.DiagnosticPosition pos, Symbol sym) {
            if (sym != null && sym.kind == 2) {
                Env<AttrContext> classEnv = Check.this.enter.getEnv((Symbol.TypeSymbol)sym);
                if (classEnv != null) {
                    DiagnosticSource prevSource = Check.this.log.currentSource();
                    try {
                        Check.this.log.useSource(classEnv.toplevel.sourcefile);
                        this.scan(classEnv.tree);
                    }
                    finally {
                        Check.this.log.useSource(prevSource.getFile());
                    }
                } else if (sym.kind == 2) {
                    this.checkClass(pos, sym, List.nil());
                }
            } else {
                this.partialCheck = true;
            }
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            super.visitSelect(tree);
            this.checkSymbol(tree.pos(), tree.sym);
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            this.checkSymbol(tree.pos(), tree.sym);
        }

        @Override
        public void visitTypeApply(JCTree.JCTypeApply tree) {
            this.scan(tree.clazz);
        }

        @Override
        public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
            this.scan(tree.elemtype);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            List<JCTree> supertypes = List.nil();
            if (tree.getExtendsClause() != null) {
                supertypes = supertypes.prepend(tree.getExtendsClause());
            }
            if (tree.getImplementsClause() != null) {
                for (JCTree intf : tree.getImplementsClause()) {
                    supertypes = supertypes.prepend(intf);
                }
            }
            this.checkClass(tree.pos(), tree.sym, supertypes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkClass(JCDiagnostic.DiagnosticPosition pos, Symbol c, List<JCTree> supertypes) {
            if ((c.flags_field & 0x40000000L) != 0L) {
                return;
            }
            if (this.seenClasses.contains(c)) {
                this.errorFound = true;
                Check.this.noteCyclic(pos, (Symbol.ClassSymbol)c);
            } else if (!c.type.isErroneous()) {
                try {
                    this.seenClasses = this.seenClasses.prepend(c);
                    if (c.type.hasTag(TypeTag.CLASS)) {
                        if (supertypes.nonEmpty()) {
                            this.scan(supertypes);
                        } else {
                            Type.ClassType ct = (Type.ClassType)c.type;
                            if (ct.supertype_field == null || ct.interfaces_field == null) {
                                this.partialCheck = true;
                                return;
                            }
                            this.checkSymbol(pos, ct.supertype_field.tsym);
                            for (Type intf : ct.interfaces_field) {
                                this.checkSymbol(pos, intf.tsym);
                            }
                        }
                        if (c.owner.kind == 2) {
                            this.checkSymbol(pos, c.owner);
                        }
                    }
                }
                finally {
                    this.seenClasses = this.seenClasses.tail;
                }
            }
        }
    }

    class Validator
    extends JCTree.Visitor {
        boolean checkRaw;
        boolean isOuter;
        Env<AttrContext> env;

        Validator(Env<AttrContext> env) {
            this.env = env;
        }

        @Override
        public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
            this.validateTree(tree.elemtype, this.checkRaw, this.isOuter);
        }

        @Override
        public void visitTypeApply(JCTree.JCTypeApply tree) {
            if (tree.type.hasTag(TypeTag.CLASS)) {
                boolean is_java_lang_Class;
                List<JCTree.JCExpression> args = tree.arguments;
                List<Type> forms = tree.type.tsym.type.getTypeArguments();
                Type incompatibleArg = Check.this.firstIncompatibleTypeArg(tree.type);
                if (incompatibleArg != null) {
                    for (JCTree jCTree : tree.arguments) {
                        if (jCTree.type == incompatibleArg) {
                            Check.this.log.error(jCTree, "not.within.bounds", incompatibleArg, forms.head);
                        }
                        forms = forms.tail;
                    }
                }
                forms = tree.type.tsym.type.getTypeArguments();
                boolean bl = is_java_lang_Class = tree.type.tsym.flatName() == ((Check)Check.this).names.java_lang_Class;
                while (args.nonEmpty() && forms.nonEmpty()) {
                    this.validateTree((JCTree)args.head, !this.isOuter || !is_java_lang_Class, false);
                    args = args.tail;
                    forms = forms.tail;
                }
                if (tree.type.getEnclosingType().isRaw()) {
                    Check.this.log.error(tree.pos(), "improperly.formed.type.inner.raw.param", new Object[0]);
                }
                if (tree.clazz.hasTag(JCTree.Tag.SELECT)) {
                    this.visitSelectInternal((JCTree.JCFieldAccess)tree.clazz);
                }
            }
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter tree) {
            this.validateTrees(tree.bounds, true, this.isOuter);
            Check.this.checkClassBounds(tree.pos(), tree.type);
        }

        @Override
        public void visitWildcard(JCTree.JCWildcard tree) {
            if (tree.inner != null) {
                this.validateTree(tree.inner, true, this.isOuter);
            }
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            if (tree.type.hasTag(TypeTag.CLASS)) {
                this.visitSelectInternal(tree);
                if (tree.selected.type.isParameterized() && tree.type.tsym.type.getTypeArguments().nonEmpty()) {
                    Check.this.log.error(tree.pos(), "improperly.formed.type.param.missing", new Object[0]);
                }
            }
        }

        public void visitSelectInternal(JCTree.JCFieldAccess tree) {
            if (tree.type.tsym.isStatic() && tree.selected.type.isParameterized()) {
                Check.this.log.error(tree.pos(), "cant.select.static.class.from.param.type", new Object[0]);
            } else {
                tree.selected.accept(this);
            }
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
            tree.underlyingType.accept(this);
        }

        @Override
        public void visitTypeIdent(JCTree.JCPrimitiveTypeTree that) {
            if (that.type.hasTag(TypeTag.VOID)) {
                Check.this.log.error(that.pos(), "void.not.allowed.here", new Object[0]);
            }
            super.visitTypeIdent(that);
        }

        @Override
        public void visitTree(JCTree tree) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validateTree(JCTree tree, boolean checkRaw, boolean isOuter) {
            if (tree != null) {
                boolean prevCheckRaw = this.checkRaw;
                this.checkRaw = checkRaw;
                this.isOuter = isOuter;
                try {
                    tree.accept(this);
                    if (checkRaw) {
                        Check.this.checkRaw(tree, this.env);
                    }
                }
                catch (Symbol.CompletionFailure ex) {
                    Check.this.completionError(tree.pos(), ex);
                }
                finally {
                    this.checkRaw = prevCheckRaw;
                }
            }
        }

        public void validateTrees(List<? extends JCTree> trees, boolean checkRaw, boolean isOuter) {
            List<JCTree> l = trees;
            while (l.nonEmpty()) {
                this.validateTree((JCTree)l.head, checkRaw, isOuter);
                l = l.tail;
            }
        }
    }

    static class NestedCheckContext
    implements CheckContext {
        CheckContext enclosingContext;

        NestedCheckContext(CheckContext enclosingContext) {
            this.enclosingContext = enclosingContext;
        }

        @Override
        public boolean compatible(Type found, Type req, Warner warn) {
            return this.enclosingContext.compatible(found, req, warn);
        }

        @Override
        public void report(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic details) {
            this.enclosingContext.report(pos, details);
        }

        @Override
        public Warner checkWarner(JCDiagnostic.DiagnosticPosition pos, Type found, Type req) {
            return this.enclosingContext.checkWarner(pos, found, req);
        }

        @Override
        public Infer.InferenceContext inferenceContext() {
            return this.enclosingContext.inferenceContext();
        }

        @Override
        public DeferredAttr.DeferredAttrContext deferredAttrContext() {
            return this.enclosingContext.deferredAttrContext();
        }
    }

    public static interface CheckContext {
        public boolean compatible(Type var1, Type var2, Warner var3);

        public void report(JCDiagnostic.DiagnosticPosition var1, JCDiagnostic var2);

        public Warner checkWarner(JCDiagnostic.DiagnosticPosition var1, Type var2, Type var3);

        public Infer.InferenceContext inferenceContext();

        public DeferredAttr.DeferredAttrContext deferredAttrContext();
    }
}

