/*
 * Copyright (c) 2003, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package jdk.javadoc.internal.doclets.formats.html.markup;

import org.checkerframework.dataflow.qual.Pure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import jdk.javadoc.internal.doclets.formats.html.Contents;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.util.DocletConstants;

public class Table {

    public Table(HtmlVersion version, HtmlStyle style) {
    }

    public Table setSummary(String summary);

    public Table setCaption(Content captionContent);

    public Table addTab(String name, Predicate<Element> predicate);

    public Table setDefaultTab(String name);

    public Table setTabScript(IntFunction<String> f);

    public Table setTabStyles(HtmlStyle activeTabStyle, HtmlStyle tabStyle, HtmlStyle tabEnd);

    public Table setTabId(Function<Integer, String> f);

    public Table setHeader(TableHeader header);

    public Table setStripedStyles(HtmlStyle evenRowStyle, HtmlStyle oddRowStyle);

    public Table setRowScopeColumn(int columnIndex);

    public Table setColumnStyles(HtmlStyle... styles);

    public Table setColumnStyles(List<HtmlStyle> styles);

    public Table setRowIdPrefix(String prefix);

    public Table setPutIdFirst(boolean first);

    public Table setUseTBody(boolean use);

    public void addRow(Content... contents);

    public void addRow(List<Content> contents);

    public void addRow(Element element, Content... contents);

    public void addRow(Element element, List<Content> contents);

    @Pure
    public boolean isEmpty();

    public Content toContent();

    public boolean needsScript();

    public String getScript();
}
