/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package java.util.concurrent;

import org.checkerframework.dataflow.qual.Pure;
import java.lang.Thread.UncaughtExceptionHandler;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.security.AccessController;
import java.security.AccessControlContext;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.concurrent.locks.LockSupport;

public class ForkJoinPool extends AbstractExecutorService {

    public static interface ForkJoinWorkerThreadFactory {

        public ForkJoinWorkerThread newThread(ForkJoinPool pool);
    }

    static AccessControlContext contextWithPermissions(Permission... perms);

    private static final class DefaultForkJoinWorkerThreadFactory implements ForkJoinWorkerThreadFactory {

        public final ForkJoinWorkerThread newThread(ForkJoinPool pool);
    }

    @jdk.internal.vm.annotation.Contended
    static final class WorkQueue {

        final boolean tryLockPhase();

        final void releasePhaseLock();

        final int getPoolIndex();

        final int queueSize();

        @Pure
        final boolean isEmpty();

        final void push(ForkJoinTask<?> task);

        final boolean lockedPush(ForkJoinTask<?> task);

        final void growArray(boolean locked);

        final ForkJoinTask<?> poll();

        final ForkJoinTask<?> nextLocalTask();

        final ForkJoinTask<?> peek();

        final boolean tryUnpush(ForkJoinTask<?> task);

        final boolean tryLockedUnpush(ForkJoinTask<?> task);

        final void cancelAll();

        final void topLevelExec(ForkJoinTask<?> t, WorkQueue q, int n);

        final void tryRemoveAndExec(ForkJoinTask<?> task);

        final int helpCC(CountedCompleter<?> task, int limit, boolean shared);

        final void helpAsyncBlocker(ManagedBlocker blocker);

        final boolean isApparentlyUnblocked();
    }

    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;

    final WorkQueue registerWorker(ForkJoinWorkerThread wt);

    final void deregisterWorker(ForkJoinWorkerThread wt, Throwable ex);

    final void signalWork();

    final void runWorker(WorkQueue w);

    final int awaitJoin(WorkQueue w, ForkJoinTask<?> task, long deadline);

    final void helpQuiescePool(WorkQueue w);

    final ForkJoinTask<?> nextTaskFor(WorkQueue w);

    final void externalPush(ForkJoinTask<?> task);

    static WorkQueue commonSubmitterQueue();

    final boolean tryExternalUnpush(ForkJoinTask<?> task);

    final int externalHelpComplete(CountedCompleter<?> task, int maxTasks);

    final int helpComplete(WorkQueue w, CountedCompleter<?> task, int maxTasks);

    static int getSurplusQueuedTaskCount();

    public ForkJoinPool() {
    }

    public ForkJoinPool(int parallelism) {
    }

    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, UncaughtExceptionHandler handler, boolean asyncMode) {
    }

    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, UncaughtExceptionHandler handler, boolean asyncMode, int corePoolSize, int maximumPoolSize, int minimumRunnable, Predicate<? super ForkJoinPool> saturate, long keepAliveTime, TimeUnit unit) {
    }

    public static ForkJoinPool commonPool();

    public <T> T invoke(ForkJoinTask<T> task);

    public void execute(ForkJoinTask<?> task);

    public void execute(Runnable task);

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> task);

    public <T> ForkJoinTask<T> submit(Callable<T> task);

    public <T> ForkJoinTask<T> submit(Runnable task, T result);

    @SuppressWarnings("unchecked")
    public ForkJoinTask<?> submit(Runnable task);

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks);

    public ForkJoinWorkerThreadFactory getFactory();

    public UncaughtExceptionHandler getUncaughtExceptionHandler();

    public int getParallelism();

    public static int getCommonPoolParallelism();

    public int getPoolSize();

    public boolean getAsyncMode();

    public int getRunningThreadCount();

    public int getActiveThreadCount();

    public boolean isQuiescent();

    public long getStealCount();

    public long getQueuedTaskCount();

    public int getQueuedSubmissionCount();

    public boolean hasQueuedSubmissions();

    protected ForkJoinTask<?> pollSubmission();

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> c);

    public String toString();

    public void shutdown();

    public List<Runnable> shutdownNow();

    public boolean isTerminated();

    public boolean isTerminating();

    public boolean isShutdown();

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException;

    public boolean awaitQuiescence(long timeout, TimeUnit unit);

    static void quiesceCommonPool();

    public static interface ManagedBlocker {

        boolean block() throws InterruptedException;

        boolean isReleasable();
    }

    public static void managedBlock(ManagedBlocker blocker) throws InterruptedException;

    static void helpAsyncBlocker(Executor e, ManagedBlocker blocker);

    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value);

    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable);

    private static final class InnocuousForkJoinWorkerThreadFactory implements ForkJoinWorkerThreadFactory {

        public final ForkJoinWorkerThread newThread(ForkJoinPool pool);
    }
}
