/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.visitor.AnnotatedTypeVisitor;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.PluginUtil;
import org.checkerframework.javacutil.TypesUtils;

public class BoundsInitializer {
    public static void initializeTypeArgs(AnnotatedTypeMirror.AnnotatedDeclaredType declaredType) {
        DeclaredType actualType = (DeclaredType)declaredType.actualType;
        if (actualType.getTypeArguments().isEmpty() && !declaredType.wasRaw()) {
            return;
        }
        TypeElement typeElement = (TypeElement)declaredType.atypeFactory.types.asElement(actualType);
        ArrayList<AnnotatedTypeMirror> typeArgs = new ArrayList<AnnotatedTypeMirror>();
        HashMap<TypeVariable, AnnotatedTypeMirror> typeArgMap = new HashMap<TypeVariable, AnnotatedTypeMirror>();
        for (int i = 0; i < typeElement.getTypeParameters().size(); ++i) {
            TypeMirror javaTypeArg;
            if (declaredType.wasRaw()) {
                TypeVariable typeVariable = (TypeVariable)typeElement.getTypeParameters().get(i).asType();
                javaTypeArg = BoundsInitializer.getUpperBoundAsWildcard(typeVariable, declaredType.atypeFactory);
            } else {
                javaTypeArg = declaredType.getUnderlyingType().getTypeArguments().get(i);
            }
            AnnotatedTypeMirror typeArg = AnnotatedTypeMirror.createType(javaTypeArg, declaredType.atypeFactory, false);
            if (typeArg.getKind() == TypeKind.WILDCARD) {
                AnnotatedTypeMirror.AnnotatedWildcardType wildcardType = (AnnotatedTypeMirror.AnnotatedWildcardType)typeArg;
                wildcardType.setTypeVariable(typeElement.getTypeParameters().get(i));
                if (declaredType.wasRaw()) {
                    wildcardType.setUninferredTypeArgument();
                }
            }
            typeArgs.add(typeArg);
            typeArgMap.put((TypeVariable)typeElement.getTypeParameters().get(i).asType(), typeArg);
            if (javaTypeArg.getKind() != TypeKind.TYPEVAR) continue;
            typeArgMap.put((TypeVariable)javaTypeArg, typeArg);
        }
        for (AnnotatedTypeMirror typeArg : typeArgs) {
            switch (typeArg.getKind()) {
                case WILDCARD: {
                    AnnotatedTypeMirror.AnnotatedWildcardType wildcardType = (AnnotatedTypeMirror.AnnotatedWildcardType)typeArg;
                    BoundsInitializer.initializeExtendsBound(wildcardType, typeArgMap);
                    BoundsInitializer.initializeSuperBound(wildcardType, typeArgMap);
                    break;
                }
                case TYPEVAR: {
                    BoundsInitializer.initializeBounds((AnnotatedTypeMirror.AnnotatedTypeVariable)typeArg, typeArgMap);
                    break;
                }
            }
        }
        declaredType.typeArgs = Collections.unmodifiableList(typeArgs);
    }

    private static WildcardType getUpperBoundAsWildcard(TypeVariable typeVariable, AnnotatedTypeFactory factory) {
        TypeMirror upperBound = typeVariable.getUpperBound();
        switch (upperBound.getKind()) {
            case TYPEVAR: 
            case ARRAY: 
            case DECLARED: {
                return factory.types.getWildcardType(upperBound, null);
            }
            case INTERSECTION: {
                return factory.types.getWildcardType(null, null);
            }
        }
        ErrorReporter.errorAbort("Unexpected upper bound kind: %s type: %s", new Object[]{upperBound.getKind(), upperBound});
        return null;
    }

    public static void initializeBounds(AnnotatedTypeMirror.AnnotatedTypeVariable typeVar) {
        BoundsInitializer.initializeBounds(typeVar, null);
    }

    private static void initializeBounds(AnnotatedTypeMirror.AnnotatedTypeVariable typeVar, Map<TypeVariable, AnnotatedTypeMirror> map) {
        Set<AnnotationMirror> annos = BoundsInitializer.saveAnnotations(typeVar);
        InitializerVisitor visitor = new InitializerVisitor(new TypeVariableStructure(null, typeVar), map);
        visitor.initializeLowerBound(typeVar);
        visitor.resolveTypeVarReferences(typeVar);
        InitializerVisitor visitor2 = new InitializerVisitor(new TypeVariableStructure(null, typeVar), map);
        visitor2.initializeUpperBound(typeVar);
        visitor2.resolveTypeVarReferences(typeVar);
        BoundsInitializer.restoreAnnotations(typeVar, annos);
    }

    private static Set<AnnotationMirror> saveAnnotations(AnnotatedTypeMirror type) {
        if (!type.getAnnotationsField().isEmpty()) {
            HashSet<AnnotationMirror> annos = new HashSet<AnnotationMirror>(type.getAnnotations());
            type.clearAnnotations();
            return annos;
        }
        return null;
    }

    private static void restoreAnnotations(AnnotatedTypeMirror type, Set<AnnotationMirror> annos) {
        if (annos != null) {
            type.addAnnotations(annos);
        }
    }

    public static void initializeSuperBound(AnnotatedTypeMirror.AnnotatedWildcardType wildcard) {
        BoundsInitializer.initializeSuperBound(wildcard, null);
    }

    private static void initializeSuperBound(AnnotatedTypeMirror.AnnotatedWildcardType wildcard, Map<TypeVariable, AnnotatedTypeMirror> map) {
        Set<AnnotationMirror> annos = BoundsInitializer.saveAnnotations(wildcard);
        InitializerVisitor visitor = new InitializerVisitor(new WildcardStructure(), map);
        visitor.initializeSuperBound(wildcard);
        visitor.resolveTypeVarReferences(wildcard);
        BoundsInitializer.restoreAnnotations(wildcard, annos);
    }

    public static void initializeExtendsBound(AnnotatedTypeMirror.AnnotatedWildcardType wildcard) {
        BoundsInitializer.initializeExtendsBound(wildcard, null);
    }

    private static void initializeExtendsBound(AnnotatedTypeMirror.AnnotatedWildcardType wildcard, Map<TypeVariable, AnnotatedTypeMirror> map) {
        Set<AnnotationMirror> annos = BoundsInitializer.saveAnnotations(wildcard);
        InitializerVisitor visitor = new InitializerVisitor(new WildcardStructure(), map);
        visitor.initializeExtendsBound(wildcard);
        visitor.resolveTypeVarReferences(wildcard);
        BoundsInitializer.restoreAnnotations(wildcard, annos);
    }

    private static AnnotatedTypeMirror createAndSetUpperBound(AnnotatedTypeMirror.AnnotatedTypeVariable typeVar) {
        AnnotatedTypeMirror upperBound = AnnotatedTypeMirror.createType(typeVar.getUnderlyingType().getUpperBound(), typeVar.atypeFactory, false);
        typeVar.setUpperBound(upperBound);
        return upperBound;
    }

    private static AnnotatedTypeMirror createAndSetLowerBound(AnnotatedTypeMirror.AnnotatedTypeVariable typeVar) {
        TypeMirror lb = typeVar.getUnderlyingType().getLowerBound();
        if (lb == null) {
            Context context = ((JavacProcessingEnvironment)typeVar.atypeFactory.processingEnv).getContext();
            Symtab syms = Symtab.instance(context);
            lb = syms.botType;
        }
        AnnotatedTypeMirror lowerBound = AnnotatedTypeMirror.createType(lb, typeVar.atypeFactory, false);
        typeVar.setLowerBound(lowerBound);
        return lowerBound;
    }

    private static boolean isImmediateBoundPath(BoundPath path) {
        if (path.size() == 1) {
            switch (((BoundPathNode)path.getFirst()).kind) {
                case UpperBound: 
                case LowerBound: {
                    return true;
                }
            }
        }
        return false;
    }

    public static void abortIfParentNotKind(TypeKind typeKind, AnnotatedTypeMirror.AnnotatedTypeVariable type, AnnotatedTypeMirror parent) {
        if (parent.getKind().equals((Object)typeKind)) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Unexpected parent kind:\n");
        builder.append("parent=");
        builder.append(parent);
        builder.append("\n");
        builder.append("replacement=");
        builder.append(type);
        builder.append("\n");
        builder.append("expected=");
        builder.append((Object)typeKind);
        builder.append("\n");
        ErrorReporter.errorAbort(builder.toString());
    }

    private static class TypeArgNode
    extends BoundPathNode {
        public final int argIndex;

        TypeArgNode(int argIndex) {
            this.argIndex = argIndex;
            this.kind = BoundPathNode.Kind.TypeArg;
            this.typeKind = TypeKind.DECLARED;
        }

        TypeArgNode(TypeArgNode template) {
            super(template);
            this.argIndex = template.argIndex;
        }

        @Override
        public String toString() {
            return super.toString() + "( argIndex=" + this.argIndex + " )";
        }

        @Override
        public void setType(AnnotatedTypeMirror parent, AnnotatedTypeMirror.AnnotatedTypeVariable replacement) {
            BoundsInitializer.abortIfParentNotKind(TypeKind.DECLARED, replacement, parent);
            AnnotatedTypeMirror.AnnotatedDeclaredType parentAdt = (AnnotatedTypeMirror.AnnotatedDeclaredType)parent;
            ArrayList<AnnotatedTypeMirror> typeArgs = new ArrayList<AnnotatedTypeMirror>(parentAdt.getTypeArguments());
            if (this.argIndex >= typeArgs.size()) {
                ErrorReporter.errorAbort("Invalid type arg index!\nparent=" + parent + "\nreplacement=" + replacement + "\nargIndex=" + this.argIndex);
            }
            typeArgs.add(this.argIndex, replacement);
            typeArgs.remove(this.argIndex + 1);
            parentAdt.setTypeArguments(typeArgs);
        }

        @Override
        public AnnotatedTypeMirror getType(AnnotatedTypeMirror parent) {
            AnnotatedTypeMirror.AnnotatedDeclaredType parentAdt = (AnnotatedTypeMirror.AnnotatedDeclaredType)parent;
            List<AnnotatedTypeMirror> typeArgs = parentAdt.getTypeArguments();
            if (this.argIndex >= typeArgs.size()) {
                ErrorReporter.errorAbort("Invalid type arg index!\nparent=" + parent + "\nargIndex=" + this.argIndex);
            }
            return typeArgs.get(this.argIndex);
        }

        @Override
        public BoundPathNode copy() {
            return new TypeArgNode(this);
        }
    }

    private static class UnionNode
    extends BoundPathNode {
        public final int altIndex;

        UnionNode(int altIndex) {
            this.altIndex = altIndex;
            this.kind = BoundPathNode.Kind.Union;
            this.typeKind = TypeKind.UNION;
        }

        UnionNode(UnionNode template) {
            super(template);
            this.altIndex = template.altIndex;
        }

        @Override
        public String toString() {
            return super.toString() + "( altIndex=" + this.altIndex + " )";
        }

        @Override
        public void setType(AnnotatedTypeMirror parent, AnnotatedTypeMirror.AnnotatedTypeVariable replacement) {
            ErrorReporter.errorAbort("Union types cannot be intersection bounds!\nparent=" + parent + "\nreplacement=" + replacement);
        }

        @Override
        public AnnotatedTypeMirror getType(AnnotatedTypeMirror parent) {
            AnnotatedTypeMirror.AnnotatedUnionType isect = (AnnotatedTypeMirror.AnnotatedUnionType)parent;
            if (parent.directSuperTypes().size() <= this.altIndex) {
                ErrorReporter.errorAbort("Invalid altIndex( " + this.altIndex + " ):\nparent=" + parent);
            }
            return isect.directSuperTypes().get(this.altIndex);
        }

        @Override
        public BoundPathNode copy() {
            return new UnionNode(this);
        }
    }

    private static class IntersectionNode
    extends BoundPathNode {
        public final int superIndex;

        IntersectionNode(int superIndex) {
            this.superIndex = superIndex;
            this.kind = BoundPathNode.Kind.Intersection;
            this.typeKind = TypeKind.INTERSECTION;
        }

        IntersectionNode(IntersectionNode template) {
            super(template);
            this.superIndex = template.superIndex;
        }

        @Override
        public String toString() {
            return super.toString() + "( superIndex=" + this.superIndex + " )";
        }

        @Override
        public void setType(AnnotatedTypeMirror parent, AnnotatedTypeMirror.AnnotatedTypeVariable replacement) {
            ErrorReporter.errorAbort("Type variables cannot be intersection bounds!\nparent=" + parent + "\nreplacement=" + replacement);
        }

        @Override
        public AnnotatedTypeMirror getType(AnnotatedTypeMirror parent) {
            AnnotatedTypeMirror.AnnotatedIntersectionType isect = (AnnotatedTypeMirror.AnnotatedIntersectionType)parent;
            if (parent.directSuperTypes().size() <= this.superIndex) {
                ErrorReporter.errorAbort("Invalid superIndex( " + this.superIndex + " ):\nparent=" + parent);
            }
            return isect.directSuperTypes().get(this.superIndex);
        }

        @Override
        public BoundPathNode copy() {
            return new IntersectionNode(this);
        }
    }

    private static class ArrayComponentNode
    extends BoundPathNode {
        ArrayComponentNode() {
            this.kind = BoundPathNode.Kind.ArrayComponent;
            this.typeKind = TypeKind.ARRAY;
        }

        ArrayComponentNode(ArrayComponentNode template) {
            super(template);
        }

        @Override
        public void setType(AnnotatedTypeMirror parent, AnnotatedTypeMirror.AnnotatedTypeVariable replacement) {
            ((AnnotatedTypeMirror.AnnotatedArrayType)parent).setComponentType(replacement);
        }

        @Override
        public AnnotatedTypeMirror getType(AnnotatedTypeMirror parent) {
            return ((AnnotatedTypeMirror.AnnotatedArrayType)parent).getComponentType();
        }

        @Override
        public BoundPathNode copy() {
            return new ArrayComponentNode(this);
        }
    }

    private static class LowerBoundNode
    extends BoundPathNode {
        LowerBoundNode() {
            this.kind = BoundPathNode.Kind.LowerBound;
            this.typeKind = TypeKind.TYPEVAR;
        }

        LowerBoundNode(LowerBoundNode template) {
            super(template);
        }

        @Override
        public void setType(AnnotatedTypeMirror parent, AnnotatedTypeMirror.AnnotatedTypeVariable replacement) {
            ((AnnotatedTypeMirror.AnnotatedTypeVariable)parent).setLowerBound(replacement);
        }

        @Override
        public AnnotatedTypeMirror getType(AnnotatedTypeMirror parent) {
            AnnotatedTypeMirror.AnnotatedTypeVariable parentAtv = (AnnotatedTypeMirror.AnnotatedTypeVariable)parent;
            if (parentAtv.getLowerBoundField() != null) {
                return parentAtv.getLowerBoundField();
            }
            return BoundsInitializer.createAndSetLowerBound((AnnotatedTypeMirror.AnnotatedTypeVariable)parent);
        }

        @Override
        public BoundPathNode copy() {
            return new LowerBoundNode(this);
        }
    }

    private static class UpperBoundNode
    extends BoundPathNode {
        UpperBoundNode() {
            this.kind = BoundPathNode.Kind.UpperBound;
            this.typeKind = TypeKind.TYPEVAR;
        }

        UpperBoundNode(UpperBoundNode template) {
            super(template);
        }

        @Override
        public void setType(AnnotatedTypeMirror parent, AnnotatedTypeMirror.AnnotatedTypeVariable replacement) {
            ((AnnotatedTypeMirror.AnnotatedTypeVariable)parent).setUpperBound(replacement);
        }

        @Override
        public AnnotatedTypeMirror getType(AnnotatedTypeMirror parent) {
            AnnotatedTypeMirror.AnnotatedTypeVariable parentAtv = (AnnotatedTypeMirror.AnnotatedTypeVariable)parent;
            if (parentAtv.getUpperBoundField() != null) {
                return parentAtv.getUpperBoundField();
            }
            return BoundsInitializer.createAndSetUpperBound((AnnotatedTypeMirror.AnnotatedTypeVariable)parent);
        }

        @Override
        public BoundPathNode copy() {
            return new UpperBoundNode(this);
        }
    }

    private static class SuperNode
    extends BoundPathNode {
        SuperNode() {
            this.kind = BoundPathNode.Kind.Super;
            this.typeKind = TypeKind.WILDCARD;
        }

        SuperNode(SuperNode template) {
            super(template);
        }

        @Override
        public void setType(AnnotatedTypeMirror parent, AnnotatedTypeMirror.AnnotatedTypeVariable replacement) {
            ((AnnotatedTypeMirror.AnnotatedWildcardType)parent).setSuperBound(replacement);
        }

        @Override
        public AnnotatedTypeMirror getType(AnnotatedTypeMirror parent) {
            return ((AnnotatedTypeMirror.AnnotatedWildcardType)parent).getSuperBound();
        }

        @Override
        public BoundPathNode copy() {
            return new SuperNode(this);
        }
    }

    private static class ExtendsNode
    extends BoundPathNode {
        ExtendsNode() {
            this.kind = BoundPathNode.Kind.Extends;
            this.typeKind = TypeKind.WILDCARD;
        }

        ExtendsNode(ExtendsNode template) {
            super(template);
        }

        @Override
        public void setType(AnnotatedTypeMirror parent, AnnotatedTypeMirror.AnnotatedTypeVariable replacement) {
            ((AnnotatedTypeMirror.AnnotatedWildcardType)parent).setExtendsBound(replacement);
        }

        @Override
        public AnnotatedTypeMirror getType(AnnotatedTypeMirror parent) {
            return ((AnnotatedTypeMirror.AnnotatedWildcardType)parent).getExtendsBound();
        }

        @Override
        public BoundPathNode copy() {
            return new ExtendsNode(this);
        }
    }

    private static abstract class BoundPathNode {
        public Kind kind;
        public TypeKind typeKind;

        BoundPathNode() {
        }

        BoundPathNode(BoundPathNode template) {
            this.kind = template.kind;
            this.typeKind = template.typeKind;
        }

        public String toString() {
            return this.kind.toString();
        }

        public AnnotatedTypeMirror next(AnnotatedTypeMirror parent) {
            BoundsInitializer.abortIfParentNotKind(this.typeKind, null, parent);
            return this.getType(parent);
        }

        public void replaceType(AnnotatedTypeMirror parent, AnnotatedTypeMirror.AnnotatedTypeVariable replacement) {
            BoundsInitializer.abortIfParentNotKind(this.typeKind, replacement, parent);
            this.setType(parent, replacement);
        }

        public abstract void setType(AnnotatedTypeMirror var1, AnnotatedTypeMirror.AnnotatedTypeVariable var2);

        public abstract AnnotatedTypeMirror getType(AnnotatedTypeMirror var1);

        public abstract BoundPathNode copy();

        static enum Kind {
            Extends,
            Super,
            UpperBound,
            LowerBound,
            ArrayComponent,
            Intersection,
            Union,
            TypeArg;

        }
    }

    private static class BoundPath
    extends LinkedList<BoundPathNode> {
        private BoundPath() {
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return PluginUtil.join(",", this);
        }

        public BoundPath copy() {
            BoundPath copy = new BoundPath();
            for (BoundPathNode node : this) {
                copy.add(node.copy());
            }
            return copy;
        }
    }

    private static class TypeVariableStructure
    extends BoundStructure {
        public final TypeVariable typeVar;
        public final AnnotatedTypeMirror.AnnotatedTypeVariable annotatedTypeVar;
        private final BoundStructure parent;
        public Set<BoundPath> immediateBoundTypeVars = new LinkedHashSet<BoundPath>();

        public TypeVariableStructure(BoundStructure parent, AnnotatedTypeMirror.AnnotatedTypeVariable annotatedTypeVar) {
            this.parent = parent;
            this.typeVar = annotatedTypeVar.getUnderlyingType();
            this.annotatedTypeVar = annotatedTypeVar;
        }

        @Override
        public void addTypeVar(TypeVariable typeVariable) {
            BoundPath copy = this.currentPath.copy();
            this.pathToTypeVar.put(copy, typeVariable);
            if (BoundsInitializer.isImmediateBoundPath(copy)) {
                this.immediateBoundTypeVars.add(copy);
            }
        }
    }

    private static class WildcardStructure
    extends BoundStructure {
        private WildcardStructure() {
        }
    }

    private static abstract class BoundStructure {
        public final Map<BoundPath, TypeVariable> pathToTypeVar = new LinkedHashMap<BoundPath, TypeVariable>();
        public final BoundPath currentPath = new BoundPath();

        public void addTypeVar(TypeVariable typeVariable) {
            this.pathToTypeVar.put(this.currentPath.copy(), typeVariable);
        }
    }

    private static class InitializerVisitor
    implements AnnotatedTypeVisitor<Void, Void> {
        private final BoundStructure topLevelStructure;
        private BoundStructure currentStructure = null;
        private final Map<TypeVariable, TypeVariableStructure> typeVarToStructure = new HashMap<TypeVariable, TypeVariableStructure>();
        private final Map<WildcardType, AnnotatedTypeMirror.AnnotatedWildcardType> wildcards = new HashMap<WildcardType, AnnotatedTypeMirror.AnnotatedWildcardType>();
        private final Map<IntersectionType, AnnotatedTypeMirror.AnnotatedIntersectionType> intersections = new HashMap<IntersectionType, AnnotatedTypeMirror.AnnotatedIntersectionType>();
        private final Map<TypeVariable, AnnotatedTypeMirror> typevars;
        private final Map<TypeVariable, WildcardType> rawTypeWildcards = new HashMap<TypeVariable, WildcardType>();

        public InitializerVisitor(BoundStructure boundStructure, Map<TypeVariable, AnnotatedTypeMirror> typevars) {
            this.topLevelStructure = boundStructure;
            this.currentStructure = boundStructure;
            this.typevars = typevars != null ? typevars : new HashMap<TypeVariable, AnnotatedTypeMirror>();
            if (boundStructure instanceof TypeVariableStructure) {
                TypeVariableStructure typeVarStruct = (TypeVariableStructure)boundStructure;
                this.typeVarToStructure.put(typeVarStruct.typeVar, typeVarStruct);
            }
        }

        @Override
        public Void visit(AnnotatedTypeMirror type) {
            type.accept(this, null);
            return null;
        }

        @Override
        public Void visit(AnnotatedTypeMirror type, Void aVoid) {
            this.visit(type);
            return null;
        }

        @Override
        public Void visitDeclared(AnnotatedTypeMirror.AnnotatedDeclaredType type, Void aVoid) {
            this.initializeTypeArgs(type);
            return null;
        }

        @Override
        public Void visitIntersection(AnnotatedTypeMirror.AnnotatedIntersectionType type, Void aVoid) {
            if (this.intersections.containsKey(type.getUnderlyingType())) {
                return null;
            }
            this.intersections.put((IntersectionType)type.getUnderlyingType(), type);
            List<AnnotatedTypeMirror.AnnotatedDeclaredType> supertypes = type.directSuperTypes();
            for (int i = 0; i < supertypes.size(); ++i) {
                AnnotatedTypeMirror.AnnotatedDeclaredType supertype = supertypes.get(i);
                BoundPathNode node = this.addPathNode(new IntersectionNode(i));
                this.visit(supertype);
                this.removePathNode(node);
            }
            return null;
        }

        @Override
        public Void visitUnion(AnnotatedTypeMirror.AnnotatedUnionType type, Void aVoid) {
            List<AnnotatedTypeMirror.AnnotatedDeclaredType> alts = type.getAlternatives();
            for (int i = 0; i < alts.size(); ++i) {
                AnnotatedTypeMirror.AnnotatedDeclaredType alt = alts.get(i);
                BoundPathNode node = this.addPathNode(new UnionNode(i));
                this.visit(alt);
                this.removePathNode(node);
            }
            return null;
        }

        @Override
        public Void visitArray(AnnotatedTypeMirror.AnnotatedArrayType type, Void aVoid) {
            if (!TypesUtils.isPrimitive(type.getComponentType().getUnderlyingType())) {
                BoundPathNode componentNode = this.addPathNode(new ArrayComponentNode());
                type.setComponentType(this.getOrVisit(type.getComponentType()));
                this.removePathNode(componentNode);
            }
            return null;
        }

        @Override
        public Void visitTypeVariable(AnnotatedTypeMirror.AnnotatedTypeVariable type, Void aVoid) {
            this.currentStructure.addTypeVar(type.getUnderlyingType());
            if (!this.haveSeenTypeVar(type)) {
                this.pushNewTypeVarStruct(type);
                this.initializeUpperBound(type);
                this.initializeLowerBound(type);
                this.popCurrentTypeVarStruct(type);
            }
            return null;
        }

        @Override
        public Void visitNull(AnnotatedTypeMirror.AnnotatedNullType type, Void aVoid) {
            return null;
        }

        @Override
        public Void visitWildcard(AnnotatedTypeMirror.AnnotatedWildcardType wildcard, Void aVoid) {
            if (wildcard.getSuperBoundField() == null) {
                this.initializeSuperBound(wildcard);
            } else {
                ErrorReporter.errorAbort("Wildcard super field should not be initialized:\nwildcard=" + wildcard.toString() + "currentPath=" + this.currentStructure.currentPath);
            }
            if (wildcard.getExtendsBoundField() == null) {
                this.initializeExtendsBound(wildcard);
            } else {
                ErrorReporter.errorAbort("Wildcard extends field should not be initialized:\nwildcard=" + wildcard.toString() + "currentPath=" + this.currentStructure.currentPath);
            }
            return null;
        }

        @Override
        public Void visitPrimitive(AnnotatedTypeMirror.AnnotatedPrimitiveType type, Void aVoid) {
            return InitializerVisitor.invalidType(type);
        }

        @Override
        public Void visitNoType(AnnotatedTypeMirror.AnnotatedNoType type, Void aVoid) {
            return InitializerVisitor.invalidType(type);
        }

        @Override
        public Void visitExecutable(AnnotatedTypeMirror.AnnotatedExecutableType type, Void aVoid) {
            return InitializerVisitor.invalidType(type);
        }

        public AnnotatedTypeMirror getOrVisit(AnnotatedTypeMirror type) {
            switch (type.getKind()) {
                case WILDCARD: {
                    AnnotatedTypeMirror.AnnotatedWildcardType wildcard = (AnnotatedTypeMirror.AnnotatedWildcardType)type;
                    if (!this.wildcards.containsKey(wildcard.getUnderlyingType())) break;
                    return this.wildcards.get(wildcard.getUnderlyingType());
                }
                case INTERSECTION: {
                    if (!this.intersections.containsKey(type.getUnderlyingType())) break;
                    return this.intersections.get(type.getUnderlyingType());
                }
                case TYPEVAR: {
                    if (!this.typevars.containsKey(type.getUnderlyingType())) break;
                    return this.typevars.get(type.getUnderlyingType());
                }
            }
            this.visit(type);
            return type;
        }

        public void initializeUpperBound(AnnotatedTypeMirror.AnnotatedTypeVariable typeVar) {
            AnnotatedTypeMirror upperBound = BoundsInitializer.createAndSetUpperBound(typeVar);
            UpperBoundNode pathNode = new UpperBoundNode();
            this.addPathNode(pathNode);
            this.visit(upperBound);
            this.removePathNode(pathNode);
        }

        public void initializeLowerBound(AnnotatedTypeMirror.AnnotatedTypeVariable typeVar) {
            AnnotatedTypeMirror lowerBound = BoundsInitializer.createAndSetLowerBound(typeVar);
            LowerBoundNode pathNode = new LowerBoundNode();
            this.addPathNode(pathNode);
            this.visit(lowerBound);
            this.removePathNode(pathNode);
        }

        public void initializeSuperBound(AnnotatedTypeMirror.AnnotatedWildcardType wildcard) {
            AnnotatedTypeFactory typeFactory = wildcard.atypeFactory;
            WildcardType underlyingType = wildcard.getUnderlyingType();
            TypeMirror underlyingSuperBound = underlyingType.getSuperBound();
            if (underlyingSuperBound == null) {
                underlyingSuperBound = TypesUtils.wildLowerBound(underlyingType, wildcard.atypeFactory.processingEnv);
            }
            AnnotatedTypeMirror superBound = AnnotatedTypeMirror.createType(underlyingSuperBound, typeFactory, false);
            wildcard.setSuperBound(superBound);
            this.wildcards.put(wildcard.getUnderlyingType(), wildcard);
            BoundPathNode superNode = this.addPathNode(new SuperNode());
            this.visit(superBound);
            this.removePathNode(superNode);
        }

        public void initializeExtendsBound(AnnotatedTypeMirror.AnnotatedWildcardType wildcard) {
            AnnotatedTypeFactory typeFactory = wildcard.atypeFactory;
            WildcardType javaWildcardType = wildcard.getUnderlyingType();
            TypeMirror javaExtendsBound = javaWildcardType.getExtendsBound() != null ? javaWildcardType.getExtendsBound() : (wildcard.getTypeVariable() != null ? wildcard.getTypeVariable().getUpperBound() : TypesUtils.wildUpperBound(javaWildcardType, wildcard.atypeFactory.processingEnv));
            if (wildcard.isUninferredTypeArgument()) {
                this.rawTypeWildcards.put(wildcard.getTypeVariable(), wildcard.getUnderlyingType());
            }
            AnnotatedTypeMirror extendsBound = AnnotatedTypeMirror.createType(javaExtendsBound, typeFactory, false);
            wildcard.setExtendsBound(extendsBound);
            this.wildcards.put(wildcard.getUnderlyingType(), wildcard);
            BoundPathNode extendsNode = this.addPathNode(new ExtendsNode());
            this.visit(extendsBound);
            this.removePathNode(extendsNode);
        }

        private void initializeTypeArgs(AnnotatedTypeMirror.AnnotatedDeclaredType declaredType) {
            List<AnnotatedTypeMirror> typeArgs;
            DeclaredType actualType = (DeclaredType)declaredType.actualType;
            if (actualType.getTypeArguments().isEmpty() && !declaredType.wasRaw()) {
                return;
            }
            TypeElement typeElement = (TypeElement)declaredType.atypeFactory.types.asElement(actualType);
            if (declaredType.typeArgs == null) {
                typeArgs = new ArrayList<AnnotatedTypeMirror>();
                for (int i = 0; i < typeElement.getTypeParameters().size(); ++i) {
                    TypeMirror javaTypeArg = this.getJavaType(declaredType, typeElement.getTypeParameters(), i);
                    AnnotatedTypeMirror atmArg = AnnotatedTypeMirror.createType(javaTypeArg, declaredType.atypeFactory, false);
                    typeArgs.add(atmArg);
                    if (atmArg.getKind() != TypeKind.WILDCARD || !declaredType.wasRaw()) continue;
                    ((AnnotatedTypeMirror.AnnotatedWildcardType)atmArg).setUninferredTypeArgument();
                }
            } else {
                typeArgs = declaredType.typeArgs;
            }
            ArrayList<AnnotatedTypeMirror> typeArgReplacements = new ArrayList<AnnotatedTypeMirror>(typeArgs.size());
            for (int i = 0; i < typeArgs.size(); ++i) {
                AnnotatedTypeMirror typeArg = typeArgs.get(i);
                BoundPathNode node = this.addPathNode(new TypeArgNode(i));
                if (typeArg.getKind() == TypeKind.WILDCARD) {
                    ((AnnotatedTypeMirror.AnnotatedWildcardType)typeArg).setTypeVariable(typeElement.getTypeParameters().get(i));
                }
                typeArgReplacements.add(this.getOrVisit(typeArg));
                this.removePathNode(node);
            }
            declaredType.setTypeArguments(typeArgReplacements);
        }

        private TypeMirror getJavaType(AnnotatedTypeMirror.AnnotatedDeclaredType type, List<? extends TypeParameterElement> parameters, int i) {
            if (type.wasRaw()) {
                TypeVariable typeVariable = (TypeVariable)parameters.get(i).asType();
                if (this.rawTypeWildcards.containsKey(typeVariable)) {
                    return this.rawTypeWildcards.get(typeVariable);
                }
                WildcardType wildcard = BoundsInitializer.getUpperBoundAsWildcard(typeVariable, type.atypeFactory);
                this.rawTypeWildcards.put(typeVariable, wildcard);
                return wildcard;
            }
            return type.getUnderlyingType().getTypeArguments().get(i);
        }

        public static Void invalidType(AnnotatedTypeMirror atm) {
            ErrorReporter.errorAbort("Unexpected type in Wildcard bound:\nkind=" + (Object)((Object)atm.getKind()) + "\natm=" + atm);
            return null;
        }

        public BoundPathNode addPathNode(BoundPathNode node) {
            this.currentStructure.currentPath.add(node);
            return node;
        }

        public BoundPathNode removePathNode(BoundPathNode node) {
            if (this.currentStructure.currentPath.getLast() != node) {
                ErrorReporter.errorAbort("Cannot remove node: " + node + " It is not the last item.\nnode=" + node + "\ncurrentPath=" + this.currentStructure.currentPath);
            }
            this.currentStructure.currentPath.removeLast();
            return node;
        }

        public void pushNewTypeVarStruct(AnnotatedTypeMirror.AnnotatedTypeVariable typeVar) {
            if (this.typeVarToStructure.containsKey(typeVar.getUnderlyingType())) {
                ErrorReporter.errorAbort("Starting a TypeVarStructure that already exists!\ntypeVar=" + typeVar + "\ncurrentStructure=" + this.currentStructure);
            }
            TypeVariableStructure typeVarStruct = new TypeVariableStructure(this.currentStructure, typeVar);
            this.typeVarToStructure.put(typeVar.getUnderlyingType(), typeVarStruct);
            this.currentStructure = typeVarStruct;
        }

        public boolean haveSeenTypeVar(AnnotatedTypeMirror.AnnotatedTypeVariable typeVariable) {
            return this.typeVarToStructure.containsKey(typeVariable.getUnderlyingType());
        }

        public void popCurrentTypeVarStruct(AnnotatedTypeMirror.AnnotatedTypeVariable typeVar) {
            if (!(this.currentStructure instanceof TypeVariableStructure)) {
                ErrorReporter.errorAbort("Trying to pop WildcardStructure!\ntypeVar=" + typeVar + "\ncurrentStucture=" + this.currentStructure + "\n");
            }
            TypeVariableStructure toPop = (TypeVariableStructure)this.currentStructure;
            if (toPop.typeVar != typeVar) {
                this.currentStructure = toPop.parent;
            }
        }

        public ReferenceMap createReferenceMap(BoundStructure boundStruct) {
            ReferenceMap refMap = new ReferenceMap();
            for (Map.Entry<BoundPath, TypeVariable> entry : boundStruct.pathToTypeVar.entrySet()) {
                TypeVariableStructure targetStructure = this.typeVarToStructure.get(entry.getValue());
                AnnotatedTypeMirror.AnnotatedTypeVariable template = targetStructure.annotatedTypeVar;
                refMap.put(entry.getKey(), template.deepCopy().asUse());
                this.addImmediateTypeVarPaths(refMap, entry.getKey(), targetStructure);
            }
            return refMap;
        }

        public void addImmediateTypeVarPaths(ReferenceMap refMap, BoundPath basePath, TypeVariableStructure targetStruct) {
            for (BoundPath path : targetStruct.immediateBoundTypeVars) {
                BoundPath newPath = basePath.copy();
                newPath.add(path.getFirst());
                TypeVariable immTypeVar = (TypeVariable)targetStruct.pathToTypeVar.get(path);
                TypeVariableStructure immTvStructure = this.typeVarToStructure.get(immTypeVar);
                AnnotatedTypeMirror.AnnotatedTypeVariable template = immTvStructure.annotatedTypeVar;
                refMap.put(newPath, template.deepCopy());
            }
        }

        public void resolveTypeVarReferences(AnnotatedTypeMirror boundedType) {
            ArrayList annotatedTypeVars = new ArrayList();
            HashMap<TypeVariable, ReferenceMap> typeVarToRefMap = new HashMap<TypeVariable, ReferenceMap>();
            for (TypeVariableStructure typeVarStruct : this.typeVarToStructure.values()) {
                ReferenceMap refMap = this.createReferenceMap(typeVarStruct);
                typeVarToRefMap.put(typeVarStruct.typeVar, refMap);
                annotatedTypeVars.addAll(refMap.values());
            }
            for (AnnotatedTypeMirror.AnnotatedTypeVariable atv : annotatedTypeVars) {
                this.fixTypeVarPathReference(atv, typeVarToRefMap);
            }
            if (this.topLevelStructure instanceof WildcardStructure) {
                this.fixWildcardPathReference((AnnotatedTypeMirror.AnnotatedWildcardType)boundedType, typeVarToRefMap);
            } else {
                AnnotatedTypeMirror.AnnotatedTypeVariable typeVar = (AnnotatedTypeMirror.AnnotatedTypeVariable)boundedType;
                this.fixTypeVarPathReference(typeVar, typeVarToRefMap);
            }
        }

        public void fixWildcardPathReference(AnnotatedTypeMirror.AnnotatedWildcardType wildcard, Map<TypeVariable, ReferenceMap> typeVarToRefMap) {
            ReferenceMap topLevelMap = this.createReferenceMap(this.topLevelStructure);
            for (AnnotatedTypeMirror.AnnotatedTypeVariable annotatedTypeVariable : topLevelMap.values()) {
                this.fixTypeVarPathReference(annotatedTypeVariable, typeVarToRefMap);
            }
            for (Map.Entry entry : topLevelMap.entrySet()) {
                AnnotatedTypeMirror parent = this.traverseToParent(wildcard, (BoundPath)entry.getKey());
                BoundPathNode terminus = (BoundPathNode)((BoundPath)entry.getKey()).getLast();
                terminus.setType(parent, (AnnotatedTypeMirror.AnnotatedTypeVariable)entry.getValue());
            }
        }

        public void fixTypeVarPathReference(AnnotatedTypeMirror.AnnotatedTypeVariable type, Map<TypeVariable, ReferenceMap> typeVarToRefMap) {
            ReferenceMap refMap = typeVarToRefMap.get(type.getUnderlyingType());
            for (Map.Entry pathToRef : refMap.entrySet()) {
                BoundPath path = (BoundPath)pathToRef.getKey();
                AnnotatedTypeMirror.AnnotatedTypeVariable replacement = ((AnnotatedTypeMirror.AnnotatedTypeVariable)pathToRef.getValue()).asUse();
                AnnotatedTypeMirror parent = this.traverseToParent(type, path);
                BoundPathNode terminus = (BoundPathNode)path.getLast();
                terminus.replaceType(parent, replacement);
            }
        }

        public AnnotatedTypeMirror traverseToParent(AnnotatedTypeMirror start, BoundPath path) {
            AnnotatedTypeMirror current = start;
            for (int i = 0; i < path.size() - 1; ++i) {
                current = ((BoundPathNode)path.get(i)).next(current);
            }
            return current;
        }

        private static class ReferenceMap
        extends LinkedHashMap<BoundPath, AnnotatedTypeMirror.AnnotatedTypeVariable> {
            private ReferenceMap() {
            }
        }
    }
}

