/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import org.checkerframework.checker.index.qual.HasSubsequence;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.util.BaseContext;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

public class Subsequence {
    public final String array;
    public final String from;
    public final String to;

    private Subsequence(String array, String from, String to) {
        this.array = array;
        this.from = from;
        this.to = to;
    }

    public static Subsequence getSubsequenceFromTree(Tree varTree, AnnotatedTypeFactory factory) {
        if (varTree.getKind() != Tree.Kind.IDENTIFIER && varTree.getKind() != Tree.Kind.MEMBER_SELECT && varTree.getKind() != Tree.Kind.VARIABLE) {
            return null;
        }
        Element element = TreeUtils.elementFromTree(varTree);
        AnnotationMirror hasSub = factory.getDeclAnnotation(element, HasSubsequence.class);
        return Subsequence.createSubsequence(hasSub, null, null);
    }

    private static Subsequence createSubsequence(AnnotationMirror hasSub, TreePath currentPath, FlowExpressionParseUtil.FlowExpressionContext context) {
        if (hasSub == null) {
            return null;
        }
        String from = AnnotationUtils.getElementValue(hasSub, "from", String.class, false);
        String to = AnnotationUtils.getElementValue(hasSub, "to", String.class, false);
        String array = AnnotationUtils.getElementValue(hasSub, "value", String.class, false);
        if (context != null && currentPath != null) {
            from = Subsequence.standardizeAndViewpointAdapt(from, currentPath, context);
            to = Subsequence.standardizeAndViewpointAdapt(to, currentPath, context);
            array = Subsequence.standardizeAndViewpointAdapt(array, currentPath, context);
        }
        return new Subsequence(array, from, to);
    }

    public static Subsequence getSubsequenceFromReceiver(FlowExpressions.Receiver rec, AnnotatedTypeFactory factory, TreePath currentPath, FlowExpressionParseUtil.FlowExpressionContext context) {
        if (rec == null) {
            return null;
        }
        if (!(rec instanceof FlowExpressions.FieldAccess)) {
            return null;
        }
        VariableElement element = ((FlowExpressions.FieldAccess)rec).getField();
        return Subsequence.createSubsequence(factory.getDeclAnnotation(element, HasSubsequence.class), currentPath, context);
    }

    private static String standardizeAndViewpointAdapt(String s2, TreePath currentPath, FlowExpressionParseUtil.FlowExpressionContext context) {
        try {
            s2 = FlowExpressionParseUtil.parse(s2, context, currentPath, false).toString();
        }
        catch (FlowExpressionParseUtil.FlowExpressionParseException flowExpressionParseException) {
            // empty catch block
        }
        return s2;
    }

    public static FlowExpressionParseUtil.FlowExpressionContext getContextFromReceiver(FlowExpressions.Receiver rec, BaseContext checker) {
        if (rec == null) {
            return null;
        }
        if (rec instanceof FlowExpressions.FieldAccess) {
            FlowExpressions.FieldAccess fa = (FlowExpressions.FieldAccess)rec;
            return new FlowExpressionParseUtil.FlowExpressionContext(fa.getReceiver(), null, checker);
        }
        return null;
    }

    public static String negateString(String s2, TreePath currentPath, FlowExpressionParseUtil.FlowExpressionContext context) {
        String original = Subsequence.standardizeAndViewpointAdapt(s2, currentPath, context);
        String result = "";
        if (!original.startsWith("-")) {
            result = result + '-';
        }
        for (int i = 0; i < original.length(); ++i) {
            char c = original.charAt(i);
            result = c == '-' ? result + '+' : (c == '+' ? result + '-' : result + c);
        }
        return result;
    }

    public String toString() {
        return "Subsequence(array=" + this.array + ", from=" + this.from + ", to=" + this.to + ")";
    }
}

