/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.guieffect;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.guieffect.Effect;
import org.checkerframework.checker.guieffect.qual.AlwaysSafe;
import org.checkerframework.checker.guieffect.qual.PolyUI;
import org.checkerframework.checker.guieffect.qual.PolyUIEffect;
import org.checkerframework.checker.guieffect.qual.PolyUIType;
import org.checkerframework.checker.guieffect.qual.SafeEffect;
import org.checkerframework.checker.guieffect.qual.SafeType;
import org.checkerframework.checker.guieffect.qual.UI;
import org.checkerframework.checker.guieffect.qual.UIEffect;
import org.checkerframework.checker.guieffect.qual.UIPackage;
import org.checkerframework.checker.guieffect.qual.UIType;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.type.treeannotator.ListTreeAnnotator;
import org.checkerframework.framework.type.treeannotator.TreeAnnotator;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.ErrorReporter;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class GuiEffectTypeFactory
extends BaseAnnotatedTypeFactory {
    protected final boolean debugSpew;
    protected final Set<LambdaExpressionTree> uiLambdas = new HashSet<LambdaExpressionTree>();

    public GuiEffectTypeFactory(BaseTypeChecker checker, boolean spew) {
        super(checker, false);
        this.debugSpew = spew;
        this.postInit();
    }

    public ExecutableElement findJavaOverride(ExecutableElement overrider, TypeMirror parentType) {
        if (parentType.getKind() != TypeKind.NONE) {
            if (this.debugSpew) {
                System.err.println("Searching for overridden methods from " + parentType);
            }
            TypeElement overriderClass = (TypeElement)overrider.getEnclosingElement();
            TypeElement elem = (TypeElement)((DeclaredType)parentType).asElement();
            if (this.debugSpew) {
                System.err.println("necessary TypeElements acquired: " + elem);
            }
            for (Element element : elem.getEnclosedElements()) {
                ExecutableElement ex;
                boolean overrides;
                if (this.debugSpew) {
                    System.err.println("Considering element " + element);
                }
                if (element.getKind() != ElementKind.METHOD && element.getKind() != ElementKind.CONSTRUCTOR || !(overrides = this.elements.overrides(overrider, ex = (ExecutableElement)element, overriderClass))) continue;
                return ex;
            }
            if (this.debugSpew) {
                System.err.println("Done considering elements of " + parentType);
            }
        }
        return null;
    }

    public boolean isPolymorphicType(TypeElement cls) {
        assert (cls != null);
        return this.getDeclAnnotation(cls, PolyUIType.class) != null || this.fromElement(cls).hasAnnotation(PolyUI.class);
    }

    public boolean isUIType(TypeElement cls) {
        boolean hasUITypeDirectly;
        if (this.debugSpew) {
            System.err.println(" isUIType(" + cls + ")");
        }
        boolean targetClassUIP = this.fromElement(cls).hasAnnotation(UI.class);
        AnnotationMirror targetClassUITypeP = this.getDeclAnnotation(cls, UIType.class);
        AnnotationMirror targetClassSafeTypeP = this.getDeclAnnotation(cls, SafeType.class);
        if (targetClassSafeTypeP != null) {
            return false;
        }
        boolean bl = hasUITypeDirectly = targetClassUIP || targetClassUITypeP != null;
        if (hasUITypeDirectly) {
            return true;
        }
        if (GuiEffectTypeFactory.isAnonymousType(cls)) {
            return false;
        }
        boolean targetClassSafeP = this.fromElement(cls).hasAnnotation(AlwaysSafe.class);
        if (targetClassSafeP) {
            return false;
        }
        PackageElement packageP = ElementUtils.enclosingPackage(cls);
        if (packageP != null) {
            if (this.debugSpew) {
                System.err.println("Found package " + packageP);
            }
            if (this.getDeclAnnotation(packageP, UIPackage.class) != null) {
                if (this.debugSpew) {
                    System.err.println("Package " + packageP + " is annotated @UIPackage");
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isAnonymousType(TypeElement elem) {
        return elem.getSimpleName().length() == 0;
    }

    public Effect getDeclaredEffect(ExecutableElement methodElt) {
        if (this.debugSpew) {
            System.err.println("begin mayHaveUIEffect(" + methodElt + ")");
        }
        AnnotationMirror targetUIP = this.getDeclAnnotation(methodElt, UIEffect.class);
        AnnotationMirror targetSafeP = this.getDeclAnnotation(methodElt, SafeEffect.class);
        AnnotationMirror targetPolyP = this.getDeclAnnotation(methodElt, PolyUIEffect.class);
        TypeElement targetClassElt = (TypeElement)methodElt.getEnclosingElement();
        if (this.debugSpew) {
            System.err.println("targetClassElt found");
        }
        if (targetSafeP != null) {
            if (this.debugSpew) {
                System.err.println("Method marked @SafeEffect");
            }
            return new Effect(SafeEffect.class);
        }
        if (targetUIP != null) {
            if (this.debugSpew) {
                System.err.println("Method marked @UIEffect");
            }
            return new Effect(UIEffect.class);
        }
        if (targetPolyP != null) {
            if (this.debugSpew) {
                System.err.println("Method marked @PolyUIEffect");
            }
            return new Effect(PolyUIEffect.class);
        }
        if (this.isUIType(targetClassElt)) {
            return new Effect(UIEffect.class);
        }
        if (GuiEffectTypeFactory.isAnonymousType(targetClassElt)) {
            boolean canInheritParentEffects = true;
            DeclaredType directSuper = (DeclaredType)targetClassElt.getSuperclass();
            TypeElement superElt = (TypeElement)directSuper.asElement();
            if (this.getDeclAnnotation(superElt, PolyUIType.class) != null && !TypesUtils.isObject(directSuper)) {
                canInheritParentEffects = false;
            } else {
                for (TypeMirror typeMirror : targetClassElt.getInterfaces()) {
                    DeclaredType iface = (DeclaredType)typeMirror;
                    TypeElement ifaceElt = (TypeElement)iface.asElement();
                    if (this.getDeclAnnotation(ifaceElt, PolyUIType.class) == null) continue;
                    canInheritParentEffects = false;
                }
            }
            if (canInheritParentEffects) {
                Effect.EffectRange r = this.findInheritedEffectRange(targetClassElt, methodElt);
                return r != null ? Effect.min(r.min, r.max) : new Effect(SafeEffect.class);
            }
        }
        return new Effect(SafeEffect.class);
    }

    public Effect getComputedEffectAtCallsite(MethodInvocationTree node, AnnotatedTypeMirror.AnnotatedDeclaredType callerReceiver, ExecutableElement methodElt) {
        Effect targetEffect = this.getDeclaredEffect(methodElt);
        if (targetEffect.isPoly()) {
            AnnotatedTypeMirror srcType = null;
            if (node.getMethodSelect().getKind() == Tree.Kind.MEMBER_SELECT) {
                ExpressionTree src = ((MemberSelectTree)node.getMethodSelect()).getExpression();
                srcType = this.getAnnotatedType(src);
            } else if (node.getMethodSelect().getKind() == Tree.Kind.IDENTIFIER) {
                if (callerReceiver == null) {
                    return targetEffect;
                }
                srcType = callerReceiver;
            } else {
                ErrorReporter.errorAbort("Unexpected getMethodSelect() kind at callsite " + node);
            }
            if (srcType.hasAnnotation(AlwaysSafe.class)) {
                targetEffect = new Effect(SafeEffect.class);
            } else if (srcType.hasAnnotation(UI.class)) {
                targetEffect = new Effect(UIEffect.class);
            }
        }
        return targetEffect;
    }

    public Effect getInferedEffectForLambdaExpression(LambdaExpressionTree lambdaTree) {
        if (this.uiLambdas.contains(lambdaTree)) {
            return new Effect(UIEffect.class);
        }
        ExecutableElement functionalInterfaceMethodElt = (ExecutableElement)((Object)TreeUtils.findFunction(lambdaTree, this.checker.getProcessingEnvironment()));
        if (this.debugSpew) {
            System.err.println("functionalInterfaceMethodElt found for lambda");
        }
        return this.getDeclaredEffect(functionalInterfaceMethodElt);
    }

    @Override
    public AnnotatedTypeMirror getAnnotatedType(Tree tree) {
        AnnotatedTypeMirror typeMirror = super.getAnnotatedType(tree);
        if (tree.getKind() == Tree.Kind.LAMBDA_EXPRESSION && this.uiLambdas.contains((LambdaExpressionTree)tree) && !typeMirror.hasAnnotation(UI.class)) {
            typeMirror.replaceAnnotation(AnnotationBuilder.fromClass(this.elements, UI.class));
        }
        return typeMirror;
    }

    public Effect.EffectRange findInheritedEffectRange(TypeElement declaringType, ExecutableElement overridingMethod) {
        return this.findInheritedEffectRange(declaringType, overridingMethod, false, null);
    }

    public Effect.EffectRange findInheritedEffectRange(TypeElement declaringType, ExecutableElement overridingMethod, boolean issueConflictWarning, Tree errorNode) {
        Effect max;
        Effect min2;
        assert (declaringType != null);
        ExecutableElement uiOverride = null;
        ExecutableElement safeOverride = null;
        ExecutableElement polyOverride = null;
        boolean isUI = (this.getDeclAnnotation(overridingMethod, UIEffect.class) != null || this.isUIType(declaringType)) && this.getDeclAnnotation(overridingMethod, SafeEffect.class) == null;
        boolean isPolyUI = this.getDeclAnnotation(overridingMethod, PolyUIEffect.class) != null;
        TypeMirror superclass = declaringType.getSuperclass();
        while (superclass != null && superclass.getKind() != TypeKind.NONE) {
            ExecutableElement overrides = this.findJavaOverride(overridingMethod, superclass);
            if (overrides != null) {
                Effect eff = this.getDeclaredEffect(overrides);
                assert (eff != null);
                if (eff.isSafe()) {
                    safeOverride = overrides;
                    if (isUI && issueConflictWarning) {
                        this.checker.report(Result.failure("override.effect.invalid", overridingMethod, declaringType, safeOverride, superclass), errorNode);
                    }
                    if (isPolyUI && issueConflictWarning) {
                        this.checker.report(Result.failure("override.effect.invalid.polymorphic", overridingMethod, declaringType, safeOverride, superclass), errorNode);
                    }
                } else if (eff.isUI()) {
                    uiOverride = overrides;
                } else {
                    assert (eff.isPoly());
                    polyOverride = overrides;
                }
            }
            DeclaredType decl = (DeclaredType)superclass;
            superclass = ((TypeElement)decl.asElement()).getSuperclass();
        }
        AnnotatedTypeMirror.AnnotatedDeclaredType annoDecl = this.fromElement(declaringType);
        for (AnnotatedTypeMirror.AnnotatedDeclaredType ty : annoDecl.directSuperTypes()) {
            ExecutableElement overrides = this.findJavaOverride(overridingMethod, ty.getUnderlyingType());
            if (overrides == null) continue;
            Effect eff = this.getDeclaredEffect(overrides);
            if (eff.isSafe()) {
                safeOverride = overrides;
                if (isUI && issueConflictWarning) {
                    this.checker.report(Result.failure("override.effect.invalid", overridingMethod, declaringType, safeOverride, ty), errorNode);
                }
                if (!isPolyUI || !issueConflictWarning) continue;
                this.checker.report(Result.failure("override.effect.invalid.polymorphic", overridingMethod, declaringType, safeOverride, ty), errorNode);
                continue;
            }
            if (eff.isUI()) {
                uiOverride = overrides;
                continue;
            }
            assert (eff.isPoly());
            polyOverride = overrides;
            if (!isUI || !issueConflictWarning) continue;
            AnnotatedTypeMirror.AnnotatedDeclaredType supdecl = ty;
            boolean isAnonInstantiation = GuiEffectTypeFactory.isAnonymousType(declaringType) && this.fromElement(declaringType).hasAnnotation(UI.class);
            if (isAnonInstantiation || supdecl.hasAnnotation(UI.class)) continue;
            this.checker.report(Result.failure("override.effect.invalid.nonui", overridingMethod, declaringType, polyOverride, supdecl), errorNode);
        }
        if (uiOverride != null && safeOverride != null && issueConflictWarning) {
            this.checker.report(Result.warning("override.effect.warning.inheritance", overridingMethod, declaringType, uiOverride.toString(), uiOverride.getEnclosingElement().asType().toString(), safeOverride.toString(), safeOverride.getEnclosingElement().asType().toString()), errorNode);
        }
        Effect effect = safeOverride != null ? new Effect(SafeEffect.class) : (polyOverride != null ? new Effect(PolyUIEffect.class) : (min2 = uiOverride != null ? new Effect(UIEffect.class) : null));
        Effect effect2 = uiOverride != null ? new Effect(UIEffect.class) : (polyOverride != null ? new Effect(PolyUIEffect.class) : (max = safeOverride != null ? new Effect(SafeEffect.class) : null));
        if (this.debugSpew) {
            System.err.println("Found " + declaringType + "." + overridingMethod + " to have inheritance pair (" + min2 + "," + max + ")");
        }
        if (min2 == null && max == null) {
            return null;
        }
        return new Effect.EffectRange(min2, max);
    }

    @Override
    protected TreeAnnotator createTreeAnnotator() {
        return new ListTreeAnnotator(super.createTreeAnnotator(), new GuiEffectTreeAnnotator());
    }

    public void constrainLambdaToUI(LambdaExpressionTree lambdaExpressionTree) {
        this.uiLambdas.add(lambdaExpressionTree);
    }

    private class GuiEffectTreeAnnotator
    extends TreeAnnotator {
        GuiEffectTreeAnnotator() {
            super(GuiEffectTypeFactory.this);
        }

        @Override
        public Void visitMethod(MethodTree node, AnnotatedTypeMirror type) {
            AnnotatedTypeMirror.AnnotatedExecutableType methType = (AnnotatedTypeMirror.AnnotatedExecutableType)type;
            TypeElement cls = (TypeElement)methType.getElement().getEnclosingElement();
            AnnotatedTypeMirror.AnnotatedDeclaredType receiverType = methType.getReceiverType();
            if (receiverType != null && !receiverType.isAnnotatedInHierarchy(AnnotationBuilder.fromClass(GuiEffectTypeFactory.this.elements, UI.class))) {
                receiverType.addAnnotation(GuiEffectTypeFactory.this.isPolymorphicType(cls) ? PolyUI.class : (GuiEffectTypeFactory.this.fromElement(cls).hasAnnotation(UI.class) ? UI.class : AlwaysSafe.class));
            }
            return super.visitMethod(node, type);
        }
    }
}

