/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ShortValue;
import com.sun.jdi.Type;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.jdi.PrimitiveValueImpl;

public class ShortValueImpl
extends PrimitiveValueImpl
implements ShortValue {
    private short value;

    ShortValueImpl(VirtualMachine virtualMachine, short s2) {
        super(virtualMachine);
        this.value = s2;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof ShortValue) {
            return this.value == ((ShortValue)object).value() && super.equals(object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.intValue();
    }

    @Override
    public int compareTo(ShortValue shortValue) {
        short s2 = shortValue.value();
        return this.value() - s2;
    }

    @Override
    public Type type() {
        return this.vm.theShortType();
    }

    @Override
    public short value() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return this.value != 0;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public char charValue() {
        return (char)this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    byte checkedByteValue() throws InvalidTypeException {
        if (this.value > 127 || this.value < -128) {
            throw new InvalidTypeException("Can't convert " + this.value + " to byte");
        }
        return super.checkedByteValue();
    }

    @Override
    char checkedCharValue() throws InvalidTypeException {
        if (this.value > 65535 || this.value < 0) {
            throw new InvalidTypeException("Can't convert " + this.value + " to char");
        }
        return super.checkedCharValue();
    }

    @Override
    public String toString() {
        return "" + this.value;
    }

    @Override
    byte typeValueKey() {
        return 83;
    }
}

