/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.Transport;
import com.sun.jdi.connect.spi.Connection;
import com.sun.jdi.connect.spi.TransportService;
import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.jdi.ConnectorImpl;
import com.sun.tools.jdi.SocketTransportService;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class ProcessAttachingConnector
extends ConnectorImpl
implements AttachingConnector {
    static final String ARG_PID = "pid";
    static final String ARG_TIMEOUT = "timeout";
    VirtualMachine vm;
    Transport transport;

    public ProcessAttachingConnector() {
        this.addStringArgument(ARG_PID, this.getString("process_attaching.pid.label"), this.getString("process_attaching.pid"), "", true);
        this.addIntegerArgument(ARG_TIMEOUT, this.getString("generic_attaching.timeout.label"), this.getString("generic_attaching.timeout"), "", false, 0, Integer.MAX_VALUE);
        this.transport = new Transport(){

            @Override
            public String name() {
                return "local";
            }
        };
    }

    @Override
    public com.sun.jdi.VirtualMachine attach(Map<String, ? extends Connector.Argument> map) throws IOException, IllegalConnectorArgumentsException {
        Object object;
        String string = this.argument(ARG_PID, map).value();
        String string2 = this.argument(ARG_TIMEOUT, map).value();
        int n = 0;
        if (string2.length() > 0) {
            n = Integer.decode(string2);
        }
        String string3 = null;
        VirtualMachine virtualMachine = null;
        try {
            virtualMachine = VirtualMachine.attach(string);
            Properties properties = virtualMachine.getAgentProperties();
            string3 = properties.getProperty("sun.jdwp.listenerAddress");
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
        finally {
            if (virtualMachine != null) {
                virtualMachine.detach();
            }
        }
        if (string3 == null) {
            throw new IOException("Not a debuggee, or not listening for debugger to attach");
        }
        int n2 = string3.indexOf(58);
        if (n2 < 1) {
            throw new IOException("Unable to determine transport endpoint");
        }
        String string4 = string3.substring(0, n2);
        string3 = string3.substring(n2 + 1, string3.length());
        TransportService transportService = null;
        if (string4.equals("dt_socket")) {
            transportService = new SocketTransportService();
        } else if (string4.equals("dt_shmem")) {
            try {
                object = Class.forName("com.sun.tools.jdi.SharedMemoryTransportService");
                transportService = (TransportService)((Class)object).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (transportService == null) {
            throw new IOException("Transport " + string4 + " not recognized");
        }
        object = ((TransportService)transportService).attach(string3, n, 0L);
        return Bootstrap.virtualMachineManager().createVirtualMachine((Connection)object);
    }

    @Override
    public String name() {
        return "com.sun.jdi.ProcessAttach";
    }

    @Override
    public String description() {
        return this.getString("process_attaching.description");
    }

    @Override
    public Transport transport() {
        if (this.transport == null) {
            return new Transport(){

                @Override
                public String name() {
                    return "local";
                }
            };
        }
        return this.transport;
    }
}

