/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.addon.at_generated;

import com.sun.codemodel.internal.JAnnotatable;
import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JFieldVar;
import com.sun.codemodel.internal.JMethod;
import com.sun.tools.internal.xjc.Driver;
import com.sun.tools.internal.xjc.Options;
import com.sun.tools.internal.xjc.Plugin;
import com.sun.tools.internal.xjc.outline.ClassOutline;
import com.sun.tools.internal.xjc.outline.EnumOutline;
import com.sun.tools.internal.xjc.outline.Outline;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.ErrorHandler;

public class PluginImpl
extends Plugin {
    private JClass annotation;
    private String date = null;

    @Override
    public String getOptionName() {
        return "mark-generated";
    }

    @Override
    public String getUsage() {
        return "  -mark-generated    :  mark the generated code as @javax.annotation.Generated";
    }

    @Override
    public boolean run(Outline model, Options opt, ErrorHandler errorHandler) {
        this.annotation = model.getCodeModel().ref("javax.annotation.Generated");
        for (ClassOutline classOutline : model.getClasses()) {
            this.augument(classOutline);
        }
        for (EnumOutline enumOutline : model.getEnums()) {
            this.augument(enumOutline);
        }
        return true;
    }

    private void augument(EnumOutline eo) {
        this.annotate(eo.clazz);
    }

    private void augument(ClassOutline co) {
        this.annotate(co.implClass);
        for (JMethod m3 : co.implClass.methods()) {
            this.annotate(m3);
        }
        for (JFieldVar f : co.implClass.fields().values()) {
            this.annotate(f);
        }
    }

    private void annotate(JAnnotatable m3) {
        m3.annotate(this.annotation).param("value", Driver.class.getName()).param("date", this.getISO8601Date()).param("comments", "JAXB RI v" + Options.getBuildID());
    }

    private String getISO8601Date() {
        if (this.date == null) {
            StringBuffer tstamp = new StringBuffer();
            tstamp.append(new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ssZ").format(new Date()));
            tstamp.insert(tstamp.length() - 2, ':');
            this.date = tstamp.toString();
        }
        return this.date;
    }
}

