/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.hat.internal.parser;

import com.sun.tools.hat.internal.parser.FileReadBuffer;
import com.sun.tools.hat.internal.parser.ReadBuffer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

class MappedReadBuffer
implements ReadBuffer {
    private MappedByteBuffer buf;

    MappedReadBuffer(MappedByteBuffer mappedByteBuffer) {
        this.buf = mappedByteBuffer;
    }

    static ReadBuffer create(RandomAccessFile randomAccessFile) throws IOException {
        FileChannel fileChannel = randomAccessFile.getChannel();
        long l = fileChannel.size();
        if (MappedReadBuffer.canUseFileMap() && l <= Integer.MAX_VALUE) {
            try {
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, l);
                fileChannel.close();
                return new MappedReadBuffer(mappedByteBuffer);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.err.println("File mapping failed, will use direct read");
            }
        }
        return new FileReadBuffer(randomAccessFile);
    }

    private static boolean canUseFileMap() {
        String string = System.getProperty("jhat.disableFileMap");
        return string == null || string.equals("false");
    }

    private void seek(long l) throws IOException {
        assert (l <= Integer.MAX_VALUE) : "position overflow";
        this.buf.position((int)l);
    }

    @Override
    public synchronized void get(long l, byte[] byArray) throws IOException {
        this.seek(l);
        this.buf.get(byArray);
    }

    @Override
    public synchronized char getChar(long l) throws IOException {
        this.seek(l);
        return this.buf.getChar();
    }

    @Override
    public synchronized byte getByte(long l) throws IOException {
        this.seek(l);
        return this.buf.get();
    }

    @Override
    public synchronized short getShort(long l) throws IOException {
        this.seek(l);
        return this.buf.getShort();
    }

    @Override
    public synchronized int getInt(long l) throws IOException {
        this.seek(l);
        return this.buf.getInt();
    }

    @Override
    public synchronized long getLong(long l) throws IOException {
        this.seek(l);
        return this.buf.getLong();
    }
}

