/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.tools.doclets.formats.html.AbstractIndexWriter;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.IndexBuilder;
import java.io.IOException;

public class SingleIndexWriter
extends AbstractIndexWriter {
    public SingleIndexWriter(ConfigurationImpl configurationImpl, String string, IndexBuilder indexBuilder) throws IOException {
        super(configurationImpl, string, indexBuilder);
        this.relativepathNoSlash = ".";
        this.relativePath = "./";
    }

    public static void generate(ConfigurationImpl configurationImpl, IndexBuilder indexBuilder) {
        String string = "index-all.html";
        try {
            SingleIndexWriter singleIndexWriter = new SingleIndexWriter(configurationImpl, string, indexBuilder);
            singleIndexWriter.generateIndexFile();
            singleIndexWriter.close();
        }
        catch (IOException iOException) {
            configurationImpl.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void generateIndexFile() throws IOException {
        String string = this.configuration.getText("doclet.Window_Single_Index");
        HtmlTree htmlTree = this.getBody(true, this.getWindowTitle(string));
        this.addTop(htmlTree);
        this.addNavLinks(true, htmlTree);
        HtmlTree htmlTree2 = new HtmlTree(HtmlTag.DIV);
        htmlTree2.addStyle(HtmlStyle.contentContainer);
        this.addLinksForIndexes(htmlTree2);
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            Character c = (Character)this.indexbuilder.elements()[i];
            this.addContents(c, this.indexbuilder.getMemberList(c), htmlTree2);
        }
        this.addLinksForIndexes(htmlTree2);
        ((Content)htmlTree).addContent(htmlTree2);
        this.addNavLinks(false, htmlTree);
        this.addBottom(htmlTree);
        this.printHtmlDocument(null, true, htmlTree);
    }

    protected void addLinksForIndexes(Content content) {
        for (int i = 0; i < this.indexbuilder.elements().length; ++i) {
            String string = this.indexbuilder.elements()[i].toString();
            content.addContent(this.getHyperLink("#_" + string + "_", new StringContent(string)));
            content.addContent(this.getSpace());
        }
    }
}

