/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.internal.tools;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParallelWorldClassLoader
extends ClassLoader
implements Closeable {
    private final String prefix;
    private final Set<JarFile> jars;

    public ParallelWorldClassLoader(ClassLoader parent, String prefix) {
        super(parent);
        this.prefix = prefix;
        this.jars = Collections.synchronizedSet(new HashSet());
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        StringBuffer sb = new StringBuffer(name.length() + this.prefix.length() + 6);
        sb.append(this.prefix).append(name.replace('.', '/')).append(".class");
        URL u = this.getParent().getResource(sb.toString());
        if (u == null) {
            throw new ClassNotFoundException(name);
        }
        InputStream is = null;
        URLConnection con = null;
        try {
            con = u.openConnection();
            is = con.getInputStream();
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(name);
        }
        if (is == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            String pkgname;
            Package pkg;
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) >= 0) {
                baos.write(buf, 0, len);
            }
            buf = baos.toByteArray();
            int packIndex = name.lastIndexOf(46);
            if (packIndex != -1 && (pkg = this.getPackage(pkgname = name.substring(0, packIndex))) == null) {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
            Class<?> clazz = this.defineClass(name, buf, 0, buf.length);
            return clazz;
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        finally {
            try {
                if (con != null && con instanceof JarURLConnection) {
                    this.jars.add(((JarURLConnection)con).getJarFile());
                }
            }
            catch (IOException iOException) {}
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected URL findResource(String name) {
        URL u = this.getParent().getResource(this.prefix + name);
        if (u != null) {
            try {
                this.jars.add(new JarFile(new File(ParallelWorldClassLoader.toJarUrl(u).toURI())));
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(ParallelWorldClassLoader.class.getName()).log(Level.WARNING, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(ParallelWorldClassLoader.class.getName()).log(Level.WARNING, null, ex);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return u;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> en = this.getParent().getResources(this.prefix + name);
        while (en.hasMoreElements()) {
            try {
                this.jars.add(new JarFile(new File(ParallelWorldClassLoader.toJarUrl(en.nextElement()).toURI())));
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(ParallelWorldClassLoader.class.getName()).log(Level.WARNING, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(ParallelWorldClassLoader.class.getName()).log(Level.WARNING, null, ex);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return en;
    }

    @Override
    public synchronized void close() throws IOException {
        for (JarFile jar2 : this.jars) {
            jar2.close();
        }
    }

    public static URL toJarUrl(URL res) throws ClassNotFoundException, MalformedURLException {
        String url = res.toExternalForm();
        if (!url.startsWith("jar:")) {
            throw new ClassNotFoundException("Loaded outside a jar " + url);
        }
        url = url.substring(4);
        url = url.substring(0, url.lastIndexOf(33));
        return new URL(url);
    }
}

