/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.util.HashMap;
import java.util.Set;

public abstract class Alignment {
    private static int nextOrdinal = 0;
    private static HashMap<String, Alignment> map = new HashMap();
    private static final String blanks = "                                                                                                                                                               ";
    private final String name;
    private final int value = nextOrdinal++;
    public static final Alignment CENTER = new Alignment("center"){

        @Override
        protected String align(String string, int n) {
            int n2 = string.length();
            if (n2 >= n) {
                return string;
            }
            int n3 = n - n2;
            int n4 = n3 / 2;
            int n5 = n3 % 2;
            if (n4 == 0) {
                return string + Alignment.blanks.substring(0, n5);
            }
            return Alignment.blanks.substring(0, n4) + string + Alignment.blanks.substring(0, n4 + n5);
        }
    };
    public static final Alignment LEFT = new Alignment("left"){

        @Override
        protected String align(String string, int n) {
            int n2 = string.length();
            if (n2 >= n) {
                return string;
            }
            int n3 = n - n2;
            return string + Alignment.blanks.substring(0, n3);
        }
    };
    public static final Alignment RIGHT = new Alignment("right"){

        @Override
        protected String align(String string, int n) {
            int n2 = string.length();
            if (n2 >= n) {
                return string;
            }
            int n3 = n - n2;
            return Alignment.blanks.substring(0, n3) + string;
        }
    };

    protected abstract String align(String var1, int var2);

    public static Alignment toAlignment(String string) {
        return map.get(string);
    }

    public static Set keySet() {
        return map.keySet();
    }

    public String toString() {
        return this.name;
    }

    private Alignment(String string) {
        this.name = string;
        map.put(string, this);
    }
}

