/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.options;

import java.io.File;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.checkerframework.checker.formatter.qual.FormatMethod;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.Raw;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.plumelib.options.Option;
import org.plumelib.options.OptionGroup;
import org.plumelib.options.StringBuilderDelimited;
import org.plumelib.options.Unpublicized;

public class Options {
    public boolean useSingleDash = false;
    private boolean parseAfterArg = true;
    public static boolean spaceSeparatedLists = false;
    public @Nullable String usageSynopsis = null;
    public boolean useDashes = true;
    private Class<?> mainClass = Void.TYPE;
    private final List<OptionInfo> options = new ArrayList<OptionInfo>();
    private final Map<String, OptionInfo> nameMap = new LinkedHashMap<String, OptionInfo>();
    private final Map<String, OptionGroupInfo> groupMap = new LinkedHashMap<String, OptionGroupInfo>();
    private boolean hasGroups;
    private static final String LIST_HELP = "[+] marked option can be specified multiple times";
    private boolean debugEnabled = false;
    private String optionsString = "";
    private static String lineSeparator = System.getProperty("line.separator");
    private boolean hasListOption = false;

    public void enableDebugLogging(boolean enabled) {
        this.debugEnabled = enabled;
    }

    public Options(Object ... args) {
        this("", args);
    }

    public Options(String usageSynopsis, Object ... args) {
        if (args.length == 0) {
            throw new Error("Must pass at least one object to Options constructor");
        }
        this.usageSynopsis = usageSynopsis;
        this.hasGroups = false;
        boolean seenFirstOpt = false;
        for (Object obj : args) {
            Field[] fields;
            Class<?> clazz;
            boolean isClass = obj instanceof Class;
            String currentGroup = null;
            Class<?> clazz2 = clazz = isClass ? (Class<?>)obj : obj.getClass();
            if (this.mainClass == Void.TYPE) {
                this.mainClass = clazz;
            }
            for (Field f : fields = clazz.getDeclaredFields()) {
                boolean unpublicized;
                block25: {
                    try {
                        Object objNonraw = obj;
                        if (this.debugEnabled) {
                            System.err.printf("Considering field %s of object %s%n", f, objNonraw);
                        }
                    }
                    catch (Throwable t) {
                        if (!this.debugEnabled) break block25;
                        System.err.printf("Considering field %s of object of type %s%n", f, obj.getClass());
                    }
                }
                try {
                    if (this.debugEnabled) {
                        System.err.printf("  with annotations %s%n", Arrays.toString(f.getDeclaredAnnotations()));
                    }
                }
                catch (ArrayStoreException e) {
                    if (e.getMessage() != null && Objects.equals(e.getMessage(), "sun.reflect.annotation.TypeNotPresentExceptionProxy")) {
                        if (this.debugEnabled) {
                            System.err.printf("  with TypeNotPresentExceptionProxy while getting annotations%n", new Object[0]);
                        }
                    }
                    throw e;
                }
                Option option = Options.safeGetAnnotation(f, Option.class);
                if (option == null) continue;
                boolean bl = unpublicized = Options.safeGetAnnotation(f, Unpublicized.class) != null;
                if (isClass && !Modifier.isStatic(f.getModifiers())) {
                    throw new Error("non-static option " + f + " in class " + obj);
                }
                @Initialized OptionInfo oi = new OptionInfo(f, option, isClass ? null : obj, unpublicized);
                this.options.add(oi);
                OptionGroup optionGroup = Options.safeGetAnnotation(f, OptionGroup.class);
                if (!seenFirstOpt) {
                    seenFirstOpt = true;
                    if (optionGroup == null) continue;
                    this.hasGroups = true;
                }
                if (!this.hasGroups) {
                    if (optionGroup == null) continue;
                    throw new Error("missing @OptionGroup annotation on the first @Option-annotated field of class " + this.mainClass);
                }
                if (currentGroup == null && optionGroup == null) {
                    throw new Error("missing @OptionGroup annotation in field " + f + " of class " + obj);
                }
                if (optionGroup != null) {
                    String name = optionGroup.value();
                    if (this.groupMap.containsKey(name)) {
                        throw new Error("option group " + name + " declared twice");
                    }
                    OptionGroupInfo gi = new OptionGroupInfo(optionGroup);
                    this.groupMap.put(name, gi);
                    currentGroup = name;
                }
                @NonNull OptionGroupInfo ogi = this.groupMap.get(currentGroup);
                ogi.optionList.add(oi);
            }
        }
        String prefix = this.useSingleDash ? "-" : "--";
        for (OptionInfo oi : this.options) {
            if (oi.shortName != null) {
                if (this.nameMap.containsKey("-" + oi.shortName)) {
                    throw new Error("short name " + oi + " appears twice");
                }
                this.nameMap.put("-" + oi.shortName, oi);
            }
            if (this.nameMap.containsKey(prefix + oi.longName)) {
                throw new Error("long name " + oi + " appears twice");
            }
            this.nameMap.put(prefix + oi.longName, oi);
            if (this.useDashes && oi.longName.contains("-")) {
                this.nameMap.put(prefix + oi.longName.replace('-', '_'), oi);
            }
            if (oi.aliases.length <= 0) continue;
            for (String alias : oi.aliases) {
                if (this.nameMap.containsKey(alias)) {
                    throw new Error("alias " + oi + " appears twice");
                }
                this.nameMap.put(alias, oi);
            }
        }
    }

    private static <T extends Annotation> @Nullable T safeGetAnnotation(Field f, Class<T> annotationClass) {
        T annotation2;
        try {
            T cast;
            annotation2 = cast = f.getAnnotation(annotationClass);
        }
        catch (Exception e) {
            System.out.printf("Exception in call to f.getAnnotation(%s)%n  for f=%s%n  %s%nClasspath =%n", annotationClass, f, e.getMessage());
            Options.printClassPath();
            annotation2 = null;
        }
        return annotation2;
    }

    static void printClassPath() {
        URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        if (sysLoader == null) {
            System.out.println("No system class loader. (Maybe means bootstrap class loader is being used?)");
        } else {
            System.out.println("Classpath:");
            for (URL url : sysLoader.getURLs()) {
                System.out.println(url.getFile());
            }
        }
    }

    public void setParseAfterArg(boolean val) {
        this.parseAfterArg = val;
    }

    public void setUseSingleDash(boolean val) {
        this.useSingleDash = val;
    }

    public String[] parse(String[] args) throws ArgException {
        ArrayList<String> nonOptions = new ArrayList<String>();
        boolean ignoreOptions = false;
        String tail = "";
        int ii = 0;
        while (ii < args.length) {
            String arg;
            if (tail.length() > 0) {
                arg = tail;
                tail = "";
            } else {
                arg = args[ii];
            }
            if (arg.equals("--")) {
                ignoreOptions = true;
            } else if ((arg.startsWith("--") || arg.startsWith("-")) && !ignoreOptions) {
                String argValue;
                String argName;
                int eqPos;
                int splitPos = arg.indexOf(",-");
                if (splitPos == 0) {
                    arg = arg.substring(1);
                    splitPos = arg.indexOf(",-");
                }
                if (splitPos > 0) {
                    tail = arg.substring(splitPos + 1);
                    arg = arg.substring(0, splitPos);
                }
                if ((eqPos = arg.indexOf(61)) == -1) {
                    argName = arg;
                    argValue = null;
                } else {
                    argName = arg.substring(0, eqPos);
                    argValue = arg.substring(eqPos + 1);
                }
                OptionInfo oi = this.nameMap.get(argName);
                if (oi == null) {
                    StringBuilder msg = new StringBuilder();
                    msg.append(String.format("unknown option name '%s' in arg '%s'", argName, arg));
                    throw new ArgException(msg.toString());
                }
                if (oi.argumentRequired() && argValue == null) {
                    if (++ii >= args.length) {
                        throw new ArgException("option %s requires an argument", arg);
                    }
                    argValue = args[ii];
                }
                this.setArg(oi, argName, argValue);
            } else {
                if (!this.parseAfterArg) {
                    ignoreOptions = true;
                }
                nonOptions.add(arg);
            }
            if (tail.length() != 0) continue;
            ++ii;
        }
        String[] result = nonOptions.toArray(new String[nonOptions.size()]);
        return result;
    }

    public static String[] tokenize(String args) {
        args = args.trim();
        ArrayList<String> argList = new ArrayList<String>();
        String arg = "";
        boolean activeQuote = false;
        for (int ii = 0; ii < args.length(); ++ii) {
            char ch = args.charAt(ii);
            if (ch == '\'' || ch == '\"') {
                arg = arg + ch;
                ++ii;
                while (ii < args.length() && args.charAt(ii) != ch) {
                    arg = arg + args.charAt(ii++);
                }
                arg = arg + ch;
                continue;
            }
            if (Character.isWhitespace(ch)) {
                argList.add(arg);
                arg = "";
                while (ii < args.length() && Character.isWhitespace(args.charAt(ii))) {
                    ++ii;
                }
                if (ii >= args.length()) continue;
                --ii;
                continue;
            }
            arg = arg + ch;
        }
        if (!arg.equals("")) {
            argList.add(arg);
        }
        String[] argsArray = argList.toArray(new String[argList.size()]);
        return argsArray;
    }

    public String[] parse(String message, String[] args) {
        String[] nonOptions = null;
        try {
            nonOptions = this.parse(args);
        }
        catch (ArgException ae) {
            String exceptionMessage = ae.getMessage();
            if (exceptionMessage != null) {
                System.out.println(exceptionMessage);
            }
            System.out.println(message);
            System.exit(-1);
        }
        return nonOptions;
    }

    public String[] parse(boolean showUsageOnError, String[] args) {
        String[] nonOptions = null;
        try {
            nonOptions = this.parse(args);
        }
        catch (ArgException ae) {
            String exceptionMessage = ae.getMessage();
            if (exceptionMessage != null) {
                System.out.println(exceptionMessage);
            }
            this.printUsage();
            System.exit(-1);
        }
        return nonOptions;
    }

    public void printUsage(PrintStream ps) {
        this.hasListOption = false;
        if (this.usageSynopsis != null) {
            ps.printf("Usage: %s%n", this.usageSynopsis);
        }
        ps.println(this.usage(new String[0]));
        if (this.hasListOption) {
            ps.println();
            ps.println(LIST_HELP);
        }
    }

    public void printUsage() {
        this.printUsage(System.out);
    }

    public String usage(String ... groupNames) {
        return this.usage(false, groupNames);
    }

    public String usage(boolean showUnpublicized, String ... groupNames) {
        if (!this.hasGroups) {
            if (groupNames.length > 0) {
                throw new IllegalArgumentException("This instance of Options does not have any option groups defined");
            }
            return this.formatOptions(this.options, this.maxOptionLength(this.options, showUnpublicized), showUnpublicized);
        }
        ArrayList<OptionGroupInfo> groups = new ArrayList<OptionGroupInfo>();
        if (groupNames.length > 0) {
            for (String groupName : groupNames) {
                if (!this.groupMap.containsKey(groupName)) {
                    throw new IllegalArgumentException("invalid option group: " + (String)groupName);
                }
                OptionGroupInfo gi = this.groupMap.get(groupName);
                if (!showUnpublicized && !gi.anyPublicized()) {
                    throw new IllegalArgumentException("group does not contain any publicized options: " + (String)groupName);
                }
                groups.add(this.groupMap.get(groupName));
            }
        } else {
            for (OptionGroupInfo gi : this.groupMap.values()) {
                if ((gi.unpublicized || !gi.anyPublicized()) && !showUnpublicized) continue;
                groups.add(gi);
            }
        }
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        for (OptionGroupInfo gi : groups) {
            lengths.add(this.maxOptionLength(gi.optionList, showUnpublicized));
        }
        int maxLength = (Integer)Collections.max(lengths);
        StringBuilderDelimited buf = new StringBuilderDelimited(lineSeparator);
        for (OptionGroupInfo gi : groups) {
            buf.add(String.format("%n%s:", gi.name));
            buf.add(this.formatOptions(gi.optionList, maxLength, showUnpublicized));
        }
        return buf.toString();
    }

    private String formatOptions(List<OptionInfo> optList, int maxLength, boolean showUnpublicized) {
        StringBuilderDelimited buf = new StringBuilderDelimited(lineSeparator);
        for (OptionInfo oi : optList) {
            if (oi.unpublicized && !showUnpublicized) continue;
            String defaultStr = "";
            if (oi.defaultStr != null) {
                defaultStr = String.format(" [default %s]", oi.defaultStr);
            }
            String use = String.format("  %-" + maxLength + "s - %s%s", oi.synopsis(), oi.description, defaultStr);
            buf.add(use);
            if (oi.list == null) continue;
            this.hasListOption = true;
        }
        return buf.toString();
    }

    private int maxOptionLength(List<OptionInfo> optList, boolean showUnpublicized) {
        int maxLength = 0;
        for (OptionInfo oi : optList) {
            int len;
            if (oi.unpublicized && !showUnpublicized || (len = oi.synopsis().length()) <= maxLength) continue;
            maxLength = len;
        }
        return maxLength;
    }

    @Pure
    boolean hasGroups() {
        return this.hasGroups;
    }

    @Pure
    boolean getUseSingleDash() {
        return this.useSingleDash;
    }

    List<OptionInfo> getOptions() {
        return this.options;
    }

    Collection<OptionGroupInfo> getOptionGroups() {
        return this.groupMap.values();
    }

    private void setArg(OptionInfo oi, String argName, @Nullable String argValue) throws ArgException {
        block45: {
            Field f = oi.field;
            Class<?> type = oi.baseType;
            if (this.optionsString.length() > 0) {
                this.optionsString = this.optionsString + " ";
            }
            this.optionsString = this.optionsString + argName;
            if (argValue != null) {
                if (!argValue.contains(" ")) {
                    this.optionsString = this.optionsString + "=" + argValue;
                } else if (!argValue.contains("'")) {
                    this.optionsString = this.optionsString + "='" + argValue + "'";
                } else if (!argValue.contains("\"")) {
                    this.optionsString = this.optionsString + "=\"" + argValue + "\"";
                } else {
                    throw new ArgException("Can't quote for internal debugging: " + argValue);
                }
            }
            if (argValue == null) {
                if (type != Boolean.TYPE || type != Boolean.class) {
                    argValue = "true";
                } else {
                    throw new ArgException("Value required for option " + argName);
                }
            }
            try {
                if (type.isPrimitive()) {
                    if (type == Boolean.TYPE) {
                        boolean val;
                        String argValueLowercase = argValue.toLowerCase();
                        if (argValueLowercase.equals("true") || argValueLowercase.equals("t")) {
                            val = true;
                        } else if (argValueLowercase.equals("false") || argValueLowercase.equals("f")) {
                            val = false;
                        } else {
                            throw new ArgException("Value \"%s\" for argument %s is not a boolean", argValue, argName);
                        }
                        argValue = val ? "true" : "false";
                        f.setBoolean(oi.obj, val);
                        break block45;
                    }
                    if (type == Byte.TYPE) {
                        byte val;
                        try {
                            val = Byte.decode(argValue);
                        }
                        catch (Exception e) {
                            throw new ArgException("Value \"%s\" for argument %s is not a byte", argValue, argName);
                        }
                        f.setByte(oi.obj, val);
                        break block45;
                    }
                    if (type == Character.TYPE) {
                        if (argValue.length() != 1) {
                            throw new ArgException("Value \"%s\" for argument %s is not a single character", argValue, argName);
                        }
                        char val = argValue.charAt(0);
                        f.setChar(oi.obj, val);
                        break block45;
                    }
                    if (type == Short.TYPE) {
                        short val;
                        try {
                            val = Short.decode(argValue);
                        }
                        catch (Exception e) {
                            throw new ArgException("Value \"%s\" for argument %s is not a short integer", argValue, argName);
                        }
                        f.setShort(oi.obj, val);
                        break block45;
                    }
                    if (type == Integer.TYPE) {
                        int val;
                        try {
                            val = Integer.decode(argValue);
                        }
                        catch (Exception e) {
                            throw new ArgException("Value \"%s\" for argument %s is not an integer", argValue, argName);
                        }
                        f.setInt(oi.obj, val);
                        break block45;
                    }
                    if (type == Long.TYPE) {
                        long val;
                        try {
                            val = Long.decode(argValue);
                        }
                        catch (Exception e) {
                            throw new ArgException("Value \"%s\" for argument %s is not a long integer", argValue, argName);
                        }
                        f.setLong(oi.obj, val);
                        break block45;
                    }
                    if (type == Float.TYPE) {
                        Float val;
                        try {
                            val = Float.valueOf(argValue);
                        }
                        catch (Exception e) {
                            throw new ArgException("Value \"%s\" for argument %s is not a float", argValue, argName);
                        }
                        f.setFloat(oi.obj, val.floatValue());
                        break block45;
                    }
                    if (type == Double.TYPE) {
                        Double val;
                        try {
                            val = Double.valueOf(argValue);
                        }
                        catch (Exception e) {
                            throw new ArgException("Value \"%s\" for argument %s is not a double", argValue, argName);
                        }
                        f.setDouble(oi.obj, val);
                        break block45;
                    }
                    throw new Error("Unexpected type " + type);
                }
                if (oi.list != null) {
                    if (spaceSeparatedLists) {
                        String[] aarr;
                        for (String aval : aarr = argValue.split("  *")) {
                            Object val = this.getRefArg(oi, argName, aval);
                            oi.list.add(val);
                        }
                    } else {
                        Object val = this.getRefArg(oi, argName, argValue);
                        oi.list.add(val);
                    }
                } else {
                    Object val = this.getRefArg(oi, argName, argValue);
                    f.set(oi.obj, val);
                }
            }
            catch (ArgException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new Error("Unexpected error ", e);
            }
        }
    }

    private @NonNull Object getRefArg(OptionInfo oi, String argName, String argValue) throws ArgException {
        Object val;
        try {
            if (oi.constructor != null) {
                val = oi.constructor.newInstance(argValue);
            } else if (oi.baseType.isEnum()) {
                Object tmpVal = this.getEnumValue(oi.baseType, argValue);
                val = tmpVal;
            } else {
                if (oi.factory == null) {
                    throw new Error("No constructor or factory for argument " + argName);
                }
                @NonNull Object tmpVal = oi.factory.invoke(null, argValue);
                val = tmpVal;
            }
        }
        catch (Exception e) {
            throw new ArgException("Invalid argument (%s) for argument %s", argValue, argName);
        }
        return val;
    }

    private <T extends Enum<T>> T getEnumValue(Class<T> enumType, String name) {
        Enum[] constants = (Enum[])enumType.getEnumConstants();
        if (constants == null) {
            throw new IllegalArgumentException(enumType.getName() + " is not an enum type");
        }
        for (Enum constant : constants) {
            if (!constant.name().equalsIgnoreCase(name.replace('-', '_'))) continue;
            return (T)constant;
        }
        throw new IllegalArgumentException("No enum constant " + enumType.getCanonicalName() + "." + name);
    }

    private static String typeShortName(Class<?> type) {
        if (type.isPrimitive()) {
            return type.getName();
        }
        if (type == File.class) {
            return "filename";
        }
        if (type == Pattern.class) {
            return "regex";
        }
        if (type.isEnum()) {
            return "enum";
        }
        return type.getSimpleName().toLowerCase();
    }

    private String getOptionsString() {
        return this.optionsString;
    }

    public String settings() {
        return this.settings(false);
    }

    public String settings(boolean showUnpublicized) {
        StringBuilderDelimited out = new StringBuilderDelimited(lineSeparator);
        int maxLength = this.maxOptionLength(this.options, showUnpublicized);
        for (OptionInfo oi : this.options) {
            String use = String.format("%-" + maxLength + "s = ", oi.longName);
            try {
                use = use + oi.field.get(oi.obj);
            }
            catch (Exception e) {
                throw new Error("unexpected exception reading field " + oi.field, e);
            }
            out.add(use);
        }
        return out.toString();
    }

    @SideEffectFree
    public String toString(@GuardSatisfied Options this) {
        StringBuilderDelimited out = new StringBuilderDelimited(lineSeparator);
        for (OptionInfo oi : this.options) {
            out.add(oi.toString());
        }
        return out.toString();
    }

    private static ParseResult parseOption(String val) {
        String typeName;
        String description;
        String shortName;
        if (val.startsWith("-")) {
            if (val.length() < 4 || !val.substring(2, 3).equals(" ")) {
                throw new Error("Malformed @Option argument \"" + val + "\".  An argument that starts with '-' should contain a short name, a space, and a description.");
            }
            shortName = val.substring(1, 2);
            description = val.substring(3);
        } else {
            shortName = null;
            description = val;
        }
        if (description.startsWith("<")) {
            typeName = description.substring(1).replaceFirst(">.*", "");
            description = description.replaceFirst("<.*> ", "");
        } else {
            typeName = null;
        }
        return new ParseResult(shortName, typeName, description);
    }

    private static <K extends Comparable<? super K>, V> Collection<@KeyFor(value={"#1"}) K> sortedKeySet(Map<K, V> m3) {
        ArrayList<@KeyFor(value={"#1"}) K> theKeys = new ArrayList<K>(m3.keySet());
        Collections.sort(theKeys);
        return theKeys;
    }

    private static class ParseResult {
        @Nullable String shortName;
        @Nullable String typeName;
        String description;

        ParseResult(@Nullable String shortName, @Nullable String typeName, String description) {
            this.shortName = shortName;
            this.typeName = typeName;
            this.description = description;
        }
    }

    public static class ArgException
    extends Exception {
        static final long serialVersionUID = 20051223L;

        public ArgException(String s2) {
            super(s2);
        }

        @FormatMethod
        public ArgException(String format, Object ... args) {
            super(String.format(format, args));
        }
    }

    static class OptionGroupInfo {
        String name;
        boolean unpublicized;
        List<OptionInfo> optionList = new ArrayList<OptionInfo>();

        OptionGroupInfo(String name, boolean unpublicized) {
            this.name = name;
            this.unpublicized = unpublicized;
        }

        OptionGroupInfo(OptionGroup optionGroup) {
            this.name = optionGroup.value();
            this.unpublicized = optionGroup.unpublicized();
        }

        boolean anyPublicized() {
            for (OptionInfo oi : this.optionList) {
                if (oi.unpublicized) continue;
                return true;
            }
            return false;
        }
    }

    class OptionInfo {
        Field field;
        @UnknownInitialization @Raw @Nullable Object obj;
        @Nullable String shortName;
        String longName;
        String[] aliases;
        String description;
        @Nullable String jdoc;
        @MonotonicNonNull Map<String, String> enumJdoc;
        String typeName;
        Class<?> baseType;
        @Nullable String defaultStr = null;
        boolean noDocDefault = false;
        @MonotonicNonNull List<Object> list = null;
        @Nullable Constructor<?> constructor = null;
        @Nullable Method factory = null;
        boolean unpublicized;

        OptionInfo(Field field, @UnknownInitialization @Raw @Nullable Option option, Object obj, boolean unpublicized) {
            ParseResult pr;
            this.field = field;
            this.obj = obj;
            this.baseType = field.getType();
            this.unpublicized = unpublicized;
            this.aliases = option.aliases();
            this.noDocDefault = option.noDocDefault();
            this.longName = field.getName();
            if (Options.this.useDashes) {
                this.longName = this.longName.replace('_', '-');
            }
            ArrayList defaultObj = null;
            if (!Modifier.isPublic(field.getModifiers())) {
                throw new Error("option field is not public: " + field);
            }
            try {
                defaultObj = field.get(obj);
                if (defaultObj != null) {
                    this.defaultStr = ((Object)defaultObj).toString();
                }
            }
            catch (Exception e) {
                throw new Error("Unexpected error getting default for " + field, e);
            }
            if (field.getType().isArray()) {
                throw new Error("@Option may not annotate a variable of array type: " + field);
            }
            Type genType = field.getGenericType();
            if (genType instanceof ParameterizedType) {
                List defaultObjAsList;
                ParameterizedType pt = (ParameterizedType)genType;
                Type rawType = pt.getRawType();
                if (!rawType.equals(List.class)) {
                    throw new Error("@Option supports List<...> but no other parameterized type; it does not support type " + pt + " for field " + field);
                }
                if (defaultObj == null) {
                    ArrayList newList = new ArrayList();
                    try {
                        field.set(obj, newList);
                    }
                    catch (Exception e) {
                        throw new Error("Unexpected error setting default for " + field, e);
                    }
                    defaultObj = newList;
                }
                if (((List)defaultObj).isEmpty()) {
                    this.defaultStr = null;
                }
                this.list = defaultObjAsList = (List)defaultObj;
                Type[] listTypeArgs = pt.getActualTypeArguments();
                this.baseType = listTypeArgs.length == 0 ? Object.class : listTypeArgs[0];
            }
            try {
                pr = Options.parseOption(option.value());
            }
            catch (Throwable e) {
                throw new Error("Error while processing @Option(\"" + option.value() + "\") on '" + field + "'", e);
            }
            this.shortName = pr.shortName;
            this.typeName = pr.typeName != null ? pr.typeName : Options.typeShortName(this.baseType);
            this.description = pr.description;
            if (!this.baseType.isPrimitive() && !this.baseType.isEnum()) {
                try {
                    if (this.baseType == Pattern.class) {
                        this.factory = Pattern.class.getMethod("compile", String.class);
                    } else {
                        this.constructor = this.baseType.getConstructor(String.class);
                    }
                }
                catch (Exception e) {
                    throw new Error("@Option does not support type " + this.baseType + " for field " + field + " because it does not have a string constructor", e);
                }
            }
        }

        public boolean argumentRequired() {
            Class<?> type = this.field.getType();
            return type != Boolean.TYPE && type != Boolean.class;
        }

        public String synopsis() {
            String prefix = Options.this.useSingleDash ? "-" : "--";
            String name = prefix + this.longName;
            if (this.shortName != null) {
                name = String.format("-%s %s", this.shortName, name);
            }
            name = name + String.format("=<%s>", this.typeName);
            if (this.list != null) {
                name = name + " [+]";
            }
            return name;
        }

        @SideEffectFree
        public String toString(@GuardSatisfied OptionInfo this) {
            String prefix = Options.this.useSingleDash ? "-" : "--";
            String shortNameStr = "";
            if (this.shortName != null) {
                shortNameStr = "-" + this.shortName + " ";
            }
            return String.format("%s%s%s field %s", shortNameStr, prefix, this.longName, this.field);
        }

        public Class<?> getDeclaringClass() {
            return this.field.getDeclaringClass();
        }
    }
}

