/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.util.dependenttypes;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.util.FlowExpressionParseUtil;

public class DependentTypesError {
    private static final String formatString = "[error for expression: %s; error: %s]";
    private static final Pattern errorPattern = Pattern.compile("\\[error for expression: (.*); error: (.*)\\]");
    public final String expression;
    public final String error;

    public static boolean isExpressionError(String expression) {
        return expression.startsWith("[error");
    }

    public DependentTypesError(String expression, String error) {
        this.expression = expression;
        this.error = error;
    }

    public DependentTypesError(String expression, FlowExpressionParseUtil.FlowExpressionParseException e) {
        StringBuilder buf = new StringBuilder();
        List<Result.DiagMessage> msgs = e.getResult().getDiagMessages();
        for (Result.DiagMessage msg : msgs) {
            buf.append(msg.getArgs()[0]);
        }
        this.error = buf.toString();
        this.expression = expression;
    }

    public DependentTypesError(String error) {
        Matcher matcher = errorPattern.matcher(error);
        if (matcher.matches()) {
            assert (matcher.groupCount() == 2);
            this.expression = matcher.group(1);
            this.error = matcher.group(2);
        } else {
            this.expression = "";
            this.error = error;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependentTypesError that = (DependentTypesError)o;
        return this.expression.equals(that.expression) && this.error.equals(that.error);
    }

    public int hashCode() {
        int result = this.expression.hashCode();
        result = 31 * result + this.error.hashCode();
        return result;
    }

    public String toString() {
        return String.format(formatString, this.expression, this.error);
    }
}

