/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.inequality;

import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.IndexAbstractTransfer;
import org.checkerframework.checker.index.inequality.LessThanAnnotatedTypeFactory;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.framework.flow.CFAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.javacutil.AnnotationProvider;

public class LessThanTransfer
extends IndexAbstractTransfer {
    public LessThanTransfer(CFAnalysis analysis) {
        super(analysis);
    }

    @Override
    protected void refineGT(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store, TransferInput<CFValue, CFStore> in) {
        LessThanAnnotatedTypeFactory factory = (LessThanAnnotatedTypeFactory)this.analysis.getTypeFactory();
        FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf((AnnotationProvider)factory, left);
        if (leftRec != null && leftRec.isUnmodifiableByOtherCode()) {
            List<String> lessThanExpressions = LessThanAnnotatedTypeFactory.getLessThanExpressions(rightAnno);
            if (lessThanExpressions == null) {
                return;
            }
            lessThanExpressions.add(leftRec.toString());
            FlowExpressions.Receiver rightRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), right);
            store.insertValue(rightRec, factory.createLessThanQualifier(lessThanExpressions));
        }
    }

    @Override
    protected void refineGTE(Node left, AnnotationMirror leftAnno, Node right, AnnotationMirror rightAnno, CFStore store, TransferInput<CFValue, CFStore> in) {
        LessThanAnnotatedTypeFactory factory = (LessThanAnnotatedTypeFactory)this.analysis.getTypeFactory();
        FlowExpressions.Receiver leftRec = FlowExpressions.internalReprOf((AnnotationProvider)factory, left);
        if (leftRec != null && leftRec.isUnmodifiableByOtherCode()) {
            List<String> lessThanExpressions = LessThanAnnotatedTypeFactory.getLessThanExpressions(rightAnno);
            if (lessThanExpressions == null) {
                return;
            }
            lessThanExpressions.add(leftRec.toString() + " + 1");
            FlowExpressions.Receiver rightRec = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), right);
            store.insertValue(rightRec, factory.createLessThanQualifier(lessThanExpressions));
        }
    }
}

