/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.formatter;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.formatter.FormatterAnnotatedTypeFactory;
import org.checkerframework.checker.formatter.FormatterTreeUtil;
import org.checkerframework.checker.formatter.qual.ConversionCategory;
import org.checkerframework.checker.formatter.qual.FormatMethod;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class FormatterVisitor
extends BaseTypeVisitor<FormatterAnnotatedTypeFactory> {
    public FormatterVisitor(BaseTypeChecker checker) {
        super(checker);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        FormatterTreeUtil tu = ((FormatterAnnotatedTypeFactory)this.atypeFactory).treeUtil;
        if (tu.isFormatCall(node, this.atypeFactory)) {
            FormatterTreeUtil formatterTreeUtil = ((FormatterAnnotatedTypeFactory)this.atypeFactory).treeUtil;
            formatterTreeUtil.getClass();
            FormatterTreeUtil.FormatCall fc = new FormatterTreeUtil.FormatCall(formatterTreeUtil, node, this.atypeFactory);
            FormatterTreeUtil.Result<String> err_missing_format = fc.hasFormatAnnotation();
            if (err_missing_format != null) {
                if (!this.isWrappedFormatCall(fc)) {
                    tu.failure(err_missing_format, "format.string.invalid", err_missing_format.value());
                }
            } else {
                FormatterTreeUtil.Result<FormatterTreeUtil.InvocationType> invc = fc.getInvocationType();
                ConversionCategory[] formatCats = fc.getFormatCategories();
                switch (invc.value()) {
                    case VARARG: {
                        FormatterTreeUtil.Result<TypeMirror>[] paramTypes = fc.getParamTypes();
                        int paraml = paramTypes.length;
                        int formatl = formatCats.length;
                        if (paraml < formatl) {
                            tu.failure(invc, "format.missing.arguments", formatl, paraml);
                            break;
                        }
                        if (paraml > formatl) {
                            tu.warning(invc, "format.excess.arguments", formatl, paraml);
                        }
                        block9: for (int i = 0; i < formatl; ++i) {
                            ConversionCategory formatCat = formatCats[i];
                            FormatterTreeUtil.Result<TypeMirror> param = paramTypes[i];
                            TypeMirror paramType = param.value();
                            switch (formatCat) {
                                case UNUSED: {
                                    tu.warning(param, "format.argument.unused", " " + (1 + i));
                                    continue block9;
                                }
                                case NULL: {
                                    tu.failure(param, "format.specifier.null", " " + (1 + i));
                                    continue block9;
                                }
                                case GENERAL: {
                                    continue block9;
                                }
                                default: {
                                    if (fc.isValidParameter(formatCat, paramType)) continue block9;
                                    tu.failure(param, "argument.type.incompatible", new Object[]{paramType, formatCat});
                                }
                            }
                        }
                        break;
                    }
                    case NULLARRAY: 
                    case ARRAY: {
                        for (ConversionCategory cat : formatCats) {
                            if (cat == ConversionCategory.NULL) {
                                tu.failure(invc, "format.specifier.null", "");
                            }
                            if (cat != ConversionCategory.UNUSED) continue;
                            tu.warning(invc, "format.argument.unused", "");
                        }
                        tu.warning(invc, "format.indirect.arguments", new Object[0]);
                    }
                }
            }
        }
        return super.visitMethodInvocation(node, p);
    }

    private boolean isWrappedFormatCall(FormatterTreeUtil.FormatCall fc) {
        boolean withinFormatMethod;
        MethodTree enclosingMethod = TreeUtils.enclosingMethod(((FormatterAnnotatedTypeFactory)this.atypeFactory).getPath(fc.node));
        if (enclosingMethod == null) {
            return false;
        }
        ExecutableElement enclosingMethodElement = TreeUtils.elementFromDeclaration(enclosingMethod);
        boolean bl = withinFormatMethod = ((FormatterAnnotatedTypeFactory)this.atypeFactory).getDeclAnnotation(enclosingMethodElement, FormatMethod.class) != null;
        if (!withinFormatMethod) {
            return false;
        }
        List<? extends ExpressionTree> args = fc.node.getArguments();
        List<? extends VariableTree> params = enclosingMethod.getParameters();
        List<? extends VariableElement> paramElements = enclosingMethodElement.getParameters();
        if (args.size() > 0 && FormatterTreeUtil.isLocale(args.get(0), this.atypeFactory)) {
            args = args.subList(1, args.size());
        }
        if (params.size() > 0 && TypesUtils.isDeclaredOfName(paramElements.get(0).asType(), "java.util.Locale")) {
            params = params.subList(1, params.size());
        }
        if (args.size() == params.size()) {
            for (int i = 0; i < args.size(); ++i) {
                ExpressionTree arg = args.get(i);
                if (arg instanceof IdentifierTree && ((IdentifierTree)arg).getName().equals(params.get(i).getName())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected void commonAssignmentCheck(AnnotatedTypeMirror varType, AnnotatedTypeMirror valueType, Tree valueTree, @CompilerMessageKey String errorKey) {
        ConversionCategory[] lhsArgTypes;
        ConversionCategory[] rhsArgTypes;
        super.commonAssignmentCheck(varType, valueType, valueTree, errorKey);
        AnnotationMirror rhs = valueType.getAnnotationInHierarchy(((FormatterAnnotatedTypeFactory)this.atypeFactory).UNKNOWNFORMAT);
        AnnotationMirror lhs = varType.getAnnotationInHierarchy(((FormatterAnnotatedTypeFactory)this.atypeFactory).UNKNOWNFORMAT);
        if (AnnotationUtils.areSameIgnoringValues(rhs, ((FormatterAnnotatedTypeFactory)this.atypeFactory).FORMAT) && AnnotationUtils.areSameIgnoringValues(lhs, ((FormatterAnnotatedTypeFactory)this.atypeFactory).FORMAT) && (rhsArgTypes = ((FormatterAnnotatedTypeFactory)this.atypeFactory).treeUtil.formatAnnotationToCategories(rhs)).length < (lhsArgTypes = ((FormatterAnnotatedTypeFactory)this.atypeFactory).treeUtil.formatAnnotationToCategories(lhs)).length) {
            this.checker.report(Result.warning("format.missing.arguments", varType.toString(), valueType.toString()), valueTree);
        }
    }
}

