/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.ConstantPool;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.DescriptorException;
import com.sun.tools.classfile.Instruction;
import com.sun.tools.classfile.Method;
import com.sun.tools.javap.AttributeWriter;
import com.sun.tools.javap.BasicWriter;
import com.sun.tools.javap.ClassWriter;
import com.sun.tools.javap.ConstantWriter;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.InstructionDetailWriter;
import com.sun.tools.javap.LocalVariableTableWriter;
import com.sun.tools.javap.LocalVariableTypeTableWriter;
import com.sun.tools.javap.Options;
import com.sun.tools.javap.SourceWriter;
import com.sun.tools.javap.StackMapWriter;
import com.sun.tools.javap.TryBlockWriter;
import java.util.ArrayList;
import java.util.List;

class CodeWriter
extends BasicWriter {
    Instruction.KindVisitor<Void, Integer> instructionPrinter = new Instruction.KindVisitor<Void, Integer>(){

        @Override
        public Void visitNoOperands(Instruction instruction, Integer n) {
            return null;
        }

        @Override
        public Void visitArrayType(Instruction instruction, Instruction.TypeKind typeKind, Integer n) {
            CodeWriter.this.print(" " + typeKind.name);
            return null;
        }

        @Override
        public Void visitBranch(Instruction instruction, int n, Integer n2) {
            CodeWriter.this.print(instruction.getPC() + n);
            return null;
        }

        @Override
        public Void visitConstantPoolRef(Instruction instruction, int n, Integer n2) {
            CodeWriter.this.print("#" + n);
            CodeWriter.this.tab();
            CodeWriter.this.print("// ");
            CodeWriter.this.printConstant(n);
            return null;
        }

        @Override
        public Void visitConstantPoolRefAndValue(Instruction instruction, int n, int n2, Integer n3) {
            CodeWriter.this.print("#" + n + ",  " + n2);
            CodeWriter.this.tab();
            CodeWriter.this.print("// ");
            CodeWriter.this.printConstant(n);
            return null;
        }

        @Override
        public Void visitLocal(Instruction instruction, int n, Integer n2) {
            CodeWriter.this.print(n);
            return null;
        }

        @Override
        public Void visitLocalAndValue(Instruction instruction, int n, int n2, Integer n3) {
            CodeWriter.this.print(n + ", " + n2);
            return null;
        }

        @Override
        public Void visitLookupSwitch(Instruction instruction, int n, int n2, int[] nArray, int[] nArray2, Integer n3) {
            int n4 = instruction.getPC();
            CodeWriter.this.print("{ // " + n2);
            CodeWriter.this.indent(n3);
            for (int i = 0; i < n2; ++i) {
                CodeWriter.this.print(String.format("%n%12d: %d", nArray[i], n4 + nArray2[i]));
            }
            CodeWriter.this.print("\n     default: " + (n4 + n) + "\n}");
            CodeWriter.this.indent(-n3.intValue());
            return null;
        }

        @Override
        public Void visitTableSwitch(Instruction instruction, int n, int n2, int n3, int[] nArray, Integer n4) {
            int n5 = instruction.getPC();
            CodeWriter.this.print("{ // " + n2 + " to " + n3);
            CodeWriter.this.indent(n4);
            for (int i = 0; i < nArray.length; ++i) {
                CodeWriter.this.print(String.format("%n%12d: %d", n2 + i, n5 + nArray[i]));
            }
            CodeWriter.this.print("\n     default: " + (n5 + n) + "\n}");
            CodeWriter.this.indent(-n4.intValue());
            return null;
        }

        @Override
        public Void visitValue(Instruction instruction, int n, Integer n2) {
            CodeWriter.this.print(n);
            return null;
        }

        @Override
        public Void visitUnknown(Instruction instruction, Integer n) {
            return null;
        }
    };
    private AttributeWriter attrWriter;
    private ClassWriter classWriter;
    private ConstantWriter constantWriter;
    private LocalVariableTableWriter localVariableTableWriter;
    private LocalVariableTypeTableWriter localVariableTypeTableWriter;
    private SourceWriter sourceWriter;
    private StackMapWriter stackMapWriter;
    private TryBlockWriter tryBlockWriter;
    private Options options;

    static CodeWriter instance(Context context) {
        CodeWriter codeWriter = context.get(CodeWriter.class);
        if (codeWriter == null) {
            codeWriter = new CodeWriter(context);
        }
        return codeWriter;
    }

    protected CodeWriter(Context context) {
        super(context);
        context.put(CodeWriter.class, this);
        this.attrWriter = AttributeWriter.instance(context);
        this.classWriter = ClassWriter.instance(context);
        this.constantWriter = ConstantWriter.instance(context);
        this.sourceWriter = SourceWriter.instance(context);
        this.tryBlockWriter = TryBlockWriter.instance(context);
        this.stackMapWriter = StackMapWriter.instance(context);
        this.localVariableTableWriter = LocalVariableTableWriter.instance(context);
        this.localVariableTypeTableWriter = LocalVariableTypeTableWriter.instance(context);
        this.options = Options.instance(context);
    }

    void write(Code_attribute code_attribute, ConstantPool constantPool) {
        this.println("Code:");
        this.indent(1);
        this.writeVerboseHeader(code_attribute, constantPool);
        this.writeInstrs(code_attribute);
        this.writeExceptionTable(code_attribute);
        this.attrWriter.write((Object)code_attribute, code_attribute.attributes, constantPool);
        this.indent(-1);
    }

    public void writeVerboseHeader(Code_attribute code_attribute, ConstantPool constantPool) {
        String string;
        Method method = this.classWriter.getMethod();
        try {
            int n = method.descriptor.getParameterCount(constantPool);
            if (!method.access_flags.is(8)) {
                ++n;
            }
            string = Integer.toString(n);
        }
        catch (ConstantPoolException constantPoolException) {
            string = this.report(constantPoolException);
        }
        catch (DescriptorException descriptorException) {
            string = this.report(descriptorException);
        }
        this.println("stack=" + code_attribute.max_stack + ", locals=" + code_attribute.max_locals + ", args_size=" + string);
    }

    public void writeInstrs(Code_attribute code_attribute) {
        List<InstructionDetailWriter> list = this.getDetailWriters(code_attribute);
        for (Instruction object : code_attribute.getInstructions()) {
            try {
                for (InstructionDetailWriter instructionDetailWriter : list) {
                    instructionDetailWriter.writeDetails(object);
                }
                this.writeInstr(object);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.println(this.report("error at or after byte " + object.getPC()));
                break;
            }
        }
        for (InstructionDetailWriter instructionDetailWriter : list) {
            instructionDetailWriter.flush();
        }
    }

    public void writeInstr(Instruction instruction) {
        this.print(String.format("%4d: %-13s ", instruction.getPC(), instruction.getMnemonic()));
        int n = this.options.indentWidth;
        int n2 = (6 + n - 1) / n;
        instruction.accept(this.instructionPrinter, n2);
        this.println();
    }

    public void writeExceptionTable(Code_attribute code_attribute) {
        if (code_attribute.exception_table_langth > 0) {
            this.println("Exception table:");
            this.indent(1);
            this.println(" from    to  target type");
            for (int i = 0; i < code_attribute.exception_table.length; ++i) {
                Code_attribute.Exception_data exception_data = code_attribute.exception_table[i];
                this.print(String.format(" %5d %5d %5d", exception_data.start_pc, exception_data.end_pc, exception_data.handler_pc));
                this.print("   ");
                int n = exception_data.catch_type;
                if (n == 0) {
                    this.println("any");
                    continue;
                }
                this.print("Class ");
                this.println(this.constantWriter.stringValue(n));
            }
            this.indent(-1);
        }
    }

    private void printConstant(int n) {
        this.constantWriter.write(n);
    }

    private List<InstructionDetailWriter> getDetailWriters(Code_attribute code_attribute) {
        ArrayList<InstructionDetailWriter> arrayList = new ArrayList<InstructionDetailWriter>();
        if (this.options.details.contains((Object)InstructionDetailWriter.Kind.SOURCE)) {
            this.sourceWriter.reset(this.classWriter.getClassFile(), code_attribute);
            if (this.sourceWriter.hasSource()) {
                arrayList.add(this.sourceWriter);
            } else {
                this.println("(Source code not available)");
            }
        }
        if (this.options.details.contains((Object)InstructionDetailWriter.Kind.LOCAL_VARS)) {
            this.localVariableTableWriter.reset(code_attribute);
            arrayList.add(this.localVariableTableWriter);
        }
        if (this.options.details.contains((Object)InstructionDetailWriter.Kind.LOCAL_VAR_TYPES)) {
            this.localVariableTypeTableWriter.reset(code_attribute);
            arrayList.add(this.localVariableTypeTableWriter);
        }
        if (this.options.details.contains((Object)InstructionDetailWriter.Kind.STACKMAPS)) {
            this.stackMapWriter.reset(code_attribute);
            this.stackMapWriter.writeInitialDetails();
            arrayList.add(this.stackMapWriter);
        }
        if (this.options.details.contains((Object)InstructionDetailWriter.Kind.TRY_BLOCKS)) {
            this.tryBlockWriter.reset(code_attribute);
            arrayList.add(this.tryBlockWriter);
        }
        return arrayList;
    }
}

