/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.regex;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.EnsuresQualifierIf;
import org.checkerframework.framework.qual.EnsuresQualifiersIf;

public class RegexUtil {
    private RegexUtil() {
        throw new AssertionError((Object)"Class RegexUtil shouldn't be instantiated");
    }

    @Pure
    @EnsuresQualifiersIf(value={@EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)})
    public static boolean isRegex(String s2) {
        return RegexUtil.isRegex(s2, 0);
    }

    @Pure
    public static boolean isRegex(String s2, int groups) {
        Pattern p;
        try {
            p = Pattern.compile(s2);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return RegexUtil.getGroupCount(p) >= groups;
    }

    @Pure
    @EnsuresQualifiersIf(value={@EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)})
    public static boolean isRegex(char c) {
        return RegexUtil.isRegex(Character.toString(c));
    }

    @SideEffectFree
    public static @Nullable String regexError(String s2) {
        return RegexUtil.regexError(s2, 0);
    }

    @SideEffectFree
    public static @Nullable String regexError(String s2, int groups) {
        try {
            Pattern p = Pattern.compile(s2);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups) {
                return RegexUtil.regexErrorMessage(s2, groups, actualGroups);
            }
        }
        catch (PatternSyntaxException e) {
            return e.getMessage();
        }
        return null;
    }

    @SideEffectFree
    public static @Nullable PatternSyntaxException regexException(String s2) {
        return RegexUtil.regexException(s2, 0);
    }

    @SideEffectFree
    public static @Nullable PatternSyntaxException regexException(String s2, int groups) {
        try {
            Pattern p = Pattern.compile(s2);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups) {
                return new PatternSyntaxException(RegexUtil.regexErrorMessage(s2, groups, actualGroups), s2, -1);
            }
        }
        catch (PatternSyntaxException pse) {
            return pse;
        }
        return null;
    }

    @SideEffectFree
    public static @Regex String asRegex(String s2) {
        return RegexUtil.asRegex(s2, 0);
    }

    @SideEffectFree
    public static @Regex String asRegex(String s2, int groups) {
        try {
            Pattern p = Pattern.compile(s2);
            int actualGroups = RegexUtil.getGroupCount(p);
            if (actualGroups < groups) {
                throw new Error(RegexUtil.regexErrorMessage(s2, groups, actualGroups));
            }
            return s2;
        }
        catch (PatternSyntaxException e) {
            throw new Error(e);
        }
    }

    private static String regexErrorMessage(String s2, int expectedGroups, int actualGroups) {
        return "regex \"" + s2 + "\" has " + actualGroups + " groups, but " + expectedGroups + " groups are needed.";
    }

    @Pure
    private static int getGroupCount(Pattern p) {
        return p.matcher("").groupCount();
    }

    public static class CheckedPatternSyntaxException
    extends Exception {
        private static final long serialVersionUID = 6266881831979001480L;
        private final PatternSyntaxException pse;

        public CheckedPatternSyntaxException(PatternSyntaxException pse) {
            this.pse = pse;
        }

        public CheckedPatternSyntaxException(String desc, String regex, int index) {
            this(new PatternSyntaxException(desc, regex, index));
        }

        public String getDescription() {
            return this.pse.getDescription();
        }

        public int getIndex() {
            return this.pse.getIndex();
        }

        @Override
        public String getMessage() {
            return this.pse.getMessage();
        }

        public String getPattern() {
            return this.pse.getPattern();
        }
    }
}

