/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractSet;
import java.util.Map;
import org.checkerframework.checker.index.qual.LessThanBottom;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundBottom;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenBottom;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexBottom;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.FBCBottom;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

final class EdgesConnecting<@KeyForBottom E>
extends AbstractSet<E> {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Map<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanUnknown @LessThanBottom @LowerBoundBottom @UpperBoundBottom @SubstringIndexUnknown @BottomVal @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ?, E> nodeToOutEdge;
    private final @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Object targetNode;

    EdgesConnecting(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Map<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanUnknown @LessThanBottom @LowerBoundBottom @UpperBoundBottom @SubstringIndexUnknown @BottomVal @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ?, E> nodeToEdgeMap, @KeyForBottom @NonNull @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Object targetNode) {
        this.nodeToOutEdge = Preconditions.checkNotNull(nodeToEdgeMap);
        this.targetNode = Preconditions.checkNotNull(targetNode);
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @Nullable @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown UnmodifiableIterator<E> iterator() {
        E connectingEdge = this.getConnectingEdge();
        return connectingEdge == null ? ImmutableSet.of().iterator() : Iterators.singletonIterator(connectingEdge);
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown int size() {
        return this.getConnectingEdge() == null ? 0 : 1;
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @UnknownInitialization @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown boolean contains(@Nullable @KeyForBottom @FBCBottom @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Object edge) {
        E connectingEdge = this.getConnectingEdge();
        return connectingEdge != null && connectingEdge.equals(edge);
    }

    private @Nullable E getConnectingEdge() {
        return this.nodeToOutEdge.get(this.targetNode);
    }
}

