/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultisetGwtSerializationDependencies;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.IndexedImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.JdkBackedImmutableMultiset;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.RegularImmutableMultiset;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;
import org.checkerframework.checker.index.qual.LessThanBottom;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundBottom;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenBottom;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexBottom;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundBottom;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.common.value.qual.BottomVal;
import org.checkerframework.common.value.qual.UnknownVal;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableMultiset<@UnknownKeyFor E>
extends ImmutableMultisetGwtSerializationDependencies<E>
implements Multiset<E> {
    @LazyInit
    private transient @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableList<E> asList;
    @LazyInit
    private transient @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableSet<@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Multiset.Entry<E>> entrySet;

    public static <E> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Collector<E, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanUnknown @LessThanBottom @LowerBoundBottom @UpperBoundBottom @SubstringIndexUnknown @BottomVal @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ?, @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E>> toImmutableMultiset() {
        return ImmutableMultiset.toImmutableMultiset(Function.identity(), e -> 1);
    }

    public static <T, E> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Collector<T, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanUnknown @LessThanBottom @LowerBoundBottom @UpperBoundBottom @SubstringIndexUnknown @BottomVal @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ?, @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E>> toImmutableMultiset(@UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Function<@UnknownKeyFor @Nullable @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ? super T, @KeyForBottom @NonNull @Initialized @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @BottomVal ? extends E> elementFunction, @UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom ToIntFunction<@UnknownKeyFor @Nullable @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ? super T> countFunction) {
        Preconditions.checkNotNull(elementFunction);
        Preconditions.checkNotNull(countFunction);
        return Collector.of(LinkedHashMultiset::create, (multiset, t) -> multiset.add(Preconditions.checkNotNull(elementFunction.apply(t)), countFunction.applyAsInt(t)), (multiset1, multiset2) -> {
            multiset1.addAll(multiset2);
            return multiset1;
        }, multiset -> ImmutableMultiset.copyFromEntries(multiset.entrySet()), new Collector.Characteristics[0]);
    }

    public static <E> @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E> of() {
        return RegularImmutableMultiset.EMPTY;
    }

    public static <E> @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E> of(E element) {
        return ImmutableMultiset.copyFromElements(element);
    }

    public static <E> @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E> of(E e1, E e2) {
        return ImmutableMultiset.copyFromElements(e1, e2);
    }

    public static <E> @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E> of(E e1, E e2, E e3) {
        return ImmutableMultiset.copyFromElements(e1, e2, e3);
    }

    public static <E> @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E> of(E e1, E e2, E e3, E e4) {
        return ImmutableMultiset.copyFromElements(e1, e2, e3, e4);
    }

    public static <E> @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E> of(E e1, E e2, E e3, E e4, E e5) {
        return ImmutableMultiset.copyFromElements(e1, e2, e3, e4, e5);
    }

    public static <E> @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... others) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().add((Object)e1)).add((Object)e2)).add((Object)e3)).add((Object)e4)).add((Object)e5)).add((Object)e6)).add((Object[])others)).build();
    }

    public static <E> @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E> copyOf(E @UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom [] elements) {
        return ImmutableMultiset.copyFromElements(elements);
    }

    public static <E> @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E> copyOf(@UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Iterable<@KeyForBottom @NonNull @Initialized @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @BottomVal ? extends E> elements) {
        ImmutableMultiset result;
        if (elements instanceof ImmutableMultiset && !(result = (ImmutableMultiset)elements).isPartialView()) {
            return result;
        }
        Multiset<E> multiset = elements instanceof Multiset ? Multisets.cast(elements) : LinkedHashMultiset.create(elements);
        return ImmutableMultiset.copyFromEntries(multiset.entrySet());
    }

    public static <E> @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E> copyOf(@UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Iterator<@KeyForBottom @NonNull @Initialized @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @BottomVal ? extends E> elements) {
        LinkedHashMultiset multiset = LinkedHashMultiset.create();
        Iterators.addAll(multiset, elements);
        return ImmutableMultiset.copyFromEntries(multiset.entrySet());
    }

    private static <E> @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E> copyFromElements(E ... elements) {
        LinkedHashMultiset multiset = LinkedHashMultiset.create();
        Collections.addAll(multiset, elements);
        return ImmutableMultiset.copyFromEntries(multiset.entrySet());
    }

    static <E> @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E> copyFromEntries(@UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Collection<@KeyForBottom @NonNull @Initialized @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @BottomVal ? extends @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Multiset.Entry<@UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @BottomVal ? extends E>> entries) {
        if (entries.isEmpty()) {
            return ImmutableMultiset.of();
        }
        return RegularImmutableMultiset.create(entries);
    }

    ImmutableMultiset() {
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown UnmodifiableIterator<E> iterator() {
        final Iterator entryIterator = ((ImmutableSet)this.entrySet()).iterator();
        return new UnmodifiableIterator<E>(){
            @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown int remaining;
            @MonotonicNonNull E element;

            @Override
            public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown boolean hasNext() {
                return this.remaining > 0 || entryIterator.hasNext();
            }

            @Override
            public E next() {
                if (this.remaining <= 0) {
                    Multiset.Entry entry = (Multiset.Entry)entryIterator.next();
                    this.element = entry.getElement();
                    this.remaining = entry.getCount();
                }
                --this.remaining;
                return this.element;
            }
        };
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableList<E> asList() {
        ImmutableList<E> result = this.asList;
        return result == null ? (this.asList = super.asList()) : result;
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown boolean contains(@Nullable @UnknownKeyFor @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Object object) {
        return this.count(object) > 0;
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown int add(E element, @UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown int remove(@Nullable @UnknownKeyFor @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Object element, @UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown int setCount(E element, @UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @CanIgnoreReturnValue
    public final @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown boolean setCount(E element, @UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom int oldCount, @UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom int newCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    @GwtIncompatible
    @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown int copyIntoArray(@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Object @UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom [] dst, @UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom int offset) {
        for (Multiset.Entry entry : this.entrySet()) {
            Arrays.fill(dst, offset, offset + entry.getCount(), entry.getElement());
            offset += entry.getCount();
        }
        return offset;
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown boolean equals(@Nullable @UnknownKeyFor @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Object object) {
        return Multisets.equalsImpl(this, object);
    }

    @Override
    @Pure
    public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown int hashCode() {
        return Sets.hashCodeImpl(this.entrySet());
    }

    @Override
    @Pure
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown String toString() {
        return ((AbstractCollection)((Object)this.entrySet())).toString();
    }

    @Override
    public abstract @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableSet<E> elementSet();

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableSet<@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Multiset.Entry<E>> entrySet() {
        ImmutableSet<Multiset.Entry<Multiset.Entry<E>>> es = this.entrySet;
        return es == null ? (this.entrySet = this.createEntrySet()) : es;
    }

    private @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableSet<@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Multiset.Entry<E>> createEntrySet() {
        return this.isEmpty() ? ImmutableSet.of() : new EntrySet();
    }

    abstract @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Multiset.Entry<E> getEntry(@UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom int var1);

    @Override
    @GwtIncompatible
    @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Object writeReplace() {
        return new SerializedForm(this);
    }

    public static <E> @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Builder<E> builder() {
        return new Builder();
    }

    static final class SerializedForm
    implements Serializable {
        final @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Object @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown [] elements;
        final @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown int @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown [] counts;
        private static final @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown long serialVersionUID = 0L;

        SerializedForm(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Multiset<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanUnknown @LessThanBottom @LowerBoundBottom @UpperBoundBottom @SubstringIndexUnknown @BottomVal @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ?> multiset) {
            int distinct = multiset.entrySet().size();
            this.elements = new Object[distinct];
            this.counts = new int[distinct];
            int i = 0;
            for (Multiset.Entry<?> entry : multiset.entrySet()) {
                this.elements[i] = entry.getElement();
                this.counts[i] = entry.getCount();
                ++i;
            }
        }

        @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Object readResolve() {
            LinkedHashMultiset multiset = LinkedHashMultiset.create(this.elements.length);
            for (int i = 0; i < this.elements.length; ++i) {
                multiset.add(this.elements[i], this.counts[i]);
            }
            return ImmutableMultiset.copyOf(multiset);
        }
    }

    static final class ElementSet<@UnknownKeyFor E>
    extends ImmutableSet.Indexed<E> {
        private final @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown List<@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Multiset.Entry<E>> entries;
        private final @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Multiset<E> delegate;

        ElementSet(@UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom List<@UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Multiset.Entry<E>> entries, @UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Multiset<E> delegate) {
            this.entries = entries;
            this.delegate = delegate;
        }

        @Override
        E get(@UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom int index) {
            return this.entries.get(index).getElement();
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown boolean contains(@Nullable @UnknownKeyFor @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Object object) {
            return this.delegate.contains(object);
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown boolean isPartialView() {
            return true;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown int size() {
            return this.entries.size();
        }
    }

    public static class Builder<@UnknownKeyFor E>
    extends ImmutableCollection.Builder<E> {
        final @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Multiset<E> contents;

        public Builder() {
            this(LinkedHashMultiset.create());
        }

        Builder(@UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Multiset<E> contents) {
            this.contents = contents;
        }

        @Override
        @CanIgnoreReturnValue
        public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Builder<E> add(E element) {
            this.contents.add(Preconditions.checkNotNull(element));
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Builder<E> add(E ... elements) {
            super.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Builder<E> addCopies(E element, @UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom int occurrences) {
            this.contents.add(Preconditions.checkNotNull(element), occurrences);
            return this;
        }

        @CanIgnoreReturnValue
        public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Builder<E> setCount(E element, @UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom int count) {
            this.contents.setCount(Preconditions.checkNotNull(element), count);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Builder<E> addAll(@UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Iterable<@KeyForBottom @NonNull @Initialized @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @BottomVal ? extends E> elements) {
            if (elements instanceof Multiset) {
                Multiset<Object> multiset = Multisets.cast(elements);
                multiset.forEachEntry((e, n) -> this.contents.add(Preconditions.checkNotNull(e), n));
            } else {
                super.addAll(elements);
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Builder<E> addAll(@UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Iterator<@KeyForBottom @NonNull @Initialized @SubstringIndexBottom @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @BottomVal ? extends E> elements) {
            super.addAll(elements);
            return this;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E> build() {
            return ImmutableMultiset.copyOf(this.contents);
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E> buildJdkBacked() {
            if (this.contents.isEmpty()) {
                return ImmutableMultiset.of();
            }
            return JdkBackedImmutableMultiset.create(this.contents.entrySet());
        }
    }

    @GwtIncompatible
    static class EntrySetSerializedForm<@UnknownKeyFor E>
    implements Serializable {
        final @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown ImmutableMultiset<E> multiset;

        EntrySetSerializedForm(@UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom ImmutableMultiset<E> multiset) {
            this.multiset = multiset;
        }

        @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Object readResolve() {
            return this.multiset.entrySet();
        }
    }

    private final class EntrySet
    extends IndexedImmutableSet<Multiset.Entry<E>> {
        private static final @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown long serialVersionUID = 0L;

        private EntrySet() {
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown boolean isPartialView() {
            return ImmutableMultiset.this.isPartialView();
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Multiset.Entry<E> get(@UnknownKeyFor @NonNull @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom int index) {
            return ImmutableMultiset.this.getEntry(index);
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown int size() {
            return ((AbstractCollection)((Object)ImmutableMultiset.this.elementSet())).size();
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown boolean contains(@Nullable @UnknownKeyFor @Initialized @SubstringIndexBottom @UnknownVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom Object o) {
            if (o instanceof Multiset.Entry) {
                Multiset.Entry entry = (Multiset.Entry)o;
                if (entry.getCount() <= 0) {
                    return false;
                }
                int count = ImmutableMultiset.this.count(entry.getElement());
                return count == entry.getCount();
            }
            return false;
        }

        @Override
        @Pure
        public @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown int hashCode() {
            return ImmutableMultiset.this.hashCode();
        }

        @Override
        @GwtIncompatible
        @UnknownKeyFor @NonNull @Initialized @UnknownVal @LessThanUnknown @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LowerBoundUnknown @UpperBoundUnknown Object writeReplace() {
            return new EntrySetSerializedForm(ImmutableMultiset.this);
        }
    }
}

