/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.serialization.ClassNameMatcher;
import org.apache.commons.io.serialization.FullClassNameMatcher;
import org.apache.commons.io.serialization.RegexpClassNameMatcher;
import org.apache.commons.io.serialization.WildcardClassNameMatcher;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ValidatingObjectInputStream
extends ObjectInputStream {
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ClassNameMatcher> acceptMatchers = new ArrayList<ClassNameMatcher>();
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ClassNameMatcher> rejectMatchers = new ArrayList<ClassNameMatcher>();

    public ValidatingObjectInputStream(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        super(input);
    }

    private void validateClassName(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized InvalidClassException {
        for (ClassNameMatcher m : this.rejectMatchers) {
            if (!m.matches(name)) continue;
            this.invalidClassNameFound(name);
        }
        boolean ok = false;
        for (ClassNameMatcher m : this.acceptMatchers) {
            if (!m.matches(name)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            this.invalidClassNameFound(name);
        }
    }

    protected void invalidClassNameFound(@UnknownKeyFor @NonNull @Initialized String className) throws @UnknownKeyFor @NonNull @Initialized InvalidClassException {
        throw new InvalidClassException("Class name not accepted: " + className);
    }

    @Override
    protected /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> resolveClass(@UnknownKeyFor @NonNull @Initialized ObjectStreamClass osc) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        this.validateClassName(osc.getName());
        return super.resolveClass(osc);
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatingObjectInputStream accept(Class<?> ... classes) {
        for (Class<?> c : classes) {
            this.acceptMatchers.add(new FullClassNameMatcher(c.getName()));
        }
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatingObjectInputStream reject(Class<?> ... classes) {
        for (Class<?> c : classes) {
            this.rejectMatchers.add(new FullClassNameMatcher(c.getName()));
        }
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatingObjectInputStream accept(String ... patterns) {
        for (String pattern : patterns) {
            this.acceptMatchers.add(new WildcardClassNameMatcher(pattern));
        }
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatingObjectInputStream reject(String ... patterns) {
        for (String pattern : patterns) {
            this.rejectMatchers.add(new WildcardClassNameMatcher(pattern));
        }
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatingObjectInputStream accept(@UnknownKeyFor @NonNull @Initialized Pattern pattern) {
        this.acceptMatchers.add(new RegexpClassNameMatcher(pattern));
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatingObjectInputStream reject(@UnknownKeyFor @NonNull @Initialized Pattern pattern) {
        this.rejectMatchers.add(new RegexpClassNameMatcher(pattern));
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatingObjectInputStream accept(@UnknownKeyFor @NonNull @Initialized ClassNameMatcher m) {
        this.acceptMatchers.add(m);
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized ValidatingObjectInputStream reject(@UnknownKeyFor @NonNull @Initialized ClassNameMatcher m) {
        this.rejectMatchers.add(m);
        return this;
    }
}

