/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class ThresholdingOutputStream
extends OutputStream {
    private final @UnknownKeyFor @NonNull @Initialized int threshold;
    private @UnknownKeyFor @NonNull @Initialized long written;
    private @UnknownKeyFor @NonNull @Initialized boolean thresholdExceeded;

    public ThresholdingOutputStream(@UnknownKeyFor @NonNull @Initialized int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized int b) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.checkThreshold(1);
        this.getStream().write(b);
        ++this.written;
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.checkThreshold(b.length);
        this.getStream().write(b);
        this.written += (long)b.length;
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] b, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.checkThreshold(len);
        this.getStream().write(b, off, len);
        this.written += (long)len;
    }

    @Override
    public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.getStream().flush();
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getStream().close();
    }

    public @UnknownKeyFor @NonNull @Initialized int getThreshold() {
        return this.threshold;
    }

    public @UnknownKeyFor @NonNull @Initialized long getByteCount() {
        return this.written;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isThresholdExceeded() {
        return this.written > (long)this.threshold;
    }

    protected void checkThreshold(@UnknownKeyFor @NonNull @Initialized int count) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (!this.thresholdExceeded && this.written + (long)count > (long)this.threshold) {
            this.thresholdExceeded = true;
            this.thresholdReached();
        }
    }

    protected void resetByteCount() {
        this.thresholdExceeded = false;
        this.written = 0L;
    }

    protected void setByteCount(@UnknownKeyFor @NonNull @Initialized long count) {
        this.written = count;
    }

    protected abstract @UnknownKeyFor @NonNull @Initialized OutputStream getStream() throws @UnknownKeyFor @NonNull @Initialized IOException;

    protected abstract void thresholdReached() throws @UnknownKeyFor @NonNull @Initialized IOException;
}

