/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.Closeable;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.UnknownInitialization;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ProxyWriter
extends FilterWriter {
    public ProxyWriter(@UnknownKeyFor @NonNull @Initialized Writer proxy) {
        super(proxy);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Writer append(@UnknownKeyFor @NonNull @Initialized char c) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeWrite(1);
            this.out.append(c);
            this.afterWrite(1);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Writer append(@Nullable @UnknownKeyFor @Initialized CharSequence csq, @UnknownKeyFor @NonNull @Initialized int start, @UnknownKeyFor @NonNull @Initialized int end) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeWrite(end - start);
            this.out.append(csq, start, end);
            this.afterWrite(end - start);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Writer append(@Nullable @UnknownKeyFor @Initialized CharSequence csq) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            int len = IOUtils.length(csq);
            this.beforeWrite(len);
            this.out.append(csq);
            this.afterWrite(len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
        return this;
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized int c) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeWrite(1);
            this.out.write(c);
            this.afterWrite(1);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] cbuf) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            int len = IOUtils.length(cbuf);
            this.beforeWrite(len);
            this.out.write(cbuf);
            this.afterWrite(len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] cbuf, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeWrite(len);
            this.out.write(cbuf, off, len);
            this.afterWrite(len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized String str) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            int len = IOUtils.length(str);
            this.beforeWrite(len);
            this.out.write(str);
            this.afterWrite(len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void write(@UnknownKeyFor @NonNull @Initialized String str, @UnknownKeyFor @NonNull @Initialized int off, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.beforeWrite(len);
            this.out.write(str, off, len);
            this.afterWrite(len);
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this.handleIOException(e);
        }
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.close((Closeable)this.out, this::handleIOException);
    }

    protected void beforeWrite(@UnknownInitialization @UnknownKeyFor @NonNull int n) throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    protected void afterWrite(@UnknownInitialization @UnknownKeyFor @NonNull int n) throws @UnknownKeyFor @NonNull @Initialized IOException {
    }

    protected void handleIOException(@UnknownKeyFor @NonNull @Initialized IOException e) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw e;
    }
}

