/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.io.input.XmlStreamReaderException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.initialization.qual.UnderInitialization;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class XmlStreamReader
extends Reader {
    private static final @UnknownKeyFor @NonNull @Initialized int BUFFER_SIZE = 8192;
    private static final @UnknownKeyFor @NonNull @Initialized String UTF_8 = "UTF-8";
    private static final @UnknownKeyFor @NonNull @Initialized String US_ASCII = "US-ASCII";
    private static final @UnknownKeyFor @NonNull @Initialized String UTF_16BE = "UTF-16BE";
    private static final @UnknownKeyFor @NonNull @Initialized String UTF_16LE = "UTF-16LE";
    private static final @UnknownKeyFor @NonNull @Initialized String UTF_32BE = "UTF-32BE";
    private static final @UnknownKeyFor @NonNull @Initialized String UTF_32LE = "UTF-32LE";
    private static final @UnknownKeyFor @NonNull @Initialized String UTF_16 = "UTF-16";
    private static final @UnknownKeyFor @NonNull @Initialized String UTF_32 = "UTF-32";
    private static final @UnknownKeyFor @NonNull @Initialized String EBCDIC = "CP1047";
    private static final @UnknownKeyFor @NonNull @Initialized ByteOrderMark @UnknownKeyFor @NonNull @Initialized [] BOMS = new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE};
    private static final @UnknownKeyFor @NonNull @Initialized ByteOrderMark @UnknownKeyFor @NonNull @Initialized [] XML_GUESS_BYTES = new ByteOrderMark[]{new ByteOrderMark("UTF-8", 60, 63, 120, 109), new ByteOrderMark("UTF-16BE", 0, 60, 0, 63), new ByteOrderMark("UTF-16LE", 60, 0, 63, 0), new ByteOrderMark("UTF-32BE", 0, 0, 0, 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 109), new ByteOrderMark("UTF-32LE", 60, 0, 0, 0, 63, 0, 0, 0, 120, 0, 0, 0, 109, 0, 0, 0), new ByteOrderMark("CP1047", 76, 111, 167, 148)};
    private final @UnknownKeyFor @NonNull @Initialized Reader reader;
    private final @UnknownKeyFor @NonNull @Initialized String encoding;
    private final @Nullable @UnknownKeyFor @Initialized String defaultEncoding;
    private static final @UnknownKeyFor @NonNull @Initialized Pattern CHARSET_PATTERN = Pattern.compile("charset=[\"']?([.[^; \"']]*)[\"']?");
    public static final @UnknownKeyFor @NonNull @Initialized Pattern ENCODING_PATTERN = Pattern.compile("<\\?xml.*encoding[\\s]*=[\\s]*((?:\".[^\"]*\")|(?:'.[^']*'))", 8);
    private static final @UnknownKeyFor @NonNull @Initialized String RAW_EX_1 = "Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch";
    private static final @UnknownKeyFor @NonNull @Initialized String RAW_EX_2 = "Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] unknown BOM";
    private static final @UnknownKeyFor @NonNull @Initialized String HTTP_EX_1 = "Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], BOM must be NULL";
    private static final @UnknownKeyFor @NonNull @Initialized String HTTP_EX_2 = "Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], encoding mismatch";
    private static final @UnknownKeyFor @NonNull @Initialized String HTTP_EX_3 = "Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], Invalid MIME";

    public @Nullable @UnknownKeyFor @Initialized String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public XmlStreamReader(@UnknownKeyFor @NonNull @Initialized File file) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(new FileInputStream(Objects.requireNonNull(file)));
    }

    public XmlStreamReader(@UnknownKeyFor @NonNull @Initialized InputStream inputStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(inputStream, true);
    }

    public XmlStreamReader(@UnknownKeyFor @NonNull @Initialized InputStream inputStream, @UnknownKeyFor @NonNull @Initialized boolean lenient) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(inputStream, lenient, null);
    }

    public XmlStreamReader(@UnknownKeyFor @NonNull @Initialized InputStream inputStream, @UnknownKeyFor @NonNull @Initialized boolean lenient, @Nullable @UnknownKeyFor @Initialized String defaultEncoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Objects.requireNonNull(inputStream, "inputStream");
        this.defaultEncoding = defaultEncoding;
        BOMInputStream bom = new BOMInputStream((InputStream)new BufferedInputStream(inputStream, 8192), false, BOMS);
        BOMInputStream pis = new BOMInputStream((InputStream)bom, true, XML_GUESS_BYTES);
        this.encoding = this.doRawStream(bom, pis, lenient);
        this.reader = new InputStreamReader((InputStream)pis, this.encoding);
    }

    public XmlStreamReader(@UnknownKeyFor @NonNull @Initialized URL url) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(Objects.requireNonNull(url, "url").openConnection(), null);
    }

    public XmlStreamReader(@UnknownKeyFor @NonNull @Initialized URLConnection conn, @Nullable @UnknownKeyFor @Initialized String defaultEncoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Objects.requireNonNull(conn, "conm");
        this.defaultEncoding = defaultEncoding;
        boolean lenient = true;
        String contentType = conn.getContentType();
        InputStream inputStream = conn.getInputStream();
        BOMInputStream bom = new BOMInputStream((InputStream)new BufferedInputStream(inputStream, 8192), false, BOMS);
        BOMInputStream pis = new BOMInputStream((InputStream)bom, true, XML_GUESS_BYTES);
        this.encoding = conn instanceof HttpURLConnection || contentType != null ? this.processHttpStream(bom, pis, contentType, true) : this.doRawStream(bom, pis, true);
        this.reader = new InputStreamReader((InputStream)pis, this.encoding);
    }

    public XmlStreamReader(@UnknownKeyFor @NonNull @Initialized InputStream inputStream, @Nullable @UnknownKeyFor @Initialized String httpContentType) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(inputStream, httpContentType, true);
    }

    public XmlStreamReader(@UnknownKeyFor @NonNull @Initialized InputStream inputStream, @Nullable @UnknownKeyFor @Initialized String httpContentType, @UnknownKeyFor @NonNull @Initialized boolean lenient, @Nullable @UnknownKeyFor @Initialized String defaultEncoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        Objects.requireNonNull(inputStream, "inputStream");
        this.defaultEncoding = defaultEncoding;
        BOMInputStream bom = new BOMInputStream((InputStream)new BufferedInputStream(inputStream, 8192), false, BOMS);
        BOMInputStream pis = new BOMInputStream((InputStream)bom, true, XML_GUESS_BYTES);
        this.encoding = this.processHttpStream(bom, pis, httpContentType, lenient);
        this.reader = new InputStreamReader((InputStream)pis, this.encoding);
    }

    public XmlStreamReader(@UnknownKeyFor @NonNull @Initialized InputStream inputStream, @Nullable @UnknownKeyFor @Initialized String httpContentType, @UnknownKeyFor @NonNull @Initialized boolean lenient) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this(inputStream, httpContentType, lenient, null);
    }

    public @UnknownKeyFor @NonNull @Initialized String getEncoding() {
        return this.encoding;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] buf, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int len) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return this.reader.read(buf, offset, len);
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.reader.close();
    }

    private @UnknownKeyFor @NonNull @Initialized String doRawStream(@UnderInitialization(value=Reader.class) XmlStreamReader this, @UnknownKeyFor @NonNull @Initialized BOMInputStream bom, @UnknownKeyFor @NonNull @Initialized BOMInputStream pis, @UnknownKeyFor @NonNull @Initialized boolean lenient) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String bomEnc = bom.getBOMCharsetName();
        String xmlGuessEnc = pis.getBOMCharsetName();
        String xmlEnc = XmlStreamReader.getXmlProlog(pis, xmlGuessEnc);
        try {
            return this.calculateRawEncoding(bomEnc, xmlGuessEnc, xmlEnc);
        }
        catch (XmlStreamReaderException ex) {
            if (lenient) {
                return this.doLenientDetection(null, ex);
            }
            throw ex;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized String processHttpStream(@UnderInitialization(value=Reader.class) XmlStreamReader this, @UnknownKeyFor @NonNull @Initialized BOMInputStream bom, @UnknownKeyFor @NonNull @Initialized BOMInputStream pis, @Nullable @UnknownKeyFor @Initialized String httpContentType, @UnknownKeyFor @NonNull @Initialized boolean lenient) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String bomEnc = bom.getBOMCharsetName();
        String xmlGuessEnc = pis.getBOMCharsetName();
        String xmlEnc = XmlStreamReader.getXmlProlog(pis, xmlGuessEnc);
        try {
            return this.calculateHttpEncoding(httpContentType, bomEnc, xmlGuessEnc, xmlEnc, lenient);
        }
        catch (XmlStreamReaderException ex) {
            if (lenient) {
                return this.doLenientDetection(httpContentType, ex);
            }
            throw ex;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized String doLenientDetection(@UnderInitialization(value=Reader.class) XmlStreamReader this, @Nullable @UnknownKeyFor @Initialized String httpContentType, @UnknownKeyFor @NonNull @Initialized XmlStreamReaderException ex) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String encoding;
        if (httpContentType != null && httpContentType.startsWith("text/html")) {
            httpContentType = httpContentType.substring("text/html".length());
            httpContentType = "text/xml" + httpContentType;
            try {
                return this.calculateHttpEncoding(httpContentType, ex.getBomEncoding(), ex.getXmlGuessEncoding(), ex.getXmlEncoding(), true);
            }
            catch (XmlStreamReaderException ex2) {
                ex = ex2;
            }
        }
        if ((encoding = ex.getXmlEncoding()) == null) {
            encoding = ex.getContentTypeEncoding();
        }
        if (encoding == null) {
            encoding = this.defaultEncoding == null ? UTF_8 : this.defaultEncoding;
        }
        return encoding;
    }

    @UnknownKeyFor @NonNull @Initialized String calculateRawEncoding(@UnderInitialization(value=Reader.class) XmlStreamReader this, @Nullable @UnknownKeyFor @Initialized String bomEnc, @Nullable @UnknownKeyFor @Initialized String xmlGuessEnc, @Nullable @UnknownKeyFor @Initialized String xmlEnc) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (bomEnc == null) {
            if (xmlGuessEnc == null || xmlEnc == null) {
                return this.defaultEncoding == null ? UTF_8 : this.defaultEncoding;
            }
            if (xmlEnc.equals(UTF_16) && (xmlGuessEnc.equals(UTF_16BE) || xmlGuessEnc.equals(UTF_16LE))) {
                return xmlGuessEnc;
            }
            return xmlEnc;
        }
        if (bomEnc.equals(UTF_8)) {
            if (xmlGuessEnc != null && !xmlGuessEnc.equals(UTF_8)) {
                String msg = MessageFormat.format(RAW_EX_1, bomEnc, xmlGuessEnc, xmlEnc);
                throw new XmlStreamReaderException(msg, bomEnc, xmlGuessEnc, xmlEnc);
            }
            if (xmlEnc != null && !xmlEnc.equals(UTF_8)) {
                String msg = MessageFormat.format(RAW_EX_1, bomEnc, xmlGuessEnc, xmlEnc);
                throw new XmlStreamReaderException(msg, bomEnc, xmlGuessEnc, xmlEnc);
            }
            return bomEnc;
        }
        if (bomEnc.equals(UTF_16BE) || bomEnc.equals(UTF_16LE)) {
            if (xmlGuessEnc != null && !xmlGuessEnc.equals(bomEnc)) {
                String msg = MessageFormat.format(RAW_EX_1, bomEnc, xmlGuessEnc, xmlEnc);
                throw new XmlStreamReaderException(msg, bomEnc, xmlGuessEnc, xmlEnc);
            }
            if (xmlEnc != null && !xmlEnc.equals(UTF_16) && !xmlEnc.equals(bomEnc)) {
                String msg = MessageFormat.format(RAW_EX_1, bomEnc, xmlGuessEnc, xmlEnc);
                throw new XmlStreamReaderException(msg, bomEnc, xmlGuessEnc, xmlEnc);
            }
            return bomEnc;
        }
        if (bomEnc.equals(UTF_32BE) || bomEnc.equals(UTF_32LE)) {
            if (xmlGuessEnc != null && !xmlGuessEnc.equals(bomEnc)) {
                String msg = MessageFormat.format(RAW_EX_1, bomEnc, xmlGuessEnc, xmlEnc);
                throw new XmlStreamReaderException(msg, bomEnc, xmlGuessEnc, xmlEnc);
            }
            if (xmlEnc != null && !xmlEnc.equals(UTF_32) && !xmlEnc.equals(bomEnc)) {
                String msg = MessageFormat.format(RAW_EX_1, bomEnc, xmlGuessEnc, xmlEnc);
                throw new XmlStreamReaderException(msg, bomEnc, xmlGuessEnc, xmlEnc);
            }
            return bomEnc;
        }
        String msg = MessageFormat.format(RAW_EX_2, bomEnc, xmlGuessEnc, xmlEnc);
        throw new XmlStreamReaderException(msg, bomEnc, xmlGuessEnc, xmlEnc);
    }

    @UnknownKeyFor @NonNull @Initialized String calculateHttpEncoding(@UnderInitialization(value=Reader.class) XmlStreamReader this, @Nullable @UnknownKeyFor @Initialized String httpContentType, @Nullable @UnknownKeyFor @Initialized String bomEnc, @Nullable @UnknownKeyFor @Initialized String xmlGuessEnc, @Nullable @UnknownKeyFor @Initialized String xmlEnc, @UnknownKeyFor @NonNull @Initialized boolean lenient) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (lenient && xmlEnc != null) {
            return xmlEnc;
        }
        String cTMime = XmlStreamReader.getContentTypeMime(httpContentType);
        String cTEnc = XmlStreamReader.getContentTypeEncoding(httpContentType);
        boolean appXml = XmlStreamReader.isAppXml(cTMime);
        boolean textXml = XmlStreamReader.isTextXml(cTMime);
        if (!appXml && !textXml) {
            String msg = MessageFormat.format(HTTP_EX_3, cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc);
            throw new XmlStreamReaderException(msg, cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc);
        }
        if (cTEnc == null) {
            if (appXml) {
                return this.calculateRawEncoding(bomEnc, xmlGuessEnc, xmlEnc);
            }
            return this.defaultEncoding == null ? US_ASCII : this.defaultEncoding;
        }
        if (cTEnc.equals(UTF_16BE) || cTEnc.equals(UTF_16LE)) {
            if (bomEnc != null) {
                String msg = MessageFormat.format(HTTP_EX_1, cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc);
                throw new XmlStreamReaderException(msg, cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc);
            }
            return cTEnc;
        }
        if (cTEnc.equals(UTF_16)) {
            if (bomEnc != null && bomEnc.startsWith(UTF_16)) {
                return bomEnc;
            }
            String msg = MessageFormat.format(HTTP_EX_2, cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc);
            throw new XmlStreamReaderException(msg, cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc);
        }
        if (cTEnc.equals(UTF_32BE) || cTEnc.equals(UTF_32LE)) {
            if (bomEnc != null) {
                String msg = MessageFormat.format(HTTP_EX_1, cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc);
                throw new XmlStreamReaderException(msg, cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc);
            }
            return cTEnc;
        }
        if (cTEnc.equals(UTF_32)) {
            if (bomEnc != null && bomEnc.startsWith(UTF_32)) {
                return bomEnc;
            }
            String msg = MessageFormat.format(HTTP_EX_2, cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc);
            throw new XmlStreamReaderException(msg, cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc);
        }
        return cTEnc;
    }

    static @Nullable @UnknownKeyFor @Initialized String getContentTypeMime(@Nullable @UnknownKeyFor @Initialized String httpContentType) {
        String mime = null;
        if (httpContentType != null) {
            int i = httpContentType.indexOf(";");
            mime = i >= 0 ? httpContentType.substring(0, i) : httpContentType;
            mime = mime.trim();
        }
        return mime;
    }

    static @Nullable @UnknownKeyFor @Initialized String getContentTypeEncoding(@Nullable @UnknownKeyFor @Initialized String httpContentType) {
        int i;
        String encoding = null;
        if (httpContentType != null && (i = httpContentType.indexOf(";")) > -1) {
            String postMime = httpContentType.substring(i + 1);
            Matcher m = CHARSET_PATTERN.matcher(postMime);
            encoding = m.find() ? m.group(1) : null;
            encoding = encoding != null ? encoding.toUpperCase(Locale.ROOT) : null;
        }
        return encoding;
    }

    private static @Nullable @UnknownKeyFor @Initialized String getXmlProlog(@UnknownKeyFor @NonNull @Initialized InputStream inputStream, @Nullable @UnknownKeyFor @Initialized String guessedEnc) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String encoding = null;
        if (guessedEnc != null) {
            byte[] bytes = new byte[8192];
            inputStream.mark(8192);
            int offset = 0;
            int max = 8192;
            int c = inputStream.read(bytes, offset, max);
            int firstGT = -1;
            String xmlProlog = "";
            while (c != -1 && firstGT == -1 && offset < 8192) {
                c = inputStream.read(bytes, offset += c, max -= c);
                xmlProlog = new String(bytes, 0, offset, guessedEnc);
                firstGT = xmlProlog.indexOf(62);
            }
            if (firstGT == -1) {
                if (c == -1) {
                    throw new IOException("Unexpected end of XML stream");
                }
                throw new IOException("XML prolog or ROOT element not found on first " + offset + " bytes");
            }
            int bytesRead = offset;
            if (bytesRead > 0) {
                String line;
                inputStream.reset();
                BufferedReader bReader = new BufferedReader(new StringReader(xmlProlog.substring(0, firstGT + 1)));
                StringBuffer prolog = new StringBuffer();
                while ((line = bReader.readLine()) != null) {
                    prolog.append(line);
                }
                Matcher m = ENCODING_PATTERN.matcher(prolog);
                if (m.find()) {
                    encoding = m.group(1).toUpperCase(Locale.ROOT);
                    encoding = encoding.substring(1, encoding.length() - 1);
                }
            }
        }
        return encoding;
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isAppXml(@Nullable @UnknownKeyFor @Initialized String mime) {
        return mime != null && (mime.equals("application/xml") || mime.equals("application/xml-dtd") || mime.equals("application/xml-external-parsed-entity") || mime.startsWith("application/") && mime.endsWith("+xml"));
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isTextXml(@Nullable @UnknownKeyFor @Initialized String mime) {
        return mime != null && (mime.equals("text/xml") || mime.equals("text/xml-external-parsed-entity") || mime.startsWith("text/") && mime.endsWith("+xml"));
    }
}

