/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.io.TaggedIOException;
import org.apache.commons.io.input.ProxyReader;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class TaggedReader
extends ProxyReader {
    private final @UnknownKeyFor @NonNull @Initialized Serializable tag = UUID.randomUUID();

    public TaggedReader(@UnknownKeyFor @NonNull @Initialized Reader proxy) {
        super(proxy);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isCauseOf(@UnknownKeyFor @NonNull @Initialized Throwable exception) {
        return TaggedIOException.isTaggedWith(exception, this.tag);
    }

    public void throwIfCauseOf(@UnknownKeyFor @NonNull @Initialized Throwable throwable) throws @UnknownKeyFor @NonNull @Initialized IOException {
        TaggedIOException.throwCauseIfTaggedWith(throwable, this.tag);
    }

    @Override
    protected void handleIOException(@UnknownKeyFor @NonNull @Initialized IOException e) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new TaggedIOException(e, this.tag);
    }
}

