/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.Serializable;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class NotFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 6131563330944994230L;
    private final @UnknownKeyFor @NonNull @Initialized IOFileFilter filter;

    public NotFileFilter(@UnknownKeyFor @NonNull @Initialized IOFileFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("The filter must not be null");
        }
        this.filter = filter;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean accept(@UnknownKeyFor @NonNull @Initialized File file) {
        return !this.filter.accept(file);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean accept(@UnknownKeyFor @NonNull @Initialized File file, @UnknownKeyFor @NonNull @Initialized String name) {
        return !this.filter.accept(file, name);
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return super.toString() + "(" + this.filter.toString() + ")";
    }
}

