/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.output.AppendableWriter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.commons.io.output.StringBuilderWriter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class IOUtils {
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] EMPTY_BYTE_ARRAY = new byte[0];
    public static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_BUFFER_SIZE = 8192;
    public static final @UnknownKeyFor @NonNull @Initialized char DIR_SEPARATOR = File.separatorChar;
    public static final @UnknownKeyFor @NonNull @Initialized char DIR_SEPARATOR_UNIX = '/';
    public static final @UnknownKeyFor @NonNull @Initialized char DIR_SEPARATOR_WINDOWS = '\\';
    public static final @UnknownKeyFor @NonNull @Initialized int EOF = -1;
    @Deprecated
    public static final @UnknownKeyFor @NonNull @Initialized String LINE_SEPARATOR = System.lineSeparator();
    public static final @UnknownKeyFor @NonNull @Initialized String LINE_SEPARATOR_UNIX = "\n";
    public static final @UnknownKeyFor @NonNull @Initialized String LINE_SEPARATOR_WINDOWS = "\r\n";
    private static final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] SKIP_BYTE_BUFFER = new byte[8192];
    private static @UnknownKeyFor @NonNull @Initialized char @Nullable @UnknownKeyFor @Initialized [] SKIP_CHAR_BUFFER;

    public static @UnknownKeyFor @NonNull @Initialized BufferedInputStream buffer(@UnknownKeyFor @NonNull @Initialized InputStream inputStream) {
        Objects.requireNonNull(inputStream, "inputStream");
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedInputStream buffer(@UnknownKeyFor @NonNull @Initialized InputStream inputStream, @UnknownKeyFor @NonNull @Initialized int size) {
        Objects.requireNonNull(inputStream, "inputStream");
        return inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream, size);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedOutputStream buffer(@UnknownKeyFor @NonNull @Initialized OutputStream outputStream) {
        Objects.requireNonNull(outputStream, "outputStream");
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedOutputStream buffer(@UnknownKeyFor @NonNull @Initialized OutputStream outputStream, @UnknownKeyFor @NonNull @Initialized int size) {
        Objects.requireNonNull(outputStream, "outputStream");
        return outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, size);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedReader buffer(@UnknownKeyFor @NonNull @Initialized Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedReader buffer(@UnknownKeyFor @NonNull @Initialized Reader reader, @UnknownKeyFor @NonNull @Initialized int size) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, size);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedWriter buffer(@UnknownKeyFor @NonNull @Initialized Writer writer) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedWriter buffer(@UnknownKeyFor @NonNull @Initialized Writer writer, @UnknownKeyFor @NonNull @Initialized int size) {
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, size);
    }

    public static void close(@Nullable @UnknownKeyFor @Initialized Closeable closeable) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void close(Closeable ... closeables) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (closeables != null) {
            for (Closeable closeable : closeables) {
                IOUtils.close(closeable);
            }
        }
    }

    public static void close(@Nullable @UnknownKeyFor @Initialized Closeable closeable, @Nullable @UnknownKeyFor @Initialized IOConsumer<@UnknownKeyFor @NonNull @Initialized IOException> consumer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (consumer == null) break block3;
                    consumer.accept(e);
                }
            }
        }
    }

    public static void close(@UnknownKeyFor @NonNull @Initialized URLConnection conn) {
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized Closeable closeable) {
        IOUtils.closeQuietly(closeable, (Consumer<IOException>)null);
    }

    @Deprecated
    public static void closeQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            IOUtils.closeQuietly(closeable);
        }
    }

    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized Closeable closeable, @Nullable @UnknownKeyFor @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized IOException> consumer) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (consumer == null) break block3;
                    consumer.accept(e);
                }
            }
        }
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized InputStream input) {
        IOUtils.closeQuietly((Closeable)input);
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized OutputStream output) {
        IOUtils.closeQuietly((Closeable)output);
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized Reader input) {
        IOUtils.closeQuietly((Closeable)input);
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized Selector selector) {
        IOUtils.closeQuietly((Closeable)selector);
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized ServerSocket serverSocket) {
        IOUtils.closeQuietly((Closeable)serverSocket);
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized Socket socket) {
        IOUtils.closeQuietly((Closeable)socket);
    }

    @Deprecated
    public static void closeQuietly(@Nullable @UnknownKeyFor @Initialized Writer output) {
        IOUtils.closeQuietly((Closeable)output);
    }

    public static @UnknownKeyFor @NonNull @Initialized long consume(@Nullable @UnknownKeyFor @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.copyLarge(input, NullOutputStream.NULL_OUTPUT_STREAM, SKIP_BYTE_BUFFER);
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean contentEquals(@UnknownKeyFor @NonNull @Initialized InputStream input1, @UnknownKeyFor @NonNull @Initialized InputStream input2) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (input1 == input2) {
            return true;
        }
        if (input1 == null ^ input2 == null) {
            return false;
        }
        BufferedInputStream bufferedInput1 = IOUtils.buffer(input1);
        BufferedInputStream bufferedInput2 = IOUtils.buffer(input2);
        int ch = bufferedInput1.read();
        while (-1 != ch) {
            int ch2 = bufferedInput2.read();
            if (ch != ch2) {
                return false;
            }
            ch = bufferedInput1.read();
        }
        return bufferedInput2.read() == -1;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean contentEquals(@UnknownKeyFor @NonNull @Initialized Reader input1, @UnknownKeyFor @NonNull @Initialized Reader input2) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (input1 == input2) {
            return true;
        }
        if (input1 == null ^ input2 == null) {
            return false;
        }
        BufferedReader bufferedInput1 = IOUtils.toBufferedReader(input1);
        BufferedReader bufferedInput2 = IOUtils.toBufferedReader(input2);
        int ch = bufferedInput1.read();
        while (-1 != ch) {
            int ch2 = bufferedInput2.read();
            if (ch != ch2) {
                return false;
            }
            ch = bufferedInput1.read();
        }
        return bufferedInput2.read() == -1;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean contentEqualsIgnoreEOL(@UnknownKeyFor @NonNull @Initialized Reader input1, @UnknownKeyFor @NonNull @Initialized Reader input2) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (input1 == input2) {
            return true;
        }
        if (input1 == null ^ input2 == null) {
            return false;
        }
        BufferedReader br1 = IOUtils.toBufferedReader(input1);
        BufferedReader br2 = IOUtils.toBufferedReader(input2);
        String line1 = br1.readLine();
        String line2 = br2.readLine();
        while (line1 != null && line1.equals(line2)) {
            line1 = br1.readLine();
            line2 = br2.readLine();
        }
        return Objects.equals(line1, line2);
    }

    public static @UnknownKeyFor @NonNull @Initialized int copy(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long count = IOUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static @UnknownKeyFor @NonNull @Initialized long copy(@Nullable @UnknownKeyFor @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized OutputStream output, @UnknownKeyFor @NonNull @Initialized int bufferSize) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.copyLarge(input, output, new byte[bufferSize]);
    }

    @Deprecated
    public static void copy(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.copy(input, output, Charset.defaultCharset());
    }

    public static void copy(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized Writer output, @Nullable @UnknownKeyFor @Initialized Charset inputCharset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        InputStreamReader in = new InputStreamReader(input, Charsets.toCharset(inputCharset));
        IOUtils.copy((Reader)in, output);
    }

    public static void copy(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized Writer output, @Nullable @UnknownKeyFor @Initialized String inputCharsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.copy(input, output, Charsets.toCharset(inputCharsetName));
    }

    public static @UnknownKeyFor @NonNull @Initialized long copy(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized Appendable output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.copy(input, output, CharBuffer.allocate(8192));
    }

    public static @UnknownKeyFor @NonNull @Initialized long copy(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized Appendable output, @UnknownKeyFor @NonNull @Initialized CharBuffer buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            buffer.flip();
            output.append(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    @Deprecated
    public static void copy(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.copy(input, output, Charset.defaultCharset());
    }

    public static void copy(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized Charset outputCharset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        OutputStreamWriter out = new OutputStreamWriter(output, Charsets.toCharset(outputCharset));
        IOUtils.copy(input, (Writer)out);
        out.flush();
    }

    public static void copy(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized String outputCharsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.copy(input, output, Charsets.toCharset(outputCharsetName));
    }

    public static @UnknownKeyFor @NonNull @Initialized int copy(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long count = IOUtils.copyLarge(input, output);
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    public static @UnknownKeyFor @NonNull @Initialized long copyLarge(@Nullable @UnknownKeyFor @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.copy(input, output, 8192);
    }

    public static @UnknownKeyFor @NonNull @Initialized long copyLarge(@Nullable @UnknownKeyFor @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized OutputStream output, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long count = 0L;
        if (input != null) {
            int n;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += (long)n;
            }
        }
        return count;
    }

    public static @UnknownKeyFor @NonNull @Initialized long copyLarge(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized OutputStream output, @UnknownKeyFor @NonNull @Initialized long inputOffset, @UnknownKeyFor @NonNull @Initialized long length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.copyLarge(input, output, inputOffset, length, new byte[8192]);
    }

    public static @UnknownKeyFor @NonNull @Initialized long copyLarge(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized OutputStream output, @UnknownKeyFor @NonNull @Initialized long inputOffset, @UnknownKeyFor @NonNull @Initialized long length, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int read;
        int bufferLength;
        if (inputOffset > 0L) {
            IOUtils.skipFully(input, inputOffset);
        }
        if (length == 0L) {
            return 0L;
        }
        int bytesToRead = bufferLength = buffer.length;
        if (length > 0L && length < (long)bufferLength) {
            bytesToRead = (int)length;
        }
        long totalRead = 0L;
        while (bytesToRead > 0 && -1 != (read = input.read(buffer, 0, bytesToRead))) {
            output.write(buffer, 0, read);
            totalRead += (long)read;
            if (length <= 0L) continue;
            bytesToRead = (int)Math.min(length - totalRead, (long)bufferLength);
        }
        return totalRead;
    }

    public static @UnknownKeyFor @NonNull @Initialized long copyLarge(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.copyLarge(input, output, new char[8192]);
    }

    public static @UnknownKeyFor @NonNull @Initialized long copyLarge(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized Writer output, @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int n;
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static @UnknownKeyFor @NonNull @Initialized long copyLarge(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized Writer output, @UnknownKeyFor @NonNull @Initialized long inputOffset, @UnknownKeyFor @NonNull @Initialized long length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.copyLarge(input, output, inputOffset, length, new char[8192]);
    }

    public static @UnknownKeyFor @NonNull @Initialized long copyLarge(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized Writer output, @UnknownKeyFor @NonNull @Initialized long inputOffset, @UnknownKeyFor @NonNull @Initialized long length, @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int read;
        if (inputOffset > 0L) {
            IOUtils.skipFully(input, inputOffset);
        }
        if (length == 0L) {
            return 0L;
        }
        int bytesToRead = buffer.length;
        if (length > 0L && length < (long)buffer.length) {
            bytesToRead = (int)length;
        }
        long totalRead = 0L;
        while (bytesToRead > 0 && -1 != (read = input.read(buffer, 0, bytesToRead))) {
            output.write(buffer, 0, read);
            totalRead += (long)read;
            if (length <= 0L) continue;
            bytesToRead = (int)Math.min(length - totalRead, (long)buffer.length);
        }
        return totalRead;
    }

    public static @UnknownKeyFor @NonNull @Initialized int length(@UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] array) {
        return array == null ? 0 : array.length;
    }

    public static @UnknownKeyFor @NonNull @Initialized int length(@UnknownKeyFor @NonNull @Initialized char @Nullable @UnknownKeyFor @Initialized [] array) {
        return array == null ? 0 : array.length;
    }

    public static @UnknownKeyFor @NonNull @Initialized int length(@Nullable @UnknownKeyFor @Initialized CharSequence csq) {
        return csq == null ? 0 : csq.length();
    }

    public static @UnknownKeyFor @NonNull @Initialized int length(@UnknownKeyFor @NonNull @Initialized Object @Nullable @UnknownKeyFor @Initialized [] array) {
        return array == null ? 0 : array.length;
    }

    public static @UnknownKeyFor @NonNull @Initialized LineIterator lineIterator(@UnknownKeyFor @NonNull @Initialized InputStream input, @Nullable @UnknownKeyFor @Initialized Charset charset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new LineIterator(new InputStreamReader(input, Charsets.toCharset(charset)));
    }

    public static @UnknownKeyFor @NonNull @Initialized LineIterator lineIterator(@UnknownKeyFor @NonNull @Initialized InputStream input, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.lineIterator(input, Charsets.toCharset(charsetName));
    }

    public static @UnknownKeyFor @NonNull @Initialized LineIterator lineIterator(@UnknownKeyFor @NonNull @Initialized Reader reader) {
        return new LineIterator(reader);
    }

    public static @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.read(input, buffer, 0, buffer.length);
    }

    public static @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buffer, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int location;
        int remaining;
        int count;
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        for (remaining = length; remaining > 0 && -1 != (count = input.read(buffer, offset + (location = length - remaining), remaining)); remaining -= count) {
        }
        return length - remaining;
    }

    public static @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel input, @UnknownKeyFor @NonNull @Initialized ByteBuffer buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int count;
        int length = buffer.remaining();
        while (buffer.remaining() > 0 && -1 != (count = input.read(buffer))) {
        }
        return length - buffer.remaining();
    }

    public static @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.read(input, buffer, 0, buffer.length);
    }

    public static @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] buffer, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int location;
        int remaining;
        int count;
        if (length < 0) {
            throw new IllegalArgumentException("Length must not be negative: " + length);
        }
        for (remaining = length; remaining > 0 && -1 != (count = input.read(buffer, offset + (location = length - remaining), remaining)); remaining -= count) {
        }
        return length - remaining;
    }

    public static void readFully(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.readFully(input, buffer, 0, buffer.length);
    }

    public static void readFully(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] buffer, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int actual = IOUtils.read(input, buffer, offset, length);
        if (actual != length) {
            throw new EOFException("Length to read: " + length + " actual: " + actual);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] readFully(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        byte[] buffer = new byte[length];
        IOUtils.readFully(input, buffer, 0, buffer.length);
        return buffer;
    }

    public static void readFully(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel input, @UnknownKeyFor @NonNull @Initialized ByteBuffer buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int expected = buffer.remaining();
        int actual = IOUtils.read(input, buffer);
        if (actual != expected) {
            throw new EOFException("Length to read: " + expected + " actual: " + actual);
        }
    }

    public static void readFully(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] buffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.readFully(input, buffer, 0, buffer.length);
    }

    public static void readFully(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] buffer, @UnknownKeyFor @NonNull @Initialized int offset, @UnknownKeyFor @NonNull @Initialized int length) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int actual = IOUtils.read(input, buffer, offset, length);
        if (actual != length) {
            throw new EOFException("Length to read: " + length + " actual: " + actual);
        }
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> readLines(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.readLines(input, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> readLines(@UnknownKeyFor @NonNull @Initialized InputStream input, @Nullable @UnknownKeyFor @Initialized Charset charset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        InputStreamReader reader = new InputStreamReader(input, Charsets.toCharset(charset));
        return IOUtils.readLines(reader);
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> readLines(@UnknownKeyFor @NonNull @Initialized InputStream input, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.readLines(input, Charsets.toCharset(charsetName));
    }

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> readLines(@UnknownKeyFor @NonNull @Initialized Reader input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String line;
        BufferedReader reader = IOUtils.toBufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            list.add(line);
        }
        return list;
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] resourceToByteArray(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.resourceToByteArray(name, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] resourceToByteArray(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized ClassLoader classLoader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toByteArray(IOUtils.resourceToURL(name, classLoader));
    }

    public static @UnknownKeyFor @NonNull @Initialized String resourceToString(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Charset charset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.resourceToString(name, charset, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized String resourceToString(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized Charset charset, @Nullable @UnknownKeyFor @Initialized ClassLoader classLoader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toString(IOUtils.resourceToURL(name, classLoader), charset);
    }

    public static @UnknownKeyFor @NonNull @Initialized URL resourceToURL(@UnknownKeyFor @NonNull @Initialized String name) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.resourceToURL(name, null);
    }

    public static @UnknownKeyFor @NonNull @Initialized URL resourceToURL(@UnknownKeyFor @NonNull @Initialized String name, @Nullable @UnknownKeyFor @Initialized ClassLoader classLoader) throws @UnknownKeyFor @NonNull @Initialized IOException {
        URL resource;
        URL uRL = resource = classLoader == null ? IOUtils.class.getResource(name) : classLoader.getResource(name);
        if (resource == null) {
            throw new IOException("Resource not found: " + name);
        }
        return resource;
    }

    @EnsuresNonNull(value={"SKIP_BYTE_BUFFER"})
    public static @UnknownKeyFor @NonNull @Initialized long skip(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized long toSkip) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long remain;
        long n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        for (remain = toSkip; remain > 0L && (n = (long)input.read(SKIP_BYTE_BUFFER, 0, (int)Math.min(remain, (long)SKIP_BYTE_BUFFER.length))) >= 0L; remain -= n) {
        }
        return toSkip - remain;
    }

    public static @UnknownKeyFor @NonNull @Initialized long skip(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel input, @UnknownKeyFor @NonNull @Initialized long toSkip) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long remain;
        int n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        ByteBuffer skipByteBuffer = ByteBuffer.allocate((int)Math.min(toSkip, (long)SKIP_BYTE_BUFFER.length));
        for (remain = toSkip; remain > 0L; remain -= (long)n) {
            skipByteBuffer.position(0);
            skipByteBuffer.limit((int)Math.min(remain, (long)SKIP_BYTE_BUFFER.length));
            n = input.read(skipByteBuffer);
            if (n == -1) break;
        }
        return toSkip - remain;
    }

    @EnsuresNonNull(value={"SKIP_CHAR_BUFFER"})
    public static @UnknownKeyFor @NonNull @Initialized long skip(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized long toSkip) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long remain;
        long n;
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Skip count must be non-negative, actual: " + toSkip);
        }
        if (SKIP_CHAR_BUFFER == null) {
            SKIP_CHAR_BUFFER = new char[SKIP_BYTE_BUFFER.length];
        }
        for (remain = toSkip; remain > 0L && (n = (long)input.read(SKIP_CHAR_BUFFER, 0, (int)Math.min(remain, (long)SKIP_BYTE_BUFFER.length))) >= 0L; remain -= n) {
        }
        return toSkip - remain;
    }

    public static void skipFully(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized long toSkip) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + toSkip);
        }
        long skipped = IOUtils.skip(input, toSkip);
        if (skipped != toSkip) {
            throw new EOFException("Bytes to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static void skipFully(@UnknownKeyFor @NonNull @Initialized ReadableByteChannel input, @UnknownKeyFor @NonNull @Initialized long toSkip) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (toSkip < 0L) {
            throw new IllegalArgumentException("Bytes to skip must not be negative: " + toSkip);
        }
        long skipped = IOUtils.skip(input, toSkip);
        if (skipped != toSkip) {
            throw new EOFException("Bytes to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static void skipFully(@UnknownKeyFor @NonNull @Initialized Reader input, @UnknownKeyFor @NonNull @Initialized long toSkip) throws @UnknownKeyFor @NonNull @Initialized IOException {
        long skipped = IOUtils.skip(input, toSkip);
        if (skipped != toSkip) {
            throw new EOFException("Chars to skip: " + toSkip + " actual: " + skipped);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized InputStream toBufferedInputStream(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return ByteArrayOutputStream.toBufferedInputStream(input);
    }

    public static @UnknownKeyFor @NonNull @Initialized InputStream toBufferedInputStream(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized int size) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return ByteArrayOutputStream.toBufferedInputStream(input, size);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedReader toBufferedReader(@UnknownKeyFor @NonNull @Initialized Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static @UnknownKeyFor @NonNull @Initialized BufferedReader toBufferedReader(@UnknownKeyFor @NonNull @Initialized Reader reader, @UnknownKeyFor @NonNull @Initialized int size) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, size);
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            IOUtils.copy(input, (OutputStream)output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized int size) throws @UnknownKeyFor @NonNull @Initialized IOException {
        int offset;
        int read;
        if (size < 0) {
            throw new IllegalArgumentException("Size must be equal or greater than zero: " + size);
        }
        if (size == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] data = new byte[size];
        for (offset = 0; offset < size && (read = input.read(data, offset, size - offset)) != -1; offset += read) {
        }
        if (offset != size) {
            throw new IOException("Unexpected read size. current: " + offset + ", expected: " + size);
        }
        return data;
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized InputStream input, @UnknownKeyFor @NonNull @Initialized long size) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size cannot be greater than Integer max value: " + size);
        }
        return IOUtils.toByteArray(input, (int)size);
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized Reader input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toByteArray(input, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized Reader input, @Nullable @UnknownKeyFor @Initialized Charset charset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            IOUtils.copy(input, (OutputStream)output, charset);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized Reader input, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toByteArray(input, Charsets.toCharset(charsetName));
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized String input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return input.getBytes(Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized URI uri) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toByteArray(uri.toURL());
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized URL url) throws @UnknownKeyFor @NonNull @Initialized IOException {
        URLConnection conn = url.openConnection();
        try {
            byte[] byArray = IOUtils.toByteArray(conn);
            return byArray;
        }
        finally {
            IOUtils.close(conn);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(@UnknownKeyFor @NonNull @Initialized URLConnection urlConn) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (InputStream inputStream = urlConn.getInputStream();){
            byte[] byArray = IOUtils.toByteArray(inputStream);
            return byArray;
        }
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] toCharArray(@UnknownKeyFor @NonNull @Initialized InputStream is) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toCharArray(is, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] toCharArray(@UnknownKeyFor @NonNull @Initialized InputStream is, @Nullable @UnknownKeyFor @Initialized Charset charset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        CharArrayWriter output = new CharArrayWriter();
        IOUtils.copy(is, (Writer)output, charset);
        return output.toCharArray();
    }

    public static @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] toCharArray(@UnknownKeyFor @NonNull @Initialized InputStream is, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toCharArray(is, Charsets.toCharset(charsetName));
    }

    public static @UnknownKeyFor @NonNull @Initialized char @UnknownKeyFor @NonNull @Initialized [] toCharArray(@UnknownKeyFor @NonNull @Initialized Reader input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        CharArrayWriter sw = new CharArrayWriter();
        IOUtils.copy(input, (Writer)sw);
        return sw.toCharArray();
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized InputStream toInputStream(@UnknownKeyFor @NonNull @Initialized CharSequence input) {
        return IOUtils.toInputStream(input, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized InputStream toInputStream(@UnknownKeyFor @NonNull @Initialized CharSequence input, @Nullable @UnknownKeyFor @Initialized Charset charset) {
        return IOUtils.toInputStream(input.toString(), charset);
    }

    public static @UnknownKeyFor @NonNull @Initialized InputStream toInputStream(@UnknownKeyFor @NonNull @Initialized CharSequence input, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toInputStream(input, Charsets.toCharset(charsetName));
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized InputStream toInputStream(@UnknownKeyFor @NonNull @Initialized String input) {
        return IOUtils.toInputStream(input, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized InputStream toInputStream(@UnknownKeyFor @NonNull @Initialized String input, @Nullable @UnknownKeyFor @Initialized Charset charset) {
        return new ByteArrayInputStream(input.getBytes(Charsets.toCharset(charset)));
    }

    public static @UnknownKeyFor @NonNull @Initialized InputStream toInputStream(@UnknownKeyFor @NonNull @Initialized String input, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        byte[] bytes = input.getBytes(Charsets.toCharset(charsetName));
        return new ByteArrayInputStream(bytes);
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new String(input, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] input, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return new String(input, Charsets.toCharset(charsetName));
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized InputStream input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toString(input, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized InputStream input, @Nullable @UnknownKeyFor @Initialized Charset charset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (StringBuilderWriter sw = new StringBuilderWriter();){
            IOUtils.copy(input, (Writer)sw, charset);
            String string = sw.toString();
            return string;
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized InputStream input, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toString(input, Charsets.toCharset(charsetName));
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized Reader input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (StringBuilderWriter sw = new StringBuilderWriter();){
            IOUtils.copy(input, (Writer)sw);
            String string = sw.toString();
            return string;
        }
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized URI uri) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toString(uri, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized URI uri, @Nullable @UnknownKeyFor @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toString(uri.toURL(), Charsets.toCharset(encoding));
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized URI uri, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toString(uri, Charsets.toCharset(charsetName));
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized URL url) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toString(url, Charset.defaultCharset());
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized URL url, @Nullable @UnknownKeyFor @Initialized Charset encoding) throws @UnknownKeyFor @NonNull @Initialized IOException {
        try (InputStream inputStream = url.openStream();){
            String string = IOUtils.toString(inputStream, encoding);
            return string;
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized String toString(@UnknownKeyFor @NonNull @Initialized URL url, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return IOUtils.toString(url, Charsets.toCharset(charsetName));
    }

    public static void write(@UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] data, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            output.write(data);
        }
    }

    @Deprecated
    public static void write(@UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] data, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, Charset.defaultCharset());
    }

    public static void write(@UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] data, @UnknownKeyFor @NonNull @Initialized Writer output, @Nullable @UnknownKeyFor @Initialized Charset charset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            output.write(new String(data, Charsets.toCharset(charset)));
        }
    }

    public static void write(@UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] data, @UnknownKeyFor @NonNull @Initialized Writer output, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, Charsets.toCharset(charsetName));
    }

    @Deprecated
    public static void write(@UnknownKeyFor @NonNull @Initialized char @Nullable @UnknownKeyFor @Initialized [] data, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, Charset.defaultCharset());
    }

    public static void write(@UnknownKeyFor @NonNull @Initialized char @Nullable @UnknownKeyFor @Initialized [] data, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized Charset charset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            output.write(new String(data).getBytes(Charsets.toCharset(charset)));
        }
    }

    public static void write(@UnknownKeyFor @NonNull @Initialized char @Nullable @UnknownKeyFor @Initialized [] data, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, Charsets.toCharset(charsetName));
    }

    public static void write(@UnknownKeyFor @NonNull @Initialized char @Nullable @UnknownKeyFor @Initialized [] data, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            output.write(data);
        }
    }

    @Deprecated
    public static void write(@Nullable @UnknownKeyFor @Initialized CharSequence data, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, Charset.defaultCharset());
    }

    public static void write(@Nullable @UnknownKeyFor @Initialized CharSequence data, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized Charset charset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            IOUtils.write(data.toString(), output, charset);
        }
    }

    public static void write(@Nullable @UnknownKeyFor @Initialized CharSequence data, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, Charsets.toCharset(charsetName));
    }

    public static void write(@Nullable @UnknownKeyFor @Initialized CharSequence data, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            IOUtils.write(data.toString(), output);
        }
    }

    @Deprecated
    public static void write(@Nullable @UnknownKeyFor @Initialized String data, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, Charset.defaultCharset());
    }

    public static void write(@Nullable @UnknownKeyFor @Initialized String data, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized Charset charset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            output.write(data.getBytes(Charsets.toCharset(charset)));
        }
    }

    public static void write(@Nullable @UnknownKeyFor @Initialized String data, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, Charsets.toCharset(charsetName));
    }

    public static void write(@Nullable @UnknownKeyFor @Initialized String data, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            output.write(data);
        }
    }

    @Deprecated
    public static void write(@Nullable @UnknownKeyFor @Initialized StringBuffer data, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.write(data, output, (String)null);
    }

    @Deprecated
    public static void write(@Nullable @UnknownKeyFor @Initialized StringBuffer data, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            output.write(data.toString().getBytes(Charsets.toCharset(charsetName)));
        }
    }

    @Deprecated
    public static void write(@Nullable @UnknownKeyFor @Initialized StringBuffer data, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            output.write(data.toString());
        }
    }

    public static void writeChunked(@UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] data, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            int bytes = data.length;
            int offset = 0;
            while (bytes > 0) {
                int chunk = Math.min(bytes, 8192);
                output.write(data, offset, chunk);
                bytes -= chunk;
                offset += chunk;
            }
        }
    }

    public static void writeChunked(@UnknownKeyFor @NonNull @Initialized char @Nullable @UnknownKeyFor @Initialized [] data, @UnknownKeyFor @NonNull @Initialized Writer output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (data != null) {
            int bytes = data.length;
            int offset = 0;
            while (bytes > 0) {
                int chunk = Math.min(bytes, 8192);
                output.write(data, offset, chunk);
                bytes -= chunk;
                offset += chunk;
            }
        }
    }

    @Deprecated
    public static void writeLines(@Nullable @UnknownKeyFor @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @Nullable @UnknownKeyFor @Initialized Object> lines, @Nullable @UnknownKeyFor @Initialized String lineEnding, @UnknownKeyFor @NonNull @Initialized OutputStream output) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.writeLines(lines, lineEnding, output, Charset.defaultCharset());
    }

    public static void writeLines(@Nullable @UnknownKeyFor @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @Nullable @UnknownKeyFor @Initialized Object> lines, @Nullable @UnknownKeyFor @Initialized String lineEnding, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized Charset charset) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (lines == null) {
            return;
        }
        if (lineEnding == null) {
            lineEnding = System.lineSeparator();
        }
        Charset cs = Charsets.toCharset(charset);
        for (Object object : lines) {
            if (object != null) {
                output.write(object.toString().getBytes(cs));
            }
            output.write(lineEnding.getBytes(cs));
        }
    }

    public static void writeLines(@Nullable @UnknownKeyFor @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @Nullable @UnknownKeyFor @Initialized Object> lines, @Nullable @UnknownKeyFor @Initialized String lineEnding, @UnknownKeyFor @NonNull @Initialized OutputStream output, @Nullable @UnknownKeyFor @Initialized String charsetName) throws @UnknownKeyFor @NonNull @Initialized IOException {
        IOUtils.writeLines(lines, lineEnding, output, Charsets.toCharset(charsetName));
    }

    public static void writeLines(@Nullable @UnknownKeyFor @Initialized Collection<@KeyForBottom @NonNull @Initialized ? extends @Nullable @UnknownKeyFor @Initialized Object> lines, @Nullable @UnknownKeyFor @Initialized String lineEnding, @UnknownKeyFor @NonNull @Initialized Writer writer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (lines == null) {
            return;
        }
        if (lineEnding == null) {
            lineEnding = System.lineSeparator();
        }
        for (Object object : lines) {
            if (object != null) {
                writer.write(object.toString());
            }
            writer.write(lineEnding);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized Writer writer(@UnknownKeyFor @NonNull @Initialized Appendable appendable) {
        Objects.requireNonNull(appendable, "appendable");
        if (appendable instanceof Writer) {
            return (Writer)appendable;
        }
        if (appendable instanceof StringBuilder) {
            return new StringBuilderWriter((StringBuilder)appendable);
        }
        return new AppendableWriter<Appendable>(appendable);
    }
}

