/*
 * Decompiled with CFR 0.152.
 */
package org.chartistjsf.component.chart.renderer;

import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.chartistjsf.component.chart.Chart;
import org.chartistjsf.component.chart.renderer.BaseChartistRenderer;
import org.chartistjsf.model.chart.Axis;
import org.chartistjsf.model.chart.AxisType;
import org.chartistjsf.model.chart.ChartSeries;
import org.chartistjsf.model.chart.LineChartModel;
import org.primefaces.util.ComponentUtils;

public class LineRenderer
extends BaseChartistRenderer {
    private static final Logger logger = Logger.getLogger(LineRenderer.class.getName());

    @Override
    protected void encodeData(FacesContext context, Chart chart) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        LineChartModel model = (LineChartModel)chart.getModel();
        if (model.getLabels().isEmpty()) {
            logger.log(Level.SEVERE, "Make sure to set the required lables for LineChart, otherwise the chart won't render");
            return;
        }
        writer.write(",data:{");
        writer.write("labels: [");
        Iterator<Object> labelsItr = model.getLabels().iterator();
        while (labelsItr.hasNext()) {
            Object label = labelsItr.next();
            if (label instanceof String) {
                writer.write("\"" + ComponentUtils.escapeText((String)label.toString()) + "\"");
            } else {
                writer.write(label != null ? label.toString() : "");
            }
            if (!labelsItr.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
        writer.write(", series:[");
        Iterator<ChartSeries> it = model.getSeries().iterator();
        while (it.hasNext()) {
            ChartSeries series = it.next();
            writer.write("{");
            writer.write("name:\"" + ComponentUtils.escapeText((String)series.getName()) + "\"");
            writer.write(", data:[");
            Iterator<Number> numbersIter = series.getData().iterator();
            while (numbersIter.hasNext()) {
                Number number = numbersIter.next();
                String numberAsString = number != null ? number.toString() : "null";
                writer.write(numberAsString);
                if (!numbersIter.hasNext()) continue;
                writer.write(",");
            }
            writer.write("]");
            writer.write("}");
            if (!it.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]");
        writer.write("}");
    }

    @Override
    protected void encodeOptions(FacesContext context, Chart chart) throws IOException {
        super.encodeOptions(context, chart);
        ResponseWriter writer = context.getResponseWriter();
        LineChartModel model = (LineChartModel)chart.getModel();
        writer.write(",animateAdvanced:" + model.isAnimateAdvanced());
        writer.write(",animatePath:" + model.isAnimatePath());
        writer.write(",options:{");
        Iterator<AxisType> it = model.getAxes().keySet().iterator();
        while (it.hasNext()) {
            AxisType axisType = it.next();
            Axis axis = model.getAxes().get((Object)axisType);
            axis.render(writer, axisType);
            if (!it.hasNext()) continue;
            writer.write(",");
        }
        if (model.getWidth() != null) {
            writer.write(",width:\"" + ComponentUtils.escapeText((String)model.getWidth()) + "\"");
        }
        if (model.getHeight() != null) {
            writer.write(",height:\"" + ComponentUtils.escapeText((String)model.getHeight()) + "\"");
        }
        writer.write(",showLine:" + model.isShowLine());
        writer.write(",showPoint:" + model.isShowPoint());
        writer.write(",showArea:" + model.isShowArea());
        writer.write(",areaBase:" + model.getAreaBase());
        writer.write(",lineSmooth:" + model.isLineSmooth());
        if (model.getLow() != 0) {
            writer.write(",low:" + model.getLow());
        }
        if (model.getHigh() != 0) {
            writer.write(",high:" + model.getHigh());
        }
        if (model.getChartPadding() != null) {
            writer.write(",chartPadding:" + model.getChartPadding());
        }
        writer.write(",fullWidth:" + model.isFullWidth());
        writer.write(",reverseData:" + model.isReverseData());
        writer.write("}");
    }
}

