/*
 * Decompiled with CFR 0.152.
 */
package org.chartistjsf.component.chart;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.chartistjsf.component.chart.Chart;
import org.chartistjsf.component.chart.renderer.BarRenderer;
import org.chartistjsf.component.chart.renderer.BaseChartistRenderer;
import org.chartistjsf.component.chart.renderer.LineRenderer;
import org.chartistjsf.component.chart.renderer.PieRenderer;
import org.primefaces.renderkit.CoreRenderer;

public class ChartRenderer
extends CoreRenderer {
    private static final Logger logger = Logger.getLogger(ChartRenderer.class.getName());
    public static final String RENDERER_TYPE = "org.chartistjsf.component.ChartRenderer";
    private static final String TYPE_LINE = "Line";
    private static final String TYPE_BAR = "Bar";
    private static final String TYPE_PIE = "Pie";
    static final Map<String, BaseChartistRenderer> CHART_RENDERERS = new HashMap<String, BaseChartistRenderer>();

    public void decode(FacesContext context, UIComponent component) {
        super.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Chart chart = (Chart)component;
        this.encodeMarkup(context, chart);
        this.encodeScript(context, chart);
    }

    protected void encodeMarkup(FacesContext context, Chart chart) throws IOException {
        if (chart == null || chart.getModel() == null) {
            logger.warning("ChartModel is null, make sure it's initialized");
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String style = chart.getStyle();
        String styleClass = chart.getStyleClass() == null ? "" : " " + chart.getStyleClass();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)chart.getClientId(context), null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.writeAttribute("class", (Object)(chart.getModel().getStyleClass() + styleClass), "styleClass");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext context, Chart chart) throws IOException {
        if (chart == null || chart.getModel() == null) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String type = chart.getType();
        BaseChartistRenderer chartistRenderer = CHART_RENDERERS.get(type);
        String clientId = chart.getClientId(context);
        this.startScript(writer, clientId);
        writer.write("$(function(){");
        writer.write("ChartistJSF.cw('Chart','" + chart.resolveWidgetVar() + "',{");
        writer.write("id:'" + clientId + "'");
        writer.write(",type:'" + type + "'");
        writer.write(",showTooltip:" + chart.getModel().isShowTooltip());
        if (chart.getModel().getResponsiveOptions() != null) {
            writer.write(", responsiveOptions: " + chart.getModel().getResponsiveOptions());
        }
        chartistRenderer.render(context, chart);
        this.encodeClientBehaviors(context, chart);
        writer.write("});});");
        this.endScript(writer);
    }

    static {
        CHART_RENDERERS.put(TYPE_LINE, new LineRenderer());
        CHART_RENDERERS.put(TYPE_BAR, new BarRenderer());
        CHART_RENDERERS.put(TYPE_PIE, new PieRenderer());
    }
}

