// Copyright 2015-2022 by Carnegie Mellon University
// See license information in LICENSE.txt

package org.cert.netsa.mothra.packer

/**
  * A simple class whose `partitioners()` method needs to be called to
  * get a sequence of [[Partitioner]]s.  Those results are used to
  * configure a [[PartitionerPackLogic]].
  *
  * The sequence of Partitioners returned by this class split by vlanId.
  *
  * @see [[ProtoSportPartitionerPackLogic]] for a different set of
  * partitioners.
  */
class VlanPartitionerPackLogic extends PartitionerConfigurator {
  // VLAN IDs of various offices
  val it = Seq(3, 4, 5, 6)
  val hr = Seq(1, 8, 11)
  val eng = Seq(9, 101)

  /** How to partition the records.  Defined here in the companion
    * object so it is only created once. */
  def partitioners: Seq[Partitioner] = {
    val vlanPartitioner = Partitioner.UInt16("vlanId")
    vlanPartitioner.addMultiplePartitionsEqualsAny(it)
    vlanPartitioner.addMultiplePartitionsEqualsAny(hr)
    vlanPartitioner.addMultiplePartitionsEqualsAny(eng)
    vlanPartitioner.coverRanges()

    Seq(vlanPartitioner)
  }
}


/*
 * To load this Partitioner at run-time, replace the "package"
 * statement above with this import statement:
 *
 * import org.cert.netsa.mothra.packer.{Partitioner, PartitionerConfigurator}
 *
 * and instead of extending PartitionerConfigurator, you return a new instance:
 *
 * new PartitionerConfigurator { ... }
 *
 * and add an "override" to "def partitioners".
 *
 * The complete code for run-time loading is shown here:
 * ******************************************************************

import org.cert.netsa.mothra.packer.{Partitioner, PartitionerConfigurator}

new PartitionerConfigurator {

  // VLAN IDs of various offices
  val it = Seq(3, 4, 5, 6)
  val hr = Seq(1, 8, 11)
  val eng = Seq(9, 101)

  /** How to partition the records.  Defined here in the companion
    * object so it is only created once. */
  override def partitioners: Seq[Partitioner] = {
    val vlanPartitioner = Partitioner.UInt16("vlanId")
    vlanPartitioner.addPartitionEqualsAny(it)
    vlanPartitioner.addPartitionEqualsAny(hr)
    vlanPartitioner.addPartitionEqualsAny(eng)
    vlanPartitioner.coverRanges()

    Seq(vlanPartitioner)
  }
}


 * ******************************************************************
 */

// @LICENSE_FOOTER@
//
// Copyright 2015-2022 Carnegie Mellon University. All Rights Reserved.
//
// This material is based upon work funded and supported by the
// Department of Defense and Department of Homeland Security under
// Contract No. FA8702-15-D-0002 with Carnegie Mellon University for the
// operation of the Software Engineering Institute, a federally funded
// research and development center sponsored by the United States
// Department of Defense. The U.S. Government has license rights in this
// software pursuant to DFARS 252.227.7014.
//
// NO WARRANTY. THIS CARNEGIE MELLON UNIVERSITY AND SOFTWARE ENGINEERING
// INSTITUTE MATERIAL IS FURNISHED ON AN "AS-IS" BASIS. CARNEGIE MELLON
// UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER EXPRESSED OR
// IMPLIED, AS TO ANY MATTER INCLUDING, BUT NOT LIMITED TO, WARRANTY OF
// FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY, OR RESULTS
// OBTAINED FROM USE OF THE MATERIAL. CARNEGIE MELLON UNIVERSITY DOES NOT
// MAKE ANY WARRANTY OF ANY KIND WITH RESPECT TO FREEDOM FROM PATENT,
// TRADEMARK, OR COPYRIGHT INFRINGEMENT.
//
// Released under a GNU GPL 2.0-style license, please see LICENSE.txt or
// contact permission@sei.cmu.edu for full terms.
//
// [DISTRIBUTION STATEMENT A] This material has been approved for public
// release and unlimited distribution. Please see Copyright notice for
// non-US Government use and distribution.
//
// Carnegie Mellon(R) and CERT(R) are registered in the U.S. Patent and
// Trademark Office by Carnegie Mellon University.
//
// This software includes and/or makes use of third party software each
// subject to its own license as detailed in LICENSE-thirdparty.tx
//
// DM20-1143
