package org.cdk8s.plus20;

/**
 * Options for `StatefulSetUpdateStrategy.rollingUpdate`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.59.0 (build eb02c92)", date = "2022-05-19T09:07:11.162Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.StatefulSetUpdateStrategyRollingUpdateOptions")
@software.amazon.jsii.Jsii.Proxy(StatefulSetUpdateStrategyRollingUpdateOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StatefulSetUpdateStrategyRollingUpdateOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * If specified, all Pods with an ordinal that is greater than or equal to the partition will be updated when the StatefulSet's .spec.template is updated. All Pods with an ordinal that is less than the partition will not be updated, and, even if they are deleted, they will be recreated at the previous version.
     * <p>
     * If the partition is greater than replicas, updates to the pod template will not be propagated to Pods.
     * In most cases you will not need to use a partition, but they are useful if you want to stage an
     * update, roll out a canary, or perform a phased roll out.
     * <p>
     * Default: 0
     * <p>
     * @see https://kubernetes.io/docs/concepts/workloads/controllers/statefulset/#partitions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPartition() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StatefulSetUpdateStrategyRollingUpdateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StatefulSetUpdateStrategyRollingUpdateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<StatefulSetUpdateStrategyRollingUpdateOptions> {
        java.lang.Number partition;

        /**
         * Sets the value of {@link StatefulSetUpdateStrategyRollingUpdateOptions#getPartition}
         * @param partition If specified, all Pods with an ordinal that is greater than or equal to the partition will be updated when the StatefulSet's .spec.template is updated. All Pods with an ordinal that is less than the partition will not be updated, and, even if they are deleted, they will be recreated at the previous version.
         *                  If the partition is greater than replicas, updates to the pod template will not be propagated to Pods.
         *                  In most cases you will not need to use a partition, but they are useful if you want to stage an
         *                  update, roll out a canary, or perform a phased roll out.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partition(java.lang.Number partition) {
            this.partition = partition;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StatefulSetUpdateStrategyRollingUpdateOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public StatefulSetUpdateStrategyRollingUpdateOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link StatefulSetUpdateStrategyRollingUpdateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatefulSetUpdateStrategyRollingUpdateOptions {
        private final java.lang.Number partition;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.partition = software.amazon.jsii.Kernel.get(this, "partition", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.partition = builder.partition;
        }

        @Override
        public final java.lang.Number getPartition() {
            return this.partition;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPartition() != null) {
                data.set("partition", om.valueToTree(this.getPartition()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-20.StatefulSetUpdateStrategyRollingUpdateOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StatefulSetUpdateStrategyRollingUpdateOptions.Jsii$Proxy that = (StatefulSetUpdateStrategyRollingUpdateOptions.Jsii$Proxy) o;

            return this.partition != null ? this.partition.equals(that.partition) : that.partition == null;
        }

        @Override
        public final int hashCode() {
            int result = this.partition != null ? this.partition.hashCode() : 0;
            return result;
        }
    }
}
