package org.cdk8s.plus20;

/**
 * Role is a namespaced, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-05-18T01:15:32.358Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.Role")
public class Role extends org.cdk8s.plus20.Resource implements org.cdk8s.plus20.IRole {

    protected Role(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Role(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Role(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable org.cdk8s.plus20.RoleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Role(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Imports a role from the cluster as a reference.
     * <p>
     * @param name The name of the role resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IRole fromRoleName(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(org.cdk8s.plus20.Role.class, "fromRoleName", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.IRole.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Add permission to perform a list of HTTP verbs on a collection of resources.
     * <p>
     * @see https://kubernetes.io/docs/reference/access-authn-authz/authorization/#determine-the-request-verb
     * @param verbs This parameter is required.
     * @param resources The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allow(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> verbs, final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IApiResource... resources) {
        software.amazon.jsii.Kernel.call(this, "allow", software.amazon.jsii.NativeType.VOID, java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(verbs, "verbs is required") }), java.util.Arrays.<Object>stream(resources)).toArray(Object[]::new));
    }

    /**
     * Add "create" permission for the resources.
     * <p>
     * @param resources The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowCreate(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IApiResource... resources) {
        software.amazon.jsii.Kernel.call(this, "allowCreate", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(resources).toArray(Object[]::new));
    }

    /**
     * Add "delete" permission for the resources.
     * <p>
     * @param resources The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDelete(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IApiResource... resources) {
        software.amazon.jsii.Kernel.call(this, "allowDelete", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(resources).toArray(Object[]::new));
    }

    /**
     * Add "deletecollection" permission for the resources.
     * <p>
     * @param resources The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowDeleteCollection(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IApiResource... resources) {
        software.amazon.jsii.Kernel.call(this, "allowDeleteCollection", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(resources).toArray(Object[]::new));
    }

    /**
     * Add "get" permission for the resources.
     * <p>
     * @param resources The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowGet(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IApiResource... resources) {
        software.amazon.jsii.Kernel.call(this, "allowGet", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(resources).toArray(Object[]::new));
    }

    /**
     * Add "list" permission for the resources.
     * <p>
     * @param resources The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowList(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IApiResource... resources) {
        software.amazon.jsii.Kernel.call(this, "allowList", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(resources).toArray(Object[]::new));
    }

    /**
     * Add "patch" permission for the resources.
     * <p>
     * @param resources The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowPatch(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IApiResource... resources) {
        software.amazon.jsii.Kernel.call(this, "allowPatch", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(resources).toArray(Object[]::new));
    }

    /**
     * Add "get", "list", and "watch" permissions for the resources.
     * <p>
     * @param resources The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowRead(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IApiResource... resources) {
        software.amazon.jsii.Kernel.call(this, "allowRead", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(resources).toArray(Object[]::new));
    }

    /**
     * Add "get", "list", "watch", "create", "update", "patch", "delete", and "deletecollection" permissions for the resources.
     * <p>
     * @param resources The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowReadWrite(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IApiResource... resources) {
        software.amazon.jsii.Kernel.call(this, "allowReadWrite", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(resources).toArray(Object[]::new));
    }

    /**
     * Add "update" permission for the resources.
     * <p>
     * @param resources The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowUpdate(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IApiResource... resources) {
        software.amazon.jsii.Kernel.call(this, "allowUpdate", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(resources).toArray(Object[]::new));
    }

    /**
     * Add "watch" permission for the resources.
     * <p>
     * @param resources The resource(s) to apply to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void allowWatch(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.IApiResource... resources) {
        software.amazon.jsii.Kernel.call(this, "allowWatch", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(resources).toArray(Object[]::new));
    }

    /**
     * Create a RoleBinding that binds the permissions in this Role to a list of subjects, that will only apply this role's namespace.
     * <p>
     * @param subjects a list of subjects to bind to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull org.cdk8s.plus20.RoleBinding bind(final @org.jetbrains.annotations.NotNull org.cdk8s.plus20.ISubject... subjects) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.RoleBinding.class), java.util.Arrays.<Object>stream(subjects).toArray(Object[]::new));
    }

    /**
     * The underlying cdk8s API object.
     * <p>
     * @see base.Resource.apiObject
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull org.cdk8s.ApiObject getApiObject() {
        return software.amazon.jsii.Kernel.get(this, "apiObject", software.amazon.jsii.NativeType.forClass(org.cdk8s.ApiObject.class));
    }

    /**
     * The name of a resource type as it appears in the relevant API endpoint.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceType() {
        return software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Rules associaated with this Role.
     * <p>
     * Returns a copy, use <code>allow</code> to add rules.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<org.cdk8s.plus20.RolePolicyRule> getRules() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.RolePolicyRule.class))));
    }

    /**
     * A fluent builder for {@link org.cdk8s.plus20.Role}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<org.cdk8s.plus20.Role> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private org.cdk8s.plus20.RoleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Metadata that all persisted resources must have, which includes all objects users must create.
         * <p>
         * @return {@code this}
         * @param metadata Metadata that all persisted resources must have, which includes all objects users must create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadata(final org.cdk8s.ApiObjectMetadata metadata) {
            this.props().metadata(metadata);
            return this;
        }

        /**
         * A list of rules the role should allow.
         * <p>
         * Default: []
         * <p>
         * @return {@code this}
         * @param rules A list of rules the role should allow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rules(final java.util.List<? extends org.cdk8s.plus20.RolePolicyRule> rules) {
            this.props().rules(rules);
            return this;
        }

        /**
         * @returns a newly built instance of {@link org.cdk8s.plus20.Role}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public org.cdk8s.plus20.Role build() {
            return new org.cdk8s.plus20.Role(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private org.cdk8s.plus20.RoleProps.Builder props() {
            if (this.props == null) {
                this.props = new org.cdk8s.plus20.RoleProps.Builder();
            }
            return this.props;
        }
    }
}
