package org.cdk8s.plus20;

/**
 * Properties for `PodDns`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.57.0 (build f614666)", date = "2022-05-18T01:15:32.343Z")
@software.amazon.jsii.Jsii(module = org.cdk8s.plus20.$Module.class, fqn = "cdk8s-plus-20.PodDnsProps")
@software.amazon.jsii.Jsii.Proxy(PodDnsProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PodDnsProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the hostname of the Pod.
     * <p>
     * Default: - Set to a system-defined value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHostname() {
        return null;
    }

    /**
     * If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default).
     * <p>
     * In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname).
     * In Windows containers, this means setting the registry value of hostname for the registry
     * key HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters to FQDN.
     * If a pod does not have FQDN, this has no effect.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getHostnameAsFQDN() {
        return null;
    }

    /**
     * A list of IP addresses that will be used as DNS servers for the Pod.
     * <p>
     * There can be at most 3 IP addresses specified.
     * When the policy is set to "NONE", the list must contain at least one IP address,
     * otherwise this property is optional.
     * The servers listed will be combined to the base nameservers generated from
     * the specified DNS policy with duplicate addresses removed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNameservers() {
        return null;
    }

    /**
     * List of objects where each object may have a name property (required) and a value property (optional).
     * <p>
     * The contents in this property
     * will be merged to the options generated from the specified DNS policy.
     * Duplicate entries are removed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<org.cdk8s.plus20.DnsOption> getOptions() {
        return null;
    }

    /**
     * Set DNS policy for the pod.
     * <p>
     * If policy is set to <code>None</code>, other configuration must be supplied.
     * <p>
     * Default: DnsPolicy.CLUSTER_FIRST
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable org.cdk8s.plus20.DnsPolicy getPolicy() {
        return null;
    }

    /**
     * A list of DNS search domains for hostname lookup in the Pod.
     * <p>
     * When specified, the provided list will be merged into the base
     * search domain names generated from the chosen DNS policy.
     * Duplicate domain names are removed.
     * <p>
     * Kubernetes allows for at most 6 search domains.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSearches() {
        return null;
    }

    /**
     * If specified, the fully qualified Pod hostname will be "<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>".
     * <p>
     * Default: - No subdomain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubdomain() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PodDnsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PodDnsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PodDnsProps> {
        java.lang.String hostname;
        java.lang.Boolean hostnameAsFqdn;
        java.util.List<java.lang.String> nameservers;
        java.util.List<org.cdk8s.plus20.DnsOption> options;
        org.cdk8s.plus20.DnsPolicy policy;
        java.util.List<java.lang.String> searches;
        java.lang.String subdomain;

        /**
         * Sets the value of {@link PodDnsProps#getHostname}
         * @param hostname Specifies the hostname of the Pod.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostname(java.lang.String hostname) {
            this.hostname = hostname;
            return this;
        }

        /**
         * Sets the value of {@link PodDnsProps#getHostnameAsFqdn}
         * @param hostnameAsFqdn If true the pod's hostname will be configured as the pod's FQDN, rather than the leaf name (the default).
         *                       In Linux containers, this means setting the FQDN in the hostname field of the kernel (the nodename field of struct utsname).
         *                       In Windows containers, this means setting the registry value of hostname for the registry
         *                       key HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\Tcpip\Parameters to FQDN.
         *                       If a pod does not have FQDN, this has no effect.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostnameAsFqdn(java.lang.Boolean hostnameAsFqdn) {
            this.hostnameAsFqdn = hostnameAsFqdn;
            return this;
        }

        /**
         * Sets the value of {@link PodDnsProps#getNameservers}
         * @param nameservers A list of IP addresses that will be used as DNS servers for the Pod.
         *                    There can be at most 3 IP addresses specified.
         *                    When the policy is set to "NONE", the list must contain at least one IP address,
         *                    otherwise this property is optional.
         *                    The servers listed will be combined to the base nameservers generated from
         *                    the specified DNS policy with duplicate addresses removed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nameservers(java.util.List<java.lang.String> nameservers) {
            this.nameservers = nameservers;
            return this;
        }

        /**
         * Sets the value of {@link PodDnsProps#getOptions}
         * @param options List of objects where each object may have a name property (required) and a value property (optional).
         *                The contents in this property
         *                will be merged to the options generated from the specified DNS policy.
         *                Duplicate entries are removed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder options(java.util.List<? extends org.cdk8s.plus20.DnsOption> options) {
            this.options = (java.util.List<org.cdk8s.plus20.DnsOption>)options;
            return this;
        }

        /**
         * Sets the value of {@link PodDnsProps#getPolicy}
         * @param policy Set DNS policy for the pod.
         *               If policy is set to <code>None</code>, other configuration must be supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(org.cdk8s.plus20.DnsPolicy policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link PodDnsProps#getSearches}
         * @param searches A list of DNS search domains for hostname lookup in the Pod.
         *                 When specified, the provided list will be merged into the base
         *                 search domain names generated from the chosen DNS policy.
         *                 Duplicate domain names are removed.
         *                 <p>
         *                 Kubernetes allows for at most 6 search domains.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder searches(java.util.List<java.lang.String> searches) {
            this.searches = searches;
            return this;
        }

        /**
         * Sets the value of {@link PodDnsProps#getSubdomain}
         * @param subdomain If specified, the fully qualified Pod hostname will be "<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subdomain(java.lang.String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PodDnsProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PodDnsProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PodDnsProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PodDnsProps {
        private final java.lang.String hostname;
        private final java.lang.Boolean hostnameAsFqdn;
        private final java.util.List<java.lang.String> nameservers;
        private final java.util.List<org.cdk8s.plus20.DnsOption> options;
        private final org.cdk8s.plus20.DnsPolicy policy;
        private final java.util.List<java.lang.String> searches;
        private final java.lang.String subdomain;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.hostname = software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hostnameAsFqdn = software.amazon.jsii.Kernel.get(this, "hostnameAsFQDN", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.nameservers = software.amazon.jsii.Kernel.get(this, "nameservers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.DnsOption.class)));
            this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(org.cdk8s.plus20.DnsPolicy.class));
            this.searches = software.amazon.jsii.Kernel.get(this, "searches", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.subdomain = software.amazon.jsii.Kernel.get(this, "subdomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.hostname = builder.hostname;
            this.hostnameAsFqdn = builder.hostnameAsFqdn;
            this.nameservers = builder.nameservers;
            this.options = (java.util.List<org.cdk8s.plus20.DnsOption>)builder.options;
            this.policy = builder.policy;
            this.searches = builder.searches;
            this.subdomain = builder.subdomain;
        }

        @Override
        public final java.lang.String getHostname() {
            return this.hostname;
        }

        @Override
        public final java.lang.Boolean getHostnameAsFQDN() {
            return this.hostnameAsFqdn;
        }

        @Override
        public final java.util.List<java.lang.String> getNameservers() {
            return this.nameservers;
        }

        @Override
        public final java.util.List<org.cdk8s.plus20.DnsOption> getOptions() {
            return this.options;
        }

        @Override
        public final org.cdk8s.plus20.DnsPolicy getPolicy() {
            return this.policy;
        }

        @Override
        public final java.util.List<java.lang.String> getSearches() {
            return this.searches;
        }

        @Override
        public final java.lang.String getSubdomain() {
            return this.subdomain;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getHostname() != null) {
                data.set("hostname", om.valueToTree(this.getHostname()));
            }
            if (this.getHostnameAsFQDN() != null) {
                data.set("hostnameAsFQDN", om.valueToTree(this.getHostnameAsFQDN()));
            }
            if (this.getNameservers() != null) {
                data.set("nameservers", om.valueToTree(this.getNameservers()));
            }
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getSearches() != null) {
                data.set("searches", om.valueToTree(this.getSearches()));
            }
            if (this.getSubdomain() != null) {
                data.set("subdomain", om.valueToTree(this.getSubdomain()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("cdk8s-plus-20.PodDnsProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PodDnsProps.Jsii$Proxy that = (PodDnsProps.Jsii$Proxy) o;

            if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) return false;
            if (this.hostnameAsFqdn != null ? !this.hostnameAsFqdn.equals(that.hostnameAsFqdn) : that.hostnameAsFqdn != null) return false;
            if (this.nameservers != null ? !this.nameservers.equals(that.nameservers) : that.nameservers != null) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            if (this.searches != null ? !this.searches.equals(that.searches) : that.searches != null) return false;
            return this.subdomain != null ? this.subdomain.equals(that.subdomain) : that.subdomain == null;
        }

        @Override
        public final int hashCode() {
            int result = this.hostname != null ? this.hostname.hashCode() : 0;
            result = 31 * result + (this.hostnameAsFqdn != null ? this.hostnameAsFqdn.hashCode() : 0);
            result = 31 * result + (this.nameservers != null ? this.nameservers.hashCode() : 0);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.searches != null ? this.searches.hashCode() : 0);
            result = 31 * result + (this.subdomain != null ? this.subdomain.hashCode() : 0);
            return result;
        }
    }
}
