/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.cli;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import java.net.InetSocketAddress;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.StringUtils;
import org.cassandraunit.CQLDataLoader;
import org.cassandraunit.dataset.cql.FileCQLDataSet;

public class CassandraUnitCommandLineLoader {
    public static final String CQL_FILE_EXTENSION = "cql";
    private static CommandLineParser commandLineParser = null;
    private static Options options = null;
    private static CommandLine commandLine = null;
    private static boolean usageBeenPrinted = false;

    public static void main(String[] args) {
        boolean exit = CassandraUnitCommandLineLoader.parseCommandLine(args);
        if (exit) {
            System.exit(1);
        } else {
            CassandraUnitCommandLineLoader.load();
        }
    }

    protected static boolean parseCommandLine(String[] args) {
        CassandraUnitCommandLineLoader.clearStaticAttributes();
        CassandraUnitCommandLineLoader.initOptions();
        commandLineParser = new PosixParser();
        boolean exit = false;
        try {
            commandLine = commandLineParser.parse(options, args);
            if (commandLine.getOptions().length == 0) {
                exit = true;
                CassandraUnitCommandLineLoader.printUsage();
            } else if (CassandraUnitCommandLineLoader.containBadReplicationFactorArgumentValue()) {
                CassandraUnitCommandLineLoader.printUsage("Bad argument value for option r");
                exit = true;
            }
        }
        catch (ParseException e) {
            CassandraUnitCommandLineLoader.printUsage(e.getMessage());
            exit = true;
        }
        return exit;
    }

    protected static void load() {
        System.out.println("Start Loading...");
        String host = commandLine.getOptionValue("h");
        String port = commandLine.getOptionValue("p");
        String file = commandLine.getOptionValue("f");
        String fileExtension = StringUtils.substringAfterLast((String)file, (String)".");
        if (CQL_FILE_EXTENSION.equals(fileExtension)) {
            CassandraUnitCommandLineLoader.cqlDataSetLoad(host, port, file);
        } else {
            CassandraUnitCommandLineLoader.otherTypeOfDataSetLoad(host, port, file);
        }
        System.out.println("Loading completed");
    }

    private static void otherTypeOfDataSetLoad(String host, String port, String file) {
        CqlSession session = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoint(new InetSocketAddress(host, Integer.parseInt(port)))).withLocalDatacenter("datacenter1")).build();
        CQLDataLoader dataLoader = new CQLDataLoader(session);
        dataLoader.load(new FileCQLDataSet(file));
    }

    private static void cqlDataSetLoad(String host, String port, String file) {
        CqlSession session = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().addContactPoint(new InetSocketAddress(host, Integer.parseInt(port)))).withLocalDatacenter("datacenter1")).build();
        CQLDataLoader dataLoader = new CQLDataLoader(session);
        dataLoader.load(new FileCQLDataSet(file, false));
    }

    private static boolean containBadReplicationFactorArgumentValue() {
        String replicationFactor = commandLine.getOptionValue("r");
        if (replicationFactor != null && !replicationFactor.trim().isEmpty()) {
            try {
                Integer.parseInt(replicationFactor);
                return false;
            }
            catch (NumberFormatException e) {
                return true;
            }
        }
        return false;
    }

    private static void printUsage(String message) {
        System.out.println(message);
        CassandraUnitCommandLineLoader.printUsage();
    }

    private static void initOptions() {
        options = new Options();
        OptionBuilder.withLongOpt((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"dataset to load");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withLongOpt((String)"host");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"target host (required)");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"target port (required)");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"p"));
    }

    private static void clearStaticAttributes() {
        commandLine = null;
        commandLineParser = null;
        options = null;
        usageBeenPrinted = false;
    }

    private static void printUsage() {
        usageBeenPrinted = true;
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(100);
        formatter.printHelp("CassandraUnitLoader is a tool to load CassandraUnit data Set into cassandra cluster", options);
    }

    protected static CommandLine getCommandLine() {
        return commandLine;
    }

    protected static boolean isUsageBeenPrinted() {
        return usageBeenPrinted;
    }
}

