/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.serializer;

import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.UUID;
import java.util.regex.Pattern;
import me.prettyprint.cassandra.serializers.AbstractSerializer;
import me.prettyprint.cassandra.serializers.BooleanSerializer;
import me.prettyprint.cassandra.serializers.ByteBufferSerializer;
import me.prettyprint.cassandra.serializers.BytesArraySerializer;
import me.prettyprint.cassandra.serializers.CompositeSerializer;
import me.prettyprint.cassandra.serializers.DateSerializer;
import me.prettyprint.cassandra.serializers.DoubleSerializer;
import me.prettyprint.cassandra.serializers.FloatSerializer;
import me.prettyprint.cassandra.serializers.IntegerSerializer;
import me.prettyprint.cassandra.serializers.LongSerializer;
import me.prettyprint.cassandra.serializers.StringSerializer;
import me.prettyprint.cassandra.serializers.UUIDSerializer;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.Composite;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.cassandraunit.exception.CassandraUnitException;
import org.cassandraunit.type.GenericType;
import org.cassandraunit.type.GenericTypeEnum;
import org.cassandraunit.utils.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTypeSerializer
extends AbstractSerializer<GenericType> {
    private static final GenericTypeSerializer instance = new GenericTypeSerializer();
    private static final Pattern hexPattern = Pattern.compile("[0-9abcdefABCDEF]+");
    private static final Pattern base64Pattern = Pattern.compile("[0-9a-zA-Z/+]+={0,3}");
    public static final DateFormat dateFormat = new SimpleDateFormat("yyyyMMdd HHmmss");
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public static GenericTypeSerializer get() {
        return instance;
    }

    public GenericType fromByteBuffer(ByteBuffer byteBuffer) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ByteBuffer toByteBuffer(GenericType genericType) {
        ByteBuffer byteBuffer = null;
        GenericTypeEnum currentType = genericType.getType();
        if (currentType == null) {
            currentType = GenericTypeEnum.BYTES_TYPE;
        }
        if (currentType == null) return byteBuffer;
        String genericValue = genericType.getValue();
        switch (genericType.getType()) {
            case BOOLEAN_TYPE: {
                return BooleanSerializer.get().toByteBuffer(Boolean.valueOf(Boolean.parseBoolean(genericValue)));
            }
            case BYTES_TYPE: {
                try {
                    if (genericValue.isEmpty()) {
                        return (ByteBuffer)ByteBufferSerializer.get().fromBytes(new byte[0]);
                    }
                    if (this.isHex(genericValue)) {
                        byte[] decodedBytes = Hex.decodeHex((char[])genericValue.toCharArray());
                        return (ByteBuffer)ByteBufferSerializer.get().fromBytes(decodedBytes);
                    }
                    if (!this.isBase64(genericValue)) throw new CassandraUnitException("Failed to parse \"" + genericValue + "\" as bytes: unknown binary encoding.");
                    byte[] decodedBytes = Base64.decode(genericValue);
                    return (ByteBuffer)ByteBufferSerializer.get().fromBytes(decodedBytes);
                }
                catch (DecoderException e) {
                    throw new CassandraUnitException("Failed to parse \"" + genericValue + "\" as bytes", e);
                }
            }
            case DATE_TYPE: {
                try {
                    return DateSerializer.get().toByteBuffer(dateFormat.parse(genericValue));
                }
                catch (ParseException e) {
                    throw new CassandraUnitException("cannot parse \"" + genericValue + "\" as date", e);
                }
            }
            case DOUBLE_TYPE: {
                return DoubleSerializer.get().toByteBuffer(Double.valueOf(Double.parseDouble(genericValue)));
            }
            case FLOAT_TYPE: {
                return FloatSerializer.get().toByteBuffer(Float.valueOf(Float.parseFloat(genericValue)));
            }
            case INTEGER_TYPE: {
                int val = Integer.parseInt(genericValue);
                return IntegerSerializer.get().toByteBuffer(Integer.valueOf(val));
            }
            case LEXICAL_UUID_TYPE: {
                return UUIDSerializer.get().toByteBuffer(UUID.fromString(genericValue));
            }
            case LONG_TYPE: {
                return LongSerializer.get().toByteBuffer(Long.valueOf(Long.parseLong(genericValue)));
            }
            case TIME_UUID_TYPE: {
                return UUIDSerializer.get().toByteBuffer(UUID.fromString(genericValue));
            }
            case ASCII_TYPE: 
            case UTF_8_TYPE: {
                return StringSerializer.get().toByteBuffer(genericValue);
            }
            case UUID_TYPE: {
                return UUIDSerializer.get().toByteBuffer(UUID.fromString(genericValue));
            }
            case COUNTER_TYPE: {
                return LongSerializer.get().toByteBuffer(Long.valueOf(Long.parseLong(genericValue)));
            }
            case COMPOSITE_TYPE: {
                return new CompositeSerializer().toByteBuffer(this.createComposite(genericType));
            }
            default: {
                return BytesArraySerializer.get().toByteBuffer(genericValue.getBytes());
            }
        }
    }

    private boolean isHex(String genericValue) {
        return hexPattern.matcher(genericValue).matches();
    }

    private boolean isBase64(String genericValue) {
        if (genericValue.length() % 4 != 0) {
            return false;
        }
        return base64Pattern.matcher(genericValue).matches();
    }

    private Composite createComposite(GenericType genericType) {
        if (!GenericTypeEnum.COMPOSITE_TYPE.equals((Object)genericType.getType())) {
            throw new IllegalArgumentException("the generricType must be a CompositeType");
        }
        Composite composite = new Composite();
        for (int i = 0; i < genericType.getCompositeValues().length; ++i) {
            composite.addComponent((Object)new GenericType(genericType.getCompositeValues()[i], genericType.getTypesBelongingCompositeType()[i]), (Serializer)GenericTypeSerializer.get());
        }
        return composite;
    }
}

