/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.utils;

import me.prettyprint.hector.api.ddl.ComparatorType;
import org.apache.commons.lang.StringUtils;
import org.cassandraunit.dataset.ParseException;
import org.cassandraunit.dataset.commons.ParsedDataType;
import org.cassandraunit.type.GenericTypeEnum;

public class ComparatorTypeHelper {
    private static final String COMPOSITE_TYPE = "CompositeType";

    public static ComparatorType verifyAndExtract(String comparatorType) {
        if (ComparatorTypeHelper.isCompositeType(comparatorType)) {
            return ComparatorTypeHelper.parseCompositeComparatorType(comparatorType);
        }
        return ComparatorTypeHelper.parseSimpleComparatorType(comparatorType);
    }

    private static boolean isCompositeType(String comparatorType) {
        return StringUtils.startsWith((String)comparatorType, (String)COMPOSITE_TYPE);
    }

    private static ComparatorType parseCompositeComparatorType(String comparatorType) {
        String compositeType = ComparatorTypeHelper.removePrependingCompositeType(comparatorType);
        if (!ComparatorTypeHelper.hasParenthesisForComponentTypes(compositeType)) {
            throw new ParseException("[" + comparatorType + "] must contain types wrapped within parenthesis, like: CompositeType(<type>,...,<type>).");
        }
        String[] types = ComparatorTypeHelper.extractComponentTypes(compositeType);
        if (ComparatorTypeHelper.areTypesNullOrEmpty(types)) {
            throw new ParseException("[" + comparatorType + "] must contain non-empty types, like: CompositeType(<type>,...,<type>).");
        }
        for (String type : types) {
            ComparatorTypeHelper.parseComponentType(comparatorType, type);
        }
        return ComparatorType.COMPOSITETYPE;
    }

    private static String removePrependingCompositeType(String comparatorType) {
        return StringUtils.removeStart((String)comparatorType, (String)COMPOSITE_TYPE);
    }

    private static boolean hasParenthesisForComponentTypes(String types) {
        return StringUtils.startsWith((String)types, (String)"(") && StringUtils.endsWith((String)types, (String)")");
    }

    private static String[] extractComponentTypes(String compositeType) {
        String compositeTypeWithoutParenthesis = ComparatorTypeHelper.removeWrappingParenthesis(compositeType);
        return StringUtils.split((String)compositeTypeWithoutParenthesis, (String)",");
    }

    private static String removeWrappingParenthesis(String aliasType) {
        return StringUtils.removeStart((String)StringUtils.removeEnd((String)aliasType, (String)")"), (String)"(");
    }

    private static boolean areTypesNullOrEmpty(String[] types) {
        if (ComparatorTypeHelper.isNullOrEmpty(types)) {
            return true;
        }
        for (String type : types) {
            if (!ComparatorTypeHelper.isNullOrEmpty(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNullOrEmpty(String[] types) {
        return types == null || types.length == 0;
    }

    private static boolean isNullOrEmpty(String type) {
        return type == null || type.length() == 0;
    }

    private static void parseComponentType(String comparatorType, String type) {
        try {
            String cleanType = ComparatorTypeHelper.removeReversedQualifierIfPresent(type);
            ParsedDataType.valueOf(cleanType);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("[" + comparatorType + "] contains an invalid 'component' type: [" + type + "].");
        }
    }

    private static String removeReversedQualifierIfPresent(String type) {
        return StringUtils.removeEndIgnoreCase((String)StringUtils.removeEndIgnoreCase((String)type, (String)"(reversed=true)"), (String)"(reversed=false)");
    }

    private static ComparatorType parseSimpleComparatorType(String type) {
        try {
            String cleanType = ComparatorTypeHelper.removeReversedQualifierIfPresent(type);
            ParsedDataType.valueOf(cleanType);
            return ComparatorType.getByClassName((String)cleanType);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("ComparatorType [" + type + "] is invalid.");
        }
    }

    public static GenericTypeEnum[] extractGenericTypesFromTypeAlias(String comparatorType) {
        String[] types = ComparatorTypeHelper.extractComponentTypes(comparatorType);
        GenericTypeEnum[] genericTypesEnum = new GenericTypeEnum[types.length];
        for (int i = 0; i < types.length; ++i) {
            String cleanType = ComparatorTypeHelper.removeReversedQualifierIfPresent(types[i]);
            genericTypesEnum[i] = GenericTypeEnum.fromValue(cleanType);
        }
        return genericTypesEnum;
    }
}

