/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit;

import com.datastax.driver.core.Session;
import org.cassandraunit.BaseCassandraUnit;
import org.cassandraunit.CQLDataLoader;
import org.cassandraunit.dataset.CQLDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraCQLUnit
extends BaseCassandraUnit {
    private CQLDataSet dataSet;
    private static final Logger log = LoggerFactory.getLogger(CassandraCQLUnit.class);
    private String hostIp = "127.0.0.1";
    private int port = 9142;
    public Session session;

    public CassandraCQLUnit(CQLDataSet dataSet) {
        this.dataSet = dataSet;
    }

    public CassandraCQLUnit(CQLDataSet dataSet, String configurationFileName) {
        this(dataSet);
        this.configurationFileName = configurationFileName;
    }

    public CassandraCQLUnit(CQLDataSet dataSet, String configurationFileName, String hostIp, int port) {
        this(dataSet);
        this.configurationFileName = configurationFileName;
        this.hostIp = hostIp;
        this.port = port;
    }

    @Override
    protected void load() {
        CQLDataLoader dataLoader = new CQLDataLoader(this.hostIp, this.port);
        dataLoader.load(this.dataSet);
        this.session = dataLoader.getSession();
    }
}

