/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.utils;

import me.prettyprint.hector.api.ddl.ComparatorType;
import org.apache.commons.lang.StringUtils;
import org.cassandraunit.dataset.ParseException;
import org.cassandraunit.type.GenericType;
import org.cassandraunit.type.GenericTypeEnum;

public class TypeExtractor {
    private static String endTypeFunction = ")";
    private static String startTypeFunction = "(";
    private static String[] availableTypeFunctionArray = new String[]{"bytes(", "integer(", "lexicaluuid(", "long(", "utf8(", "timeuuid(", "uuid(", "ascii(", "boolean(", "date(", "double(", "float(", "countercolumn("};

    public static GenericType extract(String valueToExtract, ComparatorType defaultValueType) {
        String extractedValue = null;
        GenericType genericType = null;
        if (TypeExtractor.containFunctions(valueToExtract)) {
            String typeFunction = StringUtils.substringBefore((String)valueToExtract, (String)startTypeFunction);
            String tmp = StringUtils.substringAfter((String)valueToExtract, (String)(typeFunction + startTypeFunction));
            extractedValue = StringUtils.substringBefore((String)tmp, (String)endTypeFunction);
            genericType = new GenericType(extractedValue, GenericTypeEnum.fromValue(typeFunction + "type"));
        } else {
            extractedValue = valueToExtract;
            genericType = defaultValueType == null ? new GenericType(extractedValue, GenericTypeEnum.BYTES_TYPE) : new GenericType(extractedValue, GenericTypeEnum.fromValue(defaultValueType.getTypeName()));
        }
        return genericType;
    }

    public static boolean containFunctions(String valueToExtract) {
        return StringUtils.startsWithAny((String)valueToExtract, (String[])availableTypeFunctionArray) && StringUtils.endsWith((String)valueToExtract, (String)endTypeFunction);
    }

    public static GenericType constructGenericType(String rowKeyOrColumnName, ComparatorType type, GenericTypeEnum[] typesBelongingCompositeType) {
        GenericType key = null;
        if (type == null) {
            key = new GenericType(rowKeyOrColumnName, GenericTypeEnum.BYTES_TYPE);
        } else if (ComparatorType.COMPOSITETYPE.getTypeName().equals(type.getTypeName())) {
            try {
                key = new GenericType(StringUtils.split((String)rowKeyOrColumnName, (String)":"), typesBelongingCompositeType);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(rowKeyOrColumnName + " doesn't fit with the schema declaration of your composite type");
            }
        } else {
            key = new GenericType(rowKeyOrColumnName, GenericTypeEnum.fromValue(type.getTypeName()));
        }
        return key;
    }
}

