/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.dataset.xml;

import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import me.prettyprint.hector.api.ddl.ColumnIndexType;
import me.prettyprint.hector.api.ddl.ColumnType;
import me.prettyprint.hector.api.ddl.ComparatorType;
import org.apache.commons.lang.StringUtils;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.dataset.ParseException;
import org.cassandraunit.dataset.xml.Column;
import org.cassandraunit.dataset.xml.ColumnFamily;
import org.cassandraunit.dataset.xml.ColumnMetadata;
import org.cassandraunit.dataset.xml.CompactionStrategyOption;
import org.cassandraunit.dataset.xml.Keyspace;
import org.cassandraunit.dataset.xml.Row;
import org.cassandraunit.dataset.xml.SuperColumn;
import org.cassandraunit.model.ColumnFamilyModel;
import org.cassandraunit.model.ColumnMetadataModel;
import org.cassandraunit.model.ColumnModel;
import org.cassandraunit.model.CompactionStrategyOptionModel;
import org.cassandraunit.model.KeyspaceModel;
import org.cassandraunit.model.RowModel;
import org.cassandraunit.model.StrategyModel;
import org.cassandraunit.model.SuperColumnModel;
import org.cassandraunit.type.GenericType;
import org.cassandraunit.type.GenericTypeEnum;
import org.cassandraunit.utils.ComparatorTypeHelper;
import org.cassandraunit.utils.TypeExtractor;
import org.xml.sax.SAXException;

public abstract class AbstractXmlDataSet
implements DataSet {
    private String dataSetLocation = null;
    private KeyspaceModel keyspace = null;

    public AbstractXmlDataSet(String dataSetLocation) {
        this.dataSetLocation = dataSetLocation;
        if (this.getInputDataSetLocation(dataSetLocation) == null) {
            throw new ParseException("Dataset not found");
        }
    }

    private Keyspace getXmlKeyspace() {
        InputStream inputDataSetLocation = this.getInputDataSetLocation(this.dataSetLocation);
        if (inputDataSetLocation == null) {
            throw new ParseException("Dataset not found in classpath");
        }
        try {
            Unmarshaller unmarshaller = this.getUnmarshaller();
            Keyspace xmlKeyspace = (Keyspace)unmarshaller.unmarshal(inputDataSetLocation);
            return xmlKeyspace;
        }
        catch (JAXBException e) {
            throw new ParseException(e);
        }
        catch (SAXException e) {
            throw new ParseException(e);
        }
        catch (URISyntaxException e) {
            throw new ParseException(e);
        }
    }

    protected abstract InputStream getInputDataSetLocation(String var1);

    private Unmarshaller getUnmarshaller() throws JAXBException, SAXException, URISyntaxException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Keyspace.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(this.getClass().getResource("/dataset.xsd"));
        unmarshaller.setSchema(schema);
        return unmarshaller;
    }

    private void mapXmlKeyspaceToModel(Keyspace xmlKeyspace) {
        this.keyspace = new KeyspaceModel();
        this.keyspace.setName(xmlKeyspace.getName());
        if (xmlKeyspace.getReplicationFactor() != null) {
            this.keyspace.setReplicationFactor(xmlKeyspace.getReplicationFactor());
        }
        if (xmlKeyspace.getStrategy() != null) {
            this.keyspace.setStrategy(StrategyModel.fromValue(xmlKeyspace.getStrategy().value()));
        }
        this.mapsXmlColumnFamiliesToColumnFamiliesModel(xmlKeyspace);
    }

    private void mapsXmlColumnFamiliesToColumnFamiliesModel(Keyspace xmlKeyspace) {
        if (xmlKeyspace.getColumnFamilies() != null) {
            for (ColumnFamily xmlColumnFamily : xmlKeyspace.getColumnFamilies().getColumnFamily()) {
                this.keyspace.getColumnFamilies().add(this.mapXmlColumnFamilyToColumnFamilyModel(xmlColumnFamily));
            }
        }
    }

    private ColumnFamilyModel mapXmlColumnFamilyToColumnFamilyModel(ColumnFamily xmlColumnFamily) {
        ColumnFamilyModel columnFamily = new ColumnFamilyModel();
        columnFamily.setName(xmlColumnFamily.getName());
        if (xmlColumnFamily.getType() != null) {
            columnFamily.setType(ColumnType.valueOf((String)xmlColumnFamily.getType().toString()));
        }
        columnFamily.setComment(xmlColumnFamily.getComment());
        if (xmlColumnFamily.getCompactionStrategy() != null) {
            columnFamily.setCompactionStrategy(xmlColumnFamily.getCompactionStrategy());
        }
        if (xmlColumnFamily.getCompactionStrategyOptions() != null) {
            ArrayList<CompactionStrategyOptionModel> compactionStrategyOptionModels = new ArrayList<CompactionStrategyOptionModel>();
            for (CompactionStrategyOption compactionStrategyOption : xmlColumnFamily.getCompactionStrategyOptions().getCompactionStrategyOption()) {
                compactionStrategyOptionModels.add(new CompactionStrategyOptionModel(compactionStrategyOption.getName(), compactionStrategyOption.getValue()));
            }
            columnFamily.setCompactionStrategyOptions(compactionStrategyOptionModels);
        }
        if (xmlColumnFamily.getGcGraceSeconds() != null) {
            columnFamily.setGcGraceSeconds(xmlColumnFamily.getGcGraceSeconds());
        }
        if (xmlColumnFamily.getMaxCompactionThreshold() != null) {
            columnFamily.setMaxCompactionThreshold(xmlColumnFamily.getMaxCompactionThreshold());
        }
        if (xmlColumnFamily.getMinCompactionThreshold() != null) {
            columnFamily.setMinCompactionThreshold(xmlColumnFamily.getMinCompactionThreshold());
        }
        if (xmlColumnFamily.getReadRepairChance() != null) {
            columnFamily.setReadRepairChance(xmlColumnFamily.getReadRepairChance());
        }
        if (xmlColumnFamily.getReplicationOnWrite() != null) {
            columnFamily.setReplicationOnWrite(xmlColumnFamily.getReplicationOnWrite());
        }
        GenericTypeEnum[] typesBelongingCompositeTypeForKeyType = null;
        if (xmlColumnFamily.getKeyType() != null) {
            ComparatorType keyType = ComparatorTypeHelper.verifyAndExtract(xmlColumnFamily.getKeyType());
            columnFamily.setKeyType(keyType);
            if (ComparatorType.COMPOSITETYPE.getTypeName().equals(keyType.getTypeName())) {
                String keyTypeAlias = StringUtils.removeStart((String)xmlColumnFamily.getKeyType(), (String)ComparatorType.COMPOSITETYPE.getTypeName());
                columnFamily.setKeyTypeAlias(keyTypeAlias);
                typesBelongingCompositeTypeForKeyType = ComparatorTypeHelper.extractGenericTypesFromTypeAlias(keyTypeAlias);
            }
        }
        GenericTypeEnum[] typesBelongingCompositeTypeForComparatorType = null;
        if (xmlColumnFamily.getComparatorType() != null) {
            ComparatorType comparatorType = ComparatorTypeHelper.verifyAndExtract(xmlColumnFamily.getComparatorType());
            columnFamily.setComparatorType(comparatorType);
            if (ComparatorType.COMPOSITETYPE.getTypeName().equals(comparatorType.getTypeName())) {
                String comparatorTypeAlias = StringUtils.removeStart((String)xmlColumnFamily.getComparatorType(), (String)ComparatorType.COMPOSITETYPE.getTypeName());
                columnFamily.setComparatorTypeAlias(comparatorTypeAlias);
                typesBelongingCompositeTypeForComparatorType = ComparatorTypeHelper.extractGenericTypesFromTypeAlias(comparatorTypeAlias);
            }
        }
        if (xmlColumnFamily.getSubComparatorType() != null) {
            columnFamily.setSubComparatorType(ComparatorType.getByClassName((String)xmlColumnFamily.getSubComparatorType().value()));
        }
        if (xmlColumnFamily.getDefaultColumnValueType() != null) {
            columnFamily.setDefaultColumnValueType(ComparatorType.getByClassName((String)xmlColumnFamily.getDefaultColumnValueType().value()));
        }
        columnFamily.setColumnsMetadata(this.mapXmlColumsMetadataToColumnsMetadata(xmlColumnFamily.getColumnMetadata()));
        columnFamily.setRows(this.mapXmlRowsToRowsModel(xmlColumnFamily, columnFamily.getKeyType(), typesBelongingCompositeTypeForKeyType, columnFamily.getComparatorType(), typesBelongingCompositeTypeForComparatorType, columnFamily.getSubComparatorType(), columnFamily.getDefaultColumnValueType()));
        return columnFamily;
    }

    private List<ColumnMetadataModel> mapXmlColumsMetadataToColumnsMetadata(List<ColumnMetadata> xmlColumnsMetadata) {
        ArrayList<ColumnMetadataModel> columnsMetadata = new ArrayList<ColumnMetadataModel>();
        for (ColumnMetadata xmlColumnMetadata : xmlColumnsMetadata) {
            columnsMetadata.add(this.mapXmlColumnMetadataToColumMetadataModel(xmlColumnMetadata));
        }
        return columnsMetadata;
    }

    private ColumnMetadataModel mapXmlColumnMetadataToColumMetadataModel(ColumnMetadata xmlColumnMetadata) {
        ColumnMetadataModel columnMetadata = new ColumnMetadataModel();
        columnMetadata.setColumnName(xmlColumnMetadata.getName());
        columnMetadata.setValidationClass(ComparatorType.getByClassName((String)xmlColumnMetadata.getValidationClass().value()));
        if (xmlColumnMetadata.getIndexType() != null) {
            columnMetadata.setColumnIndexType(ColumnIndexType.valueOf((String)xmlColumnMetadata.getIndexType().value()));
        }
        columnMetadata.setIndexName(xmlColumnMetadata.getIndexName());
        return columnMetadata;
    }

    private List<RowModel> mapXmlRowsToRowsModel(ColumnFamily xmlColumnFamily, ComparatorType keyType, GenericTypeEnum[] typesBelongingCompositeTypeForKeyType, ComparatorType comparatorType, GenericTypeEnum[] typesBelongingCompositeTypeForComparatorType, ComparatorType subcomparatorType, ComparatorType defaultColumnValueType) {
        ArrayList<RowModel> rowsModel = new ArrayList<RowModel>();
        ArrayList<ColumnMetadata> columnMetaData = new ArrayList();
        if (xmlColumnFamily.getColumnMetadata() != null) {
            columnMetaData = xmlColumnFamily.getColumnMetadata();
        }
        for (Row rowType : xmlColumnFamily.getRow()) {
            rowsModel.add(this.mapsXmlRowToRowModel(columnMetaData, rowType, keyType, typesBelongingCompositeTypeForKeyType, comparatorType, typesBelongingCompositeTypeForComparatorType, subcomparatorType, defaultColumnValueType));
        }
        return rowsModel;
    }

    private RowModel mapsXmlRowToRowModel(List<ColumnMetadata> columnMetaData, Row xmlRow, ComparatorType keyType, GenericTypeEnum[] typesBelongingCompositeTypeForKeyType, ComparatorType comparatorType, GenericTypeEnum[] typesBelongingCompositeTypeForComparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        RowModel row = new RowModel();
        row.setKey(TypeExtractor.constructGenericType(xmlRow.getKey(), keyType, typesBelongingCompositeTypeForKeyType));
        row.setColumns(this.mapXmlColumnsToColumnsModel(columnMetaData, xmlRow.getColumn(), comparatorType, typesBelongingCompositeTypeForComparatorType, defaultColumnValueType));
        row.setSuperColumns(this.mapXmlSuperColumnsToSuperColumnsModel(columnMetaData, xmlRow.getSuperColumn(), comparatorType, subComparatorType, defaultColumnValueType));
        return row;
    }

    private List<SuperColumnModel> mapXmlSuperColumnsToSuperColumnsModel(List<ColumnMetadata> columnMetaData, List<SuperColumn> xmlSuperColumns, ComparatorType comparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        ArrayList<SuperColumnModel> columnsModel = new ArrayList<SuperColumnModel>();
        for (SuperColumn xmlSuperColumnType : xmlSuperColumns) {
            columnsModel.add(this.mapXmlSuperColumnToSuperColumnModel(columnMetaData, xmlSuperColumnType, comparatorType, subComparatorType, defaultColumnValueType));
        }
        return columnsModel;
    }

    private SuperColumnModel mapXmlSuperColumnToSuperColumnModel(List<ColumnMetadata> columnMetaData, SuperColumn xmlSuperColumn, ComparatorType comparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        SuperColumnModel superColumnModel = new SuperColumnModel();
        superColumnModel.setName(new GenericType(xmlSuperColumn.getName(), GenericTypeEnum.fromValue(comparatorType.getTypeName())));
        superColumnModel.setColumns(this.mapXmlColumnsToColumnsModel(columnMetaData, xmlSuperColumn.getColumn(), subComparatorType, null, defaultColumnValueType));
        return superColumnModel;
    }

    private ColumnModel mapXmlColumnToColumnModel(ColumnMetadata metaData, Column xmlColumn, ComparatorType comparatorType, GenericTypeEnum[] typesBelongingCompositeTypeForComparatorType, ComparatorType defaultColumnValueType) {
        ColumnModel columnModel = new ColumnModel();
        if (comparatorType == null) {
            columnModel.setName(new GenericType(xmlColumn.getName(), GenericTypeEnum.BYTES_TYPE));
        } else if (ComparatorType.COMPOSITETYPE.getTypeName().equals(comparatorType.getTypeName())) {
            try {
                columnModel.setName(new GenericType(StringUtils.split((String)xmlColumn.getName(), (String)":"), typesBelongingCompositeTypeForComparatorType));
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(xmlColumn.getName() + " doesn't fit with the schema declaration of your composite type");
            }
        } else {
            columnModel.setName(new GenericType(xmlColumn.getName(), GenericTypeEnum.fromValue(comparatorType.getTypeName())));
        }
        if (defaultColumnValueType != null && ComparatorType.COUNTERTYPE.getClassName().equals(defaultColumnValueType.getClassName()) && TypeExtractor.containFunctions(xmlColumn.getValue())) {
            throw new ParseException("Impossible to override Column value into a Counter column family");
        }
        GenericType columnValue = null;
        if (metaData != null) {
            GenericTypeEnum genTypeEnum = GenericTypeEnum.valueOf(metaData.getValidationClass().name());
            columnValue = new GenericType(xmlColumn.getValue(), genTypeEnum);
        } else {
            columnValue = TypeExtractor.extract(xmlColumn.getValue(), defaultColumnValueType);
        }
        columnModel.setValue(columnValue);
        String timestamp = xmlColumn.getTimestamp();
        if (timestamp != null) {
            columnModel.setTimestamp(Long.valueOf(timestamp));
        } else {
            columnModel.setTimestamp(null);
        }
        return columnModel;
    }

    private List<ColumnModel> mapXmlColumnsToColumnsModel(List<ColumnMetadata> columnMetaData, List<Column> xmlColumns, ComparatorType columnNameComparatorType, GenericTypeEnum[] typesBelongingCompositeTypeForComparatorType, ComparatorType defaultColumnValueType) {
        ArrayList<ColumnModel> columnsModel = new ArrayList<ColumnModel>();
        for (Column xmlColumn : xmlColumns) {
            ColumnMetadata assocMetaData = null;
            for (ColumnMetadata tmpColumnMetaData : columnMetaData) {
                if (!tmpColumnMetaData.getName().equals(xmlColumn.getName())) continue;
                assocMetaData = tmpColumnMetaData;
            }
            columnsModel.add(this.mapXmlColumnToColumnModel(assocMetaData, xmlColumn, columnNameComparatorType, typesBelongingCompositeTypeForComparatorType, defaultColumnValueType));
        }
        return columnsModel;
    }

    @Override
    public KeyspaceModel getKeyspace() {
        if (this.keyspace == null) {
            Keyspace xmlKeyspace = this.getXmlKeyspace();
            this.mapXmlKeyspaceToModel(xmlKeyspace);
        }
        return this.keyspace;
    }

    @Override
    public List<ColumnFamilyModel> getColumnFamilies() {
        if (this.keyspace == null) {
            this.getKeyspace();
        }
        return this.keyspace.getColumnFamilies();
    }
}

