/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.dataset;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.dataset.DataSetFileExtensionEnum;
import org.cassandraunit.dataset.ParseException;
import org.cassandraunit.dataset.json.ClassPathJsonDataSet;
import org.cassandraunit.dataset.xml.ClassPathXmlDataSet;
import org.cassandraunit.dataset.yaml.ClassPathYamlDataSet;
import org.cassandraunit.model.ColumnFamilyModel;
import org.cassandraunit.model.KeyspaceModel;

public class ClassPathDataSet
implements DataSet {
    DataSet dataSet = null;

    public ClassPathDataSet(String dataSetLocation) {
        DataSetFileExtensionEnum dataSetExtensionEnum = this.getDataSetExtension(dataSetLocation);
        switch (dataSetExtensionEnum) {
            case xml: {
                this.dataSet = new ClassPathXmlDataSet(dataSetLocation);
                break;
            }
            case json: {
                this.dataSet = new ClassPathJsonDataSet(dataSetLocation);
                break;
            }
            case yaml: {
                this.dataSet = new ClassPathYamlDataSet(dataSetLocation);
                break;
            }
            default: {
                throw new ParseException("dataSet file extension must be one of .xml, .json, .yaml");
            }
        }
    }

    private DataSetFileExtensionEnum getDataSetExtension(String dataSetLocation) {
        String extension = StringUtils.substringAfterLast((String)dataSetLocation, (String)".");
        if (extension == null || extension.isEmpty()) {
            throw new ParseException("dataSet file extension must be one of .xml, .json, .yaml");
        }
        return DataSetFileExtensionEnum.valueOf(extension);
    }

    @Override
    public KeyspaceModel getKeyspace() {
        return this.dataSet.getKeyspace();
    }

    @Override
    public List<ColumnFamilyModel> getColumnFamilies() {
        return this.dataSet.getColumnFamilies();
    }
}

