/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.utils;

import me.prettyprint.hector.api.ddl.ComparatorType;
import org.apache.commons.lang.StringUtils;
import org.cassandraunit.dataset.ParseException;
import org.cassandraunit.dataset.commons.ParsedDataType;
import org.cassandraunit.type.GenericTypeEnum;

public class ComparatorTypeHelper {
    public static ComparatorType verifyAndExtract(String comparatorType) {
        String COMPOSITE_TYPE = "CompositeType";
        if (StringUtils.startsWith((String)comparatorType, (String)"CompositeType")) {
            boolean error = false;
            String aliasType = StringUtils.removeStart((String)comparatorType, (String)"CompositeType");
            if (ComparatorTypeHelper.notStardOrNotEndWithParenthesis(aliasType)) {
                error = true;
            } else {
                String aliasTypeWithoutParenthesis = StringUtils.removeStart((String)StringUtils.removeEnd((String)aliasType, (String)")"), (String)"(");
                String[] types = StringUtils.split((String)aliasTypeWithoutParenthesis, (String)",");
                if (ComparatorTypeHelper.typesNotNullAndNotEmpty(types)) {
                    error = true;
                } else {
                    try {
                        for (int i = 0; i < types.length; ++i) {
                            ParsedDataType.valueOf(types[i]);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        error = true;
                    }
                }
            }
            if (error) {
                throw new ParseException("CompositeType has to be like that : CompositeType(<type>,...,<type>)");
            }
            return ComparatorType.COMPOSITETYPE;
        }
        try {
            ParsedDataType.valueOf(comparatorType);
            return ComparatorType.getByClassName((String)comparatorType);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("ComparatorType value is not allowed");
        }
    }

    private static boolean typesNotNullAndNotEmpty(String[] types) {
        return types == null || types.length == 0;
    }

    private static boolean notStardOrNotEndWithParenthesis(String aliasType) {
        return !StringUtils.startsWith((String)aliasType, (String)"(") || !StringUtils.endsWith((String)aliasType, (String)")");
    }

    public static GenericTypeEnum[] extractGenericTypesFromTypeAlias(String comparatorTypeAlias) {
        String aliasTypeWithoutParenthesis = StringUtils.removeStart((String)StringUtils.removeEnd((String)comparatorTypeAlias, (String)")"), (String)"(");
        String[] types = StringUtils.split((String)aliasTypeWithoutParenthesis, (String)",");
        GenericTypeEnum[] genericTypesEnum = new GenericTypeEnum[types.length];
        for (int i = 0; i < types.length; ++i) {
            genericTypesEnum[i] = GenericTypeEnum.fromValue(types[i]);
        }
        return genericTypesEnum;
    }
}

