/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit.dataset.commons;

import java.util.ArrayList;
import java.util.List;
import me.prettyprint.hector.api.ddl.ColumnIndexType;
import me.prettyprint.hector.api.ddl.ColumnType;
import me.prettyprint.hector.api.ddl.ComparatorType;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.dataset.ParseException;
import org.cassandraunit.dataset.commons.ParsedColumn;
import org.cassandraunit.dataset.commons.ParsedColumnFamily;
import org.cassandraunit.dataset.commons.ParsedColumnMetadata;
import org.cassandraunit.dataset.commons.ParsedKeyspace;
import org.cassandraunit.dataset.commons.ParsedRow;
import org.cassandraunit.dataset.commons.ParsedSuperColumn;
import org.cassandraunit.model.ColumnFamilyModel;
import org.cassandraunit.model.ColumnMetadata;
import org.cassandraunit.model.ColumnModel;
import org.cassandraunit.model.KeyspaceModel;
import org.cassandraunit.model.RowModel;
import org.cassandraunit.model.StrategyModel;
import org.cassandraunit.model.SuperColumnModel;
import org.cassandraunit.type.GenericType;
import org.cassandraunit.type.GenericTypeEnum;
import org.cassandraunit.utils.TypeExtractor;

public abstract class AbstractCommonsParserDataSet
implements DataSet {
    protected KeyspaceModel keyspace = null;

    protected abstract ParsedKeyspace getParsedKeyspace();

    @Override
    public KeyspaceModel getKeyspace() {
        if (this.keyspace == null) {
            this.mapParsedKeyspaceToModel(this.getParsedKeyspace());
        }
        return this.keyspace;
    }

    @Override
    public List<ColumnFamilyModel> getColumnFamilies() {
        if (this.keyspace == null) {
            this.mapParsedKeyspaceToModel(this.getParsedKeyspace());
        }
        return this.keyspace.getColumnFamilies();
    }

    protected void mapParsedKeyspaceToModel(ParsedKeyspace parsedKeyspace) {
        if (parsedKeyspace == null) {
            throw new ParseException("dataSet is empty");
        }
        this.keyspace = new KeyspaceModel();
        if (parsedKeyspace.getName() == null) {
            throw new ParseException("Keyspace name is mandatory");
        }
        this.keyspace.setName(parsedKeyspace.getName());
        if (parsedKeyspace.getReplicationFactor() != 0) {
            this.keyspace.setReplicationFactor(parsedKeyspace.getReplicationFactor());
        }
        if (parsedKeyspace.getStrategy() != null) {
            try {
                this.keyspace.setStrategy(StrategyModel.fromValue(parsedKeyspace.getStrategy()));
            }
            catch (IllegalArgumentException e) {
                throw new ParseException("Invalid keyspace Strategy");
            }
        }
        this.mapsParsedColumnFamiliesToColumnFamiliesModel(parsedKeyspace);
    }

    private void mapsParsedColumnFamiliesToColumnFamiliesModel(ParsedKeyspace parsedKeyspace) {
        if (parsedKeyspace.getColumnFamilies() != null) {
            for (ParsedColumnFamily parsedColumnFamily : parsedKeyspace.getColumnFamilies()) {
                this.keyspace.getColumnFamilies().add(this.mapParsedColumnFamilyToColumnFamilyModel(parsedColumnFamily));
            }
        }
    }

    private ColumnFamilyModel mapParsedColumnFamilyToColumnFamilyModel(ParsedColumnFamily parsedColumnFamily) {
        ColumnFamilyModel columnFamily = new ColumnFamilyModel();
        if (parsedColumnFamily == null || parsedColumnFamily.getName() == null) {
            throw new ParseException("Column Family Name is missing");
        }
        columnFamily.setName(parsedColumnFamily.getName());
        if (parsedColumnFamily.getType() != null) {
            columnFamily.setType(ColumnType.valueOf((String)parsedColumnFamily.getType().toString()));
        }
        if (parsedColumnFamily.getKeyType() != null) {
            columnFamily.setKeyType(ComparatorType.getByClassName((String)parsedColumnFamily.getKeyType().name()));
        }
        if (parsedColumnFamily.getComparatorType() != null) {
            columnFamily.setComparatorType(ComparatorType.getByClassName((String)parsedColumnFamily.getComparatorType().name()));
        }
        if (parsedColumnFamily.getSubComparatorType() != null) {
            columnFamily.setSubComparatorType(ComparatorType.getByClassName((String)parsedColumnFamily.getSubComparatorType().name()));
        }
        if (parsedColumnFamily.getDefaultColumnValueType() != null) {
            columnFamily.setDefaultColumnValueType(ComparatorType.getByClassName((String)parsedColumnFamily.getDefaultColumnValueType().name()));
        }
        columnFamily.setColumnsMetadata(this.mapParsedColumsMetadataToColumnsMetadata(parsedColumnFamily.getColumnsMetadata()));
        columnFamily.setRows(this.mapParsedRowsToRowsModel(parsedColumnFamily, columnFamily.getKeyType(), columnFamily.getComparatorType(), columnFamily.getSubComparatorType(), columnFamily.getDefaultColumnValueType()));
        return columnFamily;
    }

    private List<ColumnMetadata> mapParsedColumsMetadataToColumnsMetadata(List<ParsedColumnMetadata> parsedColumnsMetadata) {
        ArrayList<ColumnMetadata> columnMetadatas = new ArrayList<ColumnMetadata>();
        for (ParsedColumnMetadata parsedColumnMetadata : parsedColumnsMetadata) {
            columnMetadatas.add(this.mapParsedColumMetadataToColumnMetadata(parsedColumnMetadata));
        }
        return columnMetadatas;
    }

    private ColumnMetadata mapParsedColumMetadataToColumnMetadata(ParsedColumnMetadata parsedColumnMetadata) {
        if (parsedColumnMetadata.getName() == null) {
            throw new ParseException("column metadata name can't be empty");
        }
        if (parsedColumnMetadata.getValidationClass() == null) {
            throw new ParseException("column metadata validation class can't be empty");
        }
        ColumnMetadata columnMetadata = new ColumnMetadata();
        columnMetadata.setColumnName(parsedColumnMetadata.getName());
        columnMetadata.setValidationClass(ComparatorType.getByClassName((String)parsedColumnMetadata.getValidationClass().name()));
        if (parsedColumnMetadata.getIndexType() != null) {
            columnMetadata.setColumnIndexType(ColumnIndexType.valueOf((String)parsedColumnMetadata.getIndexType().name()));
        }
        return columnMetadata;
    }

    private List<RowModel> mapParsedRowsToRowsModel(ParsedColumnFamily parsedColumnFamily, ComparatorType keyType, ComparatorType comparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        ArrayList<RowModel> rowsModel = new ArrayList<RowModel>();
        for (ParsedRow jsonRow : parsedColumnFamily.getRows()) {
            rowsModel.add(this.mapsParsedRowToRowModel(jsonRow, keyType, comparatorType, subComparatorType, defaultColumnValueType));
        }
        return rowsModel;
    }

    private RowModel mapsParsedRowToRowModel(ParsedRow parsedRow, ComparatorType keyType, ComparatorType comparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        RowModel row = new RowModel();
        row.setKey(new GenericType(parsedRow.getKey(), GenericTypeEnum.fromValue(keyType.getTypeName())));
        row.setColumns(this.mapParsedColumnsToColumnsModel(parsedRow.getColumns(), comparatorType, defaultColumnValueType));
        row.setSuperColumns(this.mapParsedSuperColumnsToSuperColumnsModel(parsedRow.getSuperColumns(), comparatorType, subComparatorType, defaultColumnValueType));
        return row;
    }

    private List<SuperColumnModel> mapParsedSuperColumnsToSuperColumnsModel(List<ParsedSuperColumn> parsedSuperColumns, ComparatorType comparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        ArrayList<SuperColumnModel> columnsModel = new ArrayList<SuperColumnModel>();
        for (ParsedSuperColumn parsedSuperColumn : parsedSuperColumns) {
            columnsModel.add(this.mapParsedSuperColumnToSuperColumnModel(parsedSuperColumn, comparatorType, subComparatorType, defaultColumnValueType));
        }
        return columnsModel;
    }

    private SuperColumnModel mapParsedSuperColumnToSuperColumnModel(ParsedSuperColumn parsedSuperColumn, ComparatorType comparatorType, ComparatorType subComparatorType, ComparatorType defaultColumnValueType) {
        SuperColumnModel superColumnModel = new SuperColumnModel();
        superColumnModel.setName(new GenericType(parsedSuperColumn.getName(), GenericTypeEnum.fromValue(comparatorType.getTypeName())));
        superColumnModel.setColumns(this.mapParsedColumnsToColumnsModel(parsedSuperColumn.getColumns(), subComparatorType, defaultColumnValueType));
        return superColumnModel;
    }

    private List<ColumnModel> mapParsedColumnsToColumnsModel(List<ParsedColumn> parsedColumns, ComparatorType comparatorType, ComparatorType defaultColumnValueType) {
        ArrayList<ColumnModel> columnsModel = new ArrayList<ColumnModel>();
        for (ParsedColumn jsonColumn : parsedColumns) {
            columnsModel.add(this.mapParsedColumnToColumnModel(jsonColumn, comparatorType, defaultColumnValueType));
        }
        return columnsModel;
    }

    private ColumnModel mapParsedColumnToColumnModel(ParsedColumn parsedColumn, ComparatorType comparatorType, ComparatorType defaultColumnValueType) {
        ColumnModel columnModel = new ColumnModel();
        if (comparatorType == null) {
            columnModel.setName(new GenericType(parsedColumn.getName(), GenericTypeEnum.BYTES_TYPE));
        } else {
            columnModel.setName(new GenericType(parsedColumn.getName(), GenericTypeEnum.fromValue(comparatorType.getTypeName())));
        }
        if (ComparatorType.COUNTERTYPE.getClassName().equals(defaultColumnValueType.getClassName()) && TypeExtractor.containFunctions(parsedColumn.getValue())) {
            throw new ParseException("Impossible to override Column value into a Counter column family");
        }
        GenericType columnValue = TypeExtractor.extract(parsedColumn.getValue(), defaultColumnValueType);
        columnModel.setValue(columnValue);
        return columnModel;
    }
}

