/*
 * Decompiled with CFR 0.152.
 */
package org.cassandraunit;

import me.prettyprint.hector.api.Cluster;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.factory.HFactory;
import org.cassandraunit.DataLoader;
import org.cassandraunit.dataset.DataSet;
import org.cassandraunit.utils.EmbeddedCassandraServerHelper;
import org.junit.Before;

public abstract class AbstractCassandraUnit4TestCase {
    private Keyspace keyspace = null;
    private boolean initialized = false;
    private Cluster cluster;

    @Before
    public void before() throws Exception {
        if (!this.initialized) {
            EmbeddedCassandraServerHelper.startEmbeddedCassandra();
            String clusterName = "TestCluster";
            String host = "localhost:9171";
            DataLoader dataLoader = new DataLoader(clusterName, host);
            dataLoader.load(this.getDataSet());
            this.cluster = HFactory.getOrCreateCluster((String)clusterName, (String)host);
            this.keyspace = HFactory.createKeyspace((String)this.getDataSet().getKeyspace().getName(), (Cluster)this.getCluster());
            this.initialized = true;
        }
    }

    public abstract DataSet getDataSet();

    public void setKeyspace(Keyspace keyspace) {
        this.keyspace = keyspace;
    }

    public Keyspace getKeyspace() {
        return this.keyspace;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public Cluster getCluster() {
        return this.cluster;
    }
}

